/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.akka.extension.quartz;

import akka.actor.ActorRef;
import akka.actor.ActorSelection;
import akka.actor.ActorSystem;
import akka.actor.ExtendedActorSystem;
import akka.actor.Extension;
import akka.actor.ExtensionId;
import akka.event.EventStream;
import akka.event.Logging$;
import akka.event.LoggingAdapter;
import com.typesafe.akka.extension.quartz.QuartzCalendars$;
import com.typesafe.akka.extension.quartz.QuartzCronSchedule;
import com.typesafe.akka.extension.quartz.QuartzSchedule;
import com.typesafe.akka.extension.quartz.QuartzSchedulerExtension$;
import com.typesafe.akka.extension.quartz.QuartzSchedules$;
import com.typesafe.akka.extension.quartz.SimpleActorMessageJob;
import com.typesafe.akka.extension.quartz.package$;
import com.typesafe.config.Config;
import java.io.Serializable;
import java.text.ParseException;
import java.util.Date;
import java.util.TimeZone;
import org.quartz.Calendar;
import org.quartz.CronExpression;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.Trigger;
import org.quartz.core.jmx.JobDataMapSupport;
import org.quartz.impl.DirectSchedulerFactory;
import org.quartz.simpl.RAMJobStore;
import org.quartz.simpl.SimpleThreadPool;
import org.quartz.spi.JobStore;
import org.quartz.spi.ThreadPool;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.control.Exception$;

@ScalaSignature(bytes="\u0006\u0001\r5q!\u0002#F\u0011\u0003\u0001f!\u0002*F\u0011\u0003\u0019\u0006B\u00026\u0002\t\u0003\u0011y\u0010C\u0004\u0004\u0002\u0005!\tea\u0001\u0007\tI+\u0005\u0001\u0018\u0005\tM\u0012\u0011\t\u0011)A\u0005O\")!\u000e\u0002C\u0001W\"9Q\u000e\u0002b\u0001\n\u0013q\u0007BB;\u0005A\u0003%q\u000eC\u0003w\t\u0011\u0005q\u000fC\u0005\u0002\b\u0011\u0011\r\u0011\"\u0005\u0002\n!A\u0011Q\u0003\u0003!\u0002\u0013\tY\u0001C\u0005\u0002\u0018\u0011\u0011\r\u0011\"\u0001\u0002\u001a!A\u0011\u0011\u0005\u0003!\u0002\u0013\tY\u0002C\u0005\u0002$\u0011\u0011\r\u0011\"\u0001\u0002\u001a!A\u0011Q\u0005\u0003!\u0002\u0013\tY\u0002C\u0005\u0002(\u0011\u0011\r\u0011\"\u0001\u0002*!A\u0011\u0011\u0007\u0003!\u0002\u0013\tY\u0003C\u0005\u00024\u0011\u0011\r\u0011\"\u0001\u00026!A\u0011q\t\u0003!\u0002\u0013\t9\u0004C\u0005\u0002J\u0011\u0001\r\u0011\"\u0001\u0002L!I\u00111\r\u0003A\u0002\u0013\u0005\u0011Q\r\u0005\t\u0003c\"\u0001\u0015)\u0003\u0002N!I\u00111\u000f\u0003C\u0002\u0013\u0005\u0011Q\u000f\u0005\t\u0003\u001f#\u0001\u0015!\u0003\u0002x!9\u0011\u0011\u0013\u0003\u0005\u0002\u0005M\u0005bBAK\t\u0011\u0005\u0011\u0011\u0006\u0005\b\u0003/#A\u0011AAM\u0011\u001d\tY\n\u0002C\u0001\u0003SAq!!(\u0005\t\u0003\ty\nC\u0004\u00022\u0012!\t!a%\t\u000f\u0005MF\u0001\"\u0001\u00026\"I\u00111\u0018\u0003\u0012\u0002\u0013\u0005\u0011Q\u0018\u0005\b\u0003'$A\u0011AAk\u0011\u001d\tI\u000e\u0002C\u0001\u00037Dq!a8\u0005\t\u0003\t\u0019\nC\u0004\u0002b\u0012!\t!a9\t\u000f\u0005\u001dH\u0001\"\u0001\u0002j\"I!Q\u0002\u0003\u0012\u0002\u0013\u0005!q\u0002\u0005\n\u0005'!\u0011\u0013!C\u0001\u0005\u001fA\u0011B!\u0006\u0005#\u0003%\tAa\u0006\t\u000f\tmA\u0001\"\u0001\u0003\u001e!I!Q\u0006\u0003\u0012\u0002\u0013\u0005!q\u0002\u0005\n\u0005_!\u0011\u0013!C\u0001\u0005\u001fA\u0011B!\r\u0005#\u0003%\tAa\u0006\t\u000f\tMB\u0001\"\u0001\u00036!9!\u0011\b\u0003\u0005\u0002\tm\u0002b\u0002B \t\u0011\u0005!\u0011\t\u0005\n\u0005\u001b\"\u0011\u0013!C\u0001\u0005\u001fA\u0011Ba\u0014\u0005#\u0003%\tAa\u0004\t\u0013\tEC!%A\u0005\u0002\t]\u0001b\u0002B*\t\u0011\u0005!Q\u000b\u0005\n\u0005K\"\u0011\u0013!C\u0001\u0005\u001fA\u0011Ba\u001a\u0005#\u0003%\tAa\u0004\t\u0013\t%D!%A\u0005\u0002\t]\u0001b\u0002B6\t\u0011%!Q\u000e\u0005\b\u0005c\"A\u0011\u0001B:\u0011\u001d\u0011\t\b\u0002C\u0001\u0005wBqA!\u001d\u0005\t\u0003\u0011I\tC\u0004\u0003r\u0011!\tAa&\t\u000f\tED\u0001\"\u0001\u0003$\"9!\u0011\u000f\u0003\u0005\u0002\t5\u0006b\u0002B\\\t\u0011%!\u0011\u0018\u0005\b\u0005\u0007$A\u0011\u0003Bc\u0011\u001d\u0011\u0019\u000e\u0002C\t\u0003'C!B!6\u0005\u0011\u000b\u0007I\u0011\u0003Bl\u0011)\u0011)\u000f\u0002EC\u0002\u0013E!q\u001d\u0005\u000b\u0005k$\u0001R1A\u0005\u0012\t]\u0018\u0001G)vCJ$(pU2iK\u0012,H.\u001a:FqR,gn]5p]*\u0011aiR\u0001\u0007cV\f'\u000f\u001e>\u000b\u0005!K\u0015!C3yi\u0016t7/[8o\u0015\tQ5*\u0001\u0003bW.\f'B\u0001'N\u0003!!\u0018\u0010]3tC\u001a,'\"\u0001(\u0002\u0007\r|Wn\u0001\u0001\u0011\u0005E\u000bQ\"A#\u00031E+\u0018M\u001d;{'\u000eDW\rZ;mKJ,\u0005\u0010^3og&|gn\u0005\u0002\u0002)B\u0019Q+W.\u000e\u0003YS!a\u0016-\u0002\u000b\u0005\u001cGo\u001c:\u000b\u0003)K!A\u0017,\u0003\u0019\u0015CH/\u001a8tS>t7*Z=\u0011\u0005E#1c\u0001\u0003^GB\u0011a,Y\u0007\u0002?*\t\u0001-A\u0003tG\u0006d\u0017-\u0003\u0002c?\n1\u0011I\\=SK\u001a\u0004\"!\u00163\n\u0005\u00154&!C#yi\u0016t7/[8o\u0003\u0019\u0019\u0018p\u001d;f[B\u0011Q\u000b[\u0005\u0003SZ\u00131#\u0012=uK:$W\rZ!di>\u00148+_:uK6\fa\u0001P5oSRtDCA.m\u0011\u00151g\u00011\u0001h\u0003\rawnZ\u000b\u0002_B\u0011\u0001o]\u0007\u0002c*\u0011!\u000fW\u0001\u0006KZ,g\u000e^\u0005\u0003iF\u0014a\u0002T8hO&tw-\u00113baR,'/\u0001\u0003m_\u001e\u0004\u0013!D:dQ\u0016$W\u000f\\3s\u001d\u0006lW-F\u0001y!\rI\u0018\u0011\u0001\b\u0003uz\u0004\"a_0\u000e\u0003qT!!`(\u0002\rq\u0012xn\u001c;?\u0013\tyx,\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u0007\t)A\u0001\u0004TiJLgn\u001a\u0006\u0003\u007f~\u000baaY8oM&<WCAA\u0006!\u0011\ti!!\u0005\u000e\u0005\u0005=!bAA\u0004\u0017&!\u00111CA\b\u0005\u0019\u0019uN\u001c4jO\u000691m\u001c8gS\u001e\u0004\u0013a\u0003;ie\u0016\fGmQ8v]R,\"!a\u0007\u0011\u0007y\u000bi\"C\u0002\u0002 }\u00131!\u00138u\u00031!\bN]3bI\u000e{WO\u001c;!\u00039!\bN]3bIB\u0013\u0018n\u001c:jif\fq\u0002\u001e5sK\u0006$\u0007K]5pe&$\u0018\u0010I\u0001\u0015I\u0006,Wn\u001c8UQJ,\u0017\rZ:`IEl\u0017M]6\u0016\u0005\u0005-\u0002c\u00010\u0002.%\u0019\u0011qF0\u0003\u000f\t{w\u000e\\3b]\u0006)B-Y3n_:$\u0006N]3bIN|F%]7be.\u0004\u0013a\u00043fM\u0006,H\u000e\u001e+j[\u0016TxN\\3\u0016\u0005\u0005]\u0002\u0003BA\u001d\u0003\u0007j!!a\u000f\u000b\t\u0005u\u0012qH\u0001\u0005kRLGN\u0003\u0002\u0002B\u0005!!.\u0019<b\u0013\u0011\t)%a\u000f\u0003\u0011QKW.\u001a.p]\u0016\f\u0001\u0003Z3gCVdG\u000fV5nKj|g.\u001a\u0011\u0002\u0013M\u001c\u0007.\u001a3vY\u0016\u001cXCAA'!\u001d\ty%!\u0017y\u0003;j!!!\u0015\u000b\t\u0005M\u0013QK\u0001\nS6lW\u000f^1cY\u0016T1!a\u0016`\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u00037\n\tFA\u0002NCB\u00042!UA0\u0013\r\t\t'\u0012\u0002\u000f#V\f'\u000f\u001e>TG\",G-\u001e7f\u00035\u00198\r[3ek2,7o\u0018\u0013fcR!\u0011qMA7!\rq\u0016\u0011N\u0005\u0004\u0003Wz&\u0001B+oSRD\u0011\"a\u001c\u0016\u0003\u0003\u0005\r!!\u0014\u0002\u0007a$\u0013'\u0001\u0006tG\",G-\u001e7fg\u0002\n1B];o]&twMS8cgV\u0011\u0011q\u000f\t\b\u0003s\ny\b_AA\u001b\t\tYH\u0003\u0003\u0002~\u0005U\u0013aB7vi\u0006\u0014G.Z\u0005\u0005\u00037\nY\b\u0005\u0003\u0002\u0004\u0006-UBAAC\u0015\r1\u0015q\u0011\u0006\u0003\u0003\u0013\u000b1a\u001c:h\u0013\u0011\ti)!\"\u0003\r){'mS3z\u00031\u0011XO\u001c8j]\u001eTuNY:!\u0003\u001d\u0019H/\u00198eEf$\"!a\u001a\u0002\u001f%\u001c\u0018J\\*uC:$'-_'pI\u0016\fQa\u001d;beR$\"!a\u000b\u0002\u0013%\u001c8\u000b^1si\u0016$\u0017a\u00038fqR$&/[4hKJ$B!!)\u0002.B)a,a)\u0002(&\u0019\u0011QU0\u0003\r=\u0003H/[8o!\u0011\tI$!+\n\t\u0005-\u00161\b\u0002\u0005\t\u0006$X\r\u0003\u0004\u00020v\u0001\r\u0001_\u0001\u0005]\u0006lW-\u0001\u0006tkN\u0004XM\u001c3BY2\f\u0001b\u001d5vi\u0012|wO\u001c\u000b\u0005\u0003O\n9\fC\u0005\u0002:~\u0001\n\u00111\u0001\u0002,\u0005)r/Y5u\r>\u0014(j\u001c2t)>\u001cu.\u001c9mKR,\u0017AE:ikR$wn\u001e8%I\u00164\u0017-\u001e7uIE*\"!a0+\t\u0005-\u0012\u0011Y\u0016\u0003\u0003\u0007\u0004B!!2\u0002P6\u0011\u0011q\u0019\u0006\u0005\u0003\u0013\fY-A\u0005v]\u000eDWmY6fI*\u0019\u0011QZ0\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002R\u0006\u001d'!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006Q1/^:qK:$'j\u001c2\u0015\t\u0005-\u0012q\u001b\u0005\u0007\u0003_\u000b\u0003\u0019\u0001=\u0002\u0013I,7/^7f\u0015>\u0014G\u0003BA\u0016\u0003;Da!a,#\u0001\u0004A\u0018!\u0003:fgVlW-\u00117m\u0003%\u0019\u0017M\\2fY*{'\r\u0006\u0003\u0002,\u0005\u0015\bBBAXI\u0001\u0007\u00010A\tde\u0016\fG/\u001a&pEN\u001b\u0007.\u001a3vY\u0016$\u0002#a*\u0002l\u00065\u0018q_A~\u0005\u0003\u0011)A!\u0003\t\r\u0005=V\u00051\u0001y\u0011\u001d\ty/\na\u0001\u0003c\f\u0001B]3dK&4XM\u001d\t\u0004+\u0006M\u0018bAA{-\nA\u0011i\u0019;peJ+g\r\u0003\u0004\u0002z\u0016\u0002\r!X\u0001\u0004[N<\u0007\"CA\u007fKA\u0005\t\u0019AA\u0000\u0003-!Wm]2sSB$\u0018n\u001c8\u0011\ty\u000b\u0019\u000b\u001f\u0005\u0007\u0005\u0007)\u0003\u0019\u0001=\u0002\u001d\r\u0014xN\\#yaJ,7o]5p]\"I!qA\u0013\u0011\u0002\u0003\u0007\u0011q`\u0001\tG\u0006dWM\u001c3be\"I!1B\u0013\u0011\u0002\u0003\u0007\u0011qG\u0001\ti&lWM_8oK\u0006Y2M]3bi\u0016TuNY*dQ\u0016$W\u000f\\3%I\u00164\u0017-\u001e7uIQ*\"A!\u0005+\t\u0005}\u0018\u0011Y\u0001\u001cGJ,\u0017\r^3K_\n\u001c6\r[3ek2,G\u0005Z3gCVdG\u000f\n\u001c\u00027\r\u0014X-\u0019;f\u0015>\u00147k\u00195fIVdW\r\n3fM\u0006,H\u000e\u001e\u00138+\t\u0011IB\u000b\u0003\u00028\u0005\u0005\u0017!E;qI\u0006$XMS8c'\u000eDW\rZ;mKR\u0001\u0012q\u0015B\u0010\u0005C\u0011\u0019C!\n\u0003(\t%\"1\u0006\u0005\u0007\u0003_K\u0003\u0019\u0001=\t\u000f\u0005=\u0018\u00061\u0001\u0002r\"1\u0011\u0011`\u0015A\u0002uC\u0011\"!@*!\u0003\u0005\r!a@\t\r\t\r\u0011\u00061\u0001y\u0011%\u00119!\u000bI\u0001\u0002\u0004\ty\u0010C\u0005\u0003\f%\u0002\n\u00111\u0001\u00028\u0005YR\u000f\u001d3bi\u0016TuNY*dQ\u0016$W\u000f\\3%I\u00164\u0017-\u001e7uIQ\n1$\u001e9eCR,'j\u001c2TG\",G-\u001e7fI\u0011,g-Y;mi\u00122\u0014aG;qI\u0006$XMS8c'\u000eDW\rZ;mK\u0012\"WMZ1vYR$s'A\teK2,G/\u001a&pEN\u001b\u0007.\u001a3vY\u0016$B!a\u000b\u00038!1\u0011qV\u0017A\u0002a\fQ\"\u001e8tG\",G-\u001e7f\u0015>\u0014G\u0003BA\u0016\u0005{Aa!a,/\u0001\u0004A\u0018AD2sK\u0006$XmU2iK\u0012,H.\u001a\u000b\r\u0003O\u0012\u0019E!\u0012\u0003H\t%#1\n\u0005\u0007\u0003_{\u0003\u0019\u0001=\t\u0013\u0005ux\u0006%AA\u0002\u0005}\bB\u0002B\u0002_\u0001\u0007\u0001\u0010C\u0005\u0003\b=\u0002\n\u00111\u0001\u0002\u0000\"I!1B\u0018\u0011\u0002\u0003\u0007\u0011qG\u0001\u0019GJ,\u0017\r^3TG\",G-\u001e7fI\u0011,g-Y;mi\u0012\u0012\u0014\u0001G2sK\u0006$XmU2iK\u0012,H.\u001a\u0013eK\u001a\fW\u000f\u001c;%i\u0005A2M]3bi\u0016\u001c6\r[3ek2,G\u0005Z3gCVdG\u000fJ\u001b\u0002\u001bI,7o\u00195fIVdWMS8c)A\t9Ka\u0016\u0003Z\tm#Q\fB0\u0005C\u0012\u0019\u0007\u0003\u0004\u00020N\u0002\r\u0001\u001f\u0005\b\u0003_\u001c\u0004\u0019AAy\u0011\u0019\tIp\ra\u0001;\"I\u0011Q`\u001a\u0011\u0002\u0003\u0007\u0011q \u0005\u0007\u0005\u0007\u0019\u0004\u0019\u0001=\t\u0013\t\u001d1\u0007%AA\u0002\u0005}\b\"\u0003B\u0006gA\u0005\t\u0019AA\u001c\u0003]\u0011Xm]2iK\u0012,H.\u001a&pE\u0012\"WMZ1vYR$C'A\fsKN\u001c\u0007.\u001a3vY\u0016TuN\u0019\u0013eK\u001a\fW\u000f\u001c;%m\u00059\"/Z:dQ\u0016$W\u000f\\3K_\n$C-\u001a4bk2$HeN\u0001\u000fe\u0016lwN^3TG\",G-\u001e7f)\u0011\t9Ga\u001c\t\r\u0005=v\u00071\u0001y\u0003!\u00198\r[3ek2,G\u0003CAT\u0005k\u00129H!\u001f\t\r\u0005=\u0006\b1\u0001y\u0011\u001d\ty\u000f\u000fa\u0001\u0003cDa!!?9\u0001\u0004iF\u0003CAT\u0005{\u0012yHa\"\t\r\u0005=\u0016\b1\u0001y\u0011\u001d\ty/\u000fa\u0001\u0005\u0003\u00032!\u0016BB\u0013\r\u0011)I\u0016\u0002\u000f\u0003\u000e$xN]*fY\u0016\u001cG/[8o\u0011\u0019\tI0\u000fa\u0001;RA\u0011q\u0015BF\u0005\u001b\u0013)\n\u0003\u0004\u00020j\u0002\r\u0001\u001f\u0005\b\u0003_T\u0004\u0019\u0001BH!\r\u0001(\u0011S\u0005\u0004\u0005'\u000b(aC#wK:$8\u000b\u001e:fC6Da!!?;\u0001\u0004iFCCAT\u00053\u0013YJ!(\u0003 \"1\u0011qV\u001eA\u0002aDq!a<<\u0001\u0004\t\t\u0010\u0003\u0004\u0002zn\u0002\r!\u0018\u0005\b\u0005C[\u0004\u0019AAQ\u0003%\u0019H/\u0019:u\t\u0006$X\r\u0006\u0006\u0002(\n\u0015&q\u0015BU\u0005WCa!a,=\u0001\u0004A\bbBAxy\u0001\u0007!\u0011\u0011\u0005\u0007\u0003sd\u0004\u0019A/\t\u000f\t\u0005F\b1\u0001\u0002\"RQ\u0011q\u0015BX\u0005c\u0013\u0019L!.\t\r\u0005=V\b1\u0001y\u0011\u001d\ty/\u0010a\u0001\u0005\u001fCa!!?>\u0001\u0004i\u0006b\u0002BQ{\u0001\u0007\u0011\u0011U\u0001\u0011g\u000eDW\rZ;mK&sG/\u001a:oC2$\"\"a*\u0003<\nu&q\u0018Ba\u0011\u0019\tyK\u0010a\u0001q\"1\u0011q\u001e A\u0002uCa!!??\u0001\u0004i\u0006b\u0002BQ}\u0001\u0007\u0011\u0011U\u0001\fg\u000eDW\rZ;mK*{'\r\u0006\u0006\u0003H\n-'Q\u001aBh\u0005#$B!a*\u0003J\"9!\u0011O A\u0002\u0005u\u0003BBAX\u007f\u0001\u0007\u0001\u0010\u0003\u0004\u0002p~\u0002\r!\u0018\u0005\u0007\u0003s|\u0004\u0019A/\t\u000f\t\u0005v\b1\u0001\u0002\"\u0006\u0019\u0012N\\5uS\u0006d\u0017n]3DC2,g\u000eZ1sg\u0006QA\u000f\u001b:fC\u0012\u0004vn\u001c7\u0016\u0005\te\u0007\u0003\u0002Bn\u0005Cl!A!8\u000b\t\t}\u0017QQ\u0001\u0006g&l\u0007\u000f\\\u0005\u0005\u0005G\u0014iN\u0001\tTS6\u0004H.\u001a+ie\u0016\fG\rU8pY\u0006A!n\u001c2Ti>\u0014X-\u0006\u0002\u0003jB!!1\u001eBy\u001b\t\u0011iO\u0003\u0003\u0003p\u0006\u0015\u0015aA:qS&!!1\u001fBw\u0005!QuNY*u_J,\u0017!C:dQ\u0016$W\u000f\\3s+\t\u0011I\u0010\u0005\u0003\u0002\u0004\nm\u0018\u0002\u0002B\u007f\u0003\u000b\u0013\u0011bU2iK\u0012,H.\u001a:\u0015\u0003A\u000b1aZ3u)\rY6Q\u0001\u0005\u0007M\u000e\u0001\raa\u0002\u0011\u0007U\u001bI!C\u0002\u0004\fY\u00131\"Q2u_J\u001c\u0016p\u001d;f[\u0002")
public class QuartzSchedulerExtension
implements Extension {
    private SimpleThreadPool threadPool;
    private JobStore jobStore;
    private Scheduler scheduler;
    private final ExtendedActorSystem system;
    private final LoggingAdapter log;
    private final Config config;
    private final int threadCount;
    private final int threadPriority;
    private final boolean daemonThreads_$qmark;
    private final TimeZone defaultTimezone;
    private scala.collection.immutable.Map<String, QuartzSchedule> schedules;
    private final scala.collection.mutable.Map<String, JobKey> runningJobs;
    private volatile byte bitmap$0;

    public static QuartzSchedulerExtension get(ActorSystem actorSystem) {
        return QuartzSchedulerExtension$.MODULE$.get(actorSystem);
    }

    public static Extension createExtension(ExtendedActorSystem extendedActorSystem) {
        return QuartzSchedulerExtension$.MODULE$.createExtension(extendedActorSystem);
    }

    public static ExtensionId<QuartzSchedulerExtension> lookup() {
        return QuartzSchedulerExtension$.MODULE$.lookup();
    }

    public static Extension apply(ActorSystem actorSystem) {
        return QuartzSchedulerExtension$.MODULE$.apply(actorSystem);
    }

    private LoggingAdapter log() {
        return this.log;
    }

    public String schedulerName() {
        return new StringOps(Predef$.MODULE$.augmentString("QuartzScheduler~%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.system.name()}));
    }

    public Config config() {
        return this.config;
    }

    public int threadCount() {
        return this.threadCount;
    }

    public int threadPriority() {
        return this.threadPriority;
    }

    public boolean daemonThreads_$qmark() {
        return this.daemonThreads_$qmark;
    }

    public TimeZone defaultTimezone() {
        return this.defaultTimezone;
    }

    public scala.collection.immutable.Map<String, QuartzSchedule> schedules() {
        return this.schedules;
    }

    public void schedules_$eq(scala.collection.immutable.Map<String, QuartzSchedule> x$1) {
        this.schedules = x$1;
    }

    public scala.collection.mutable.Map<String, JobKey> runningJobs() {
        return this.runningJobs;
    }

    public void standby() {
        this.scheduler().standby();
    }

    public boolean isInStandbyMode() {
        return this.scheduler().isInStandbyMode();
    }

    public boolean start() {
        boolean bl;
        boolean bl2 = this.isStarted();
        if (bl2) {
            this.log().warning("Cannot start scheduler, already started.");
            bl = false;
        } else if (!bl2) {
            this.scheduler().start();
            bl = true;
        } else {
            throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl2));
        }
        return bl;
    }

    public boolean isStarted() {
        return this.scheduler().isStarted();
    }

    public Option<Date> nextTrigger(String name) {
        return this.runningJobs().get((Object)name).flatMap((Function1 & Serializable & scala.Serializable)jobKey -> ((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.scheduler().getTriggersOfJob(jobKey)).asScala()).headOption().map((Function1 & Serializable & scala.Serializable)trigger -> trigger.getNextFireTime()));
    }

    public void suspendAll() {
        this.log().info("Suspending all Quartz jobs.");
        this.scheduler().pauseAll();
    }

    public void shutdown(boolean waitForJobsToComplete) {
        this.scheduler().shutdown(waitForJobsToComplete);
    }

    public boolean shutdown$default$1() {
        return false;
    }

    public boolean suspendJob(String name) {
        boolean bl;
        Option option = this.runningJobs().get((Object)name);
        if (option instanceof Some) {
            Some some = (Some)option;
            JobKey job = (JobKey)some.value();
            this.log().info("Suspending Quartz Job '{}'", (Object)name);
            this.scheduler().pauseJob(job);
            bl = true;
        } else if (None$.MODULE$.equals(option)) {
            this.log().warning("No running Job named '{}' found: Cannot suspend", (Object)name);
            bl = false;
        } else {
            throw new MatchError((Object)option);
        }
        return bl;
    }

    public boolean resumeJob(String name) {
        boolean bl;
        Option option = this.runningJobs().get((Object)name);
        if (option instanceof Some) {
            Some some = (Some)option;
            JobKey job = (JobKey)some.value();
            this.log().info("Resuming Quartz Job '{}'", (Object)name);
            this.scheduler().resumeJob(job);
            bl = true;
        } else if (None$.MODULE$.equals(option)) {
            this.log().warning("No running Job named '{}' found: Cannot unpause", (Object)name);
            bl = false;
        } else {
            throw new MatchError((Object)option);
        }
        return bl;
    }

    public void resumeAll() {
        this.log().info("Resuming all Quartz jobs.");
        this.scheduler().resumeAll();
    }

    public boolean cancelJob(String name) {
        boolean bl;
        Option option = this.runningJobs().get((Object)name);
        if (option instanceof Some) {
            Some some = (Some)option;
            JobKey job = (JobKey)some.value();
            this.log().info("Cancelling Quartz Job '{}'", (Object)name);
            boolean result = this.scheduler().deleteJob(job);
            this.runningJobs().$minus$eq((Object)name);
            bl = result;
        } else if (None$.MODULE$.equals(option)) {
            this.log().warning("No running Job named '{}' found: Cannot cancel", (Object)name);
            bl = false;
        } else {
            throw new MatchError((Object)option);
        }
        return bl;
    }

    public Date createJobSchedule(String name, ActorRef receiver, Object msg, Option<String> description, String cronExpression, Option<String> calendar, TimeZone timezone) {
        this.createSchedule(name, description, cronExpression, calendar, timezone);
        return this.schedule(name, receiver, msg);
    }

    public Option<String> createJobSchedule$default$4() {
        return None$.MODULE$;
    }

    public Option<String> createJobSchedule$default$6() {
        return None$.MODULE$;
    }

    public TimeZone createJobSchedule$default$7() {
        return this.defaultTimezone();
    }

    public Date updateJobSchedule(String name, ActorRef receiver, Object msg, Option<String> description, String cronExpression, Option<String> calendar, TimeZone timezone) {
        return this.rescheduleJob(name, receiver, msg, description, cronExpression, calendar, timezone);
    }

    public Option<String> updateJobSchedule$default$4() {
        return None$.MODULE$;
    }

    public Option<String> updateJobSchedule$default$6() {
        return None$.MODULE$;
    }

    public TimeZone updateJobSchedule$default$7() {
        return this.defaultTimezone();
    }

    public boolean deleteJobSchedule(String name) {
        return this.unscheduleJob(name);
    }

    /*
     * WARNING - void declaration
     */
    public boolean unscheduleJob(String name) {
        void var2_2;
        block0: {
            boolean isJobCancelled = this.cancelJob(name);
            if (!isJobCancelled) break block0;
            this.removeSchedule(name);
        }
        return (boolean)var2_2;
    }

    public void createSchedule(String name, Option<String> description, String cronExpression, Option<String> calendar, TimeZone timezone) {
        CronExpression cronExpression2;
        Option option = this.schedules().get((Object)name);
        if (option instanceof Some) {
            throw new IllegalArgumentException(new StringBuilder(44).append("A schedule with this name already exists: [").append(name).append("]").toString());
        }
        if (None$.MODULE$.equals(option)) {
            CronExpression expr;
            Either either = Exception$.MODULE$.catching((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Class[]{ParseException.class})).either((Function0 & Serializable & scala.Serializable)() -> new CronExpression(cronExpression));
            if (either instanceof Left) {
                Left left = (Left)either;
                Throwable t = (Throwable)left.value();
                throw new IllegalArgumentException(new StringBuilder(77).append("Invalid 'expression' for Cron Schedule '").append(name).append("'. Failed to validate CronExpression.").toString(), t);
            }
            if (!(either instanceof Right)) {
                throw new MatchError((Object)either);
            }
            Right right = (Right)either;
            cronExpression2 = expr = (CronExpression)right.value();
        } else {
            throw new MatchError((Object)option);
        }
        CronExpression expression = cronExpression2;
        QuartzCronSchedule quartzSchedule = new QuartzCronSchedule(name, description, expression, timezone, calendar);
        this.schedules_$eq((scala.collection.immutable.Map<String, QuartzSchedule>)this.schedules().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)name), (Object)quartzSchedule)));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public Option<String> createSchedule$default$2() {
        return None$.MODULE$;
    }

    public Option<String> createSchedule$default$4() {
        return None$.MODULE$;
    }

    public TimeZone createSchedule$default$5() {
        return this.defaultTimezone();
    }

    public Date rescheduleJob(String name, ActorRef receiver, Object msg, Option<String> description, String cronExpression, Option<String> calendar, TimeZone timezone) {
        this.cancelJob(name);
        this.removeSchedule(name);
        this.createSchedule(name, description, cronExpression, calendar, timezone);
        return this.scheduleInternal(name, receiver, msg, (Option<Date>)None$.MODULE$);
    }

    public Option<String> rescheduleJob$default$4() {
        return None$.MODULE$;
    }

    public Option<String> rescheduleJob$default$6() {
        return None$.MODULE$;
    }

    public TimeZone rescheduleJob$default$7() {
        return this.defaultTimezone();
    }

    private void removeSchedule(String name) {
        this.schedules_$eq((scala.collection.immutable.Map<String, QuartzSchedule>)((scala.collection.immutable.Map)this.schedules().$minus((Object)name)));
    }

    public Date schedule(String name, ActorRef receiver, Object msg) {
        return this.scheduleInternal(name, receiver, msg, (Option<Date>)None$.MODULE$);
    }

    public Date schedule(String name, ActorSelection receiver, Object msg) {
        return this.scheduleInternal(name, receiver, msg, (Option<Date>)None$.MODULE$);
    }

    public Date schedule(String name, EventStream receiver, Object msg) {
        return this.scheduleInternal(name, receiver, msg, (Option<Date>)None$.MODULE$);
    }

    public Date schedule(String name, ActorRef receiver, Object msg, Option<Date> startDate) {
        return this.scheduleInternal(name, receiver, msg, startDate);
    }

    public Date schedule(String name, ActorSelection receiver, Object msg, Option<Date> startDate) {
        return this.scheduleInternal(name, receiver, msg, startDate);
    }

    public Date schedule(String name, EventStream receiver, Object msg, Option<Date> startDate) {
        return this.scheduleInternal(name, receiver, msg, startDate);
    }

    private Date scheduleInternal(String name, Object receiver, Object msg, Option<Date> startDate) {
        Option option = this.schedules().get((Object)name);
        if (!(option instanceof Some)) {
            if (None$.MODULE$.equals(option)) {
                throw new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString("No matching quartz configuration found for schedule '%s'")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name})));
            }
            throw new MatchError((Object)option);
        }
        Some some = (Some)option;
        QuartzSchedule schedule = (QuartzSchedule)some.value();
        Date date = this.scheduleJob(name, receiver, msg, startDate, schedule);
        return date;
    }

    public Date scheduleJob(String name, Object receiver, Object msg, Option<Date> startDate, QuartzSchedule schedule) {
        this.log().info("Setting up scheduled job '{}', with '{}'", (Object)name, (Object)schedule);
        scala.collection.immutable.Map jobDataMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"logBus"), (Object)this.system.eventStream()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"receiver"), receiver), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"message"), msg)}));
        JobDataMap jobData = JobDataMapSupport.newJobDataMap((java.util.Map)((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)jobDataMap).asJava()));
        JobDetail job = JobBuilder.newJob(SimpleActorMessageJob.class).withIdentity(new StringBuilder(4).append(name).append("_Job").toString()).usingJobData(jobData).withDescription((String)schedule.description().orNull(Predef$.MODULE$.$conforms())).build();
        this.log().debug("Adding jobKey {} to runningJobs map.", (Object)job.getKey());
        this.runningJobs().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)name), (Object)job.getKey()));
        this.log().debug("Building Trigger with startDate '{}", startDate.getOrElse((Function0 & Serializable & scala.Serializable)() -> new Date()));
        Trigger trigger = schedule.buildTrigger(name, startDate);
        this.log().debug("Scheduling Job '{}' and Trigger '{}'. Is Scheduler Running? {}", (Object)job, (Object)trigger, (Object)BoxesRunTime.boxToBoolean((boolean)this.scheduler().isStarted()));
        return this.scheduler().scheduleJob(job, trigger);
    }

    public void initialiseCalendars() {
        QuartzCalendars$.MODULE$.apply(this.config(), this.defaultTimezone()).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)QuartzSchedulerExtension.$anonfun$initialiseCalendars$1(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            QuartzSchedulerExtension.$anonfun$initialiseCalendars$2(this, x$1);
            return BoxedUnit.UNIT;
        });
        this.log().info(new StringBuilder(23).append("Initialized calendars: ").append(((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(this.scheduler().getCalendarNames()).asScala()).mkString(",")).toString());
    }

    /*
     * WARNING - void declaration
     */
    private SimpleThreadPool threadPool$lzycompute() {
        QuartzSchedulerExtension quartzSchedulerExtension = this;
        synchronized (quartzSchedulerExtension) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                void var2_2;
                SimpleThreadPool _tp = new SimpleThreadPool(this.threadCount(), this.threadPriority());
                _tp.setThreadNamePrefix("AKKA_QRTZ_");
                _tp.setMakeThreadsDaemons(this.daemonThreads_$qmark());
                this.threadPool = var2_2;
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.threadPool;
    }

    public SimpleThreadPool threadPool() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.threadPool$lzycompute() : this.threadPool;
    }

    private JobStore jobStore$lzycompute() {
        QuartzSchedulerExtension quartzSchedulerExtension = this;
        synchronized (quartzSchedulerExtension) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.jobStore = new RAMJobStore();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.jobStore;
    }

    public JobStore jobStore() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.jobStore$lzycompute() : this.jobStore;
    }

    /*
     * WARNING - void declaration
     */
    private Scheduler scheduler$lzycompute() {
        QuartzSchedulerExtension quartzSchedulerExtension = this;
        synchronized (quartzSchedulerExtension) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                void var2_2;
                DirectSchedulerFactory.getInstance().createScheduler(this.schedulerName(), this.system.name(), (ThreadPool)this.threadPool(), this.jobStore());
                Scheduler scheduler = DirectSchedulerFactory.getInstance().getScheduler(this.schedulerName());
                this.log().debug("Initialized a Quartz Scheduler '{}'", (Object)scheduler);
                this.system.registerOnTermination((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    this.log().info("Shutting down Quartz Scheduler with ActorSystem Termination (Any jobs awaiting completion will end as well, as actors are ending)...");
                    scheduler.shutdown(false);
                });
                this.scheduler = var2_2;
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.scheduler;
    }

    public Scheduler scheduler() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.scheduler$lzycompute() : this.scheduler;
    }

    public static final /* synthetic */ boolean $anonfun$initialiseCalendars$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$initialiseCalendars$2(QuartzSchedulerExtension $this, Tuple2 x$1) {
        Tuple2 tuple2 = x$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String name = (String)tuple2._1();
        Calendar calendar = (Calendar)tuple2._2();
        $this.log().info("Configuring Calendar '{}'", (Object)name);
        $this.scheduler().addCalendar(name, calendar, true, true);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public QuartzSchedulerExtension(ExtendedActorSystem system) {
        this.system = system;
        this.log = Logging$.MODULE$.apply((ActorSystem)system, (Object)this, package$.MODULE$.quartzExtensionLoggerType());
        this.config = system.settings().config().getConfig("akka.quartz").root().toConfig();
        this.threadCount = this.config().getInt("threadPool.threadCount");
        Predef$.MODULE$.require(this.threadCount() >= 1, (Function0 & Serializable & scala.Serializable)() -> "Quartz Thread Count (akka.quartz.threadPool.threadCount) must be a positive integer.");
        this.threadPriority = this.config().getInt("threadPool.threadPriority");
        Predef$.MODULE$.require(this.threadPriority() >= 1 && this.threadPriority() <= 10, (Function0 & Serializable & scala.Serializable)() -> "Quartz Thread Priority (akka.quartz.threadPool.threadPriority) must be a positive integer between 1 (lowest) and 10 (highest).");
        this.daemonThreads_$qmark = this.config().getBoolean("threadPool.daemonThreads");
        this.defaultTimezone = TimeZone.getTimeZone(this.config().getString("defaultTimezone"));
        this.schedules = QuartzSchedules$.MODULE$.apply(this.config(), this.defaultTimezone());
        this.runningJobs = Map$.MODULE$.empty();
        this.log().debug("Configured Schedules: {}", this.schedules());
        this.scheduler().start();
        this.initialiseCalendars();
    }
}

