/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import org.h2.api.Interval;
import org.h2.api.IntervalQualifier;
import org.h2.api.TimestampWithTimeZone;
import org.h2.engine.Mode;
import org.h2.engine.SessionInterface;
import org.h2.engine.SysProperties;
import org.h2.jdbc.JdbcArray;
import org.h2.jdbc.JdbcBlob;
import org.h2.jdbc.JdbcClob;
import org.h2.jdbc.JdbcConnection;
import org.h2.jdbc.JdbcLob;
import org.h2.message.DbException;
import org.h2.util.JdbcUtils;
import org.h2.util.LocalDateTimeUtils;
import org.h2.util.Utils;
import org.h2.value.Value;
import org.h2.value.ValueArray;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueByte;
import org.h2.value.ValueBytes;
import org.h2.value.ValueDate;
import org.h2.value.ValueDecimal;
import org.h2.value.ValueDouble;
import org.h2.value.ValueFloat;
import org.h2.value.ValueGeometry;
import org.h2.value.ValueInt;
import org.h2.value.ValueInterval;
import org.h2.value.ValueJavaObject;
import org.h2.value.ValueLobDb;
import org.h2.value.ValueLong;
import org.h2.value.ValueNull;
import org.h2.value.ValueResultSet;
import org.h2.value.ValueRow;
import org.h2.value.ValueShort;
import org.h2.value.ValueString;
import org.h2.value.ValueStringFixed;
import org.h2.value.ValueStringIgnoreCase;
import org.h2.value.ValueTime;
import org.h2.value.ValueTimestamp;
import org.h2.value.ValueTimestampTimeZone;
import org.h2.value.ValueUuid;

public class DataType {
    public static final int TYPE_RESULT_SET = -10;
    public static final Class<?> GEOMETRY_CLASS;
    private static final String GEOMETRY_CLASS_NAME = "org.locationtech.jts.geom.Geometry";
    private static final ArrayList<DataType> TYPES;
    private static final HashMap<String, DataType> TYPES_BY_NAME;
    static final DataType[] TYPES_BY_VALUE_TYPE;
    public int type;
    public String name;
    public int sqlType;
    public int sqlTypePos;
    public long maxPrecision;
    public int minScale;
    public int maxScale;
    public boolean decimal;
    public String prefix;
    public String suffix;
    public String params;
    public boolean autoIncrement;
    public boolean caseSensitive;
    public boolean supportsPrecision;
    public boolean supportsScale;
    public long defaultPrecision;
    public int defaultScale;
    public boolean hidden;

    private static void addDecimal() {
        DataType.add(6, 3, DataType.createNumeric(Integer.MAX_VALUE, 65535, Short.MAX_VALUE), new String[]{"DECIMAL", "DEC"});
    }

    private static void addNumeric() {
        DataType.add(6, 2, DataType.createNumeric(Integer.MAX_VALUE, 65535, Short.MAX_VALUE), new String[]{"NUMERIC", "NUMBER"});
    }

    private static void addInterval(int n) {
        IntervalQualifier intervalQualifier = IntervalQualifier.valueOf(n - 26);
        String string = intervalQualifier.toString();
        DataType dataType = new DataType();
        dataType.prefix = "INTERVAL ";
        dataType.suffix = ' ' + string;
        dataType.supportsPrecision = true;
        dataType.defaultPrecision = 2L;
        dataType.maxPrecision = 18L;
        if (intervalQualifier.hasSeconds()) {
            dataType.supportsScale = true;
            dataType.defaultScale = 6;
            dataType.maxScale = 9;
            dataType.params = "PRECISION,SCALE";
        } else {
            dataType.params = "PRECISION";
        }
        DataType.add(n, 1111, dataType, new String[]{("INTERVAL " + string).intern()});
    }

    private static void add(int n, int n2, DataType dataType, String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            DataType dataType2 = new DataType();
            dataType2.type = n;
            dataType2.sqlType = n2;
            dataType2.name = stringArray[i];
            dataType2.autoIncrement = dataType.autoIncrement;
            dataType2.decimal = dataType.decimal;
            dataType2.maxPrecision = dataType.maxPrecision;
            dataType2.maxScale = dataType.maxScale;
            dataType2.minScale = dataType.minScale;
            dataType2.params = dataType.params;
            dataType2.prefix = dataType.prefix;
            dataType2.suffix = dataType.suffix;
            dataType2.supportsPrecision = dataType.supportsPrecision;
            dataType2.supportsScale = dataType.supportsScale;
            dataType2.defaultPrecision = dataType.defaultPrecision;
            dataType2.defaultScale = dataType.defaultScale;
            dataType2.caseSensitive = dataType.caseSensitive;
            dataType2.hidden = i > 0;
            for (DataType dataType3 : TYPES) {
                if (dataType3.sqlType != dataType2.sqlType) continue;
                ++dataType2.sqlTypePos;
            }
            TYPES_BY_NAME.put(dataType2.name, dataType2);
            if (TYPES_BY_VALUE_TYPE[n] == null) {
                DataType.TYPES_BY_VALUE_TYPE[n] = dataType2;
            }
            TYPES.add(dataType2);
        }
    }

    public static DataType createNumeric(int n, int n2, boolean bl) {
        DataType dataType = new DataType();
        dataType.defaultPrecision = dataType.maxPrecision = (long)n;
        dataType.maxScale = dataType.minScale = n2;
        dataType.defaultScale = dataType.minScale;
        dataType.decimal = true;
        dataType.autoIncrement = bl;
        return dataType;
    }

    public static DataType createNumeric(int n, int n2, int n3) {
        DataType dataType = new DataType();
        dataType.maxPrecision = n;
        dataType.defaultPrecision = n2;
        dataType.defaultScale = n3;
        dataType.params = "PRECISION,SCALE";
        dataType.supportsPrecision = true;
        dataType.supportsScale = true;
        dataType.maxScale = n;
        dataType.decimal = true;
        return dataType;
    }

    public static DataType createDate(int n, int n2, String string, boolean bl, int n3, int n4) {
        DataType dataType = new DataType();
        dataType.prefix = string + " '";
        dataType.suffix = "'";
        dataType.maxPrecision = n;
        dataType.defaultPrecision = n2;
        if (bl) {
            dataType.params = "SCALE";
            dataType.supportsScale = true;
            dataType.maxScale = n4;
            dataType.defaultScale = n3;
        }
        return dataType;
    }

    private static DataType createString(boolean bl) {
        DataType dataType = new DataType();
        dataType.prefix = "'";
        dataType.suffix = "'";
        dataType.params = "LENGTH";
        dataType.caseSensitive = bl;
        dataType.supportsPrecision = true;
        dataType.maxPrecision = Integer.MAX_VALUE;
        dataType.defaultPrecision = Integer.MAX_VALUE;
        return dataType;
    }

    private static DataType createLob() {
        DataType dataType = DataType.createString(true);
        dataType.maxPrecision = Long.MAX_VALUE;
        dataType.defaultPrecision = Long.MAX_VALUE;
        return dataType;
    }

    private static DataType createGeometry() {
        DataType dataType = new DataType();
        dataType.prefix = "'";
        dataType.suffix = "'";
        dataType.params = "TYPE,SRID";
        dataType.maxPrecision = Integer.MAX_VALUE;
        dataType.defaultPrecision = Integer.MAX_VALUE;
        return dataType;
    }

    public static ArrayList<DataType> getTypes() {
        return TYPES;
    }

    public static Value readValue(SessionInterface sessionInterface, ResultSet resultSet, int n, int n2) {
        try {
            Value value;
            switch (n2) {
                case 0: {
                    return ValueNull.INSTANCE;
                }
                case 12: {
                    Object object = resultSet.getObject(n);
                    if (object instanceof byte[]) {
                        value = ValueBytes.getNoCopy((byte[])object);
                        break;
                    }
                    if (object != null) {
                        value = ValueUuid.get((UUID)object);
                        break;
                    }
                    value = ValueNull.INSTANCE;
                    break;
                }
                case 20: {
                    Object object = resultSet.getObject(n);
                    if (object instanceof UUID) {
                        value = ValueUuid.get((UUID)object);
                        break;
                    }
                    if (object != null) {
                        value = ValueUuid.get((byte[])object);
                        break;
                    }
                    value = ValueNull.INSTANCE;
                    break;
                }
                case 1: {
                    boolean bl = resultSet.getBoolean(n);
                    value = resultSet.wasNull() ? ValueNull.INSTANCE : ValueBoolean.get(bl);
                    break;
                }
                case 2: {
                    byte by = resultSet.getByte(n);
                    value = resultSet.wasNull() ? ValueNull.INSTANCE : ValueByte.get(by);
                    break;
                }
                case 10: {
                    Date date = resultSet.getDate(n);
                    value = date == null ? ValueNull.INSTANCE : ValueDate.get(date);
                    break;
                }
                case 9: {
                    Time time = resultSet.getTime(n);
                    value = time == null ? ValueNull.INSTANCE : ValueTime.get(time);
                    break;
                }
                case 11: {
                    Timestamp timestamp = resultSet.getTimestamp(n);
                    value = timestamp == null ? ValueNull.INSTANCE : ValueTimestamp.get(timestamp);
                    break;
                }
                case 24: {
                    Object object = resultSet.getObject(n);
                    if (object == null) {
                        value = ValueNull.INSTANCE;
                        break;
                    }
                    if (LocalDateTimeUtils.isJava8DateApiPresent() && LocalDateTimeUtils.OFFSET_DATE_TIME.isInstance(object)) {
                        value = LocalDateTimeUtils.offsetDateTimeToValue(object);
                        break;
                    }
                    TimestampWithTimeZone timestampWithTimeZone = (TimestampWithTimeZone)object;
                    value = ValueTimestampTimeZone.get(timestampWithTimeZone);
                    break;
                }
                case 6: {
                    BigDecimal bigDecimal = resultSet.getBigDecimal(n);
                    value = bigDecimal == null ? ValueNull.INSTANCE : ValueDecimal.get(bigDecimal);
                    break;
                }
                case 7: {
                    double d = resultSet.getDouble(n);
                    value = resultSet.wasNull() ? ValueNull.INSTANCE : ValueDouble.get(d);
                    break;
                }
                case 8: {
                    float f = resultSet.getFloat(n);
                    value = resultSet.wasNull() ? ValueNull.INSTANCE : ValueFloat.get(f);
                    break;
                }
                case 4: {
                    int n3 = resultSet.getInt(n);
                    value = resultSet.wasNull() ? ValueNull.INSTANCE : ValueInt.get(n3);
                    break;
                }
                case 5: {
                    long l = resultSet.getLong(n);
                    value = resultSet.wasNull() ? ValueNull.INSTANCE : ValueLong.get(l);
                    break;
                }
                case 3: {
                    short s = resultSet.getShort(n);
                    value = resultSet.wasNull() ? ValueNull.INSTANCE : ValueShort.get(s);
                    break;
                }
                case 14: {
                    String string = resultSet.getString(n);
                    value = string == null ? ValueNull.INSTANCE : ValueStringIgnoreCase.get(string);
                    break;
                }
                case 21: {
                    String string = resultSet.getString(n);
                    value = string == null ? ValueNull.INSTANCE : ValueStringFixed.get(string);
                    break;
                }
                case 13: {
                    String string = resultSet.getString(n);
                    value = string == null ? ValueNull.INSTANCE : ValueString.get(string);
                    break;
                }
                case 16: {
                    Reader reader;
                    String string;
                    value = sessionInterface == null ? ((string = resultSet.getString(n)) == null ? ValueNull.INSTANCE : ValueLobDb.createSmallLob(16, string.getBytes(StandardCharsets.UTF_8))) : ((reader = resultSet.getCharacterStream(n)) == null ? ValueNull.INSTANCE : sessionInterface.getDataHandler().getLobStorage().createClob(new BufferedReader(reader), -1L));
                    if (sessionInterface == null) break;
                    sessionInterface.addTemporaryLob(value);
                    break;
                }
                case 15: {
                    if (sessionInterface == null) {
                        byte[] byArray = resultSet.getBytes(n);
                        return byArray == null ? ValueNull.INSTANCE : ValueLobDb.createSmallLob(15, byArray);
                    }
                    InputStream inputStream = resultSet.getBinaryStream(n);
                    value = inputStream == null ? ValueNull.INSTANCE : sessionInterface.getDataHandler().getLobStorage().createBlob(inputStream, -1L);
                    sessionInterface.addTemporaryLob(value);
                    break;
                }
                case 19: {
                    if (SysProperties.serializeJavaObject) {
                        byte[] byArray = resultSet.getBytes(n);
                        value = byArray == null ? ValueNull.INSTANCE : ValueJavaObject.getNoCopy(null, byArray, sessionInterface.getDataHandler());
                        break;
                    }
                    Object object = resultSet.getObject(n);
                    value = object == null ? ValueNull.INSTANCE : ValueJavaObject.getNoCopy(object, null, sessionInterface.getDataHandler());
                    break;
                }
                case 17: {
                    Array array = resultSet.getArray(n);
                    if (array == null) {
                        return ValueNull.INSTANCE;
                    }
                    Object[] objectArray = (Object[])array.getArray();
                    if (objectArray == null) {
                        return ValueNull.INSTANCE;
                    }
                    int n4 = objectArray.length;
                    Value[] valueArray = new Value[n4];
                    for (int i = 0; i < n4; ++i) {
                        valueArray[i] = DataType.convertToValue(sessionInterface, objectArray[i], 0);
                    }
                    value = ValueArray.get(valueArray);
                    break;
                }
                case 25: {
                    int n5 = resultSet.getInt(n);
                    value = resultSet.wasNull() ? ValueNull.INSTANCE : ValueInt.get(n5);
                    break;
                }
                case 39: {
                    Object[] objectArray = (Object[])resultSet.getObject(n);
                    if (objectArray == null) {
                        return ValueNull.INSTANCE;
                    }
                    int n6 = objectArray.length;
                    Value[] valueArray = new Value[n6];
                    for (int i = 0; i < n6; ++i) {
                        valueArray[i] = DataType.convertToValue(sessionInterface, objectArray[i], 0);
                    }
                    value = ValueRow.get(valueArray);
                    break;
                }
                case 18: {
                    ResultSet resultSet2 = (ResultSet)resultSet.getObject(n);
                    if (resultSet2 == null) {
                        return ValueNull.INSTANCE;
                    }
                    return ValueResultSet.get(sessionInterface, resultSet2, Integer.MAX_VALUE);
                }
                case 22: {
                    Object object = resultSet.getObject(n);
                    if (object == null) {
                        return ValueNull.INSTANCE;
                    }
                    return ValueGeometry.getFromGeometry(object);
                }
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: {
                    Object object = resultSet.getObject(n);
                    if (object == null) {
                        return ValueNull.INSTANCE;
                    }
                    Interval interval = (Interval)object;
                    return ValueInterval.from(interval.getQualifier(), interval.isNegative(), interval.getLeading(), interval.getRemaining());
                }
                default: {
                    if (JdbcUtils.customDataTypesHandler != null) {
                        return JdbcUtils.customDataTypesHandler.getValue(n2, resultSet.getObject(n), sessionInterface.getDataHandler());
                    }
                    throw DbException.throwInternalError("type=" + n2);
                }
            }
            return value;
        }
        catch (SQLException sQLException) {
            throw DbException.convert(sQLException);
        }
    }

    public static String getTypeClassName(int n, boolean bl) {
        switch (n) {
            case 1: {
                return Boolean.class.getName();
            }
            case 2: {
                if (bl && !SysProperties.OLD_RESULT_SET_GET_OBJECT) {
                    return Integer.class.getName();
                }
                return Byte.class.getName();
            }
            case 3: {
                if (bl && !SysProperties.OLD_RESULT_SET_GET_OBJECT) {
                    return Integer.class.getName();
                }
                return Short.class.getName();
            }
            case 4: {
                return Integer.class.getName();
            }
            case 5: {
                return Long.class.getName();
            }
            case 6: {
                return BigDecimal.class.getName();
            }
            case 9: {
                return Time.class.getName();
            }
            case 10: {
                return Date.class.getName();
            }
            case 11: {
                return Timestamp.class.getName();
            }
            case 24: {
                if (SysProperties.RETURN_OFFSET_DATE_TIME && LocalDateTimeUtils.isJava8DateApiPresent()) {
                    return LocalDateTimeUtils.OFFSET_DATE_TIME.getName();
                }
                return TimestampWithTimeZone.class.getName();
            }
            case 12: 
            case 20: {
                return byte[].class.getName();
            }
            case 13: 
            case 14: 
            case 21: 
            case 25: {
                return String.class.getName();
            }
            case 15: {
                return Blob.class.getName();
            }
            case 16: {
                return Clob.class.getName();
            }
            case 7: {
                return Double.class.getName();
            }
            case 8: {
                return Float.class.getName();
            }
            case 0: {
                return null;
            }
            case 19: {
                return Object.class.getName();
            }
            case -1: {
                return Object.class.getName();
            }
            case 17: {
                return Array.class.getName();
            }
            case 18: {
                return ResultSet.class.getName();
            }
            case 22: {
                return GEOMETRY_CLASS != null ? GEOMETRY_CLASS_NAME : String.class.getName();
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                return Interval.class.getName();
            }
        }
        if (JdbcUtils.customDataTypesHandler != null) {
            return JdbcUtils.customDataTypesHandler.getDataTypeClassName(n);
        }
        throw DbException.throwInternalError("type=" + n);
    }

    public static DataType getDataType(int n) {
        DataType dataType;
        if (n == -1) {
            throw DbException.get(50004, "?");
        }
        if (n >= 0 && n < 40 && (dataType = TYPES_BY_VALUE_TYPE[n]) != null) {
            return dataType;
        }
        if (JdbcUtils.customDataTypesHandler != null && (dataType = JdbcUtils.customDataTypesHandler.getDataTypeById(n)) != null) {
            return dataType;
        }
        return TYPES_BY_VALUE_TYPE[0];
    }

    public static int convertTypeToSQLType(int n) {
        return DataType.getDataType((int)n).sqlType;
    }

    public static int convertSQLTypeToValueType(int n, String string) {
        switch (n) {
            case -2: {
                if (!string.equalsIgnoreCase("UUID")) break;
                return 20;
            }
            case 1111: 
            case 2000: {
                if (!string.equalsIgnoreCase("geometry")) break;
                return 22;
            }
        }
        return DataType.convertSQLTypeToValueType(n);
    }

    public static int getValueTypeFromResultSet(ResultSetMetaData resultSetMetaData, int n) throws SQLException {
        return DataType.convertSQLTypeToValueType(resultSetMetaData.getColumnType(n), resultSetMetaData.getColumnTypeName(n));
    }

    public static int convertSQLTypeToValueType(int n) {
        switch (n) {
            case -15: 
            case 1: {
                return 21;
            }
            case -16: 
            case -9: 
            case -1: 
            case 12: {
                return 13;
            }
            case 2: 
            case 3: {
                return 6;
            }
            case -7: 
            case 16: {
                return 1;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return 3;
            }
            case -6: {
                return 2;
            }
            case -5: {
                return 5;
            }
            case 7: {
                return 8;
            }
            case 6: 
            case 8: {
                return 7;
            }
            case -4: 
            case -3: 
            case -2: {
                return 12;
            }
            case 1111: 
            case 2000: {
                return 19;
            }
            case 91: {
                return 10;
            }
            case 92: {
                return 9;
            }
            case 93: {
                return 11;
            }
            case 2014: {
                return 24;
            }
            case 2004: {
                return 15;
            }
            case 2005: 
            case 2011: {
                return 16;
            }
            case 0: {
                return 0;
            }
            case 2003: {
                return 17;
            }
            case -10: {
                return 18;
            }
        }
        throw DbException.get(50004, Integer.toString(n));
    }

    public static int getTypeFromClass(Class<?> clazz) {
        if (clazz == null || Void.TYPE == clazz) {
            return 0;
        }
        if (clazz.isPrimitive()) {
            clazz = Utils.getNonPrimitiveClass(clazz);
        }
        if (String.class == clazz) {
            return 13;
        }
        if (Integer.class == clazz) {
            return 4;
        }
        if (Long.class == clazz) {
            return 5;
        }
        if (Boolean.class == clazz) {
            return 1;
        }
        if (Double.class == clazz) {
            return 7;
        }
        if (Byte.class == clazz) {
            return 2;
        }
        if (Short.class == clazz) {
            return 3;
        }
        if (Character.class == clazz) {
            throw DbException.get(22018, "char (not supported)");
        }
        if (Float.class == clazz) {
            return 8;
        }
        if (byte[].class == clazz) {
            return 12;
        }
        if (UUID.class == clazz) {
            return 20;
        }
        if (Void.class == clazz) {
            return 0;
        }
        if (BigDecimal.class.isAssignableFrom(clazz)) {
            return 6;
        }
        if (ResultSet.class.isAssignableFrom(clazz)) {
            return 18;
        }
        if (ValueLobDb.class.isAssignableFrom(clazz)) {
            return 15;
        }
        if (Date.class.isAssignableFrom(clazz)) {
            return 10;
        }
        if (Time.class.isAssignableFrom(clazz)) {
            return 9;
        }
        if (Timestamp.class.isAssignableFrom(clazz)) {
            return 11;
        }
        if (java.util.Date.class.isAssignableFrom(clazz)) {
            return 11;
        }
        if (Reader.class.isAssignableFrom(clazz)) {
            return 16;
        }
        if (Clob.class.isAssignableFrom(clazz)) {
            return 16;
        }
        if (InputStream.class.isAssignableFrom(clazz)) {
            return 15;
        }
        if (Blob.class.isAssignableFrom(clazz)) {
            return 15;
        }
        if (Object[].class.isAssignableFrom(clazz)) {
            return 17;
        }
        if (DataType.isGeometryClass(clazz)) {
            return 22;
        }
        if (LocalDateTimeUtils.LOCAL_DATE == clazz) {
            return 10;
        }
        if (LocalDateTimeUtils.LOCAL_TIME == clazz) {
            return 9;
        }
        if (LocalDateTimeUtils.LOCAL_DATE_TIME == clazz) {
            return 11;
        }
        if (LocalDateTimeUtils.OFFSET_DATE_TIME == clazz || LocalDateTimeUtils.INSTANT == clazz) {
            return 24;
        }
        if (JdbcUtils.customDataTypesHandler != null) {
            return JdbcUtils.customDataTypesHandler.getTypeIdFromClass(clazz);
        }
        return 19;
    }

    public static Value convertToValue(SessionInterface sessionInterface, Object object, int n) {
        Value value = DataType.convertToValue1(sessionInterface, object, n);
        if (sessionInterface != null) {
            sessionInterface.addTemporaryLob(value);
        }
        return value;
    }

    private static Value convertToValue1(SessionInterface sessionInterface, Object object, int n) {
        if (object == null) {
            return ValueNull.INSTANCE;
        }
        if (n == 19) {
            return ValueJavaObject.getNoCopy(object, null, sessionInterface.getDataHandler());
        }
        if (object instanceof String) {
            return ValueString.get((String)object);
        }
        if (object instanceof Value) {
            return (Value)object;
        }
        if (object instanceof Long) {
            return ValueLong.get((Long)object);
        }
        if (object instanceof Integer) {
            return ValueInt.get((Integer)object);
        }
        if (object instanceof BigInteger) {
            return ValueDecimal.get(new BigDecimal((BigInteger)object));
        }
        if (object instanceof BigDecimal) {
            return ValueDecimal.get((BigDecimal)object);
        }
        if (object instanceof Boolean) {
            return ValueBoolean.get((Boolean)object);
        }
        if (object instanceof Byte) {
            return ValueByte.get((Byte)object);
        }
        if (object instanceof Short) {
            return ValueShort.get((Short)object);
        }
        if (object instanceof Float) {
            return ValueFloat.get(((Float)object).floatValue());
        }
        if (object instanceof Double) {
            return ValueDouble.get((Double)object);
        }
        if (object instanceof byte[]) {
            return ValueBytes.get((byte[])object);
        }
        if (object instanceof Date) {
            return ValueDate.get((Date)object);
        }
        if (object instanceof Time) {
            return ValueTime.get((Time)object);
        }
        if (object instanceof Timestamp) {
            return ValueTimestamp.get((Timestamp)object);
        }
        if (object instanceof java.util.Date) {
            return ValueTimestamp.fromMillis(((java.util.Date)object).getTime());
        }
        if (object instanceof Reader) {
            BufferedReader bufferedReader = new BufferedReader((Reader)object);
            return sessionInterface.getDataHandler().getLobStorage().createClob(bufferedReader, -1L);
        }
        if (object instanceof Clob) {
            try {
                Clob clob = (Clob)object;
                BufferedReader bufferedReader = new BufferedReader(clob.getCharacterStream());
                return sessionInterface.getDataHandler().getLobStorage().createClob(bufferedReader, clob.length());
            }
            catch (SQLException sQLException) {
                throw DbException.convert(sQLException);
            }
        }
        if (object instanceof InputStream) {
            return sessionInterface.getDataHandler().getLobStorage().createBlob((InputStream)object, -1L);
        }
        if (object instanceof Blob) {
            try {
                Blob blob = (Blob)object;
                return sessionInterface.getDataHandler().getLobStorage().createBlob(blob.getBinaryStream(), blob.length());
            }
            catch (SQLException sQLException) {
                throw DbException.convert(sQLException);
            }
        }
        if (object instanceof SQLXML) {
            try {
                SQLXML sQLXML = (SQLXML)object;
                BufferedReader bufferedReader = new BufferedReader(sQLXML.getCharacterStream());
                return sessionInterface.getDataHandler().getLobStorage().createClob(bufferedReader, -1L);
            }
            catch (SQLException sQLException) {
                throw DbException.convert(sQLException);
            }
        }
        if (object instanceof Array) {
            Array array = (Array)object;
            try {
                return DataType.convertToValue(sessionInterface, array.getArray(), 17);
            }
            catch (SQLException sQLException) {
                throw DbException.convert(sQLException);
            }
        }
        if (object instanceof ResultSet) {
            return ValueResultSet.get(sessionInterface, (ResultSet)object, Integer.MAX_VALUE);
        }
        if (object instanceof UUID) {
            return ValueUuid.get((UUID)object);
        }
        Class<?> clazz = object.getClass();
        if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            int n2 = objectArray.length;
            Value[] valueArray = new Value[n2];
            for (int i = 0; i < n2; ++i) {
                valueArray[i] = DataType.convertToValue(sessionInterface, objectArray[i], n);
            }
            return ValueArray.get(clazz.getComponentType(), valueArray);
        }
        if (object instanceof Character) {
            return ValueStringFixed.get(((Character)object).toString());
        }
        if (DataType.isGeometry(object)) {
            return ValueGeometry.getFromGeometry(object);
        }
        if (clazz == LocalDateTimeUtils.LOCAL_DATE) {
            return LocalDateTimeUtils.localDateToDateValue(object);
        }
        if (clazz == LocalDateTimeUtils.LOCAL_TIME) {
            return LocalDateTimeUtils.localTimeToTimeValue(object);
        }
        if (clazz == LocalDateTimeUtils.LOCAL_DATE_TIME) {
            return LocalDateTimeUtils.localDateTimeToValue(object);
        }
        if (clazz == LocalDateTimeUtils.INSTANT) {
            return LocalDateTimeUtils.instantToValue(object);
        }
        if (clazz == LocalDateTimeUtils.OFFSET_DATE_TIME) {
            return LocalDateTimeUtils.offsetDateTimeToValue(object);
        }
        if (object instanceof TimestampWithTimeZone) {
            return ValueTimestampTimeZone.get((TimestampWithTimeZone)object);
        }
        if (object instanceof Interval) {
            Interval interval = (Interval)object;
            return ValueInterval.from(interval.getQualifier(), interval.isNegative(), interval.getLeading(), interval.getRemaining());
        }
        if (clazz == LocalDateTimeUtils.PERIOD) {
            return LocalDateTimeUtils.periodToValue(object);
        }
        if (clazz == LocalDateTimeUtils.DURATION) {
            return LocalDateTimeUtils.durationToValue(object);
        }
        if (JdbcUtils.customDataTypesHandler != null) {
            return JdbcUtils.customDataTypesHandler.getValue(n, object, sessionInterface.getDataHandler());
        }
        return ValueJavaObject.getNoCopy(object, null, sessionInterface.getDataHandler());
    }

    public static boolean isGeometryClass(Class<?> clazz) {
        if (clazz == null || GEOMETRY_CLASS == null) {
            return false;
        }
        return GEOMETRY_CLASS.isAssignableFrom(clazz);
    }

    public static boolean isGeometry(Object object) {
        if (object == null) {
            return false;
        }
        return DataType.isGeometryClass(object.getClass());
    }

    public static DataType getTypeByName(String string, Mode mode) {
        DataType dataType = mode.typeByNameMap.get(string);
        if (dataType == null && (dataType = TYPES_BY_NAME.get(string)) == null && JdbcUtils.customDataTypesHandler != null) {
            dataType = JdbcUtils.customDataTypesHandler.getDataTypeByName(string);
        }
        return dataType;
    }

    public static boolean isDateTimeType(int n) {
        switch (n) {
            case 9: 
            case 10: 
            case 11: 
            case 24: {
                return true;
            }
        }
        return false;
    }

    public static boolean isIntervalType(int n) {
        return n >= 26 && n <= 38;
    }

    public static boolean isYearMonthIntervalType(int n) {
        return n == 26 || n == 27 || n == 32;
    }

    public static boolean isLargeObject(int n) {
        return n == 15 || n == 16;
    }

    public static boolean isNumericType(int n) {
        return n >= 2 && n <= 8;
    }

    public static boolean isStringType(int n) {
        return n == 13 || n == 21 || n == 14;
    }

    public static boolean isExtInfoType(int n) {
        return n == 22 || n == 25;
    }

    public static boolean hasTotalOrdering(int n) {
        switch (n) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 19: 
            case 20: 
            case 22: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                return true;
            }
        }
        return false;
    }

    public static boolean supportsAdd(int n) {
        switch (n) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                return true;
            }
            case -1: 
            case 0: 
            case 1: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: {
                return false;
            }
        }
        if (JdbcUtils.customDataTypesHandler != null) {
            return JdbcUtils.customDataTypesHandler.supportsAdd(n);
        }
        return false;
    }

    public static int getAddProofType(int n) {
        switch (n) {
            case 2: {
                return 5;
            }
            case 8: {
                return 7;
            }
            case 4: {
                return 5;
            }
            case 5: {
                return 6;
            }
            case 3: {
                return 5;
            }
            case -1: 
            case 0: 
            case 1: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                return n;
            }
        }
        if (JdbcUtils.customDataTypesHandler != null) {
            return JdbcUtils.customDataTypesHandler.getAddProofType(n);
        }
        return n;
    }

    public static Object getDefaultForPrimitiveType(Class<?> clazz) {
        if (clazz == Boolean.TYPE) {
            return Boolean.FALSE;
        }
        if (clazz == Byte.TYPE) {
            return (byte)0;
        }
        if (clazz == Character.TYPE) {
            return Character.valueOf('\u0000');
        }
        if (clazz == Short.TYPE) {
            return (short)0;
        }
        if (clazz == Integer.TYPE) {
            return 0;
        }
        if (clazz == Long.TYPE) {
            return 0L;
        }
        if (clazz == Float.TYPE) {
            return Float.valueOf(0.0f);
        }
        if (clazz == Double.TYPE) {
            return 0.0;
        }
        throw DbException.throwInternalError("primitive=" + clazz.toString());
    }

    public static Object convertTo(JdbcConnection jdbcConnection, Value value, Class<?> clazz) {
        if (clazz == Blob.class) {
            return new JdbcBlob(jdbcConnection, value, JdbcLob.State.WITH_VALUE, 0);
        }
        if (clazz == Clob.class) {
            return new JdbcClob(jdbcConnection, value, JdbcLob.State.WITH_VALUE, 0);
        }
        if (clazz == Array.class) {
            return new JdbcArray(jdbcConnection, value, 0);
        }
        switch (value.getValueType()) {
            case 19: {
                Object object;
                Object object2 = object = SysProperties.serializeJavaObject ? JdbcUtils.deserialize(value.getBytes(), jdbcConnection.getSession().getDataHandler()) : value.getObject();
                if (!clazz.isAssignableFrom(object.getClass())) break;
                return object;
            }
            case -1: 
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 24: {
                break;
            }
            default: {
                if (JdbcUtils.customDataTypesHandler == null) break;
                return JdbcUtils.customDataTypesHandler.getObject(value, clazz);
            }
        }
        throw DbException.getUnsupportedException("converting to class " + clazz.getName());
    }

    static {
        Class clazz;
        TYPES = new ArrayList(96);
        TYPES_BY_NAME = new HashMap(128);
        TYPES_BY_VALUE_TYPE = new DataType[40];
        try {
            clazz = JdbcUtils.loadUserClass(GEOMETRY_CLASS_NAME);
        }
        catch (Exception exception) {
            clazz = null;
        }
        GEOMETRY_CLASS = clazz;
        DataType dataType = new DataType();
        dataType.maxPrecision = 1L;
        dataType.defaultPrecision = 1L;
        DataType.add(0, 0, dataType, new String[]{"NULL"});
        DataType.add(13, 12, DataType.createString(true), new String[]{"VARCHAR", "CHARACTER VARYING", "VARCHAR2", "NVARCHAR", "NVARCHAR2", "VARCHAR_CASESENSITIVE", "TID"});
        DataType.add(13, -1, DataType.createString(true), new String[]{"LONGVARCHAR", "LONGNVARCHAR"});
        DataType.add(21, 1, DataType.createString(true), new String[]{"CHAR", "CHARACTER", "NCHAR"});
        DataType.add(14, 12, DataType.createString(false), new String[]{"VARCHAR_IGNORECASE"});
        DataType.add(1, 16, DataType.createNumeric(1, 0, false), new String[]{"BOOLEAN", "BIT", "BOOL"});
        DataType.add(2, -6, DataType.createNumeric(3, 0, false), new String[]{"TINYINT"});
        DataType.add(3, 5, DataType.createNumeric(5, 0, false), new String[]{"SMALLINT", "YEAR", "INT2"});
        DataType.add(4, 4, DataType.createNumeric(10, 0, false), new String[]{"INTEGER", "INT", "MEDIUMINT", "INT4", "SIGNED"});
        DataType.add(4, 4, DataType.createNumeric(10, 0, true), new String[]{"SERIAL"});
        DataType.add(5, -5, DataType.createNumeric(19, 0, false), new String[]{"BIGINT", "INT8", "LONG"});
        DataType.add(5, -5, DataType.createNumeric(19, 0, true), new String[]{"IDENTITY", "BIGSERIAL"});
        if (SysProperties.BIG_DECIMAL_IS_DECIMAL) {
            DataType.addDecimal();
            DataType.addNumeric();
        } else {
            DataType.addNumeric();
            DataType.addDecimal();
        }
        DataType.add(8, 7, DataType.createNumeric(7, 0, false), new String[]{"REAL", "FLOAT4"});
        DataType.add(7, 8, DataType.createNumeric(17, 0, false), new String[]{"DOUBLE", "DOUBLE PRECISION"});
        DataType.add(7, 6, DataType.createNumeric(17, 0, false), new String[]{"FLOAT", "FLOAT8"});
        DataType.add(9, 92, DataType.createDate(18, 8, "TIME", true, 0, 9), new String[]{"TIME", "TIME WITHOUT TIME ZONE"});
        DataType.add(10, 91, DataType.createDate(10, 10, "DATE", false, 0, 0), new String[]{"DATE"});
        DataType.add(11, 93, DataType.createDate(29, 26, "TIMESTAMP", true, 6, 9), new String[]{"TIMESTAMP", "TIMESTAMP WITHOUT TIME ZONE", "DATETIME", "DATETIME2", "SMALLDATETIME"});
        DataType.add(24, 2014, DataType.createDate(35, 32, "TIMESTAMP_TZ", true, 6, 9), new String[]{"TIMESTAMP WITH TIME ZONE"});
        DataType.add(12, -3, DataType.createString(false), new String[]{"VARBINARY", "BINARY VARYING"});
        DataType.add(12, -2, DataType.createString(false), new String[]{"BINARY", "RAW", "BYTEA", "LONG RAW"});
        DataType.add(12, -4, DataType.createString(false), new String[]{"LONGVARBINARY"});
        dataType = new DataType();
        dataType.suffix = "'";
        dataType.prefix = "'";
        dataType.maxPrecision = 16L;
        dataType.defaultPrecision = 16L;
        DataType.add(20, -2, DataType.createString(false), new String[]{"UUID", "UNIQUEIDENTIFIER"});
        DataType.add(19, 1111, DataType.createString(false), new String[]{"OTHER", "OBJECT", "JAVA_OBJECT"});
        DataType.add(15, 2004, DataType.createLob(), new String[]{"BLOB", "BINARY LARGE OBJECT", "TINYBLOB", "MEDIUMBLOB", "LONGBLOB", "IMAGE", "OID"});
        DataType.add(16, 2005, DataType.createLob(), new String[]{"CLOB", "CHARACTER LARGE OBJECT", "TINYTEXT", "TEXT", "MEDIUMTEXT", "LONGTEXT", "NTEXT", "NCLOB"});
        DataType.add(22, 1111, DataType.createGeometry(), new String[]{"GEOMETRY"});
        dataType = new DataType();
        dataType.prefix = "ARRAY[";
        dataType.suffix = "]";
        DataType.add(17, 2003, dataType, new String[]{"ARRAY"});
        dataType = new DataType();
        dataType.defaultPrecision = Integer.MAX_VALUE;
        dataType.maxPrecision = Integer.MAX_VALUE;
        DataType.add(18, -10, dataType, new String[]{"RESULT_SET"});
        dataType = DataType.createString(false);
        dataType.supportsPrecision = false;
        dataType.supportsScale = false;
        DataType.add(25, 1111, dataType, new String[]{"ENUM"});
        for (int i = 26; i <= 38; ++i) {
            DataType.addInterval(i);
        }
        dataType = new DataType();
        dataType.type = 39;
        dataType.name = "ROW";
        dataType.sqlType = 1111;
        dataType.prefix = "ROW(";
        dataType.suffix = ")";
        DataType.TYPES_BY_VALUE_TYPE[39] = dataType;
    }
}

