/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core;

import javax.jcr.ItemNotFoundException;
import javax.jcr.NamespaceException;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.ConstraintViolationException;
import org.apache.jackrabbit.core.HierarchyManager;
import org.apache.jackrabbit.core.ItemId;
import org.apache.jackrabbit.core.nodetype.EffectiveNodeType;
import org.apache.jackrabbit.core.nodetype.NodeDef;
import org.apache.jackrabbit.core.nodetype.NodeTypeConflictException;
import org.apache.jackrabbit.core.nodetype.NodeTypeRegistry;
import org.apache.jackrabbit.core.nodetype.PropDef;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.core.state.PropertyState;
import org.apache.jackrabbit.core.value.InternalValue;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.commons.conversion.PathResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ItemValidator {
    private static Logger log = LoggerFactory.getLogger((Class)ItemValidator.class);
    protected final NodeTypeRegistry ntReg;
    protected final HierarchyManager hierMgr;
    protected final PathResolver resolver;

    public ItemValidator(NodeTypeRegistry ntReg, HierarchyManager hierMgr, PathResolver resolver) {
        this.ntReg = ntReg;
        this.hierMgr = hierMgr;
        this.resolver = resolver;
    }

    public void validate(NodeState nodeState) throws ConstraintViolationException, RepositoryException {
        EffectiveNodeType entPrimary = this.ntReg.getEffectiveNodeType(nodeState.getNodeTypeName());
        EffectiveNodeType entPrimaryAndMixins = this.getEffectiveNodeType(nodeState);
        NodeDef def = this.ntReg.getNodeDef(nodeState.getDefinitionId());
        Name[] requiredPrimaryTypes = def.getRequiredPrimaryTypes();
        for (int i = 0; i < requiredPrimaryTypes.length; ++i) {
            if (entPrimary.includesNodeType(requiredPrimaryTypes[i])) continue;
            String msg = this.safeGetJCRPath(nodeState.getNodeId()) + ": missing required primary type " + requiredPrimaryTypes[i];
            log.debug(msg);
            throw new ConstraintViolationException(msg);
        }
        PropDef[] pda = entPrimaryAndMixins.getMandatoryPropDefs();
        for (int i = 0; i < pda.length; ++i) {
            PropDef pd = pda[i];
            if (nodeState.hasPropertyName(pd.getName())) continue;
            String msg = this.safeGetJCRPath(nodeState.getNodeId()) + ": mandatory property " + pd.getName() + " does not exist";
            log.debug(msg);
            throw new ConstraintViolationException(msg);
        }
        NodeDef[] cnda = entPrimaryAndMixins.getMandatoryNodeDefs();
        for (int i = 0; i < cnda.length; ++i) {
            NodeDef cnd = cnda[i];
            if (nodeState.hasChildNodeEntry(cnd.getName())) continue;
            String msg = this.safeGetJCRPath(nodeState.getNodeId()) + ": mandatory child node " + cnd.getName() + " does not exist";
            log.debug(msg);
            throw new ConstraintViolationException(msg);
        }
    }

    public void validate(PropertyState propState) throws ConstraintViolationException, RepositoryException {
        PropDef def = this.ntReg.getPropDef(propState.getDefinitionId());
        InternalValue[] values = propState.getValues();
        int type = 0;
        for (int i = 0; i < values.length; ++i) {
            if (type == 0) {
                type = values[i].getType();
            } else if (type != values[i].getType()) {
                throw new ConstraintViolationException(this.safeGetJCRPath(propState.getPropertyId()) + ": inconsistent value types");
            }
            if (def.getRequiredType() == 0 || def.getRequiredType() == type) continue;
            throw new ConstraintViolationException(this.safeGetJCRPath(propState.getPropertyId()) + ": requiredType constraint is not satisfied");
        }
        EffectiveNodeType.checkSetPropertyValueConstraints(def, values);
    }

    public EffectiveNodeType getEffectiveNodeType(NodeState state) throws RepositoryException {
        try {
            return this.ntReg.getEffectiveNodeType(state.getNodeTypeName(), state.getMixinTypeNames());
        }
        catch (NodeTypeConflictException ntce) {
            String msg = "internal error: failed to build effective node type for node " + this.safeGetJCRPath(state.getNodeId());
            log.debug(msg);
            throw new RepositoryException(msg, (Throwable)ntce);
        }
    }

    public String safeGetJCRPath(Path path) {
        try {
            return this.resolver.getJCRPath(path);
        }
        catch (NamespaceException e) {
            log.error("failed to convert {} to a JCR path", (Object)path);
            return path.toString();
        }
    }

    public String safeGetJCRPath(ItemId id) {
        try {
            return this.safeGetJCRPath(this.hierMgr.getPath(id));
        }
        catch (ItemNotFoundException e) {
            return id.toString();
        }
        catch (RepositoryException e) {
            log.error(id + ": failed to build path");
            return id.toString();
        }
    }
}

