/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.builder;

import com.xebialabs.xlrelease.domain.Link;
import com.xebialabs.xlrelease.domain.ParallelGroup;
import com.xebialabs.xlrelease.domain.Task;

public class LinkBuilder {
    private String id;
    private Task source;
    private Task target;
    private ParallelGroup parallelGroup;

    private LinkBuilder() {
    }

    public static LinkBuilder newLink() {
        return new LinkBuilder();
    }

    public LinkBuilder withId(String id) {
        this.id = id;
        return this;
    }

    public LinkBuilder withSource(Task source) {
        this.source = source;
        return this;
    }

    public LinkBuilder withTarget(Task target) {
        this.target = target;
        return this;
    }

    public LinkBuilder withParallelGroup(ParallelGroup parallelGroup) {
        this.parallelGroup = parallelGroup;
        return this;
    }

    public Link build() {
        Link link = (Link)new Link().getType().getDescriptor().newInstance(this.id);
        link.setSource(this.source);
        link.setTarget(this.target);
        link.setParallelGroup(this.parallelGroup);
        if (null != this.parallelGroup) {
            this.parallelGroup.getLinks().add(link);
        }
        return link;
    }
}

