/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web.configurers;

import java.util.UUID;
import javax.servlet.Filter;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.RememberMeAuthenticationProvider;
import org.springframework.security.config.annotation.web.HttpSecurityBuilder;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.config.annotation.web.configurers.LogoutConfigurer;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.RememberMeServices;
import org.springframework.security.web.authentication.logout.LogoutHandler;
import org.springframework.security.web.authentication.rememberme.AbstractRememberMeServices;
import org.springframework.security.web.authentication.rememberme.PersistentTokenBasedRememberMeServices;
import org.springframework.security.web.authentication.rememberme.PersistentTokenRepository;
import org.springframework.security.web.authentication.rememberme.RememberMeAuthenticationFilter;
import org.springframework.security.web.authentication.rememberme.TokenBasedRememberMeServices;
import org.springframework.security.web.authentication.ui.DefaultLoginPageGeneratingFilter;

public final class RememberMeConfigurer<H extends HttpSecurityBuilder<H>>
extends AbstractHttpConfigurer<RememberMeConfigurer<H>, H> {
    private static final String DEFAULT_REMEMBER_ME_NAME = "remember-me";
    private AuthenticationSuccessHandler authenticationSuccessHandler;
    private String key;
    private RememberMeServices rememberMeServices;
    private LogoutHandler logoutHandler;
    private String rememberMeParameter = "remember-me";
    private String rememberMeCookieName = "remember-me";
    private String rememberMeCookieDomain;
    private PersistentTokenRepository tokenRepository;
    private UserDetailsService userDetailsService;
    private Integer tokenValiditySeconds;
    private Boolean useSecureCookie;
    private Boolean alwaysRemember;

    public RememberMeConfigurer<H> tokenValiditySeconds(int tokenValiditySeconds) {
        this.tokenValiditySeconds = tokenValiditySeconds;
        return this;
    }

    public RememberMeConfigurer<H> useSecureCookie(boolean useSecureCookie) {
        this.useSecureCookie = useSecureCookie;
        return this;
    }

    public RememberMeConfigurer<H> userDetailsService(UserDetailsService userDetailsService) {
        this.userDetailsService = userDetailsService;
        return this;
    }

    public RememberMeConfigurer<H> tokenRepository(PersistentTokenRepository tokenRepository) {
        this.tokenRepository = tokenRepository;
        return this;
    }

    public RememberMeConfigurer<H> key(String key) {
        this.key = key;
        return this;
    }

    public RememberMeConfigurer<H> rememberMeParameter(String rememberMeParameter) {
        this.rememberMeParameter = rememberMeParameter;
        return this;
    }

    public RememberMeConfigurer<H> rememberMeCookieName(String rememberMeCookieName) {
        this.rememberMeCookieName = rememberMeCookieName;
        return this;
    }

    public RememberMeConfigurer<H> rememberMeCookieDomain(String rememberMeCookieDomain) {
        this.rememberMeCookieDomain = rememberMeCookieDomain;
        return this;
    }

    public RememberMeConfigurer<H> authenticationSuccessHandler(AuthenticationSuccessHandler authenticationSuccessHandler) {
        this.authenticationSuccessHandler = authenticationSuccessHandler;
        return this;
    }

    public RememberMeConfigurer<H> rememberMeServices(RememberMeServices rememberMeServices) {
        this.rememberMeServices = rememberMeServices;
        return this;
    }

    public RememberMeConfigurer<H> alwaysRemember(boolean alwaysRemember) {
        this.alwaysRemember = alwaysRemember;
        return this;
    }

    @Override
    public void init(H http) throws Exception {
        this.validateInput();
        String key = this.getKey();
        RememberMeServices rememberMeServices = this.getRememberMeServices(http, key);
        http.setSharedObject(RememberMeServices.class, (RememberMeServices)rememberMeServices);
        LogoutConfigurer logoutConfigurer = http.getConfigurer(LogoutConfigurer.class);
        if (logoutConfigurer != null && this.logoutHandler != null) {
            logoutConfigurer.addLogoutHandler(this.logoutHandler);
        }
        RememberMeAuthenticationProvider authenticationProvider = new RememberMeAuthenticationProvider(key);
        authenticationProvider = this.postProcess(authenticationProvider);
        http.authenticationProvider((AuthenticationProvider)authenticationProvider);
        this.initDefaultLoginFilter(http);
    }

    @Override
    public void configure(H http) throws Exception {
        RememberMeAuthenticationFilter rememberMeFilter = new RememberMeAuthenticationFilter(http.getSharedObject(AuthenticationManager.class), this.rememberMeServices);
        if (this.authenticationSuccessHandler != null) {
            rememberMeFilter.setAuthenticationSuccessHandler(this.authenticationSuccessHandler);
        }
        rememberMeFilter = this.postProcess(rememberMeFilter);
        http.addFilter((Filter)rememberMeFilter);
    }

    private void validateInput() {
        if (this.rememberMeServices != null && this.rememberMeCookieName != DEFAULT_REMEMBER_ME_NAME) {
            throw new IllegalArgumentException("Can not set rememberMeCookieName and custom rememberMeServices.");
        }
    }

    private String getRememberMeParameter() {
        return this.rememberMeParameter;
    }

    private void initDefaultLoginFilter(H http) {
        DefaultLoginPageGeneratingFilter loginPageGeneratingFilter = http.getSharedObject(DefaultLoginPageGeneratingFilter.class);
        if (loginPageGeneratingFilter != null) {
            loginPageGeneratingFilter.setRememberMeParameter(this.getRememberMeParameter());
        }
    }

    private RememberMeServices getRememberMeServices(H http, String key) throws Exception {
        if (this.rememberMeServices != null) {
            if (this.rememberMeServices instanceof LogoutHandler && this.logoutHandler == null) {
                this.logoutHandler = (LogoutHandler)this.rememberMeServices;
            }
            return this.rememberMeServices;
        }
        AbstractRememberMeServices tokenRememberMeServices = this.createRememberMeServices(http, key);
        tokenRememberMeServices.setParameter(this.rememberMeParameter);
        tokenRememberMeServices.setCookieName(this.rememberMeCookieName);
        if (this.rememberMeCookieDomain != null) {
            tokenRememberMeServices.setCookieDomain(this.rememberMeCookieDomain);
        }
        if (this.tokenValiditySeconds != null) {
            tokenRememberMeServices.setTokenValiditySeconds(this.tokenValiditySeconds.intValue());
        }
        if (this.useSecureCookie != null) {
            tokenRememberMeServices.setUseSecureCookie(this.useSecureCookie.booleanValue());
        }
        if (this.alwaysRemember != null) {
            tokenRememberMeServices.setAlwaysRemember(this.alwaysRemember.booleanValue());
        }
        tokenRememberMeServices.afterPropertiesSet();
        this.logoutHandler = tokenRememberMeServices;
        this.rememberMeServices = tokenRememberMeServices;
        return tokenRememberMeServices;
    }

    private AbstractRememberMeServices createRememberMeServices(H http, String key) throws Exception {
        return this.tokenRepository == null ? this.createTokenBasedRememberMeServices(http, key) : this.createPersistentRememberMeServices(http, key);
    }

    private AbstractRememberMeServices createTokenBasedRememberMeServices(H http, String key) {
        UserDetailsService userDetailsService = this.getUserDetailsService(http);
        return new TokenBasedRememberMeServices(key, userDetailsService);
    }

    private AbstractRememberMeServices createPersistentRememberMeServices(H http, String key) {
        UserDetailsService userDetailsService = this.getUserDetailsService(http);
        return new PersistentTokenBasedRememberMeServices(key, userDetailsService, this.tokenRepository);
    }

    private UserDetailsService getUserDetailsService(H http) {
        if (this.userDetailsService == null) {
            this.userDetailsService = http.getSharedObject(UserDetailsService.class);
        }
        if (this.userDetailsService == null) {
            throw new IllegalStateException("userDetailsService cannot be null. Invoke " + RememberMeConfigurer.class.getSimpleName() + "#userDetailsService(UserDetailsService) or see its javadoc for alternative approaches.");
        }
        return this.userDetailsService;
    }

    private String getKey() {
        if (this.key == null) {
            this.key = UUID.randomUUID().toString();
        }
        return this.key;
    }
}

