/*
 * Decompiled with CFR 0.152.
 */
package org.commonmark.ext.ins.internal;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.commonmark.ext.ins.Ins;
import org.commonmark.node.Node;
import org.commonmark.renderer.NodeRenderer;
import org.commonmark.renderer.html.HtmlNodeRendererContext;
import org.commonmark.renderer.html.HtmlWriter;

public class InsNodeRenderer
implements NodeRenderer {
    private final HtmlNodeRendererContext context;
    private final HtmlWriter html;

    public InsNodeRenderer(HtmlNodeRendererContext context) {
        this.context = context;
        this.html = context.getWriter();
    }

    public Set<Class<? extends Node>> getNodeTypes() {
        return Collections.singleton(Ins.class);
    }

    public void render(Node node) {
        Map attributes = this.context.extendAttributes(node, "ins", Collections.emptyMap());
        this.html.tag("ins", attributes);
        this.renderChildren(node);
        this.html.tag("/ins");
    }

    private void renderChildren(Node parent) {
        Node node = parent.getFirstChild();
        while (node != null) {
            Node next = node.getNext();
            this.context.render(node);
            node = next;
        }
    }
}

