/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xlrelease.domain.BaseConfiguration;
import com.xebialabs.xlrelease.domain.Configuration;
import com.xebialabs.xlrelease.domain.events.ConfigurationCreatedEvent;
import com.xebialabs.xlrelease.domain.events.ConfigurationDeletedEvent;
import com.xebialabs.xlrelease.domain.events.ConfigurationUpdatedEvent;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.repository.CiHelper;
import com.xebialabs.xlrelease.repository.ConfigurationRepository;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.service.CiIdService;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SharedConfigurationService {
    private CiIdService ciIdService;
    private ConfigurationRepository configurationRepository;
    private XLReleaseEventBus eventBus;

    @Autowired
    public SharedConfigurationService(CiIdService ciIdService, ConfigurationRepository configurationRepository, XLReleaseEventBus eventBus) {
        this.ciIdService = ciIdService;
        this.configurationRepository = configurationRepository;
        this.eventBus = eventBus;
    }

    @Timed
    public boolean exists(String configurationInstanceId) {
        return this.configurationRepository.exists(configurationInstanceId);
    }

    @Timed
    public Configuration findById(String configurationInstanceId) {
        return (Configuration)this.configurationRepository.read(configurationInstanceId);
    }

    @Timed
    public List<Configuration> findAll() {
        return this.configurationRepository.findAllByTypeAndTitle(Type.valueOf(Configuration.class), null, null, false);
    }

    @Timed
    public List<Configuration> searchByTypeAndTitle(Type configurationType, String title) {
        this.checkIsConfigurationType(configurationType);
        return this.configurationRepository.findAllByTypeAndTitle(configurationType, title, null, false);
    }

    @Timed
    public List<Configuration> searchByTypeAndTitle(Type configurationType, String title, String folderId, boolean folderOnly) {
        this.checkIsConfigurationType(configurationType);
        return this.configurationRepository.findAllByTypeAndTitle(configurationType, title, folderId, folderOnly);
    }

    @Timed
    public List<Descriptor> findAllConfigurationDescriptors() {
        Type configurationType = Type.valueOf(Configuration.class);
        Collection allTypes = DescriptorRegistry.getSubtypes((Type)configurationType);
        return allTypes.stream().filter(type -> !type.getDescriptor().isVirtual()).map(Type::getDescriptor).collect(Collectors.toList());
    }

    @Timed
    public Configuration update(String configurationInstanceId, Configuration configuration) {
        configuration.setId(configurationInstanceId);
        CiHelper.fixUpInternalReferences((ConfigurationItem)configuration);
        this.configurationRepository.update(configuration);
        this.eventBus.publish((XLReleaseEvent)new ConfigurationUpdatedEvent((BaseConfiguration)configuration));
        return configuration;
    }

    @Timed
    public Configuration create(Configuration configuration) {
        String id = this.getUniqueId(Ids.CUSTOM_CONFIGURATION_ROOT);
        configuration.setId(id);
        CiHelper.fixUpInternalReferences((ConfigurationItem)configuration);
        this.configurationRepository.create(configuration);
        this.eventBus.publish((XLReleaseEvent)new ConfigurationCreatedEvent((BaseConfiguration)configuration));
        return configuration;
    }

    @Timed
    public void delete(String configurationInstanceId) {
        Configuration conf = (Configuration)this.configurationRepository.read(configurationInstanceId);
        this.configurationRepository.delete(configurationInstanceId);
        this.eventBus.publish((XLReleaseEvent)new ConfigurationDeletedEvent((BaseConfiguration)conf));
    }

    private String getUniqueId(String parentId) {
        return this.ciIdService.getUniqueId(Type.valueOf(Configuration.class), parentId);
    }

    private void checkIsConfigurationType(Type configurationType) {
        boolean typeIsConfiguration = configurationType.instanceOf(Type.valueOf(Configuration.class));
        if (!typeIsConfiguration) {
            throw new IllegalArgumentException(String.format("Type '%s' is not a Configuration type", configurationType));
        }
    }
}

