/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.delivery.security;

import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.xlrelease.delivery.domain.Delivery;
import com.xebialabs.xlrelease.delivery.security.DeliveryPermissions$;
import com.xebialabs.xlrelease.delivery.service.DeliveryPatternService;
import com.xebialabs.xlrelease.delivery.service.DeliveryService;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.security.authentication.AuthenticationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import scala.collection.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@Component
@ScalaSignature(bytes="\u0006\u0001\u0005uc\u0001B\u000b\u0017\u0001\u0005B\u0001\u0002\u000b\u0001\u0003\u0002\u0003\u0006I!\u000b\u0005\ta\u0001\u0011\t\u0011)A\u0005c!Aq\u0007\u0001B\u0001B\u0003%\u0001\b\u0003\u0005<\u0001\t\u0005\t\u0015!\u0003=\u0011\u0015\u0001\u0005\u0001\"\u0001B\u0011\u00159\u0006\u0001\"\u0001Y\u0011\u0015I\u0007\u0001\"\u0001k\u0011\u0015I\u0007\u0001\"\u0001m\u0011\u0015!\b\u0001\"\u0001v\u0011\u00159\b\u0001\"\u0001y\u0011\u0015Q\b\u0001\"\u0001|\u0011\u0015Q\b\u0001\"\u0001\u007f\u0011\u001d\t\u0019\u0001\u0001C\u0001\u0003\u000bAq!a\u0001\u0001\t\u0003\tI\u0001C\u0004\u0002\u000e\u0001!I!a\u0004\t\u000f\u0005U\u0001\u0001\"\u0003\u0002\u0018!9\u00111\u0004\u0001\u0005\n\u0005u\u0001bBA\u0011\u0001\u0011%\u00111\u0005\u0005\b\u0003O\u0001A\u0011BA\u0015\u0011\u001d\ti\u0003\u0001C\u0005\u0003_\u0011\u0011\u0004R3mSZ,'/\u001f)fe6L7o]5p]\u000eCWmY6fe*\u0011q\u0003G\u0001\tg\u0016\u001cWO]5us*\u0011\u0011DG\u0001\tI\u0016d\u0017N^3ss*\u00111\u0004H\u0001\nq2\u0014X\r\\3bg\u0016T!!\b\u0010\u0002\u0013a,'-[1mC\n\u001c(\"A\u0010\u0002\u0007\r|Wn\u0001\u0001\u0014\u0005\u0001\u0011\u0003CA\u0012'\u001b\u0005!#\"A\u0013\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u001d\"#AB!osJ+g-A\u000bbkRDWM\u001c;jG\u0006$\u0018n\u001c8TKJ4\u0018nY3\u0011\u0005)rS\"A\u0016\u000b\u00051j\u0013AD1vi\",g\u000e^5dCRLwN\u001c\u0006\u0003/iI!aL\u0016\u0003+\u0005+H\u000f[3oi&\u001c\u0017\r^5p]N+'O^5dK\u00061B-\u001a7jm\u0016\u0014\u0018\u0010U1ui\u0016\u0014hnU3sm&\u001cW\r\u0005\u00023k5\t1G\u0003\u000251\u000591/\u001a:wS\u000e,\u0017B\u0001\u001c4\u0005Y!U\r\\5wKJL\b+\u0019;uKJt7+\u001a:wS\u000e,\u0017a\u00043fY&4XM]=TKJ4\u0018nY3\u0011\u0005IJ\u0014B\u0001\u001e4\u0005=!U\r\\5wKJL8+\u001a:wS\u000e,\u0017a\u00039fe6L7o]5p]N\u0004\"!\u0010 \u000e\u00035J!aP\u0017\u0003#A+'/\\5tg&|gn\u00115fG.,'/\u0001\u0004=S:LGO\u0010\u000b\u0006\u0005\u0012+ei\u0012\t\u0003\u0007\u0002i\u0011A\u0006\u0005\u0006Q\u0015\u0001\r!\u000b\u0005\u0006a\u0015\u0001\r!\r\u0005\u0006o\u0015\u0001\r\u0001\u000f\u0005\u0006w\u0015\u0001\r\u0001\u0010\u0015\u0003\u000b%\u0003\"AS+\u000e\u0003-S!\u0001T'\u0002\u0015\u0005tgn\u001c;bi&|gN\u0003\u0002O\u001f\u00069a-Y2u_JL(B\u0001)R\u0003\u0015\u0011W-\u00198t\u0015\t\u00116+A\btaJLgn\u001a4sC6,wo\u001c:l\u0015\u0005!\u0016aA8sO&\u0011ak\u0013\u0002\n\u0003V$xn^5sK\u0012\f\u0011b\u00195fG.4\u0016.Z<\u0015\u0005ec\u0006CA\u0012[\u0013\tYFE\u0001\u0003V]&$\b\"B/\u0007\u0001\u0004q\u0016A\u00033fY&4XM]=JIB\u0011qL\u001a\b\u0003A\u0012\u0004\"!\u0019\u0013\u000e\u0003\tT!a\u0019\u0011\u0002\rq\u0012xn\u001c;?\u0013\t)G%\u0001\u0004Qe\u0016$WMZ\u0005\u0003O\"\u0014aa\u0015;sS:<'BA3%\u0003E\u0019\u0007.Z2l-&,w\u000fR3mSZ,'/\u001f\u000b\u00033.DQ!X\u0004A\u0002y#\"!W7\t\u000beA\u0001\u0019\u00018\u0011\u0005=\u0014X\"\u00019\u000b\u0005ED\u0012A\u00023p[\u0006Lg.\u0003\u0002ta\nAA)\u001a7jm\u0016\u0014\u00180A\tdQ\u0016\u001c7.\u00123ji\u0012+G.\u001b<fef$\"!\u0017<\t\u000buK\u0001\u0019\u00010\u0002=\rDWmY6FI&$HK]1dW\u0016$\u0017\n^3n\u001f:$U\r\\5wKJLHCA-z\u0011\u0015i&\u00021\u0001_\u0003a\u0019\u0007.Z2l-&,w\u000fR3mSZ,'/\u001f)biR,'O\u001c\u000b\u00033rDQ!`\u0006A\u0002y\u000b\u0011\u0002]1ui\u0016\u0014h.\u00133\u0015\u0005e{\bBBA\u0001\u0019\u0001\u0007a.A\u0004qCR$XM\u001d8\u00021\rDWmY6FI&$H)\u001a7jm\u0016\u0014\u0018\u0010U1ui\u0016\u0014h\u000eF\u0002Z\u0003\u000fAQ!`\u0007A\u0002y#2!WA\u0006\u0011\u0019\t\tA\u0004a\u0001]\u0006I2\r[3dWZKWm\u001e#fY&4XM]=P]\u001a{G\u000eZ3s)\rI\u0016\u0011\u0003\u0005\u0007\u0003'y\u0001\u0019\u00010\u0002\u0011\u0019|G\u000eZ3s\u0013\u0012\f\u0011d\u00195fG.,E-\u001b;EK2Lg/\u001a:z\u001f:4u\u000e\u001c3feR\u0019\u0011,!\u0007\t\r\u0005M\u0001\u00031\u0001_\u0003q\u0019\u0007.Z2l\u000b\u0012LG\u000f\u0016:bG.,G-\u0013;f[>sgi\u001c7eKJ$2!WA\u0010\u0011\u0019\t\u0019\"\u0005a\u0001=\u0006\u00013\r[3dWZKWm\u001e#fY&4XM]=QCR$XM\u001d8P]\u001a{G\u000eZ3s)\rI\u0016Q\u0005\u0005\u0007\u0003'\u0011\u0002\u0019\u00010\u0002A\rDWmY6FI&$H)\u001a7jm\u0016\u0014\u0018\u0010U1ui\u0016\u0014hn\u00148G_2$WM\u001d\u000b\u00043\u0006-\u0002BBA\n'\u0001\u0007a,A\fdQ\u0016\u001c7\u000eU3s[&\u001c8/[8o\u001f:4u\u000e\u001c3feR)\u0011,!\r\u00024!1\u00111\u0003\u000bA\u0002yCq!!\u000e\u0015\u0001\u0004\t9$A\nqKJl\u0017n]:j_:\u001cHk\u001c,fe&4\u0017\u0010E\u0003$\u0003s\ti$C\u0002\u0002<\u0011\u0012!\u0002\u0010:fa\u0016\fG/\u001a3?!\u0011\ty$a\u0013\u000e\u0005\u0005\u0005#\u0002BA\"\u0003\u000b\n!\u0002]3s[&\u001c8/[8o\u0015\r9\u0012q\t\u0006\u0004\u0003\u0013b\u0012\u0001\u00033fa2|\u00170\u001b;\n\t\u00055\u0013\u0011\t\u0002\u000b!\u0016\u0014X.[:tS>t\u0007f\u0001\u0001\u0002RA!\u00111KA-\u001b\t\t)FC\u0002\u0002XE\u000b!b\u001d;fe\u0016|G/\u001f9f\u0013\u0011\tY&!\u0016\u0003\u0013\r{W\u000e]8oK:$\b")
public class DeliveryPermissionChecker {
    private final DeliveryPatternService deliveryPatternService;
    private final DeliveryService deliveryService;
    private final PermissionChecker permissions;

    public void checkView(String deliveryId) {
        Delivery delivery = this.deliveryService.getDeliveryOrPattern(deliveryId);
        if (delivery.isTemplate()) {
            this.checkViewDeliveryPattern(delivery);
        } else {
            this.checkViewDelivery(delivery);
        }
    }

    public void checkViewDelivery(String deliveryId) {
        String folderId = this.deliveryService.getFolderId(deliveryId);
        this.checkViewDeliveryOnFolder(folderId);
    }

    public void checkViewDelivery(Delivery delivery) {
        String folderId = delivery.getFolderId();
        this.checkViewDeliveryOnFolder(folderId);
    }

    public void checkEditDelivery(String deliveryId) {
        String folderId = this.deliveryService.getFolderId(deliveryId);
        this.checkEditDeliveryOnFolder(folderId);
    }

    public void checkEditTrackedItemOnDelivery(String deliveryId) {
        String folderId = this.deliveryService.getFolderId(deliveryId);
        this.checkEditTrackedItemOnFolder(folderId);
    }

    public void checkViewDeliveryPattern(String patternId) {
        String folderId = this.deliveryPatternService.getFolderId(patternId);
        this.checkViewDeliveryPatternOnFolder(folderId);
    }

    public void checkViewDeliveryPattern(Delivery pattern) {
        String folderId = pattern.getFolderId();
        this.checkViewDeliveryPatternOnFolder(folderId);
    }

    public void checkEditDeliveryPattern(String patternId) {
        String folderId = this.deliveryPatternService.getFolderId(patternId);
        this.checkEditDeliveryPatternOnFolder(folderId);
    }

    public void checkEditDeliveryPattern(Delivery pattern) {
        String folderId = pattern.getFolderId();
        this.checkEditDeliveryPatternOnFolder(folderId);
    }

    private void checkViewDeliveryOnFolder(String folderId) {
        this.checkPermissionOnFolder(folderId, DeliveryPermissions$.MODULE$.VIEW_DELIVERY_PERMISSION_SET());
    }

    private void checkEditDeliveryOnFolder(String folderId) {
        this.checkPermissionOnFolder(folderId, DeliveryPermissions$.MODULE$.EDIT_DELIVERY_PERMISSION_SET());
    }

    private void checkEditTrackedItemOnFolder(String folderId) {
        this.checkPermissionOnFolder(folderId, DeliveryPermissions$.MODULE$.EDIT_DELIVERY_TRACKED_ITEM_PERMISSION_SET());
    }

    private void checkViewDeliveryPatternOnFolder(String folderId) {
        this.checkPermissionOnFolder(folderId, DeliveryPermissions$.MODULE$.VIEW_DELIVERY_PATTERN_PERMISSION_SET());
    }

    private void checkEditDeliveryPatternOnFolder(String folderId) {
        this.checkPermissionOnFolder(folderId, DeliveryPermissions$.MODULE$.EDIT_DELIVERY_PATTERN_PERMISSION_SET());
    }

    private void checkPermissionOnFolder(String folderId, Seq<Permission> permissionsToVerify) {
        this.permissions.checkAny(folderId, (Permission[])permissionsToVerify.toArray(ClassTag$.MODULE$.apply(Permission.class)));
    }

    @Autowired
    public DeliveryPermissionChecker(AuthenticationService authenticationService, DeliveryPatternService deliveryPatternService, DeliveryService deliveryService, PermissionChecker permissions) {
        this.deliveryPatternService = deliveryPatternService;
        this.deliveryService = deliveryService;
        this.permissions = permissions;
    }
}

