/*
 * Decompiled with CFR 0.152.
 */
package akka.dispatch;

import akka.ConfigurationException;
import akka.actor.ActorSystem;
import akka.dispatch.BalancingDispatcherConfigurator;
import akka.dispatch.CachingConfig;
import akka.dispatch.DispatcherConfigurator;
import akka.dispatch.DispatcherPrerequisites;
import akka.dispatch.Dispatchers$;
import akka.dispatch.MessageDispatcher;
import akka.dispatch.MessageDispatcherConfigurator;
import akka.dispatch.PinnedDispatcherConfigurator;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import java.util.concurrent.ConcurrentHashMap;
import scala.Function1;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005s!B\u000e\u001d\u0011\u0003\tc!B\u0012\u001d\u0011\u0003!\u0003\"B\u0016\u0002\t\u0003a\u0003bB\u0017\u0002\u0005\u0004%)A\f\u0005\u0007e\u0005\u0001\u000bQB\u0018\u0007\t\rb\u0002a\r\u0005\ti\u0015\u0011)\u0019!C\u0001k!A\u0001)\u0002B\u0001B\u0003%a\u0007\u0003\u0005B\u000b\t\u0015\r\u0011\"\u0001C\u0011!1UA!A!\u0002\u0013\u0019\u0005\"B\u0016\u0006\t\u00039\u0005bB&\u0006\u0005\u0004%\t\u0001\u0014\u0005\u0007!\u0016\u0001\u000b\u0011B'\t\u000fE+!\u0019!C\u0001%\"1Q,\u0002Q\u0001\nMCQAX\u0003\u0005\u0002}CqaY\u0003C\u0002\u0013%A\r\u0003\u0004~\u000b\u0001\u0006I!\u001a\u0005\u0006}\u0016!\ta \u0005\b\u0003\u000b)A\u0011AA\u0004\u0011\u001d\t\t\"\u0002C\u0005\u0003'Aq!a\u0006\u0006\t\u0003\tI\u0002C\u0004W\u000b\u0011\u0005a$!\t\t\u000fY+A\u0011\u0001\u0010\u0002&!9\u0011QF\u0003\u0005\n\u0005=\u0002\u0002CA\u001a\u000b\u0011\u0005a$!\u000e\t\u000f\u0005mR\u0001\"\u0003\u0002>\u0005YA)[:qCR\u001c\u0007.\u001a:t\u0015\tib$\u0001\u0005eSN\u0004\u0018\r^2i\u0015\u0005y\u0012\u0001B1lW\u0006\u001c\u0001\u0001\u0005\u0002#\u00035\tADA\u0006ESN\u0004\u0018\r^2iKJ\u001c8CA\u0001&!\t1\u0013&D\u0001(\u0015\u0005A\u0013!B:dC2\f\u0017B\u0001\u0016(\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012!I\u0001\u0014\t\u00164\u0017-\u001e7u\t&\u001c\b/\u0019;dQ\u0016\u0014\u0018\nZ\u000b\u0002_=\t\u0001'I\u00012\u0003u\t7n[1/C\u000e$xN\u001d\u0018eK\u001a\fW\u000f\u001c;.I&\u001c\b/\u0019;dQ\u0016\u0014\u0018\u0001\u0006#fM\u0006,H\u000e\u001e#jgB\fGo\u00195fe&#\u0007e\u0005\u0002\u0006K\u0005A1/\u001a;uS:<7/F\u00017!\t9TH\u0004\u00029w5\t\u0011H\u0003\u0002;=\u0005)\u0011m\u0019;pe&\u0011A(O\u0001\f\u0003\u000e$xN]*zgR,W.\u0003\u0002?\u007f\tA1+\u001a;uS:<7O\u0003\u0002=s\u0005I1/\u001a;uS:<7\u000fI\u0001\u000eaJ,'/Z9vSNLG/Z:\u0016\u0003\r\u0003\"A\t#\n\u0005\u0015c\"a\u0006#jgB\fGo\u00195feB\u0013XM]3rk&\u001c\u0018\u000e^3t\u00039\u0001(/\u001a:fcVL7/\u001b;fg\u0002\"2\u0001S%K!\t\u0011S\u0001C\u00035\u0015\u0001\u0007a\u0007C\u0003B\u0015\u0001\u00071)A\u0007dC\u000eD\u0017N\\4D_:4\u0017nZ\u000b\u0002\u001bB\u0011!ET\u0005\u0003\u001fr\u0011QbQ1dQ&twmQ8oM&<\u0017AD2bG\"LgnZ\"p]\u001aLw\rI\u0001\u0018I\u00164\u0017-\u001e7u\t&\u001c\b/\u0019;dQ\u0016\u00148i\u001c8gS\u001e,\u0012a\u0015\t\u0003)nk\u0011!\u0016\u0006\u0003-^\u000baaY8oM&<'B\u0001-Z\u0003!!\u0018\u0010]3tC\u001a,'\"\u0001.\u0002\u0007\r|W.\u0003\u0002]+\n11i\u001c8gS\u001e\f\u0001\u0004Z3gCVdG\u000fR5ta\u0006$8\r[3s\u0007>tg-[4!\u0003]!WMZ1vYR<En\u001c2bY\u0012K7\u000f]1uG\",'/F\u0001a!\t\u0011\u0013-\u0003\u0002c9\t\tR*Z:tC\u001e,G)[:qCR\u001c\u0007.\u001a:\u0002/\u0011L7\u000f]1uG\",'oQ8oM&<WO]1u_J\u001cX#A3\u0011\t\u0019lwN_\u0007\u0002O*\u0011\u0001.[\u0001\u000bG>t7-\u001e:sK:$(B\u00016l\u0003\u0011)H/\u001b7\u000b\u00031\fAA[1wC&\u0011an\u001a\u0002\u0012\u0007>t7-\u001e:sK:$\b*Y:i\u001b\u0006\u0004\bC\u00019x\u001d\t\tX\u000f\u0005\u0002sO5\t1O\u0003\u0002uA\u00051AH]8pizJ!A^\u0014\u0002\rA\u0013X\rZ3g\u0013\tA\u0018P\u0001\u0004TiJLgn\u001a\u0006\u0003m\u001e\u0002\"AI>\n\u0005qd\"!H'fgN\fw-\u001a#jgB\fGo\u00195fe\u000e{gNZ5hkJ\fGo\u001c:\u00021\u0011L7\u000f]1uG\",'oQ8oM&<WO]1u_J\u001c\b%\u0001\u0004m_>\\W\u000f\u001d\u000b\u0004A\u0006\u0005\u0001BBA\u0002%\u0001\u0007q.\u0001\u0002jI\u0006i\u0001.Y:ESN\u0004\u0018\r^2iKJ$B!!\u0003\u0002\u0010A\u0019a%a\u0003\n\u0007\u00055qEA\u0004C_>dW-\u00198\t\r\u0005\r1\u00031\u0001p\u0003Iawn\\6va\u000e{gNZ5hkJ\fGo\u001c:\u0015\u0007i\f)\u0002\u0003\u0004\u0002\u0004Q\u0001\ra\\\u0001\u0015e\u0016<\u0017n\u001d;fe\u000e{gNZ5hkJ\fGo\u001c:\u0015\r\u0005%\u00111DA\u000f\u0011\u0019\t\u0019!\u0006a\u0001_\"1\u0011qD\u000bA\u0002i\fAbY8oM&<WO]1u_J$2aUA\u0012\u0011\u0019\t\u0019A\u0006a\u0001_R)1+a\n\u0002*!1\u00111A\fA\u0002=Da!a\u000b\u0018\u0001\u0004\u0019\u0016!C1qa\u000e{gNZ5h\u0003!IGmQ8oM&<GcA*\u00022!1\u00111\u0001\rA\u0002=\fAA\u001a:p[R\u0019\u0001-a\u000e\t\r\u0005e\u0012\u00041\u0001T\u0003\r\u0019gmZ\u0001\u0011G>tg-[4ve\u0006$xN\u001d$s_6$2A_A \u0011\u0019\tID\u0007a\u0001'\u0002")
public class Dispatchers {
    private final ActorSystem.Settings settings;
    private final DispatcherPrerequisites prerequisites;
    private final CachingConfig cachingConfig;
    private final Config defaultDispatcherConfig;
    private final ConcurrentHashMap<String, MessageDispatcherConfigurator> dispatcherConfigurators;

    public static String DefaultDispatcherId() {
        return Dispatchers$.MODULE$.DefaultDispatcherId();
    }

    public ActorSystem.Settings settings() {
        return this.settings;
    }

    public DispatcherPrerequisites prerequisites() {
        return this.prerequisites;
    }

    public CachingConfig cachingConfig() {
        return this.cachingConfig;
    }

    public Config defaultDispatcherConfig() {
        return this.defaultDispatcherConfig;
    }

    public MessageDispatcher defaultGlobalDispatcher() {
        return this.lookup("akka.actor.default-dispatcher");
    }

    private ConcurrentHashMap<String, MessageDispatcherConfigurator> dispatcherConfigurators() {
        return this.dispatcherConfigurators;
    }

    public MessageDispatcher lookup(String id) {
        return this.lookupConfigurator(id).dispatcher();
    }

    public boolean hasDispatcher(String id) {
        return this.dispatcherConfigurators().containsKey(id) || this.cachingConfig().hasPath(id);
    }

    private MessageDispatcherConfigurator lookupConfigurator(String id) {
        MessageDispatcherConfigurator messageDispatcherConfigurator;
        MessageDispatcherConfigurator messageDispatcherConfigurator2 = this.dispatcherConfigurators().get(id);
        if (messageDispatcherConfigurator2 == null) {
            if (!this.cachingConfig().hasPath(id)) {
                throw new ConfigurationException(new StringBuilder(28).append("Dispatcher [").append(id).append("] not configured").toString());
            }
            MessageDispatcherConfigurator newConfigurator = this.configuratorFrom(this.config(id));
            MessageDispatcherConfigurator messageDispatcherConfigurator3 = this.dispatcherConfigurators().putIfAbsent(id, newConfigurator);
            MessageDispatcherConfigurator messageDispatcherConfigurator4 = messageDispatcherConfigurator3 == null ? newConfigurator : messageDispatcherConfigurator3;
            messageDispatcherConfigurator = messageDispatcherConfigurator4;
        } else {
            messageDispatcherConfigurator = messageDispatcherConfigurator2;
        }
        return messageDispatcherConfigurator;
    }

    public boolean registerConfigurator(String id, MessageDispatcherConfigurator configurator2) {
        return this.dispatcherConfigurators().putIfAbsent(id, configurator2) == null;
    }

    public Config config(String id) {
        return this.config(id, this.settings().config().getConfig(id));
    }

    public Config config(String id, Config appConfig) {
        return this.idConfig(id).withFallback((ConfigMergeable)appConfig).withFallback((ConfigMergeable)ConfigFactory.parseMap((java.util.Map)((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)Dispatchers.simpleName$1(id))}))).asJava()))).withFallback((ConfigMergeable)this.defaultDispatcherConfig());
    }

    private Config idConfig(String id) {
        return ConfigFactory.parseMap((java.util.Map)((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"id"), (Object)id)}))).asJava()));
    }

    public MessageDispatcher from(Config cfg) {
        return this.configuratorFrom(cfg).dispatcher();
    }

    private MessageDispatcherConfigurator configuratorFrom(Config cfg) {
        MessageDispatcherConfigurator messageDispatcherConfigurator;
        if (!cfg.hasPath("id")) {
            throw new ConfigurationException(new StringBuilder(44).append("Missing dispatcher 'id' property in config: ").append(cfg.root().render()).toString());
        }
        String string = cfg.getString("type");
        if ("Dispatcher".equals(string)) {
            messageDispatcherConfigurator = new DispatcherConfigurator(cfg, this.prerequisites());
        } else {
            if ("BalancingDispatcher".equals(string)) {
                throw new IllegalArgumentException(new StringBuilder(163).append("BalancingDispatcher is deprecated, use a BalancingPool instead. During a migration period you can still use BalancingDispatcher by specifying the full class name: ").append(BalancingDispatcherConfigurator.class.getName()).toString());
            }
            if ("PinnedDispatcher".equals(string)) {
                messageDispatcherConfigurator = new PinnedDispatcherConfigurator(cfg, this.prerequisites());
            } else {
                .colon.colon args = new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(Config.class), (Object)cfg), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(DispatcherPrerequisites.class), (Object)this.prerequisites()), (List)Nil$.MODULE$));
                messageDispatcherConfigurator = (MessageDispatcherConfigurator)this.prerequisites().dynamicAccess().createInstanceFor(string, (scala.collection.immutable.Seq<Tuple2<Class<?>, Object>>)args, ClassTag$.MODULE$.apply(MessageDispatcherConfigurator.class)).recover((PartialFunction)new Serializable(null, string, cfg){
                    public static final long serialVersionUID = 0L;
                    private final String x1$1;
                    private final Config cfg$1;

                    public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        A1 A1 = x1;
                        throw new ConfigurationException(new StringOps(Predef$.MODULE$.augmentString("Cannot instantiate MessageDispatcherConfigurator type [%s], defined in [%s], make sure it has constructor with [com.typesafe.config.Config] and [akka.dispatch.DispatcherPrerequisites] parameters")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.x1$1, this.cfg$1.getString("id")})), A1);
                    }

                    public final boolean isDefinedAt(Throwable x1) {
                        Throwable throwable = x1;
                        boolean bl = true;
                        return bl;
                    }
                    {
                        this.x1$1 = x1$1;
                        this.cfg$1 = cfg$1;
                    }
                }).get();
            }
        }
        return messageDispatcherConfigurator;
    }

    private static final String simpleName$1(String id$1) {
        return id$1.substring(id$1.lastIndexOf(46) + 1);
    }

    public Dispatchers(ActorSystem.Settings settings, DispatcherPrerequisites prerequisites) {
        this.settings = settings;
        this.prerequisites = prerequisites;
        this.cachingConfig = new CachingConfig(settings.config());
        this.defaultDispatcherConfig = this.idConfig("akka.actor.default-dispatcher").withFallback((ConfigMergeable)settings.config().getConfig("akka.actor.default-dispatcher"));
        this.dispatcherConfigurators = new ConcurrentHashMap();
    }
}

