/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.rmi.jackrabbit;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.rmi.RemoteException;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NodeType;
import org.apache.jackrabbit.api.JackrabbitNodeTypeManager;
import org.apache.jackrabbit.rmi.client.ClientNodeTypeManager;
import org.apache.jackrabbit.rmi.client.LocalAdapterFactory;
import org.apache.jackrabbit.rmi.client.RemoteRepositoryException;
import org.apache.jackrabbit.rmi.jackrabbit.RemoteJackrabbitNodeTypeManager;
import org.apache.jackrabbit.rmi.remote.RemoteNodeType;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ClientJackrabbitNodeTypeManager
extends ClientNodeTypeManager
implements JackrabbitNodeTypeManager {
    private final RemoteJackrabbitNodeTypeManager remote;

    public ClientJackrabbitNodeTypeManager(RemoteJackrabbitNodeTypeManager remote, LocalAdapterFactory factory) {
        super(remote, factory);
        this.remote = remote;
    }

    public boolean hasNodeType(String name) throws RepositoryException {
        try {
            return this.remote.hasNodeType(name);
        }
        catch (RemoteException e) {
            throw new RemoteRepositoryException(e);
        }
    }

    public NodeType[] registerNodeTypes(InputSource in) throws SAXException, RepositoryException {
        try {
            return this.registerNodeTypes(in.getByteStream(), "text/xml");
        }
        catch (IOException e) {
            throw new SAXException("Error reading node type stream", e);
        }
    }

    public NodeType[] registerNodeTypes(InputStream in, String contentType) throws IOException, RepositoryException {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] buffer = new byte[1000];
            int n = in.read(buffer);
            while (n != -1) {
                out.write(buffer, 0, n);
                n = in.read(buffer);
            }
            RemoteNodeType[] remotes = this.remote.registerNodeTypes(out.toByteArray(), contentType);
            NodeType[] types = new NodeType[remotes.length];
            for (int i = 0; i < remotes.length; ++i) {
                types[i] = this.getFactory().getNodeType(remotes[i]);
            }
            NodeType[] nodeTypeArray = types;
            return nodeTypeArray;
        }
        catch (RemoteException e) {
            throw new RemoteRepositoryException(e);
        }
        finally {
            in.close();
        }
    }
}

