/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.replicator;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.tmatesoft.svn.core.ISVNDirEntryHandler;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLogEntry;
import org.tmatesoft.svn.core.SVNLogEntryPath;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNProperty;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.util.SVNHashSet;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.SVNRepositoryFactory;
import org.tmatesoft.svn.core.io.diff.SVNDiffWindow;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNReplicationEditor
implements ISVNEditor {
    private static final int ACCEPT = 0;
    private static final int IGNORE = 1;
    private static final int DECIDE = 2;
    private ISVNEditor myCommitEditor;
    private Map myCopiedPaths;
    private Map myChangedPaths;
    private Set myDeletedPaths;
    private SVNRepository myRepos;
    private Map myPathsToFileBatons;
    private Stack myDirsStack;
    private long myPreviousRevision;
    private long myTargetRevision;
    private SVNCommitInfo myCommitInfo;
    private SVNRepository mySourceRepository;

    public SVNReplicationEditor(SVNRepository repository, ISVNEditor commitEditor, SVNLogEntry revision) {
        this.myRepos = repository;
        this.myCommitEditor = commitEditor;
        this.myPathsToFileBatons = new SVNHashMap();
        this.myDirsStack = new Stack();
        this.myCopiedPaths = new SVNHashMap();
        this.myChangedPaths = revision.getChangedPaths();
        this.myDeletedPaths = new SVNHashSet();
        for (String path : this.myChangedPaths.keySet()) {
            SVNLogEntryPath pathChange = (SVNLogEntryPath)this.myChangedPaths.get(path);
            if (pathChange.getType() != 'R' && pathChange.getType() != 'A' || pathChange.getCopyPath() == null || pathChange.getCopyRevision() < 0L) continue;
            this.myCopiedPaths.put(path, pathChange);
        }
    }

    @Override
    public void targetRevision(long revision) throws SVNException {
        this.myPreviousRevision = revision - 1L;
        this.myTargetRevision = revision;
    }

    @Override
    public void openRoot(long revision) throws SVNException {
        this.myCommitEditor.openRoot(this.myPreviousRevision);
        EntryBaton baton = new EntryBaton("/");
        baton.myPropsAct = 0;
        this.myDirsStack.push(baton);
    }

    @Override
    public void deleteEntry(String path, long revision) throws SVNException {
        String absPath = this.getSourceRepository().getRepositoryPath(path);
        SVNLogEntryPath deletedPath = (SVNLogEntryPath)this.myChangedPaths.get(absPath);
        if (deletedPath != null && (deletedPath.getType() == 'D' || deletedPath.getType() == 'R')) {
            if (deletedPath.getType() == 'D') {
                this.myChangedPaths.remove(absPath);
            }
        } else {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.UNKNOWN, "Expected that path ''{0}'' is deleted in revision {1}", absPath, new Long(this.myPreviousRevision));
            SVNErrorManager.error(err, SVNLogType.FSFS);
        }
        if (!this.myDeletedPaths.contains(path)) {
            this.myCommitEditor.deleteEntry(path, this.myPreviousRevision);
            this.myDeletedPaths.add(path);
        }
    }

    @Override
    public void absentDir(String path) throws SVNException {
    }

    @Override
    public void absentFile(String path) throws SVNException {
    }

    @Override
    public void addDir(String path, String copyFromPath, long copyFromRevision) throws SVNException {
        String absPath = this.getSourceRepository().getRepositoryPath(path);
        EntryBaton baton = new EntryBaton(absPath);
        this.myDirsStack.push(baton);
        SVNLogEntryPath changedPath = (SVNLogEntryPath)this.myChangedPaths.get(absPath);
        if (changedPath != null && (changedPath.getType() == 'A' || changedPath.getType() == 'R') && changedPath.getCopyPath() != null && changedPath.getCopyRevision() >= 0L) {
            baton.myPropsAct = 2;
            SVNProperties props = new SVNProperties();
            this.getSourceRepository().getDir(changedPath.getCopyPath(), changedPath.getCopyRevision(), props, (ISVNDirEntryHandler)null);
            baton.myProps = props;
            if (changedPath.getType() == 'R') {
                if (!this.myDeletedPaths.contains(path)) {
                    this.myCommitEditor.deleteEntry(path, this.myPreviousRevision);
                    this.myDeletedPaths.add(path);
                }
                this.myChangedPaths.remove(absPath);
            }
            this.myCommitEditor.addDir(path, changedPath.getCopyPath(), changedPath.getCopyRevision());
        } else if (changedPath != null && (changedPath.getType() == 'A' || changedPath.getType() == 'R')) {
            baton.myPropsAct = 0;
            this.myCommitEditor.addDir(path, null, -1L);
        } else if (changedPath != null && changedPath.getType() == 'M') {
            baton.myPropsAct = 0;
            this.myCommitEditor.openDir(path, this.myPreviousRevision);
        } else if (changedPath == null) {
            baton.myPropsAct = 1;
            this.myCommitEditor.openDir(path, this.myPreviousRevision);
        } else {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.UNKNOWN, "Unknown bug in addDir()");
            SVNErrorManager.error(err, SVNLogType.FSFS);
        }
    }

    @Override
    public void openDir(String path, long revision) throws SVNException {
        EntryBaton baton = new EntryBaton(this.getSourceRepository().getRepositoryPath(path));
        baton.myPropsAct = 0;
        this.myDirsStack.push(baton);
        this.myCommitEditor.openDir(path, this.myPreviousRevision);
    }

    @Override
    public void changeDirProperty(String name, SVNPropertyValue value) throws SVNException {
        if (!SVNProperty.isRegularProperty(name)) {
            return;
        }
        EntryBaton baton = (EntryBaton)this.myDirsStack.peek();
        if (baton.myPropsAct == 0) {
            this.myCommitEditor.changeDirProperty(name, value);
        } else if (baton.myPropsAct == 2) {
            SVNPropertyValue propVal = baton.myProps.getSVNPropertyValue(name);
            if (propVal != null && propVal.equals(value)) {
                baton.myPropsAct = 1;
                return;
            }
            baton.myPropsAct = 0;
            this.myCommitEditor.changeDirProperty(name, value);
        }
    }

    @Override
    public void closeDir() throws SVNException {
        if (this.myDirsStack.size() > 1 && !this.myCopiedPaths.isEmpty()) {
            EntryBaton currentDir = (EntryBaton)this.myDirsStack.peek();
            this.completeDeletion(currentDir.myPath);
        }
        this.myDirsStack.pop();
        this.myCommitEditor.closeDir();
    }

    @Override
    public void addFile(String path, String copyFromPath, long copyFromRevision) throws SVNException {
        String absPath = this.getSourceRepository().getRepositoryPath(path);
        EntryBaton baton = new EntryBaton(absPath);
        this.myPathsToFileBatons.put(path, baton);
        SVNLogEntryPath changedPath = (SVNLogEntryPath)this.myChangedPaths.get(absPath);
        if (changedPath != null && (changedPath.getType() == 'A' || changedPath.getType() == 'R') && changedPath.getCopyPath() != null && changedPath.getCopyRevision() >= 0L) {
            baton.myPropsAct = 2;
            baton.myTextAct = 0;
            SVNProperties props = new SVNProperties();
            if (this.areFileContentsEqual(absPath, this.myTargetRevision, changedPath.getCopyPath(), changedPath.getCopyRevision(), props)) {
                baton.myTextAct = 1;
            }
            baton.myProps = props;
            if (changedPath.getType() == 'R') {
                if (!this.myDeletedPaths.contains(path)) {
                    this.myCommitEditor.deleteEntry(path, this.myPreviousRevision);
                    this.myDeletedPaths.add(path);
                }
                this.myChangedPaths.remove(absPath);
            }
            this.myCommitEditor.addFile(path, changedPath.getCopyPath(), changedPath.getCopyRevision());
        } else if (changedPath != null && (changedPath.getType() == 'A' || changedPath.getType() == 'R')) {
            baton.myPropsAct = 0;
            baton.myTextAct = 0;
            if (changedPath.getType() == 'R') {
                if (!this.myDeletedPaths.contains(path)) {
                    this.myCommitEditor.deleteEntry(path, this.myPreviousRevision);
                    this.myDeletedPaths.add(path);
                }
                this.myChangedPaths.remove(absPath);
            }
            this.myCommitEditor.addFile(path, null, -1L);
        } else if (changedPath != null && changedPath.getType() == 'M') {
            baton.myPropsAct = 2;
            baton.myTextAct = 0;
            SVNLogEntryPath realPath = this.getFileCopyOrigin(absPath);
            if (realPath == null) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.UNKNOWN, "Unknown error, can't get the copy origin of a file");
                SVNErrorManager.error(err, SVNLogType.FSFS);
            }
            SVNProperties props = new SVNProperties();
            if (this.areFileContentsEqual(absPath, this.myTargetRevision, realPath.getCopyPath(), realPath.getCopyRevision(), props)) {
                baton.myTextAct = 1;
            }
            baton.myProps = props;
            this.myCommitEditor.openFile(path, this.myPreviousRevision);
        } else if (changedPath == null) {
            baton.myPropsAct = 1;
            baton.myTextAct = 1;
        } else {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.UNKNOWN, "Unknown bug in addFile()");
            SVNErrorManager.error(err, SVNLogType.FSFS);
        }
    }

    @Override
    public void openFile(String path, long revision) throws SVNException {
        EntryBaton baton = new EntryBaton(this.getSourceRepository().getRepositoryPath(path));
        baton.myPropsAct = 0;
        baton.myTextAct = 0;
        this.myPathsToFileBatons.put(path, baton);
        this.myCommitEditor.openFile(path, this.myPreviousRevision);
    }

    @Override
    public void applyTextDelta(String path, String baseChecksum) throws SVNException {
        EntryBaton baton = (EntryBaton)this.myPathsToFileBatons.get(path);
        if (baton.myTextAct == 0) {
            this.myCommitEditor.applyTextDelta(path, baseChecksum);
        }
    }

    @Override
    public OutputStream textDeltaChunk(String path, SVNDiffWindow diffWindow) throws SVNException {
        EntryBaton baton = (EntryBaton)this.myPathsToFileBatons.get(path);
        if (baton.myTextAct == 0) {
            return this.myCommitEditor.textDeltaChunk(path, diffWindow);
        }
        return SVNFileUtil.DUMMY_OUT;
    }

    @Override
    public void textDeltaEnd(String path) throws SVNException {
        EntryBaton baton = (EntryBaton)this.myPathsToFileBatons.get(path);
        if (baton.myTextAct == 0) {
            this.myCommitEditor.textDeltaEnd(path);
        }
    }

    @Override
    public void changeFileProperty(String path, String name, SVNPropertyValue value) throws SVNException {
        if (!SVNProperty.isRegularProperty(name)) {
            return;
        }
        EntryBaton baton = (EntryBaton)this.myPathsToFileBatons.get(path);
        if (baton.myPropsAct == 0) {
            this.myCommitEditor.changeFileProperty(path, name, value);
        } else if (baton.myPropsAct == 2) {
            SVNPropertyValue propVal = baton.myProps.getSVNPropertyValue(name);
            if (propVal != null && propVal.equals(value)) {
                baton.myPropsAct = 1;
                return;
            }
            baton.myPropsAct = 0;
            this.myCommitEditor.changeFileProperty(path, name, value);
        }
    }

    @Override
    public void closeFile(String path, String textChecksum) throws SVNException {
        EntryBaton baton = (EntryBaton)this.myPathsToFileBatons.get(path);
        if (baton.myTextAct != 1 || baton.myTextAct != 1) {
            this.myCommitEditor.closeFile(path, textChecksum);
        }
    }

    @Override
    public SVNCommitInfo closeEdit() throws SVNException {
        this.myCommitInfo = this.myCommitEditor.closeEdit();
        if (this.mySourceRepository != null) {
            this.mySourceRepository.closeSession();
            this.mySourceRepository = null;
        }
        return this.myCommitInfo;
    }

    @Override
    public void abortEdit() throws SVNException {
        if (this.mySourceRepository != null) {
            this.mySourceRepository.closeSession();
            this.mySourceRepository = null;
        }
        this.myCommitEditor.abortEdit();
    }

    public SVNCommitInfo getCommitInfo() {
        return this.myCommitInfo;
    }

    private SVNRepository getSourceRepository() throws SVNException {
        if (this.mySourceRepository == null) {
            this.mySourceRepository = SVNRepositoryFactory.create(this.myRepos.getLocation());
            this.mySourceRepository.setAuthenticationManager(this.myRepos.getAuthenticationManager());
            this.mySourceRepository.setDebugLog(this.myRepos.getDebugLog());
            this.mySourceRepository.setTunnelProvider(this.myRepos.getTunnelProvider());
            this.mySourceRepository.setCanceller(this.myRepos.getCanceller());
        }
        return this.mySourceRepository;
    }

    private void completeDeletion(String dirPath) throws SVNException {
        ArrayList<String> pathsToDelete = new ArrayList<String>();
        for (String path : this.myChangedPaths.keySet()) {
            SVNLogEntryPath pathChange;
            if (!path.startsWith(dirPath + "/") || (pathChange = (SVNLogEntryPath)this.myChangedPaths.get(path)).getType() != 'D') continue;
            String relativePath = path.substring(dirPath.length() + 1);
            pathsToDelete.add(relativePath);
        }
        String[] pathsArray = pathsToDelete.toArray(new String[pathsToDelete.size()]);
        Arrays.sort(pathsArray, SVNPathUtil.PATH_COMPARATOR);
        String currentOpened = "";
        for (int i = 0; i < pathsArray.length; ++i) {
            String nextRelativePath = pathsArray[i];
            while (!"".equals(currentOpened) && nextRelativePath.indexOf(currentOpened) == -1) {
                this.myCommitEditor.closeDir();
                currentOpened = SVNPathUtil.removeTail(currentOpened);
            }
            String nextRelativePathToDelete = null;
            nextRelativePathToDelete = !"".equals(currentOpened) ? nextRelativePath.substring(currentOpened.length() + 1) : nextRelativePath;
            String[] entries = nextRelativePathToDelete.split("/");
            int j = 0;
            for (j = 0; j < entries.length - 1; ++j) {
                currentOpened = SVNPathUtil.append(currentOpened, entries[j]);
                this.myCommitEditor.openDir(SVNPathUtil.append(dirPath, currentOpened), this.myPreviousRevision);
            }
            String pathToDelete = SVNPathUtil.append(currentOpened, entries[j]);
            String absPathToDelete = SVNPathUtil.append(dirPath, pathToDelete);
            if (!this.myDeletedPaths.contains(absPathToDelete)) {
                this.myCommitEditor.deleteEntry(absPathToDelete, this.myPreviousRevision);
                this.myDeletedPaths.add(absPathToDelete);
            }
            this.myChangedPaths.remove(absPathToDelete);
        }
        while (!"".equals(currentOpened)) {
            this.myCommitEditor.closeDir();
            currentOpened = SVNPathUtil.removeTail(currentOpened);
        }
    }

    private SVNLogEntryPath getFileCopyOrigin(String path) throws SVNException {
        int i;
        String[] paths = this.myCopiedPaths.keySet().toArray(new String[this.myCopiedPaths.size()]);
        Arrays.sort(paths, 0, paths.length, SVNPathUtil.PATH_COMPARATOR);
        SVNLogEntryPath realPath = null;
        ArrayList<String> candidates = new ArrayList<String>();
        for (i = 0; i < paths.length; ++i) {
            String copiedPath = paths[i];
            if (!path.startsWith(copiedPath + "/")) continue;
            if (path.equals(copiedPath)) {
                return (SVNLogEntryPath)this.myCopiedPaths.get(copiedPath);
            }
            candidates.add(copiedPath);
        }
        for (i = candidates.size() - 1; i >= 0; --i) {
            String candidateParent = (String)candidates.get(i);
            if (this.getSourceRepository().checkPath(candidateParent, this.myTargetRevision) != SVNNodeKind.DIR) continue;
            SVNLogEntryPath changedPath = (SVNLogEntryPath)this.myCopiedPaths.get(candidateParent);
            String fileRelativePath = path.substring(candidateParent.length() + 1);
            fileRelativePath = SVNPathUtil.append(changedPath.getCopyPath(), fileRelativePath);
            return new SVNLogEntryPath(path, ' ', fileRelativePath, changedPath.getCopyRevision());
        }
        return realPath;
    }

    private boolean areFileContentsEqual(String path1, long rev1, String path2, long rev2, SVNProperties props2) throws SVNException {
        SVNProperties props1 = new SVNProperties();
        props2 = props2 == null ? new SVNProperties() : props2;
        SVNRepository repos = this.getSourceRepository();
        repos.getFile(path1, rev1, props1, null);
        repos.getFile(path2, rev2, props2, null);
        String crc1 = props1.getStringValue("svn:entry:checksum");
        String crc2 = props2.getStringValue("svn:entry:checksum");
        return crc1 != null && crc1.equals(crc2);
    }

    private static class EntryBaton {
        private String myPath;
        private int myPropsAct;
        private int myTextAct;
        private SVNProperties myProps;

        public EntryBaton(String path) {
            this.myPath = path;
        }
    }
}

