/*
 * Decompiled with CFR 0.152.
 */
package akka.remote.transport.netty;

import akka.ConfigurationException;
import akka.dispatch.ThreadPoolConfig$;
import akka.remote.transport.netty.NettyTransportSettings$Tcp$;
import akka.remote.transport.netty.NettyTransportSettings$Udp$;
import akka.remote.transport.netty.SSLSettings;
import akka.util.Helpers;
import akka.util.Helpers$;
import com.typesafe.config.Config;
import java.io.Serializable;
import java.net.InetAddress;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.collection.immutable.StringOps;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\tUr!B%K\u0011\u0003\u0019f!B+K\u0011\u00031\u0006\"B/\u0002\t\u0003qfaB0\u0002!\u0003\r\n\u0003Y\u0004\u0007\u0003\u000f\n\u0001\u0012Q7\u0007\u000b\t\f\u0001\u0012Q2\t\u000bu+A\u0011\u00017\t\u000b9,A\u0011I8\t\u000fa,\u0011\u0011!C!s\"9!0BA\u0001\n\u0003Y\b\u0002C@\u0006\u0003\u0003%\t!!\u0001\t\u0013\u00055Q!!A\u0005B\u0005=\u0001\"CA\u000f\u000b\u0005\u0005I\u0011AA\u0010\u0011%\tI#BA\u0001\n\u0003\nY\u0003C\u0005\u0002.\u0015\t\t\u0011\"\u0003\u00020\u001d9\u0011\u0011J\u0001\t\u0002\u0006ubaBA\u001c\u0003!\u0005\u0015\u0011\b\u0005\u0007;B!\t!a\u000f\t\u000b9\u0004B\u0011I8\t\u000fa\u0004\u0012\u0011!C!s\"9!\u0010EA\u0001\n\u0003Y\b\u0002C@\u0011\u0003\u0003%\t!a\u0010\t\u0013\u00055\u0001#!A\u0005B\u0005=\u0001\"CA\u000f!\u0005\u0005I\u0011AA\"\u0011%\tI\u0003EA\u0001\n\u0003\nY\u0003C\u0005\u0002.A\t\t\u0011\"\u0003\u00020\u0019)QK\u0013\u0001\u0002L!Q\u0011Q\n\u000e\u0003\u0002\u0003\u0006I!a\u0014\t\ruSB\u0011AA1\u0011%\t9G\u0007b\u0001\n\u0003\tI\u0007\u0003\u0005\u0002\u0006j\u0001\u000b\u0011BA6\u0011%\t9I\u0007b\u0001\n\u0003\tI\t\u0003\u0005\u0002\fj\u0001\u000b\u0011BA\u0011\u0011%\tiI\u0007b\u0001\n\u0003\ty\t\u0003\u0005\u0002 j\u0001\u000b\u0011BAI\u0011%\t\tK\u0007b\u0001\n\u0003\t\u0019\u000b\u0003\u0005\u0002,j\u0001\u000b\u0011BAS\u0011!\tiK\u0007Q\u0005\n\u0005=\u0006\"CA\\5\t\u0007I\u0011AA]\u0011!\tYM\u0007Q\u0001\n\u0005m\u0006\"CAg5\t\u0007I\u0011AAh\u0011!\t\tN\u0007Q\u0001\n\u0005E\u0006\"CAj5\t\u0007I\u0011AAh\u0011!\t)N\u0007Q\u0001\n\u0005E\u0006\"CAl5\t\u0007I\u0011AAh\u0011!\tIN\u0007Q\u0001\n\u0005E\u0006\"CAn5\t\u0007I\u0011AAh\u0011!\tiN\u0007Q\u0001\n\u0005E\u0006\u0002CAp5\t\u0007I\u0011A>\t\u000f\u0005\u0005(\u0004)A\u0005y\"A\u00111\u001d\u000eC\u0002\u0013\u00051\u0010C\u0004\u0002fj\u0001\u000b\u0011\u0002?\t\u0013\u0005\u001d(D1A\u0005\u0002\u0005%\u0005\u0002CAu5\u0001\u0006I!!\t\t\u0013\u0005-(D1A\u0005\u0002\u0005%\u0005\u0002CAw5\u0001\u0006I!!\t\t\u0013\u0005=(D1A\u0005\u0002\u0005%\u0005\u0002CAy5\u0001\u0006I!!\t\t\u0013\u0005M(D1A\u0005\u0002\u0005=\u0005\u0002CA{5\u0001\u0006I!!%\t\u0013\u0005](D1A\u0005\u0002\u0005=\u0005\u0002CA}5\u0001\u0006I!!%\t\u0011\u0005m(D1A\u0005\u0002mDqA!\u0004\u001bA\u0003%A\u0010\u0003\u0005\u0003\u0010i\u0011\r\u0011\"\u0001|\u0011\u001d\u00119B\u0007Q\u0001\nqD\u0011B!\u0007\u001b\u0005\u0004%\tAa\u0007\t\u0011\t\u0015\"\u0004)A\u0005\u0005;A\u0001Ba\n\u001b\u0005\u0004%\ta\u001f\u0005\b\u0005SQ\u0002\u0015!\u0003}\u0011!\u0011YC\u0007b\u0001\n\u0003Y\bb\u0002B\u00175\u0001\u0006I\u0001 \u0005\b\u0005_QB\u0011\u0002B\u0019\u0003YqU\r\u001e;z)J\fgn\u001d9peR\u001cV\r\u001e;j]\u001e\u001c(BA&M\u0003\u0015qW\r\u001e;z\u0015\tie*A\u0005ue\u0006t7\u000f]8si*\u0011q\nU\u0001\u0007e\u0016lw\u000e^3\u000b\u0003E\u000bA!Y6lC\u000e\u0001\u0001C\u0001+\u0002\u001b\u0005Q%A\u0006(fiRLHK]1ogB|'\u000f^*fiRLgnZ:\u0014\u0005\u00059\u0006C\u0001-\\\u001b\u0005I&\"\u0001.\u0002\u000bM\u001c\u0017\r\\1\n\u0005qK&AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002'\n!Qj\u001c3f'\t\u0019q+K\u0002\u0004\u000bA\u00111\u0001V2q'\u0015)q\u000b\u001a4j!\t)7!D\u0001\u0002!\tAv-\u0003\u0002i3\n9\u0001K]8ek\u000e$\bC\u0001-k\u0013\tY\u0017L\u0001\u0007TKJL\u0017\r\\5{C\ndW\rF\u0001n!\t)W!\u0001\u0005u_N#(/\u001b8h)\u0005\u0001\bCA9w\u001b\u0005\u0011(BA:u\u0003\u0011a\u0017M\\4\u000b\u0003U\fAA[1wC&\u0011qO\u001d\u0002\u0007'R\u0014\u0018N\\4\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\u0005\u0001\u0018\u0001\u00049s_\u0012,8\r^!sSRLX#\u0001?\u0011\u0005ak\u0018B\u0001@Z\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\t\u0019!!\u0003\u0011\u0007a\u000b)!C\u0002\u0002\be\u00131!\u00118z\u0011!\tYACA\u0001\u0002\u0004a\u0018a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002\u0012A1\u00111CA\r\u0003\u0007i!!!\u0006\u000b\u0007\u0005]\u0011,\u0001\u0006d_2dWm\u0019;j_:LA!a\u0007\u0002\u0016\tA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\t\t#a\n\u0011\u0007a\u000b\u0019#C\u0002\u0002&e\u0013qAQ8pY\u0016\fg\u000eC\u0005\u0002\f1\t\t\u00111\u0001\u0002\u0004\u0005A\u0001.Y:i\u0007>$W\rF\u0001}\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\u0005E\u0002cA9\u00024%\u0019\u0011Q\u0007:\u0003\r=\u0013'.Z2u\u0005\r)F\r]\n\u0006!]#g-\u001b\u000b\u0003\u0003{\u0001\"!\u001a\t\u0015\t\u0005\r\u0011\u0011\t\u0005\t\u0003\u0017)\u0012\u0011!a\u0001yR!\u0011\u0011EA#\u0011%\tYaFA\u0001\u0002\u0004\t\u0019!A\u0002UGB\f1!\u00163q'\tQr+\u0001\u0004d_:4\u0017n\u001a\t\u0005\u0003#\ni&\u0004\u0002\u0002T)!\u0011QJA+\u0015\u0011\t9&!\u0017\u0002\u0011QL\b/Z:bM\u0016T!!a\u0017\u0002\u0007\r|W.\u0003\u0003\u0002`\u0005M#AB\"p]\u001aLw\r\u0006\u0003\u0002d\u0005\u0015\u0004C\u0001+\u001b\u0011\u001d\ti\u0005\ba\u0001\u0003\u001f\nQ\u0002\u0016:b]N\u0004xN\u001d;N_\u0012,WCAA6!\r\tig\u0001\b\u0004\u0003_\u0002a\u0002BA9\u0003\u0007sA!a\u001d\u0002\u0002:!\u0011QOA@\u001d\u0011\t9(! \u000e\u0005\u0005e$bAA>%\u00061AH]8pizJ\u0011!U\u0005\u0003\u001fBK!!\u0014(\n\u0005-c\u0015A\u0004+sC:\u001c\bo\u001c:u\u001b>$W\rI\u0001\n\u000b:\f'\r\\3Tg2,\"!!\t\u0002\u0015\u0015s\u0017M\u00197f'Nd\u0007%\u0001\u000eT'2+enZ5oKB\u0013xN^5eKJ\u001cE.Y:t\u001d\u0006lW-\u0006\u0002\u0002\u0012B!\u00111SAN\u001d\u0011\t)*a&\u0011\u0007\u0005]\u0014,C\u0002\u0002\u001af\u000ba\u0001\u0015:fI\u00164\u0017bA<\u0002\u001e*\u0019\u0011\u0011T-\u00027M\u001bF*\u00128hS:,\u0007K]8wS\u0012,'o\u00117bgNt\u0015-\\3!\u0003I)6/\u001a#jgB\fGo\u00195fe\u001a{'/S8\u0016\u0005\u0005\u0015\u0006#\u0002-\u0002(\u0006E\u0015bAAU3\n1q\n\u001d;j_:\f1#V:f\t&\u001c\b/\u0019;dQ\u0016\u0014hi\u001c:J_\u0002\n!b\u001c9uS>t7+\u001b>f)\u0011\t\t,a-\u0011\ta\u000b9\u000b \u0005\b\u0003k+\u0003\u0019AAI\u0003\u0005\u0019\u0018!E\"p]:,7\r^5p]RKW.Z8viV\u0011\u00111\u0018\t\u0005\u0003{\u000b9-\u0004\u0002\u0002@*!\u0011\u0011YAb\u0003!!WO]1uS>t'bAAc3\u0006Q1m\u001c8dkJ\u0014XM\u001c;\n\t\u0005%\u0017q\u0018\u0002\u000f\r&t\u0017\u000e^3EkJ\fG/[8o\u0003I\u0019uN\u001c8fGRLwN\u001c+j[\u0016|W\u000f\u001e\u0011\u00021]\u0013\u0018\u000e^3Ck\u001a4WM\u001d%jO\"<\u0016\r^3s\u001b\u0006\u00148.\u0006\u0002\u00022\u0006IrK]5uK\n+hMZ3s\u0011&<\u0007nV1uKJl\u0015M]6!\u0003]9&/\u001b;f\u0005V4g-\u001a:M_^<\u0016\r^3s\u001b\u0006\u00148.\u0001\rXe&$XMQ;gM\u0016\u0014Hj\\<XCR,'/T1sW\u0002\nabU3oI\n+hMZ3s'&TX-A\bTK:$')\u001e4gKJ\u001c\u0016N_3!\u0003E\u0011VmY3jm\u0016\u0014UO\u001a4feNK'0Z\u0001\u0013%\u0016\u001cW-\u001b<f\u0005V4g-\u001a:TSj,\u0007%\u0001\u0007NCb4%/Y7f'&TX-A\u0007NCb4%/Y7f'&TX\rI\u0001\b\u0005\u0006\u001c7\u000e\\8h\u0003!\u0011\u0015mY6m_\u001e\u0004\u0013A\u0003+da:{G-\u001a7bs\u0006YAk\u00199O_\u0012,G.Y=!\u00031!6\r]&fKB\fG.\u001b<f\u00035!6\r]&fKB\fG.\u001b<fA\u0005aAk\u00199SKV\u001cX-\u00113ee\u0006iAk\u00199SKV\u001cX-\u00113ee\u0002\n\u0001\u0002S8ti:\fW.Z\u0001\n\u0011>\u001cHO\\1nK\u0002\nABQ5oI\"{7\u000f\u001e8b[\u0016\fQBQ5oI\"{7\u000f\u001e8b[\u0016\u0004\u0013\u0001\u0004)peR\u001cV\r\\3di>\u0014\bf\u0002 \u0002\u0000\n\u0015!\u0011\u0002\t\u00041\n\u0005\u0011b\u0001B\u00023\nQA-\u001a9sK\u000e\fG/\u001a3\"\u0005\t\u001d\u0011aM,B%:Kej\u0012\u001e!)\"L7\u000fI:i_VdG\rI8oYf\u0004#-\u001a\u0011vg\u0016$\u0007EY=!aJ|g-Z:tS>t\u0017\r\\:/C\t\u0011Y!A\u00023]A\nQ\u0002U8siN+G.Z2u_J\u0004\u0013\u0001\u0005\"j]\u0012\u0004vN\u001d;TK2,7\r^8sQ\u001d\u0001\u0015q B\u0003\u0005'\t#A!\u0006\u0002\u0007IrC'A\tCS:$\u0007k\u001c:u'\u0016dWm\u0019;pe\u0002\n1bU:m'\u0016$H/\u001b8hgV\u0011!Q\u0004\t\u00061\u0006\u001d&q\u0004\t\u0004)\n\u0005\u0012b\u0001B\u0012\u0015\nY1k\u0015'TKR$\u0018N\\4t\u00031\u00196\u000f\\*fiRLgnZ:!\u0003i\u0019VM\u001d<feN{7m[3u/>\u00148.\u001a:Q_>d7+\u001b>f\u0003m\u0019VM\u001d<feN{7m[3u/>\u00148.\u001a:Q_>d7+\u001b>fA\u0005Q2\t\\5f]R\u001cvnY6fi^{'o[3s!>|GnU5{K\u0006Y2\t\\5f]R\u001cvnY6fi^{'o[3s!>|GnU5{K\u0002\n!bY8naV$Xm\u0016)T)\ra(1\u0007\u0005\b\u0003\u001bB\u0005\u0019AA(\u0001")
public class NettyTransportSettings {
    private final Config config;
    private final Mode TransportMode;
    private final boolean EnableSsl;
    private final String SSLEngineProviderClassName;
    private final Option<String> UseDispatcherForIo;
    private final FiniteDuration ConnectionTimeout;
    private final Option<Object> WriteBufferHighWaterMark;
    private final Option<Object> WriteBufferLowWaterMark;
    private final Option<Object> SendBufferSize;
    private final Option<Object> ReceiveBufferSize;
    private final int MaxFrameSize;
    private final int Backlog;
    private final boolean TcpNodelay;
    private final boolean TcpKeepalive;
    private final boolean TcpReuseAddr;
    private final String Hostname;
    private final String BindHostname;
    private final int PortSelector;
    private final int BindPortSelector;
    private final Option<SSLSettings> SslSettings;
    private final int ServerSocketWorkerPoolSize;
    private final int ClientSocketWorkerPoolSize;

    public Mode TransportMode() {
        return this.TransportMode;
    }

    public boolean EnableSsl() {
        return this.EnableSsl;
    }

    public String SSLEngineProviderClassName() {
        return this.SSLEngineProviderClassName;
    }

    public Option<String> UseDispatcherForIo() {
        return this.UseDispatcherForIo;
    }

    private Option<Object> optionSize(String s) {
        None$ none$;
        int n = (int)Predef$.MODULE$.Long2long(this.config.getBytes(s));
        switch (n) {
            case 0: {
                none$ = None$.MODULE$;
                break;
            }
            default: {
                if (n < 0) {
                    throw new ConfigurationException(new StringBuilder(52).append("Setting '").append(s).append("' must be 0 or positive (and fit in an Int)").toString());
                }
                none$ = new Some((Object)BoxesRunTime.boxToInteger((int)n));
                break;
            }
        }
        return none$;
    }

    public FiniteDuration ConnectionTimeout() {
        return this.ConnectionTimeout;
    }

    public Option<Object> WriteBufferHighWaterMark() {
        return this.WriteBufferHighWaterMark;
    }

    public Option<Object> WriteBufferLowWaterMark() {
        return this.WriteBufferLowWaterMark;
    }

    public Option<Object> SendBufferSize() {
        return this.SendBufferSize;
    }

    public Option<Object> ReceiveBufferSize() {
        return this.ReceiveBufferSize;
    }

    public int MaxFrameSize() {
        return this.MaxFrameSize;
    }

    public int Backlog() {
        return this.Backlog;
    }

    public boolean TcpNodelay() {
        return this.TcpNodelay;
    }

    public boolean TcpKeepalive() {
        return this.TcpKeepalive;
    }

    public boolean TcpReuseAddr() {
        return this.TcpReuseAddr;
    }

    public String Hostname() {
        return this.Hostname;
    }

    public String BindHostname() {
        return this.BindHostname;
    }

    public int PortSelector() {
        return this.PortSelector;
    }

    public int BindPortSelector() {
        return this.BindPortSelector;
    }

    public Option<SSLSettings> SslSettings() {
        return this.SslSettings;
    }

    public int ServerSocketWorkerPoolSize() {
        return this.ServerSocketWorkerPoolSize;
    }

    public int ClientSocketWorkerPoolSize() {
        return this.ClientSocketWorkerPoolSize;
    }

    private int computeWPS(Config config) {
        return ThreadPoolConfig$.MODULE$.scaledPoolSize(config.getInt("pool-size-min"), config.getDouble("pool-size-factor"), config.getInt("pool-size-max"));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$EnableSsl$1(NettyTransportSettings $this, boolean x$1) {
        if (!x$1) return true;
        Mode mode = $this.TransportMode();
        NettyTransportSettings$Tcp$ nettyTransportSettings$Tcp$ = NettyTransportSettings$Tcp$.MODULE$;
        if (mode != null) {
            if (!mode.equals(nettyTransportSettings$Tcp$)) return false;
            return true;
        }
        if (nettyTransportSettings$Tcp$ == null) return true;
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$ReceiveBufferSize$1(NettyTransportSettings $this, Option s) {
        if (s.isDefined()) return true;
        Mode mode = $this.TransportMode();
        NettyTransportSettings$Udp$ nettyTransportSettings$Udp$ = NettyTransportSettings$Udp$.MODULE$;
        if (mode == null) {
            if (nettyTransportSettings$Udp$ == null) return false;
            return true;
        } else if (mode.equals(nettyTransportSettings$Udp$)) return false;
        return true;
    }

    private static final Nothing$ throwInvalidNettyVersion$1(String nettyVersion$1) {
        throw new IllegalArgumentException(new StringBuilder(109).append("akka-remote with the Netty transport requires Netty version 3.10.6 or ").append(new StringBuilder(87).append("later. Version [").append(nettyVersion$1).append("] is on the class path. Issue https://github.com/netty/netty/pull/4739 ").toString()).append("may cause messages to not be delivered.").toString());
    }

    public NettyTransportSettings(Config config) {
        Product product;
        this.config = config;
        String string = config.getString("transport-protocol");
        if ("tcp".equals(string)) {
            product = NettyTransportSettings$Tcp$.MODULE$;
        } else if ("udp".equals(string)) {
            product = NettyTransportSettings$Udp$.MODULE$;
        } else {
            throw new ConfigurationException(new StringBuilder(21).append("Unknown transport: [").append(string).append("]").toString());
        }
        this.TransportMode = product;
        this.EnableSsl = BoxesRunTime.unboxToBoolean((Object)Helpers.Requiring$.MODULE$.requiring$extension1(Helpers$.MODULE$.Requiring((Object)BoxesRunTime.boxToBoolean((boolean)config.getBoolean("enable-ssl"))), (Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)NettyTransportSettings.$anonfun$EnableSsl$1(this, BoxesRunTime.unboxToBoolean((Object)x$1))), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(21).append(this.TransportMode()).append(" does not support SSL").toString()));
        this.SSLEngineProviderClassName = this.EnableSsl() ? config.getString("ssl-engine-provider") : "";
        String string2 = config.getString("use-dispatcher-for-io");
        boolean bl = "".equals(string2) ? true : string2 == null;
        Object object = bl ? None$.MODULE$ : new Some((Object)string2);
        this.UseDispatcherForIo = object;
        this.ConnectionTimeout = Helpers.ConfigOps$.MODULE$.getMillisDuration$extension(Helpers$.MODULE$.ConfigOps(config), "connection-timeout");
        this.WriteBufferHighWaterMark = this.optionSize("write-buffer-high-water-mark");
        this.WriteBufferLowWaterMark = this.optionSize("write-buffer-low-water-mark");
        this.SendBufferSize = this.optionSize("send-buffer-size");
        this.ReceiveBufferSize = (Option)Helpers.Requiring$.MODULE$.requiring$extension1(Helpers$.MODULE$.Requiring(this.optionSize("receive-buffer-size")), (Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)NettyTransportSettings.$anonfun$ReceiveBufferSize$1(this, s)), (Function0 & Serializable & scala.Serializable)() -> "receive-buffer-size must be specified for UDP");
        this.MaxFrameSize = BoxesRunTime.unboxToInt((Object)Helpers.Requiring$.MODULE$.requiring$extension1(Helpers$.MODULE$.Requiring((Object)BoxesRunTime.boxToInteger((int)((int)Predef$.MODULE$.Long2long(config.getBytes("maximum-frame-size"))))), (Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$2 -> x$2 >= 32000, (Function0 & Serializable & scala.Serializable)() -> "Setting 'maximum-frame-size' must be at least 32000 bytes"));
        this.Backlog = config.getInt("backlog");
        this.TcpNodelay = config.getBoolean("tcp-nodelay");
        this.TcpKeepalive = config.getBoolean("tcp-keepalive");
        String string3 = config.getString("tcp-reuse-addr");
        boolean bl2 = "off-for-windows".equals(string3) ? !Helpers$.MODULE$.isWindows() : config.getBoolean("tcp-reuse-addr");
        this.TcpReuseAddr = bl2;
        String string4 = config.getString("hostname");
        String string5 = "".equals(string4) ? InetAddress.getLocalHost().getHostAddress() : string4;
        this.Hostname = string5;
        String string6 = config.getString("bind-hostname");
        String string7 = "".equals(string6) ? this.Hostname() : string6;
        this.BindHostname = string7;
        this.PortSelector = config.getInt("port");
        String string8 = config.getString("bind-port");
        int n = "".equals(string8) ? this.PortSelector() : new StringOps(Predef$.MODULE$.augmentString(string8)).toInt();
        this.BindPortSelector = n;
        this.SslSettings = this.EnableSsl() ? new Some((Object)new SSLSettings(config.getConfig("security"))) : None$.MODULE$;
        this.ServerSocketWorkerPoolSize = this.computeWPS(config.getConfig("server-socket-worker-pool"));
        this.ClientSocketWorkerPoolSize = this.computeWPS(config.getConfig("client-socket-worker-pool"));
        String nettyVersion = "3.10.6.Final-5f56a03";
        try {
            String[] segments = nettyVersion.split("[.-]");
            if (segments.length < 3 || new StringOps(Predef$.MODULE$.augmentString(segments[0])).toInt() != 3 || new StringOps(Predef$.MODULE$.augmentString(segments[1])).toInt() != 10 || new StringOps(Predef$.MODULE$.augmentString(segments[2])).toInt() < 6) {
                throw NettyTransportSettings.throwInvalidNettyVersion$1(nettyVersion);
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw NettyTransportSettings.throwInvalidNettyVersion$1(nettyVersion);
        }
    }

    public static interface Mode {
    }
}

