/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.domain;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.repository.core.Securable;
import com.xebialabs.deployit.security.Role;
import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlplatform.documentation.PublicApiRef;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;
import com.xebialabs.xlrelease.api.internal.InternalMetadata;
import com.xebialabs.xlrelease.builder.VariableBuilder;
import com.xebialabs.xlrelease.domain.Attachment;
import com.xebialabs.xlrelease.domain.Changes;
import com.xebialabs.xlrelease.domain.CiWithInternalMetadata;
import com.xebialabs.xlrelease.domain.GateTask;
import com.xebialabs.xlrelease.domain.Phase;
import com.xebialabs.xlrelease.domain.PlanItem;
import com.xebialabs.xlrelease.domain.ReleaseExtension;
import com.xebialabs.xlrelease.domain.ReleaseTrigger;
import com.xebialabs.xlrelease.domain.ReleaseVisitor;
import com.xebialabs.xlrelease.domain.ServerUrl;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.Team;
import com.xebialabs.xlrelease.domain.UserInputTask;
import com.xebialabs.xlrelease.domain.VariableContainer;
import com.xebialabs.xlrelease.domain.VisitableItem;
import com.xebialabs.xlrelease.domain.recover.TaskRecoverOp;
import com.xebialabs.xlrelease.domain.status.FlagStatus;
import com.xebialabs.xlrelease.domain.status.PhaseStatus;
import com.xebialabs.xlrelease.domain.status.ReleaseStatus;
import com.xebialabs.xlrelease.domain.status.TaskStatus;
import com.xebialabs.xlrelease.domain.variables.FolderVariables;
import com.xebialabs.xlrelease.domain.variables.GlobalVariables;
import com.xebialabs.xlrelease.domain.variables.Variable;
import com.xebialabs.xlrelease.domain.variables.reference.PropertyUsagePoint;
import com.xebialabs.xlrelease.domain.variables.reference.ReleasePropertyVariableKey;
import com.xebialabs.xlrelease.domain.variables.reference.ReleaseVariablesUsagePoint;
import com.xebialabs.xlrelease.domain.variables.reference.UsagePoint;
import com.xebialabs.xlrelease.domain.variables.reference.VariableCollectingVisitor;
import com.xebialabs.xlrelease.domain.variables.reference.VariableReference;
import com.xebialabs.xlrelease.events.ReleaseAbortOperation;
import com.xebialabs.xlrelease.events.ReleaseAbortScriptsExecution;
import com.xebialabs.xlrelease.events.ReleaseCompleteOperation;
import com.xebialabs.xlrelease.events.ReleaseFailOperation;
import com.xebialabs.xlrelease.events.ReleasePauseOperation;
import com.xebialabs.xlrelease.events.ReleaseResumeOperation;
import com.xebialabs.xlrelease.events.ReleaseRetryOperation;
import com.xebialabs.xlrelease.events.ReleaseStartFailingOperation;
import com.xebialabs.xlrelease.events.ReleaseStartOperation;
import com.xebialabs.xlrelease.repository.CiHelper;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.user.User;
import com.xebialabs.xlrelease.variable.VariableFactory;
import com.xebialabs.xlrelease.variable.VariableHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(description="A release or template.", root=Metadata.ConfigurationItemRoot.APPLICATIONS, versioned=false)
@PublicApiRef
@ShowOnlyPublicApiMembers
public class Release
extends PlanItem
implements Securable,
CiWithInternalMetadata,
VariableContainer {
    @Property(category="internal", required=false)
    private String rootReleaseId;
    @Property(category="internal", defaultValue="100", description="The maximum number of concurrent releases that can be started by Create Release tasks")
    private int maxConcurrentReleases;
    @Property(asContainment=true, required=false, description="The triggers that may start a release from a template. (Templates only)")
    protected List<ReleaseTrigger> releaseTriggers = new ArrayList<ReleaseTrigger>();
    @Property(asContainment=true, required=false, description="The teams configured on the release.", isTransient=true)
    protected List<Team> teams = new ArrayList<Team>();
    @Deprecated
    @Property(required=false, category="internal", isTransient=true)
    private List<String> memberViewers = new ArrayList<String>();
    @Deprecated
    @Property(required=false, category="internal", isTransient=true)
    private List<String> roleViewers = new ArrayList<String>();
    @Property(asContainment=true, required=false, description="File attachments of the release.")
    private List<Attachment> attachments = new ArrayList<Attachment>();
    @Property(asContainment=true, required=false, description="The list of phases in the release.")
    protected List<Phase> phases = new ArrayList<Phase>();
    @Property(required=false, category="internal")
    protected Date queryableStartDate;
    @Property(required=false, category="internal")
    protected Date queryableEndDate;
    @Property(description="The calculated flag status, derived from the flags from the release and its tasks.", defaultValue="OK")
    protected FlagStatus realFlagStatus = FlagStatus.OK;
    @Property(description="The state the release is in.")
    protected ReleaseStatus status;
    @Property(required=false, description="The tags of the release. Tags can be used for grouping and querying.")
    protected List<String> tags;
    @Property(asContainment=true, required=false, description="List of variable CIs representing variables in this release or template")
    protected List<Variable> variables = new ArrayList<Variable>();
    @Property(required=false, category="internal")
    protected String calendarLinkToken;
    @Property(required=false, category="internal")
    protected boolean calendarPublished;
    @Property(required=false, category="internal")
    protected boolean tutorial;
    @Property(required=false, description="Releases automatically abort when a task fails if this property is set to true.")
    protected boolean abortOnFailure;
    @Property(required=false, description="If set to false, a trigger can't create a release if the previous one it created is still running.")
    protected boolean allowConcurrentReleasesFromTrigger = true;
    @Property(required=false, description="The ID of the template that created this release.")
    protected String originTemplateId;
    @Property(category="internal")
    protected int runningTriggeredReleasesCount = 0;
    @Property(required=false, description="True if release was created by a trigger.")
    protected boolean createdFromTrigger;
    @Property(required=false, description="The credentials of this user are used to run automated scripts in this release.")
    protected String scriptUsername;
    @Property(required=false, password=true, description="The password of the user that lends his credentials to run the scripts.")
    protected String scriptUserPassword;
    @Property(required=false, asContainment=true, description="Extensions of this release, e.g. 'Release contents dashboard'")
    protected List<ReleaseExtension> extensions = new ArrayList<ReleaseExtension>();
    @Property(required=false, description="The Create Release task from which this release was created, if any")
    protected String startedFromTaskId;
    @Property(required=false, defaultValue="false", description="If true, the release will automatically start at scheduledStartDate.")
    protected boolean autoStart;
    @Property(category="internal")
    protected int automatedResumeCount = 0;
    @Property(category="internal", hidden=true, defaultValue="50", description="The maximum number of automatic release resumes performed during phase restarts.")
    protected int maxAutomatedResumes;
    @Property(required=false, description="The comment to associate with the action")
    private String abortComment;
    private Map<String, InternalMetadata> $metadata = new LinkedHashMap<String, InternalMetadata>();
    private boolean archived;
    private Integer ciUid;
    private static final Logger logger = LoggerFactory.getLogger(Release.class);

    @PublicApiMember
    public List<Phase> getPhases() {
        return this.phases;
    }

    public void setPhases(List<Phase> phases) {
        this.phases = phases;
    }

    @PublicApiMember
    public List<ReleaseTrigger> getReleaseTriggers() {
        return this.releaseTriggers;
    }

    public Optional<ReleaseTrigger> getReleaseTriggerById(String releaseTriggerId) {
        return this.releaseTriggers.stream().filter(releaseTrigger -> releaseTrigger.getId().equals(releaseTriggerId)).findFirst();
    }

    public void setReleaseTriggers(List<ReleaseTrigger> releaseTriggers) {
        this.releaseTriggers = releaseTriggers;
    }

    public void deleteReleaseTriggerById(String triggerId) {
        this.releaseTriggers = this.releaseTriggers.stream().filter(releaseTrigger -> !releaseTrigger.getId().equals(triggerId)).collect(Collectors.toList());
    }

    public void replaceTrigger(ReleaseTrigger releaseTrigger) {
        Optional<ReleaseTrigger> maybeTrigger = this.getReleaseTriggerById(releaseTrigger.getId());
        if (maybeTrigger.isPresent()) {
            int index = this.releaseTriggers.indexOf((Object)maybeTrigger.get());
            this.releaseTriggers.set(index, releaseTrigger);
        }
    }

    public String getRootReleaseId() {
        return this.rootReleaseId;
    }

    public void setRootReleaseId(String rootReleaseId) {
        this.rootReleaseId = rootReleaseId;
    }

    public int getMaxConcurrentReleases() {
        return this.maxConcurrentReleases;
    }

    public void setMaxConcurrentReleases(int maxConcurrentReleases) {
        this.maxConcurrentReleases = maxConcurrentReleases;
    }

    public Integer getCiUid() {
        return this.ciUid;
    }

    public void setCiUid(Integer ciUid) {
        this.ciUid = ciUid;
    }

    public int getAutomatedResumeCount() {
        return this.automatedResumeCount;
    }

    public void setAutomatedResumeCount(int automatedResumeCount) {
        this.automatedResumeCount = automatedResumeCount;
    }

    public int getMaxAutomatedResumes() {
        return this.maxAutomatedResumes;
    }

    public void setMaxAutomatedResumes(int maxAutomatedResumes) {
        this.maxAutomatedResumes = maxAutomatedResumes;
    }

    public String getAbortComment() {
        return this.abortComment;
    }

    private void setAbortComment(String abortComment) {
        this.abortComment = abortComment;
    }

    @PublicApiMember
    public Map<String, String> getVariableValues() {
        return VariableHelper.getStringVariableValues(this.variables);
    }

    @PublicApiMember
    public Map<String, String> getPasswordVariableValues() {
        HashMap<String, String> values = new HashMap<String, String>();
        values.putAll(VariableHelper.getPasswordStringVariableValues(this.variables));
        if (this.getGlobalVariables() != null) {
            values.putAll(this.getGlobalVariables().getPasswordVariableValues());
        }
        if (this.getFolderVariables() != null) {
            values.putAll(this.getFolderVariables().getPasswordVariableValues());
        }
        return values;
    }

    public List<Variable> getCiPropertyVariables() {
        return Arrays.stream(ReleasePropertyVariableKey.values()).filter(property -> property.getValue(this) != null).map(property -> VariableBuilder.newStringVariable(property.getKey(), property.getValue(this)).build()).collect(Collectors.toList());
    }

    public Map<String, String> getAllStringVariableValues() {
        ArrayList<Variable> allVariables = new ArrayList<Variable>(this.variables);
        if (this.getGlobalVariables() != null) {
            allVariables.addAll(this.getGlobalVariables().getVariables());
        }
        if (this.getFolderVariables() != null) {
            allVariables.addAll(this.getFolderVariables().getVariables());
        }
        allVariables.addAll(this.getCiPropertyVariables());
        return VariableHelper.getStringVariableValues(allVariables);
    }

    public Map<String, Variable> getVariablesByKeys() {
        return VariableHelper.indexByKey(this.variables);
    }

    @PublicApiMember
    public void setVariableValues(Map<String, ?> variableValues) {
        this.setVariableValues(variableValues, false);
    }

    @PublicApiMember
    public void setPasswordVariableValues(Map<String, ?> variableValues) {
        this.setVariableValues(variableValues, true);
    }

    private void setVariableValues(Map<String, ?> values, boolean passwords) {
        this.scanAndAddNewVariables();
        for (Map.Entry<String, ?> entry : values.entrySet()) {
            String key;
            Map<String, Variable> variablesMap = this.getVariablesByKeys();
            if (variablesMap.containsKey(key = VariableHelper.withoutVariableSyntax(entry.getKey())) || variablesMap.containsKey(entry.getKey())) {
                Variable variable = variablesMap.containsKey(key) ? variablesMap.get(key) : variablesMap.get(entry.getKey());
                if (variable.isPassword() != passwords) continue;
                variable.setUntypedValue(entry.getValue());
                continue;
            }
            this.addVariable(VariableFactory.createVariableByValueType(key, entry.getValue(), passwords, false));
        }
    }

    public List<Variable> scanAndAddNewVariables(VisitableItem updated) {
        Set<VariableReference> variableUsages = this.collectVariableReferences(updated);
        Map<String, Variable> currentVariables = this.getVariablesByKeys();
        List<VariableReference> newVariableReferences = variableUsages.stream().filter(v -> !VariableHelper.withoutVariableSyntax(v.getKey()).startsWith("folder.")).filter(v -> !VariableHelper.withoutVariableSyntax(v.getKey()).startsWith("global.")).filter(v -> !currentVariables.containsKey(VariableHelper.withoutVariableSyntax(v.getKey()))).collect(Collectors.toList());
        if (this.variables == null) {
            this.variables = new ArrayList<Variable>();
        }
        List<Variable> variables = VariableFactory.variableReferencesToVariables(newVariableReferences);
        this.variables.addAll(variables);
        return variables;
    }

    public List<Variable> scanAndAddNewVariables() {
        return this.scanAndAddNewVariables(this);
    }

    @Override
    public List<Variable> getAllVariables() {
        ArrayList<Variable> allVariables = new ArrayList<Variable>(this.variables);
        allVariables.addAll(this.getCiPropertyVariables());
        return allVariables;
    }

    @PublicApiMember
    public List<Variable> getVariables() {
        return Collections.unmodifiableList(this.variables);
    }

    public void addVariables(List<Variable> newVariables) {
        this.variables.addAll(newVariables);
    }

    public void replaceVariable(Variable current, Variable replacement) {
        int index = this.variables.indexOf(current);
        this.variables.set(index, replacement);
    }

    @PublicApiMember
    public void setVariables(List<Variable> variables) {
        VariableHelper.checkVariables(variables);
        this.variables = new ArrayList<Variable>(variables);
    }

    public Optional<Variable> getVariableById(String variableId) {
        return this.getVariables().stream().filter(variable -> variable.getId().equals(variableId)).findFirst();
    }

    public Variable addVariable(Variable variable) {
        this.checkVariableCanBeAdded(variable);
        this.variables.add(variable);
        return variable;
    }

    public void checkVariableCanBeAdded(Variable variable) {
        VariableHelper.checkVariable(variable);
        Preconditions.checkArgument((!this.getVariablesByKeys().containsKey(variable.getKey()) ? 1 : 0) != 0, (String)"A variable already exists by key '%s'", (Object)variable.getKey());
    }

    public GlobalVariables getGlobalVariables() {
        return (GlobalVariables)this.$metadata.get("globalVariables");
    }

    public void setGlobalVariables(GlobalVariables globalVariables) {
        this.$metadata.put("globalVariables", globalVariables);
    }

    public FolderVariables getFolderVariables() {
        return (FolderVariables)this.$metadata.get("folderVariables");
    }

    public void setFolderVariables(FolderVariables folderVariables) {
        this.$metadata.put("folderVariables", folderVariables);
    }

    public Changes removeVariable(String variableId) {
        Changes changes = new Changes();
        CiHelper.removeCisWithId(this.variables, variableId);
        changes.remove(variableId);
        changes.update(this);
        List<UserInputTask> userInputTasks = this.getAllTasksOfType(UserInputTask.class);
        for (UserInputTask task : userInputTasks) {
            changes.addAll(task.removeVariable(variableId));
        }
        return changes;
    }

    public boolean isVariableUsed(Variable variable) {
        String variableKey = VariableHelper.withVariableSyntax(variable.getKey());
        Set<VariableReference> variableReferences = this.collectVariableReferences();
        return variableReferences.stream().anyMatch(input -> variableKey.equals(input.getKey()));
    }

    @PublicApiMember
    public ReleaseStatus getStatus() {
        return this.status;
    }

    @PublicApiMember
    public void setStatus(ReleaseStatus value) {
        this.status = value;
    }

    public Team getAdminTeam() {
        for (Team team : this.getTeams()) {
            if (!team.getTeamName().equals("Release Admin")) continue;
            return team;
        }
        return null;
    }

    @PublicApiMember
    public List<Team> getTeams() {
        return this.teams;
    }

    public void setTeams(List<Team> teams) {
        this.teams = teams;
    }

    @PublicApiMember
    public List<String> getTags() {
        return this.tags;
    }

    @PublicApiMember
    public void setTags(List<String> tags) {
        this.tags = tags != null ? tags.stream().distinct().collect(Collectors.toList()) : Collections.emptyList();
    }

    @PublicApiMember
    public List<Attachment> getAttachments() {
        return this.attachments;
    }

    public void setAttachments(List<Attachment> attachments) {
        this.attachments = attachments;
    }

    public void deleteAttachment(String attachmentId) {
        CiHelper.removeCisWithId(this.attachments, attachmentId);
    }

    public Set<Task> getTasksUsingAttachment(String attachmentId) {
        HashSet<Task> tasks = new HashSet<Task>();
        for (Task task : this.getAllTasks()) {
            tasks.addAll(task.getAttachments().stream().filter(attachment -> attachment.getId().equals(attachmentId)).map(attachment -> task).collect(Collectors.toSet()));
        }
        return tasks;
    }

    @Override
    public boolean hasBeenStarted() {
        return this.status != null && this.status.hasBeenStarted();
    }

    public List<Attachment> getReleaseAttachments() {
        HashSet<Attachment> attachments = new HashSet<Attachment>(this.attachments);
        List<Task> allTasks = this.getAllTasks();
        for (Task task : allTasks) {
            attachments.removeAll(task.getAttachments());
        }
        return new ArrayList<Attachment>(attachments);
    }

    @PublicApiMember
    public String getCalendarLinkToken() {
        return this.calendarLinkToken;
    }

    public void setCalendarLinkToken(String calendarLinkToken) {
        this.calendarLinkToken = calendarLinkToken;
    }

    @PublicApiMember
    public boolean isCalendarPublished() {
        return this.calendarPublished;
    }

    @PublicApiMember
    public void setCalendarPublished(boolean calendarPublished) {
        this.calendarPublished = calendarPublished;
    }

    public List<ReleaseExtension> getExtensions() {
        return this.extensions;
    }

    public void setExtensions(List<ReleaseExtension> extensions) {
        this.extensions = extensions;
    }

    public FlagStatus getRealFlagStatus() {
        return this.realFlagStatus;
    }

    public Phase getCurrentPhase() {
        return this.getPhases().stream().filter(phase -> phase.getStatus() == PhaseStatus.IN_PROGRESS || phase.isFailing() || phase.isFailed()).findFirst().orElse(null);
    }

    public Task getCurrentTask() {
        Phase currentPhase = this.getCurrentPhase();
        if (currentPhase != null) {
            return currentPhase.getCurrentTask();
        }
        return null;
    }

    public boolean hasCurrentPhase() {
        return null != this.getCurrentPhase();
    }

    @VisibleForTesting
    void complete(Changes changes) {
        this.setStatus(ReleaseStatus.COMPLETED);
        this.setEndDate(new Date());
        this.setFlagStatus(FlagStatus.OK);
        this.setFlagComment("");
        this.freezeVariables();
        changes.update(this);
        changes.addOperation(new ReleaseCompleteOperation(this));
    }

    public Changes start() {
        return this.start(false);
    }

    public Changes startAsPartOfBulkOperation() {
        return this.start(true);
    }

    public Changes resume() {
        Changes changes = new Changes();
        this.setStatus(ReleaseStatus.IN_PROGRESS);
        if (this.getStartDate() == null) {
            this.setStartDate(new Date());
        }
        changes.update(this);
        changes.addOperation(new ReleaseResumeOperation(this));
        Optional<Phase> firstPlannedPhase = this.getPhases().stream().filter(Phase::isPlanned).findFirst();
        if (!firstPlannedPhase.isPresent()) {
            throw new IllegalStateException("No planned phase found in release " + this.getId());
        }
        this.startActivablePhase(firstPlannedPhase.get(), changes);
        return changes;
    }

    private boolean hasPhase() {
        return !this.getPhases().isEmpty();
    }

    private void startActivablePhase(Phase phase, Changes changes) {
        changes.addAll(phase.start());
        this.checkPhaseStatus(phase, changes);
    }

    private void checkPhaseStatus(Phase phase, Changes changes) {
        if (phase.isDone()) {
            this.startNextPhase(phase, changes);
        } else if (phase.isFailed()) {
            changes.addAll(this.fail());
        } else if (phase.isFailing()) {
            changes.addAll(this.failing());
        }
    }

    private void startNextPhase(Phase phase, Changes changes) {
        if (this.hasNextPhase(phase)) {
            Phase nextPhase = this.getNextPhase(phase);
            this.startActivablePhase(nextPhase, changes);
        } else {
            this.complete(changes);
        }
    }

    public Changes markTaskAsDone(String taskId, TaskStatus status) {
        Changes changes = new Changes();
        if (this.hasCurrentPhase()) {
            Phase currentPhase = this.getCurrentPhase();
            this.recoverReleaseIfNeeded(changes);
            changes.addAll(currentPhase.markTaskAsDone(taskId, status));
            this.checkPhaseStatus(currentPhase, changes);
        }
        return changes;
    }

    private void recoverReleaseIfNeeded(Changes changes) {
        if (this.getStatus() == ReleaseStatus.FAILED || this.getStatus() == ReleaseStatus.FAILING) {
            changes.update(this);
            changes.addOperation(new ReleaseRetryOperation(this));
            this.setStatus(ReleaseStatus.IN_PROGRESS);
        }
    }

    public Changes startPendingTask(String taskId) {
        Changes changes = new Changes();
        if (this.hasCurrentPhase()) {
            Phase currentPhase = this.getCurrentPhase();
            changes.addAll(currentPhase.startPendingTask(taskId));
            this.checkPhaseStatus(currentPhase, changes);
        }
        return changes;
    }

    public Changes startWithInput(String taskId) {
        Changes changes = new Changes();
        if (this.hasCurrentPhase()) {
            Phase currentPhase = this.getCurrentPhase();
            changes.addAll(currentPhase.startWithInput(taskId));
            this.checkPhaseStatus(currentPhase, changes);
        }
        return changes;
    }

    public Changes taskPreconditionValidated(String taskId) {
        Changes changes = new Changes();
        if (this.hasCurrentPhase()) {
            Phase currentPhase = this.getCurrentPhase();
            changes.addAll(currentPhase.taskPreconditionValidated(taskId));
            this.checkPhaseStatus(currentPhase, changes);
        }
        return changes;
    }

    public Changes failTask(String taskId, String failReason) {
        return this.failTask(taskId, failReason, User.AUTHENTICATED_USER);
    }

    public Changes failTask(String taskId, String failReason, User user) {
        Changes changes = new Changes();
        Task task = this.getTask(taskId);
        for (Phase phase : this.phases) {
            Changes updatedPhaseItems = phase.failTask(taskId, failReason, user);
            if (!updatedPhaseItems.hasUpdatedItems()) continue;
            changes.addAll(updatedPhaseItems);
            if ((!task.isTaskFailureHandlerEnabled() || task.getTaskRecoverOp() == TaskRecoverOp.FAIL_TASK) && this.isAbortOnFailure()) {
                String lastCommentOnTask = this.getLastComment(task);
                changes.addAll(this.abort(lastCommentOnTask.isEmpty() ? String.format("Task '%s' failed", task.getTitle()) : String.format("Task '%s' failed because of: '%s'", task.getTitle(), lastCommentOnTask)));
                continue;
            }
            if (phase.isFailed()) {
                changes.addAll(this.fail());
                continue;
            }
            if (!phase.isFailing()) continue;
            changes.addAll(this.failing());
        }
        return changes;
    }

    private String getLastComment(Task task) {
        if (task.getComments().size() != 0) {
            return task.getComments().get(task.getComments().size() - 1).getText();
        }
        return "";
    }

    private Changes fail() {
        Changes changes = new Changes();
        this.setStatus(ReleaseStatus.FAILED);
        changes.update(this);
        changes.addOperation(new ReleaseFailOperation(this));
        return changes;
    }

    private Changes failing() {
        Changes changes = new Changes();
        this.setStatus(ReleaseStatus.FAILING);
        changes.update(this);
        changes.addOperation(new ReleaseStartFailingOperation(this));
        return changes;
    }

    public Changes abort(String abortComment) {
        return this.abort(false, abortComment);
    }

    public Changes abortAsPartOfBulkOperation(String abortComment) {
        return this.abort(true, abortComment);
    }

    public Changes retryTask(String taskId) {
        Changes changes = new Changes();
        for (Phase phase : this.phases) {
            Changes updatedPhaseItems = phase.retryTask(taskId);
            if (!updatedPhaseItems.hasUpdatedItems()) continue;
            this.setStatus(ReleaseStatus.IN_PROGRESS);
            changes.addAll(updatedPhaseItems);
            changes.addOperation(new ReleaseRetryOperation(this));
            this.checkPhaseStatus(phase, changes);
            changes.update(this);
        }
        return changes;
    }

    public Phase getNextPhase(Phase currentPhase) {
        int currentPhasePosition = this.phases.indexOf(currentPhase) + 1;
        ListIterator<Phase> iterator = this.phases.listIterator(currentPhasePosition);
        return iterator.hasNext() ? iterator.next() : null;
    }

    public boolean hasNextPhase(Phase phase) {
        return this.getNextPhase(phase) != null;
    }

    public void addPhase(Phase phase) {
        this.addPhase(phase, this.phases.size());
    }

    public void addPhase(Phase phase, int position) {
        this.phases.add(position, phase);
        phase.setRelease(this);
    }

    public void deletePhase(Phase phase) {
        this.phases.remove(phase);
    }

    public List<Task> getAllTasks() {
        ArrayList<Task> tasks = new ArrayList<Task>();
        if (this.phases != null) {
            for (Phase phase : this.phases) {
                tasks.addAll(phase.getAllTasks());
            }
        }
        return tasks;
    }

    public Task getTask(String taskId) {
        if (taskId != null) {
            for (Task task : this.getAllTasks()) {
                if (!taskId.equals(task.getId())) continue;
                return task;
            }
        }
        return null;
    }

    public Attachment getAttachment(String attachmentId) {
        for (Attachment attachment : this.attachments) {
            if (!attachmentId.equals(attachment.getId())) continue;
            return attachment;
        }
        return null;
    }

    public Phase movePhase(Integer originIndex, Integer targetIndex) {
        Phase phaseToMove = this.phases.get(originIndex);
        Phase targetPhase = this.phases.get(targetIndex);
        Preconditions.checkArgument((phaseToMove.isPlanned() && targetPhase.isPlanned() ? 1 : 0) != 0, (Object)"Only planned phases can be moved.");
        this.phases.remove(phaseToMove);
        this.phases.add(targetIndex, phaseToMove);
        return phaseToMove;
    }

    public Phase getPhase(Integer index) {
        return this.phases.get(index);
    }

    public Phase getPhase(String phaseId) {
        return this.getPhases().stream().filter(phase -> Objects.equals(Ids.getName(phase.getId()), Ids.getName(phaseId))).findAny().orElse(null);
    }

    public boolean hasPhase(String phaseId) {
        return this.getPhase(phaseId) != null;
    }

    public void addTeam(Team team) {
        Preconditions.checkArgument((!this.hasTeam(team.getTeamName()) ? 1 : 0) != 0, (String)"Release '%s' already has a team named %s", (Object)this.getTitle(), (Object)team.getTeamName());
        this.teams.add(team);
    }

    public void deleteTeam(String teamId) {
        Iterator<Team> i = this.teams.iterator();
        while (i.hasNext()) {
            Team team = i.next();
            if (!team.getId().equals(teamId)) continue;
            if (Ids.isInRootFolder(this.getId())) {
                Preconditions.checkArgument((!team.isSystemTeam() ? 1 : 0) != 0, (String)"The predefined '%s' team can not be deleted.", (Object)team.getTeamName());
            }
            i.remove();
        }
    }

    public void addBelow(String phaseId, Phase addedPhase) {
        addedPhase.setRelease(this);
        this.addBelow(phaseId, Collections.singletonList(addedPhase));
    }

    void addBelow(String phaseId, List<Phase> phasesToAdd) {
        for (int i = 0; i < this.getPhases().size(); ++i) {
            Phase phase = this.getPhase(i);
            if (!phase.getId().equals(phaseId)) continue;
            this.phases.addAll(i + 1, phasesToAdd);
            phasesToAdd.forEach(added -> added.setRelease(this));
        }
    }

    public Set<VariableReference> collectVariableReferences() {
        return this.collectVariableReferences(this);
    }

    public Set<VariableReference> collectVariableReferences(VisitableItem updated) {
        return VariableCollectingVisitor.collectFrom(updated);
    }

    public List<GateTask> getAllGates() {
        return this.getAllTasksOfType(GateTask.class);
    }

    public List<UserInputTask> getAllUserInputTasks() {
        return this.getAllTasksOfType(UserInputTask.class);
    }

    public <T> List<T> getAllTasksOfType(Class<T> clazz) {
        return this.getAllTasks().stream().filter(clazz::isInstance).map(task -> task).collect(Collectors.toList());
    }

    public Date findFirstSetDate() {
        for (Phase phase : this.getPhases()) {
            if (phase.hasScheduledStartDate()) {
                return phase.getScheduledStartDate();
            }
            for (Task task : phase.getAllTasks()) {
                if (!task.hasScheduledStartDate()) continue;
                return task.getScheduledStartDate();
            }
        }
        return DateTime.now().withHourOfDay(9).withMinuteOfHour(0).withSecondOfMinute(0).withMillisOfSecond(0).toDate();
    }

    public void clearComments() {
        this.getPhases().forEach(phase -> phase.getAllTasks().forEach(Task::clearComments));
    }

    public boolean hasNoAutomatedTaskRunning() {
        return this.getAllTasks().stream().noneMatch(Task.IS_AUTOMATED_AND_IN_PROGRESS);
    }

    @Override
    public boolean isDone() {
        return this.status == ReleaseStatus.COMPLETED;
    }

    public boolean isPlannedOrActive() {
        return this.isPlanned() || this.isActive();
    }

    @Override
    public boolean isActive() {
        return this.status != null && this.status.isActive();
    }

    public boolean isDefunct() {
        return this.isAborted() || this.isDone();
    }

    @Override
    public boolean isUpdatable() {
        return !this.isDefunct();
    }

    @Override
    public boolean isAborted() {
        return this.status == ReleaseStatus.ABORTED;
    }

    public boolean isFailing() {
        return this.status == ReleaseStatus.FAILING;
    }

    public boolean isFailed() {
        return this.status == ReleaseStatus.FAILED;
    }

    public boolean isPaused() {
        return this.status == ReleaseStatus.PAUSED;
    }

    public boolean isTemplate() {
        return this.status == ReleaseStatus.TEMPLATE;
    }

    public boolean isPlanned() {
        return ReleaseStatus.PLANNED == this.status;
    }

    public boolean isInProgress() {
        return this.status == ReleaseStatus.IN_PROGRESS;
    }

    public boolean isTutorial() {
        return this.tutorial;
    }

    public void setTutorial(boolean tutorial) {
        this.tutorial = tutorial;
    }

    @PublicApiMember
    public boolean isAbortOnFailure() {
        return this.abortOnFailure;
    }

    @PublicApiMember
    public void setAbortOnFailure(boolean abortOnFailure) {
        this.abortOnFailure = abortOnFailure;
    }

    @PublicApiMember
    public boolean isAllowConcurrentReleasesFromTrigger() {
        return this.allowConcurrentReleasesFromTrigger;
    }

    @PublicApiMember
    public void setAllowConcurrentReleasesFromTrigger(boolean allowConcurrentReleasesFromTrigger) {
        this.allowConcurrentReleasesFromTrigger = allowConcurrentReleasesFromTrigger;
    }

    @PublicApiMember
    public String getOriginTemplateId() {
        return this.originTemplateId;
    }

    public void setOriginTemplateId(String originTemplateId) {
        this.originTemplateId = originTemplateId;
    }

    @PublicApiMember
    public int getRunningTriggeredReleasesCount() {
        return this.runningTriggeredReleasesCount;
    }

    public void incrementRunningTriggeredReleasesCount() {
        ++this.runningTriggeredReleasesCount;
    }

    public void decrementRunningTriggeredReleasesCount() {
        Preconditions.checkState((this.runningTriggeredReleasesCount > 0 ? 1 : 0) != 0, (Object)"Running triggered releases count should be greater than 0");
        --this.runningTriggeredReleasesCount;
    }

    public boolean canTriggerReleases() {
        return this.isAllowConcurrentReleasesFromTrigger() || this.hasNoRunningTriggeredReleases();
    }

    public boolean hasNoRunningTriggeredReleases() {
        return this.getRunningTriggeredReleasesCount() == 0;
    }

    public void setRunningTriggeredReleasesCount(int runningTriggeredReleasesCount) {
        this.runningTriggeredReleasesCount = runningTriggeredReleasesCount;
    }

    @PublicApiMember
    public boolean isCreatedFromTrigger() {
        return this.createdFromTrigger;
    }

    public void setCreatedFromTrigger(boolean createdFromTrigger) {
        this.createdFromTrigger = createdFromTrigger;
    }

    @Override
    public Release getRelease() {
        return this;
    }

    @Override
    public String getDisplayPath() {
        return this.getTitle();
    }

    public Team getTeamWithId(String id) {
        for (Team team : this.teams) {
            if (!team.getId().equals(id)) continue;
            return team;
        }
        throw new IllegalStateException("Release " + this.getId() + " doesn't contain team with id " + id);
    }

    @Override
    public List<PlanItem> getChildren() {
        ArrayList<PlanItem> planItems = new ArrayList<PlanItem>();
        planItems.addAll(this.phases);
        planItems.addAll(this.getAllTasks());
        return planItems;
    }

    public List<PlanItem> getAllPlanItems() {
        ArrayList<PlanItem> planItems = new ArrayList<PlanItem>();
        planItems.add(this);
        planItems.addAll(this.getChildren());
        return planItems;
    }

    private void freezeVariables() {
        Map<String, String> variables = this.getAllStringVariableValues();
        if (variables == null || variables.isEmpty()) {
            return;
        }
        this.setDescription(VariableHelper.replaceAll(this.getDescription(), variables, new HashSet<String>(), false));
    }

    public String toString() {
        return String.format("Release {id=%s, title=%s, status=%s}", new Object[]{this.getId(), this.getTitle(), this.getStatus()});
    }

    public void checkDatesValidityForRelease() {
        Preconditions.checkArgument((this.dueDate != null ? 1 : 0) != 0, (Object)"Due date must be set");
        this.checkDatesValidityForTemplate();
    }

    public void checkDatesValidityForTemplate() {
        Preconditions.checkArgument((this.scheduledStartDate != null ? 1 : 0) != 0, (Object)"Scheduled start date must be set");
        this.checkDatesValidity();
    }

    public void checkDatesValidity() {
        this.checkDatesValidity(this.scheduledStartDate, this.dueDate, this.plannedDuration);
    }

    public void updateDatesForRelease(Date scheduledStartDate, Date dueDate, Integer plannedDuration) {
        Preconditions.checkArgument((dueDate != null ? 1 : 0) != 0, (Object)"Due date must be set");
        this.updateDatesForTemplate(scheduledStartDate, dueDate, plannedDuration);
    }

    public void updateDatesForTemplate(Date scheduledStartDate, Date dueDate, Integer plannedDuration) {
        Preconditions.checkArgument((scheduledStartDate != null ? 1 : 0) != 0, (Object)"Scheduled start date must be set");
        this.updateDates(scheduledStartDate, dueDate, plannedDuration);
    }

    public Date getQueryableStartDate() {
        return this.queryableStartDate;
    }

    public void setQueryableStartDate(Date queryableStartDate) {
        this.queryableStartDate = queryableStartDate;
    }

    public Date getQueryableEndDate() {
        return this.queryableEndDate;
    }

    public void setQueryableEndDate(Date queryableEndDate) {
        this.queryableEndDate = queryableEndDate;
    }

    @PublicApiMember
    public String getScriptUsername() {
        return this.scriptUsername;
    }

    @PublicApiMember
    public void setScriptUsername(String scriptUsername) {
        this.scriptUsername = scriptUsername;
    }

    @PublicApiMember
    public String getScriptUserPassword() {
        return this.scriptUserPassword;
    }

    @PublicApiMember
    public void setScriptUserPassword(String scriptUserPassword) {
        this.scriptUserPassword = scriptUserPassword;
    }

    @PublicApiMember
    public String getUrl() {
        ServerUrl serverUrl = (ServerUrl)this.$metadata.get("serverUrl");
        if (serverUrl == null) {
            return null;
        }
        return ServerUrl.buildUrl(serverUrl.url(), this);
    }

    public String getStartedFromTaskId() {
        return this.startedFromTaskId;
    }

    public void setStartedFromTaskId(String startedFromTaskId) {
        this.startedFromTaskId = startedFromTaskId;
    }

    @Override
    public void setStartDate(Date value) {
        super.setStartDate(value);
        this.queryableStartDate = this.getStartOrScheduledDate();
    }

    @Override
    public void setScheduledStartDate(Date scheduledStartDate) {
        super.setScheduledStartDate(scheduledStartDate);
        this.queryableStartDate = this.getStartOrScheduledDate();
    }

    @Override
    public void setEndDate(Date value) {
        super.setEndDate(value);
        this.queryableEndDate = this.getEndOrDueDate();
    }

    @Override
    public void setDueDate(Date value) {
        super.setDueDate(value);
        this.queryableEndDate = this.getEndOrDueDate();
    }

    public void updateTeam(Team newTeam) {
        Optional<Team> optionalTeam = this.teams.stream().filter(team -> team.getId().equals(newTeam.getId())).findAny();
        if (optionalTeam.isPresent()) {
            Team team2 = optionalTeam.get();
            if (team2.isSystemTeam()) {
                Preconditions.checkArgument((boolean)newTeam.getTeamName().equals(team2.getTeamName()), (Object)"Cannot rename a system team");
            }
            team2.setTeamName(newTeam.getTeamName());
            team2.setRoles(newTeam.getRoles());
            team2.setMembers(newTeam.getMembers());
            team2.setPermissions(newTeam.getPermissions());
        } else {
            logger.warn("Tried to update an unknown team {}", (Object)newTeam.getId());
        }
    }

    public void updateRealFlagStatus() {
        FlagStatus tasksFlagStatus;
        if (this.getAllTasks().size() > 0) {
            Task worstTask = Collections.max(this.getAllTasks(), Comparator.comparingInt(t -> t.getFlagStatus().getRisk()));
            tasksFlagStatus = worstTask.getFlagStatus();
        } else {
            tasksFlagStatus = FlagStatus.OK;
        }
        this.realFlagStatus = tasksFlagStatus.getRisk() > this.flagStatus.getRisk() ? tasksFlagStatus : this.flagStatus;
    }

    public boolean hasScriptUsername() {
        return this.scriptUsername != null;
    }

    public List<Task> getActiveTasks() {
        return this.getAllTasks().stream().filter(Task::isActive).collect(Collectors.toList());
    }

    public boolean isArchived() {
        return this.archived;
    }

    public void setArchived(boolean isArchived) {
        this.archived = isArchived;
    }

    @Override
    public void accept(ReleaseVisitor visitor) {
        visitor.visit(this);
        for (Phase phase : this.phases) {
            phase.accept(visitor);
        }
        for (ReleaseExtension extension : this.extensions) {
            extension.accept(visitor);
        }
        for (Variable variable : this.variables) {
            variable.accept(visitor);
        }
    }

    @Override
    public List<UsagePoint> getVariableUsages() {
        return Arrays.asList(new PropertyUsagePoint(this, "description"), new ReleaseVariablesUsagePoint(this));
    }

    @Override
    public Map<String, InternalMetadata> get$metadata() {
        return this.$metadata;
    }

    public String findFolderId() {
        return Ids.findFolderId(this.getId());
    }

    public boolean hasTeam(String teamName) {
        return this.getTeams().stream().anyMatch(team -> Objects.equals(team.getTeamName(), teamName));
    }

    public Set<String> getTeamsOf(String username, List<Role> userRoles) {
        return this.getTeams().stream().filter(team -> team.hasMember(username) || team.hasAnyRole(userRoles)).map(Team::getTeamName).collect(Collectors.toSet());
    }

    public Set<String> getPermissions(String user, List<Role> userRoles) {
        return this.getPermissions(Collections.singletonList(user), userRoles);
    }

    public Set<String> getPermissions(Collection<String> principals, List<Role> userRoles) {
        return this.getTeams().stream().filter(team -> team.hasAnyMember(principals) || team.hasAnyRole(userRoles)).flatMap(team -> team.getPermissions().stream()).collect(Collectors.toSet());
    }

    public boolean isAutoStart() {
        return this.autoStart;
    }

    public void setAutoStart(boolean autoStart) {
        this.autoStart = autoStart;
    }

    public boolean canAutomaticallyStartReleaseNow() {
        return this.status == ReleaseStatus.PLANNED && this.autoStart && this.getScheduledStartDate() != null && new Date().after(this.getScheduledStartDate());
    }

    public boolean isPending() {
        return this.isPlanned() && this.isAutoStart();
    }

    public void deleteTask(Task task) {
        this.getPhases().forEach(phase -> phase.deleteTask(task));
    }

    public void replaceTask(Task task) {
        this.getPhases().forEach(phase -> phase.replaceTask(task));
    }

    public List<Phase> getPhasesByTitle(String phaseTitle) {
        return this.getPhases().stream().filter(phase -> phase.hasTitle(phaseTitle)).collect(Collectors.toList());
    }

    public List<Phase> getPhasesContainingInTitle(String partialTitleToLookFor) {
        return this.filterPhasesContainingInTitle(this.getPhases(), partialTitleToLookFor);
    }

    public List<Phase> filterPhasesContainingInTitle(List<Phase> phases, String partialTitleToLookFor) {
        return phases.stream().filter(phase -> phase.isTitleContaining(partialTitleToLookFor)).collect(Collectors.toList());
    }

    public List<Task> getTasksByTitle(String phaseTitle, String taskTitle) {
        return this.getAllTasks().stream().filter(task -> task.hasTitle(taskTitle) && (Strings.isNullOrEmpty((String)phaseTitle) || task.getPhase().hasTitle(phaseTitle))).collect(Collectors.toList());
    }

    public Changes restorePhases(List<Phase> phases) {
        Changes changes = new Changes();
        this.addBelow(this.getCurrentPhase().getId(), phases);
        this.setStatus(ReleaseStatus.PAUSED);
        changes.update(this);
        changes.addOperation(new ReleasePauseOperation(this));
        return changes;
    }

    public void fixId(String folderId) {
        CiHelper.rewriteWithNewId(this, Ids.formatFolderWithRelease(folderId, this.getId()));
    }

    private Changes start(boolean isPartOfBulkOperation) {
        Preconditions.checkState((!this.hasBeenStarted() ? 1 : 0) != 0, (Object)"Only not started releases may be started");
        Changes changes = new Changes();
        this.setStatus(ReleaseStatus.IN_PROGRESS);
        this.setStartDate(new Date());
        changes.update(this);
        changes.addOperation(new ReleaseStartOperation(this, isPartOfBulkOperation));
        if (this.hasPhase()) {
            Phase firstPhase = this.getPhases().get(0);
            this.startActivablePhase(firstPhase, changes);
        } else {
            this.complete(changes);
        }
        return changes;
    }

    private Changes abort(boolean isPartOfBulkOperation, String abortComment) {
        Preconditions.checkState((this.getStatus() != ReleaseStatus.TEMPLATE ? 1 : 0) != 0, (Object)"Can't abort a template release");
        Preconditions.checkState((!Strings.isNullOrEmpty((String)abortComment) ? 1 : 0) != 0, (Object)"Can't abort a release without comment");
        Changes changes = new Changes();
        this.setAbortComment(abortComment);
        this.setStatus(ReleaseStatus.ABORTED);
        this.setEndDate(new Date());
        changes.update(this);
        changes.addOperation(new ReleaseAbortOperation(this, isPartOfBulkOperation));
        changes.addOperation(new ReleaseAbortScriptsExecution(this));
        this.phases.stream().filter(phase -> !phase.isDone()).forEach(phase -> changes.addAll(phase.abort()));
        return changes;
    }
}

