/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.domain.tasks.customscript;

import com.google.common.annotations.VisibleForTesting;
import com.xebialabs.deployit.plumbing.scheduler.Scheduler;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.config.XlrConfig;
import com.xebialabs.xlrelease.domain.BaseScriptTask;
import com.xebialabs.xlrelease.domain.CustomScriptTask;
import com.xebialabs.xlrelease.domain.status.TaskStatus;
import com.xebialabs.xlrelease.domain.tasks.BaseScriptTaskExecutor;
import com.xebialabs.xlrelease.repository.TaskRepository;
import com.xebialabs.xlrelease.repository.query.ResolveOptionsBuilder;
import com.xebialabs.xlrelease.script.ScriptCallback;
import com.xebialabs.xlrelease.script.ScriptService;
import com.xebialabs.xlrelease.user.User;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CustomScriptTaskExecutor
extends BaseScriptTaskExecutor<CustomScriptTask> {
    public static final Logger logger = LoggerFactory.getLogger(CustomScriptTaskExecutor.class);
    private Scheduler scheduler;
    private XlrConfig xlrConfig;

    @Autowired
    public CustomScriptTaskExecutor(TaskRepository taskRepository, ReleaseActorService releaseActorService, Collection<? extends ScriptService> scriptServices, Scheduler scheduler, XlrConfig xlrConfig) {
        super(taskRepository, releaseActorService, scriptServices);
        this.scheduler = scheduler;
        this.xlrConfig = xlrConfig;
    }

    @Override
    public Class<CustomScriptTask> getTaskClass() {
        return CustomScriptTask.class;
    }

    @Override
    public void execute(CustomScriptTask task) {
        this.execute(task, null);
    }

    @VisibleForTesting
    void execute(CustomScriptTask task, String lastExecutionId) {
        if (!task.isInProgress()) {
            logger.info("Not executing script of task {} as it is {}", (Object)task, (Object)task.getStatus());
            return;
        }
        if (lastExecutionId != null && !task.isStillExecutingScript(lastExecutionId)) {
            logger.info("Not executing script of task {} as the execution ID has changed from the last polling from {} to {}. Probably the task was aborted and immediately retried.", new Object[]{task, lastExecutionId, task.getExecutionId()});
            return;
        }
        this.scriptServiceFor((BaseScriptTask)task).executeCustomScriptTask(task, this.onSuccess(task), this.onFailure(task));
    }

    @Override
    public ScriptCallback onSuccess(final CustomScriptTask task) {
        return new ScriptCallback(){

            @Override
            public void run() {
                if (!task.hasNextScriptToExecute()) {
                    CustomScriptTaskExecutor.this.scriptTaskCompleted(task.getId(), this.getExecutionLog(), task.getExecutionId());
                } else {
                    String lastExecutionId = task.getExecutionId();
                    CustomScriptTaskExecutor.this.scheduler.scheduleOnce(() -> {
                        CustomScriptTask currentTask = (CustomScriptTask)CustomScriptTaskExecutor.this.taskRepository.findById(task.getId());
                        CustomScriptTaskExecutor.this.execute(currentTask, lastExecutionId);
                    }, task.getInterval() != null ? (long)(task.getInterval() * 1000) : CustomScriptTaskExecutor.this.xlrConfig.durations_customScriptTaskScheduleInterval().toMillis(), TimeUnit.MILLISECONDS);
                }
            }
        };
    }

    @Override
    protected void scriptTaskCompleted(String taskId, String executionLog, String scriptExecutionId) {
        BaseScriptTask task = (BaseScriptTask)this.taskRepository.findById(taskId, new ResolveOptionsBuilder().build());
        boolean shouldWait = ((CustomScriptTask)task).isWaitingForSignal();
        if (shouldWait) {
            logger.info("Will not complete task: '{}', staying in progress until task condition is met.", (Object)task.getId());
        } else if (task.isStillExecutingScript(scriptExecutionId)) {
            this.releaseActorService.markTaskAsDone(TaskStatus.COMPLETED, taskId, executionLog, User.LOG_OUTPUT);
        } else {
            logger.debug("Will not complete task: '{}', it has been aborted.", (Object)task.getId());
        }
    }
}

