/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.db.sql;

import com.xebialabs.xlrelease.db.sql.SqlBuilder;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.sql.Connection;
import javax.sql.DataSource;
import org.slf4j.Marker;
import org.springframework.jdbc.core.JdbcTemplate;
import scala.Function0;
import scala.Serializable;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u00193Aa\u0001\u0003\u0001\u001f!)a\u0004\u0001C\u0001?!)!\u0005\u0001C\u0001G\t\u00112+\u001d7ES\u0006dWm\u0019;EKR,7\r^8s\u0015\t)a!A\u0002tc2T!a\u0002\u0005\u0002\u0005\u0011\u0014'BA\u0005\u000b\u0003%AHN]3mK\u0006\u001cXM\u0003\u0002\f\u0019\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u0002\u001b\u0005\u00191m\\7\u0004\u0001M\u0019\u0001\u0001\u0005\f\u0011\u0005E!R\"\u0001\n\u000b\u0003M\tQa]2bY\u0006L!!\u0006\n\u0003\r\u0005s\u0017PU3g!\t9B$D\u0001\u0019\u0015\tI\"$A\u0003tY\u001a$$NC\u0001\u001c\u0003!9'/\u001b>{Y\u0016$\u0017BA\u000f\u0019\u0005\u001daunZ4j]\u001e\fa\u0001P5oSRtD#\u0001\u0011\u0011\u0005\u0005\u0002Q\"\u0001\u0003\u0002!\u0011,G/Z2u'FdG)[1mK\u000e$HC\u0001\u00139!\t)SG\u0004\u0002'g9\u0011qE\r\b\u0003QEr!!\u000b\u0019\u000f\u0005)zcBA\u0016/\u001b\u0005a#BA\u0017\u000f\u0003\u0019a$o\\8u}%\tQ\"\u0003\u0002\f\u0019%\u0011\u0011BC\u0005\u0003\u000f!I!!\u0002\u0004\n\u0005Q\"\u0011AC*rY\n+\u0018\u000e\u001c3fe&\u0011ag\u000e\u0002\b\t&\fG.Z2u\u0015\t!D\u0001C\u0003:\u0005\u0001\u0007!(\u0001\u0007kI\n\u001cG+Z7qY\u0006$X\r\u0005\u0002<\t6\tAH\u0003\u0002>}\u0005!1m\u001c:f\u0015\ty\u0004)\u0001\u0003kI\n\u001c'BA!C\u0003=\u0019\bO]5oO\u001a\u0014\u0018-\\3x_J\\'\"A\"\u0002\u0007=\u0014x-\u0003\u0002Fy\ta!\n\u001a2d)\u0016l\u0007\u000f\\1uK\u0002")
public class SqlDialectDetector
implements Logging {
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        SqlDialectDetector sqlDialectDetector = this;
        synchronized (sqlDialectDetector) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public SqlBuilder.Dialect detectSqlDialect(JdbcTemplate jdbcTemplate) {
        SqlBuilder.DerbyDialect derbyDialect;
        DataSource ds = jdbcTemplate.getDataSource();
        try (Connection connection = ds.getConnection();){
            SqlBuilder.Dialect dialect;
            String dbName = connection.getMetaData().getDatabaseProductName();
            this.logger().debug((Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(26).append("Detecting SQL dialect for ").append(dbName).toString());
            String dbNameLower = dbName.toLowerCase();
            if (dbNameLower.contains("derby")) {
                dialect = new SqlBuilder.DerbyDialect(dbNameLower);
            } else if (dbNameLower.contains("oracle")) {
                dialect = new SqlBuilder.OracleDialect(dbNameLower);
            } else if (dbNameLower.contains("db2")) {
                dialect = new SqlBuilder.Db2Dialect(dbNameLower);
            } else if (dbNameLower.contains("sql server")) {
                dialect = new SqlBuilder.MSSQLDialect(dbNameLower);
            } else if (dbNameLower.contains("mysql") || dbNameLower.contains("h2") || dbNameLower.contains("postgresql")) {
                dialect = new SqlBuilder.CommonDialect(dbNameLower);
            } else {
                this.logger().warn((Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(29).append(dbName).append(" is not officially supported.").toString());
                dialect = new SqlBuilder.CommonDialect(dbNameLower);
            }
            SqlBuilder.DerbyDialect dialect2 = dialect;
            this.logger().info((Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(20).append("SQL dialect for ").append(dbName).append(" is ").append(dialect2).toString());
            derbyDialect = dialect2;
        }
        return derbyDialect;
    }

    public SqlDialectDetector() {
        Logging.$init$((Logging)this);
    }
}

