/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.internal;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.plumbing.id.IdParam;
import com.xebialabs.deployit.security.PermissionDeniedException;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.domain.Dependency;
import com.xebialabs.xlrelease.domain.GateCondition;
import com.xebialabs.xlrelease.domain.GateTask;
import com.xebialabs.xlrelease.domain.Phase;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.query.ResolveOptions;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.security.TaskGranularPermissions;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import com.xebialabs.xlrelease.service.DependencyService;
import com.xebialabs.xlrelease.service.GateConditionService;
import com.xebialabs.xlrelease.service.ReleaseService;
import com.xebialabs.xlrelease.service.TaskService;
import com.xebialabs.xlrelease.views.DependencyTargetView;
import com.xebialabs.xlrelease.views.DependencyView;
import com.xebialabs.xlrelease.views.GateConditionView;
import com.xebialabs.xlrelease.views.PlanItemView;
import com.xebialabs.xlrelease.views.ReleaseView;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Path(value="/gates")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Controller
public class GatesResource {
    private ReleaseActorService releaseActorService;
    private GateConditionService conditions;
    private ReleaseService releaseService;
    private PermissionChecker permissions;
    private DependencyService dependencyService;
    private TaskService taskService;
    private TaskGranularPermissions taskPermissionChecker;

    @Autowired
    public GatesResource(ReleaseActorService releaseActorService, GateConditionService conditions, ReleaseService releaseService, PermissionChecker permissions, DependencyService dependencyService, TaskService taskService, TaskGranularPermissions taskPermissionChecker) {
        this.releaseActorService = releaseActorService;
        this.conditions = conditions;
        this.releaseService = releaseService;
        this.permissions = permissions;
        this.dependencyService = dependencyService;
        this.taskService = taskService;
        this.taskPermissionChecker = taskPermissionChecker;
    }

    @PUT
    @Timed
    @Path(value="conditions/{conditionId:.*Condition[^/-]*}")
    public GateConditionView updateCondition(@PathParam(value="conditionId") @IdParam String conditionId, GateConditionView conditionView) {
        GateConditionView gateConditionView;
        Release release = this.releaseService.findById(Ids.releaseIdFrom((String)conditionId), ResolveOptions.MINIMAL());
        if (release.isTemplate() && this.permissions.hasPermission(XLReleasePermissions.EDIT_TEMPLATE, release)) {
            gateConditionView = new GateConditionView(this.releaseActorService.updateGateCondition(conditionId, conditionView.toCondition()));
        } else if (this.permissions.isAllowedToWorkOnTask(Ids.getParentId((String)conditionId)) && this.checkHasEditTaskPermissionIfConditionTitleChanged(conditionId, conditionView, release) || this.taskPermissionChecker.hasEditTaskConfigurationGranularPermission(release)) {
            gateConditionView = new GateConditionView(this.releaseActorService.updateGateCondition(conditionId, conditionView.toCondition()));
        } else {
            throw PermissionDeniedException.forPermission((Permission)(release.isTemplate() ? XLReleasePermissions.EDIT_TEMPLATE : XLReleasePermissions.EDIT_RELEASE_TASK), (String)release.getId());
        }
        return gateConditionView;
    }

    @POST
    @Timed
    @Path(value="{gateId:.*Task[^/-]*}/conditions")
    public GateConditionView createCondition(@PathParam(value="gateId") @IdParam String gateId) {
        Release release = this.releaseService.findById(Ids.releaseIdFrom((String)gateId));
        this.taskPermissionChecker.checkHasEditTaskOrEditTaskConfiguration(release);
        GateCondition gateCondition = this.releaseActorService.createGateCondition(gateId);
        return new GateConditionView(gateCondition);
    }

    @DELETE
    @Timed
    @Path(value="conditions/{conditionId:.*Condition[^/-]*}")
    public void deleteCondition(@PathParam(value="conditionId") @IdParam String conditionId) {
        Release release = this.releaseService.findById(Ids.releaseIdFrom((String)conditionId), ResolveOptions.MINIMAL());
        this.taskPermissionChecker.checkHasEditTaskOrEditTaskConfiguration(release);
        this.releaseActorService.deleteGateCondition(conditionId);
    }

    @GET
    @Timed
    @Path(value="{gateId:.*Task[^/-]*}/dependencies")
    public List<DependencyView> getDependencies(@PathParam(value="gateId") @IdParam String gateId) {
        GateTask gateTask = (GateTask)this.taskService.findByIdIncludingArchived(gateId);
        this.permissions.checkViewTask((Task)gateTask);
        return gateTask.getDependencies().stream().map(DependencyView::new).collect(Collectors.toList());
    }

    @POST
    @Timed
    @Path(value="{gateId:.*Task[^/-]*}/dependencies")
    public DependencyView addDependency(@PathParam(value="gateId") @IdParam String gateId, DependencyView dependencyView) {
        Release release = this.releaseService.findById(Ids.releaseIdFrom((String)gateId), ResolveOptions.MINIMAL());
        this.taskPermissionChecker.checkHasEditTaskOrEditTaskConfiguration(release);
        if (dependencyView.hasFixedTarget()) {
            this.permissions.checkView(Ids.releaseIdFrom((String)dependencyView.toTargetId()));
        }
        Dependency dependency = this.releaseActorService.createDependency(gateId, dependencyView.toTargetIdOrVariable());
        return new DependencyView(dependency);
    }

    @GET
    @Timed
    @Path(value="{gateId:.*Task[^/-]*}/dependency-target-candidates")
    public List<PlanItemView> getDependencyTargetCandidates(@PathParam(value="gateId") @IdParam String gateId) {
        List<Release> dependencyTargetCandidates = this.dependencyService.findAllDependencyCandidates(gateId);
        return dependencyTargetCandidates.stream().map(PlanItemView::new).collect(Collectors.toList());
    }

    @GET
    @Timed
    @Path(value="{gateId:.*Task[^/-]*}/dependency-target-candidates/{releaseId:.*Release[^/-]*}")
    public ReleaseView loadDependencyTargetCandidate(@PathParam(value="gateId") @IdParam String gateId, @PathParam(value="releaseId") @IdParam String releaseId) {
        this.permissions.checkView(releaseId);
        return new ReleaseView(this.dependencyService.getDependencyCandidate(gateId, releaseId));
    }

    @GET
    @Timed
    @Path(value="{gateId:.*Task[^/-]*}/dependency-target-statuses")
    public List<DependencyTargetView> getDependenciesStatuses(@PathParam(value="gateId") @IdParam String gateId) {
        GateTask gateTask = (GateTask)this.taskService.findByIdIncludingArchived(gateId, ResolveOptions.MINIMAL());
        this.permissions.checkViewTask((Task)gateTask);
        return gateTask.getDependencies().stream().map(dependency -> {
            String targetId = dependency.getTargetId();
            try {
                if (Ids.isReleaseId((String)targetId)) {
                    Release release = (Release)this.dependencyService.findDependencyTargetByTargetId(targetId);
                    return new DependencyTargetView(release.getId(), release.getStatus().value());
                }
                if (Ids.isPhaseId((String)targetId)) {
                    Phase phase = (Phase)this.dependencyService.findDependencyTargetByTargetId(targetId);
                    return new DependencyTargetView(phase.getId(), phase.getStatus().value());
                }
                if (Ids.isTaskId((String)targetId)) {
                    Task task = (Task)this.dependencyService.findDependencyTargetByTargetId(targetId);
                    return new DependencyTargetView(task.getId(), task.getStatus().value());
                }
            }
            catch (NotFoundException ex) {
                return new DependencyTargetView(targetId, "not_found");
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private boolean checkHasEditTaskPermissionIfConditionTitleChanged(String conditionId, GateConditionView conditionView, Release release) {
        if (!com.google.common.base.Objects.equal((Object)this.conditions.findById(conditionId).getTitle(), (Object)conditionView.toCondition().getTitle())) {
            return this.permissions.hasPermission(XLReleasePermissions.EDIT_RELEASE_TASK, release);
        }
        return true;
    }
}

