/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import com.xebialabs.deployit.core.api.InternalSecurityProxy;
import com.xebialabs.deployit.core.api.dto.RolePermissions;
import com.xebialabs.deployit.core.rest.api.DtoReader;
import com.xebialabs.deployit.core.rest.api.DtoWriter;
import com.xebialabs.deployit.core.rest.api.support.PaginationSupport;
import com.xebialabs.deployit.core.rest.secured.AbstractSecuredResource;
import com.xebialabs.deployit.engine.api.dto.Ordering;
import com.xebialabs.deployit.engine.api.dto.Paging;
import com.xebialabs.deployit.engine.api.security.Role;
import com.xebialabs.deployit.engine.api.security.RolePrincipals;
import com.xebialabs.deployit.engine.spi.event.RolePermissionsChangedEvent;
import com.xebialabs.deployit.engine.spi.event.RolePrincipalsChangedEvent;
import com.xebialabs.deployit.engine.spi.exception.DeployitException;
import com.xebialabs.deployit.engine.spi.exception.HttpResponseCodeResult;
import com.xebialabs.deployit.event.EventBusHolder;
import com.xebialabs.deployit.security.PermissionEditor;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ws.rs.core.Context;
import org.jboss.resteasy.spi.HttpResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Controller
public class SecurityResource
extends AbstractSecuredResource
implements InternalSecurityProxy {
    @Context
    private HttpResponse response;
    @Autowired
    private RoleService roleService;
    @Autowired
    private PermissionEditor permissionEditor;
    private DtoWriter dtoWriter = new DtoWriter();
    private DtoReader dtoReader = new DtoReader();
    private static final Logger logger = LoggerFactory.getLogger(SecurityResource.class);

    public Boolean exists(String roleName) {
        return this.roleService.roleExists(roleName);
    }

    public List<Role> list(String id, String rolePattern, Paging paging, Ordering order) {
        if (rolePattern == null && (paging == null || paging.resultsPerPage() == -1) && order == null) {
            return this.dtoWriter.writeRoles(this.roleService.getRoles(id));
        }
        PaginationSupport.addTotalCountHeader(this.roleService.countRoles(id, rolePattern), this.response);
        return this.dtoWriter.writeRoles(this.roleService.getRoles(id, rolePattern, paging, order));
    }

    public List<RolePermissions> readRolePermissions(String id, String rolePattern, Paging paging, Ordering order) {
        Map rolePermissionMultimap;
        this.checkPermission(PlatformPermissions.EDIT_SECURITY);
        if (rolePattern == null && (paging == null || paging.resultsPerPage() == -1) && order == null) {
            rolePermissionMultimap = this.permissionEditor.readPermissions(id);
        } else {
            rolePermissionMultimap = this.permissionEditor.readPermissions(id, rolePattern, paging, order);
            PaginationSupport.addTotalCountHeader(this.roleService.countRoles(id, rolePattern), this.response);
        }
        return this.dtoWriter.writeRolePermissions(rolePermissionMultimap);
    }

    public void writeRolePermissions(String id, List<RolePermissions> permissions) {
        this.checkPermission(PlatformPermissions.EDIT_SECURITY);
        List roles = this.roleService.getRoles();
        Map<com.xebialabs.deployit.security.Role, Set<Permission>> multimap = this.dtoReader.readRolePermissions(permissions, roles);
        this.permissionEditor.editPermissions(id, multimap);
        SecurityResource.fireRolePermissionsChangedEvent(id, permissions);
    }

    private static void fireRolePermissionsChangedEvent(String id, List<RolePermissions> permissions) {
        List collect = permissions.stream().map(p -> p.getRole().getName() + " => " + p.getPermissions()).collect(Collectors.toList());
        EventBusHolder.publish((Object)new RolePermissionsChangedEvent(id, collect));
    }

    public List<RolePrincipals> readRolePrincipals(String rolePattern, Paging paging, Ordering order) {
        List multimap;
        this.checkPermission(PlatformPermissions.EDIT_SECURITY);
        if (rolePattern == null && (paging == null || paging.resultsPerPage() == -1) && order == null) {
            multimap = this.roleService.readRoleAssignments();
        } else {
            multimap = this.roleService.readRoleAssignments(rolePattern, paging, order);
            long total = this.roleService.countRoles((Number)-1, rolePattern);
            PaginationSupport.addTotalCountHeader(total, this.response);
        }
        logger.debug("com.xebialabs.deployit.security.RoleService delivered roles: {}", (Object)multimap);
        List<RolePrincipals> assignments = this.dtoWriter.writeRoleAssignments(multimap);
        logger.debug("Going to return the following roles: {}", assignments);
        return assignments;
    }

    public void writeRolePrincipals(List<RolePrincipals> rolePrincipals) {
        this.checkPermission(PlatformPermissions.EDIT_SECURITY);
        logger.debug("Got the following roles: {}", rolePrincipals);
        HashMap<String, RolePrincipals> indexed = new HashMap<String, RolePrincipals>();
        for (RolePrincipals rp : rolePrincipals) {
            String roleName = rp.getRole().getName();
            if (roleName == null || roleName.trim().isEmpty()) {
                throw new IllegalArgumentException("Role name cannot be empty");
            }
            if (!indexed.containsKey(roleName)) {
                indexed.put(roleName, rp);
                continue;
            }
            ((RolePrincipals)indexed.get(roleName)).addPrincipals(rp.getPrincipals());
        }
        List<com.xebialabs.deployit.security.Role> roles = this.dtoReader.readRoleAssignments(new ArrayList<RolePrincipals>(indexed.values()));
        logger.debug("Going to write the following role assignments: {}", roles);
        this.roleService.writeRoleAssignments(roles);
        SecurityResource.fireRolePrincipalsChangedEvent(rolePrincipals);
    }

    private static void fireRolePrincipalsChangedEvent(List<RolePrincipals> rolePrincipals) {
        EventBusHolder.publish((Object)new RolePrincipalsChangedEvent(rolePrincipals.stream().map(rp -> rp.getRole().getName() + " => " + rp.getPrincipals()).collect(Collectors.toList())));
    }

    public void setRoleService(RoleService roleService) {
        this.roleService = roleService;
    }

    @HttpResponseCodeResult(statusCode=400)
    public static class UnknownPermissionException
    extends DeployitException {
        public UnknownPermissionException(String permission) {
            super("Permission %s does not exist.", new Object[]{permission});
        }
    }
}

