/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.geo;

import java.io.Serializable;
import lombok.Generated;
import org.springframework.data.domain.Range;
import org.springframework.data.geo.Metric;
import org.springframework.data.geo.Metrics;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public final class Distance
implements Serializable,
Comparable<Distance> {
    private static final long serialVersionUID = 2460886201934027744L;
    private final double value;
    private final Metric metric;

    public Distance(double value) {
        this(value, Metrics.NEUTRAL);
    }

    public Distance(double value, Metric metric) {
        Assert.notNull((Object)metric, (String)"Metric must not be null!");
        this.value = value;
        this.metric = metric;
    }

    public static Range<Distance> between(Distance min, Distance max) {
        return Range.from(Range.Bound.inclusive(min)).to(Range.Bound.inclusive(max));
    }

    public static Range<Distance> between(double minValue, Metric minMetric, double maxValue, Metric maxMetric) {
        return Distance.between(new Distance(minValue, minMetric), new Distance(maxValue, maxMetric));
    }

    public double getNormalizedValue() {
        return this.value / this.metric.getMultiplier();
    }

    public String getUnit() {
        return this.metric.getAbbreviation();
    }

    public Distance add(Distance other) {
        Assert.notNull((Object)other, (String)"Distance to add must not be null!");
        double newNormalizedValue = this.getNormalizedValue() + other.getNormalizedValue();
        return new Distance(newNormalizedValue * this.metric.getMultiplier(), this.metric);
    }

    public Distance add(Distance other, Metric metric) {
        Assert.notNull((Object)other, (String)"Distance to must not be null!");
        Assert.notNull((Object)metric, (String)"Result metric must not be null!");
        double newLeft = this.getNormalizedValue() * metric.getMultiplier();
        double newRight = other.getNormalizedValue() * metric.getMultiplier();
        return new Distance(newLeft + newRight, metric);
    }

    public Distance in(Metric metric) {
        Assert.notNull((Object)metric, (String)"Metric must not be null!");
        return this.metric.equals(metric) ? this : new Distance(this.getNormalizedValue() * metric.getMultiplier(), metric);
    }

    @Override
    public int compareTo(@Nullable Distance that) {
        if (that == null) {
            return 1;
        }
        double difference = this.getNormalizedValue() - that.getNormalizedValue();
        return difference == 0.0 ? 0 : (difference > 0.0 ? 1 : -1);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.value);
        if (this.metric != Metrics.NEUTRAL) {
            builder.append(" ").append(this.metric.toString());
        }
        return builder.toString();
    }

    @Generated
    public double getValue() {
        return this.value;
    }

    @Generated
    public Metric getMetric() {
        return this.metric;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Distance)) {
            return false;
        }
        Distance other = (Distance)o;
        if (Double.compare(this.getValue(), other.getValue()) != 0) {
            return false;
        }
        Metric this$metric = this.getMetric();
        Metric other$metric = other.getMetric();
        return !(this$metric == null ? other$metric != null : !this$metric.equals(other$metric));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $value = Double.doubleToLongBits(this.getValue());
        result = result * 59 + (int)($value >>> 32 ^ $value);
        Metric $metric = this.getMetric();
        result = result * 59 + ($metric == null ? 43 : $metric.hashCode());
        return result;
    }
}

