/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.domain.status;

import com.xebialabs.xlplatform.documentation.PublicApiRef;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;

@PublicApiRef
@ShowOnlyPublicApiMembers
public enum TaskStatus {
    PLANNED("planned"),
    PENDING("pending"),
    IN_PROGRESS("in_progress"),
    COMPLETED("completed"),
    COMPLETED_IN_ADVANCE("completed_in_advance"),
    SKIPPED("skipped"),
    SKIPPED_IN_ADVANCE("skipped_in_advance"),
    FAILED("failed"),
    FAILING("failing"),
    ABORTED("aborted"),
    PRECONDITION_IN_PROGRESS("precondition_in_progress"),
    WAITING_FOR_INPUT("waiting_for_input"),
    FAILURE_HANDLER_IN_PROGRESS("failure_handler_in_progress"),
    FACET_CHECK_IN_PROGRESS("facet_check_in_progress");

    public static final TaskStatus[] ACTIVE_STATUSES;
    private final String value;

    private TaskStatus(String v) {
        this.value = v;
    }

    public String value() {
        return this.value;
    }

    public boolean hasBeenStarted() {
        return this != PLANNED && this != PENDING && this != WAITING_FOR_INPUT;
    }

    public boolean isDone() {
        return this.isOneOf(COMPLETED, SKIPPED);
    }

    public boolean isDoneInAdvance() {
        return this.isOneOf(COMPLETED_IN_ADVANCE, SKIPPED_IN_ADVANCE);
    }

    public boolean isActive() {
        return this.isOneOf(ACTIVE_STATUSES);
    }

    public boolean isOneOf(TaskStatus ... statuses) {
        for (TaskStatus status : statuses) {
            if (this != status) continue;
            return true;
        }
        return false;
    }

    static {
        ACTIVE_STATUSES = new TaskStatus[]{PENDING, PRECONDITION_IN_PROGRESS, FAILURE_HANDLER_IN_PROGRESS, IN_PROGRESS, FAILING, FAILED, WAITING_FOR_INPUT};
    }
}

