/*
 * Decompiled with CFR 0.152.
 */
package akka.remote;

import akka.event.EventStream;
import akka.event.Logging;
import akka.event.SubchannelClassification;
import akka.remote.FailureDetector;
import akka.remote.FailureDetector$;
import akka.remote.HeartbeatHistory;
import akka.remote.HeartbeatHistory$;
import akka.remote.PhiAccrualFailureDetector$State$;
import akka.util.Helpers;
import akka.util.Helpers$;
import com.typesafe.config.Config;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicReference;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.collection.Iterator;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\t5e\u0001\u0002\u001e<\u0001\u0001C\u0001b\u0013\u0001\u0003\u0006\u0004%\t\u0001\u0014\u0005\t!\u0002\u0011\t\u0011)A\u0005\u001b\"A\u0011\u000b\u0001BC\u0002\u0013\u0005!\u000b\u0003\u0005W\u0001\t\u0005\t\u0015!\u0003T\u0011!9\u0006A!b\u0001\n\u0003A\u0006\u0002C1\u0001\u0005\u0003\u0005\u000b\u0011B-\t\u0011\t\u0004!Q1A\u0005\u0002aC\u0001b\u0019\u0001\u0003\u0002\u0003\u0006I!\u0017\u0005\tI\u0002\u0011)\u0019!C\u00011\"AQ\r\u0001B\u0001B\u0003%\u0011\f\u0003\u0005g\u0001\t\u0005\t\u0015!\u0003h\u0011!\u0001\bA!A!\u0002\u0017\t\bBB@\u0001\t\u0003\t\t\u0001\u0003\u0004\u0000\u0001\u0011\u0005\u0011Q\u0003\u0005\u0007\u007f\u0002!\t!!\n\t\u0013\u0005\u0005\u0003A1A\u0005\n\u0005\r\u0003\u0002CA&\u0001\u0001\u0006I!!\u0012\t\u0013\u00055\u0003A1A\u0005\n\u0005=\u0003\u0002CA,\u0001\u0001\u0006I!!\u0015\t\u0015\u0005e\u0003\u00011A\u0005\u0002u\nY\u0006\u0003\u0006\u0002n\u0001\u0001\r\u0011\"\u0001>\u0003_B\u0001\"a\u001f\u0001A\u0003&\u0011Q\f\u0004\u0007\u0003{\u0002A)a \t\u0015\u00055uC!f\u0001\n\u0003\t\u0019\u0005\u0003\u0006\u0002\u0010^\u0011\t\u0012)A\u0005\u0003\u000bB!\"!%\u0018\u0005+\u0007I\u0011AAJ\u0011)\t9j\u0006B\tB\u0003%\u0011Q\u0013\u0005\u0007\u007f^!\t!!'\t\u0013\u0005\rv#!A\u0005\u0002\u0005\u0015\u0006\"CAV/E\u0005I\u0011AAW\u0011%\t\u0019mFI\u0001\n\u0003\t)\rC\u0005\u0002J^\t\t\u0011\"\u0011\u0002L\"A\u00111\\\f\u0002\u0002\u0013\u0005!\u000bC\u0005\u0002^^\t\t\u0011\"\u0001\u0002`\"I\u0011\u0011^\f\u0002\u0002\u0013\u0005\u00131\u001e\u0005\n\u0003s<\u0012\u0011!C\u0001\u0003wD\u0011B!\u0002\u0018\u0003\u0003%\tEa\u0002\t\u0013\t%q#!A\u0005B\t-\u0001\"\u0003B\u0007/\u0005\u0005I\u0011\tB\b\u000f%\u0011\u0019\u0002AA\u0001\u0012\u0013\u0011)BB\u0005\u0002~\u0001\t\t\u0011#\u0003\u0003\u0018!1q0\u000bC\u0001\u0005KA\u0011B!\u0003*\u0003\u0003%)Ea\u0003\t\u0013\t\u001d\u0012&!A\u0005\u0002\n%\u0002\"\u0003B\u0018S\u0005\u0005I\u0011\u0011B\u0019\u0011%\u0011y\u0004\u0001b\u0001\n\u0013\u0011\t\u0005\u0003\u0005\u0003V\u0001\u0001\u000b\u0011\u0002B\"\u0011\u001d\u00119\u0006\u0001C!\u00053BqAa\u0016\u0001\t\u0013\u0011Y\u0006C\u0004\u0003`\u0001!\tE!\u0017\t\u000f\t\u0005\u0004\u0001\"\u0012\u0003d!1!q\u000e\u0001\u0005\u00021CqAa\u001c\u0001\t\u0013\u0011\t\b\u0003\u0005\u0003p\u0001!\t!\u0010B;\u0011%\u0011\u0019\t\u0001b\u0001\n\u0013\ty\u0005\u0003\u0005\u0003\u0006\u0002\u0001\u000b\u0011BA)\u0011\u001d\u00119\t\u0001C\u0005\u0005\u0013\u0013\u0011\u0004\u00155j\u0003\u000e\u001c'/^1m\r\u0006LG.\u001e:f\t\u0016$Xm\u0019;pe*\u0011A(P\u0001\u0007e\u0016lw\u000e^3\u000b\u0003y\nA!Y6lC\u000e\u00011c\u0001\u0001B\u000fB\u0011!)R\u0007\u0002\u0007*\tA)A\u0003tG\u0006d\u0017-\u0003\u0002G\u0007\n1\u0011I\\=SK\u001a\u0004\"\u0001S%\u000e\u0003mJ!AS\u001e\u0003\u001f\u0019\u000b\u0017\u000e\\;sK\u0012+G/Z2u_J\f\u0011\u0002\u001e5sKNDw\u000e\u001c3\u0016\u00035\u0003\"A\u0011(\n\u0005=\u001b%A\u0002#pk\ndW-\u0001\u0006uQJ,7\u000f[8mI\u0002\nQ\"\\1y'\u0006l\u0007\u000f\\3TSj,W#A*\u0011\u0005\t#\u0016BA+D\u0005\rIe\u000e^\u0001\u000f[\u0006D8+Y7qY\u0016\u001c\u0016N_3!\u0003=i\u0017N\\*uI\u0012+g/[1uS>tW#A-\u0011\u0005i{V\"A.\u000b\u0005qk\u0016\u0001\u00033ve\u0006$\u0018n\u001c8\u000b\u0005y\u001b\u0015AC2p]\u000e,(O]3oi&\u0011\u0001m\u0017\u0002\u000f\r&t\u0017\u000e^3EkJ\fG/[8o\u0003Ai\u0017N\\*uI\u0012+g/[1uS>t\u0007%\u0001\rbG\u000e,\u0007\u000f^1cY\u0016DU-\u0019:uE\u0016\fG\u000fU1vg\u0016\f\u0011$Y2dKB$\u0018M\u00197f\u0011\u0016\f'\u000f\u001e2fCR\u0004\u0016-^:fA\u00051b-\u001b:ti\"+\u0017M\u001d;cK\u0006$Xi\u001d;j[\u0006$X-A\fgSJ\u001cH\u000fS3beR\u0014W-\u0019;FgRLW.\u0019;fA\u0005YQM^3oiN#(/Z1n!\r\u0011\u0005N[\u0005\u0003S\u000e\u0013aa\u00149uS>t\u0007CA6o\u001b\u0005a'BA7>\u0003\u0015)g/\u001a8u\u0013\tyGNA\u0006Fm\u0016tGo\u0015;sK\u0006l\u0017!B2m_\u000e\\\u0007C\u0001:}\u001d\t\u0019(P\u0004\u0002us:\u0011Q\u000f_\u0007\u0002m*\u0011qoP\u0001\u0007yI|w\u000e\u001e \n\u0003yJ!\u0001P\u001f\n\u0005m\\\u0014a\u0004$bS2,(/\u001a#fi\u0016\u001cGo\u001c:\n\u0005ut(!B\"m_\u000e\\'BA><\u0003\u0019a\u0014N\\5u}Qq\u00111AA\u0005\u0003\u0017\ti!a\u0004\u0002\u0012\u0005MA\u0003BA\u0003\u0003\u000f\u0001\"\u0001\u0013\u0001\t\u000bAl\u00019A9\t\u000b-k\u0001\u0019A'\t\u000bEk\u0001\u0019A*\t\u000b]k\u0001\u0019A-\t\u000b\tl\u0001\u0019A-\t\u000b\u0011l\u0001\u0019A-\t\u000b\u0019l\u0001\u0019A4\u0015\u0019\u0005]\u00111DA\u000f\u0003?\t\t#a\t\u0015\t\u0005\u0015\u0011\u0011\u0004\u0005\u0006a:\u0001\u001d!\u001d\u0005\u0006\u0017:\u0001\r!\u0014\u0005\u0006#:\u0001\ra\u0015\u0005\u0006/:\u0001\r!\u0017\u0005\u0006E:\u0001\r!\u0017\u0005\u0006I:\u0001\r!\u0017\u000b\u0007\u0003\u000b\t9#!\u0010\t\u000f\u0005%r\u00021\u0001\u0002,\u000511m\u001c8gS\u001e\u0004B!!\f\u0002:5\u0011\u0011q\u0006\u0006\u0005\u0003S\t\tD\u0003\u0003\u00024\u0005U\u0012\u0001\u0003;za\u0016\u001c\u0018MZ3\u000b\u0005\u0005]\u0012aA2p[&!\u00111HA\u0018\u0005\u0019\u0019uN\u001c4jO\"1\u0011qH\bA\u0002)\f!!\u001a<\u0002\u001d\u0019L'o\u001d;IK\u0006\u0014HOY3biV\u0011\u0011Q\t\t\u0004\u0011\u0006\u001d\u0013bAA%w\t\u0001\u0002*Z1si\n,\u0017\r\u001e%jgR|'/_\u0001\u0010M&\u00148\u000f\u001e%fCJ$(-Z1uA\u0005q\u0012mY2faR\f'\r\\3IK\u0006\u0014HOY3biB\u000bWo]3NS2d\u0017n]\u000b\u0003\u0003#\u00022AQA*\u0013\r\t)f\u0011\u0002\u0005\u0019>tw-A\u0010bG\u000e,\u0007\u000f^1cY\u0016DU-\u0019:uE\u0016\fG\u000fU1vg\u0016l\u0015\u000e\u001c7jg\u0002\nq!\u00193ee\u0016\u001c8/\u0006\u0002\u0002^A!\u0011qLA4\u001d\u0011\t\t'a\u0019\u0011\u0005U\u001c\u0015bAA3\u0007\u00061\u0001K]3eK\u001aLA!!\u001b\u0002l\t11\u000b\u001e:j]\u001eT1!!\u001aD\u0003-\tG\r\u001a:fgN|F%Z9\u0015\t\u0005E\u0014q\u000f\t\u0004\u0005\u0006M\u0014bAA;\u0007\n!QK\\5u\u0011%\tI(FA\u0001\u0002\u0004\ti&A\u0002yIE\n\u0001\"\u00193ee\u0016\u001c8\u000f\t\u0002\u0006'R\fG/Z\n\u0007/\u0005\u000b\t)a\"\u0011\u0007\t\u000b\u0019)C\u0002\u0002\u0006\u000e\u0013q\u0001\u0015:pIV\u001cG\u000fE\u0002C\u0003\u0013K1!a#D\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003\u001dA\u0017n\u001d;pef\f\u0001\u0002[5ti>\u0014\u0018\u0010I\u0001\ni&lWm\u001d;b[B,\"!!&\u0011\t\tC\u0017\u0011K\u0001\u000bi&lWm\u001d;b[B\u0004CCBAN\u0003?\u000b\t\u000bE\u0002\u0002\u001e^i\u0011\u0001\u0001\u0005\b\u0003\u001bc\u0002\u0019AA#\u0011\u001d\t\t\n\ba\u0001\u0003+\u000bAaY8qsR1\u00111TAT\u0003SC\u0011\"!$\u001e!\u0003\u0005\r!!\u0012\t\u0013\u0005EU\u0004%AA\u0002\u0005U\u0015AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003_SC!!\u0012\u00022.\u0012\u00111\u0017\t\u0005\u0003k\u000by,\u0004\u0002\u00028*!\u0011\u0011XA^\u0003%)hn\u00195fG.,GMC\u0002\u0002>\u000e\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\t\t-a.\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005\u001d'\u0006BAK\u0003c\u000bQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAAg!\u0011\ty-!7\u000e\u0005\u0005E'\u0002BAj\u0003+\fA\u0001\\1oO*\u0011\u0011q[\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002j\u0005E\u0017\u0001\u00049s_\u0012,8\r^!sSRL\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003C\f9\u000fE\u0002C\u0003GL1!!:D\u0005\r\te.\u001f\u0005\t\u0003s\u0012\u0013\u0011!a\u0001'\u0006y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002nB1\u0011q^A{\u0003Cl!!!=\u000b\u0007\u0005M8)\u0001\u0006d_2dWm\u0019;j_:LA!a>\u0002r\nA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\tiPa\u0001\u0011\u0007\t\u000by0C\u0002\u0003\u0002\r\u0013qAQ8pY\u0016\fg\u000eC\u0005\u0002z\u0011\n\t\u00111\u0001\u0002b\u0006A\u0001.Y:i\u0007>$W\rF\u0001T\u0003!!xn\u0015;sS:<GCAAg\u0003\u0019)\u0017/^1mgR!\u0011Q B\t\u0011%\tIhJA\u0001\u0002\u0004\t\t/A\u0003Ti\u0006$X\rE\u0002\u0002\u001e&\u001aR!\u000bB\r\u0003\u000f\u0003\"Ba\u0007\u0003\"\u0005\u0015\u0013QSAN\u001b\t\u0011iBC\u0002\u0003 \r\u000bqA];oi&lW-\u0003\u0003\u0003$\tu!!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oeQ\u0011!QC\u0001\u0006CB\u0004H.\u001f\u000b\u0007\u00037\u0013YC!\f\t\u000f\u00055E\u00061\u0001\u0002F!9\u0011\u0011\u0013\u0017A\u0002\u0005U\u0015aB;oCB\u0004H.\u001f\u000b\u0005\u0005g\u0011Y\u0004\u0005\u0003CQ\nU\u0002c\u0002\"\u00038\u0005\u0015\u0013QS\u0005\u0004\u0005s\u0019%A\u0002+va2,'\u0007C\u0005\u0003>5\n\t\u00111\u0001\u0002\u001c\u0006\u0019\u0001\u0010\n\u0019\u0002\u000bM$\u0018\r^3\u0016\u0005\t\r\u0003C\u0002B#\u0005#\nY*\u0004\u0002\u0003H)!!\u0011\nB&\u0003\u0019\tGo\\7jG*\u0019aL!\u0014\u000b\t\t=\u0013Q[\u0001\u0005kRLG.\u0003\u0003\u0003T\t\u001d#aD!u_6L7MU3gKJ,gnY3\u0002\rM$\u0018\r^3!\u0003-I7/\u0011<bS2\f'\r\\3\u0016\u0005\u0005uH\u0003BA\u007f\u0005;Bq!!%2\u0001\u0004\t\t&\u0001\u0007jg6{g.\u001b;pe&tw-A\u0005iK\u0006\u0014HOY3biR\u0011\u0011\u0011\u000f\u0015\u0004g\t\u001d\u0004\u0003\u0002B5\u0005Wj!!a/\n\t\t5\u00141\u0018\u0002\bi\u0006LGN]3d\u0003\r\u0001\b.\u001b\u000b\u0004\u001b\nM\u0004bBAIk\u0001\u0007\u0011\u0011\u000b\u000b\b\u001b\n]$1\u0010B@\u0011\u001d\u0011IH\u000ea\u0001\u0003#\n\u0001\u0002^5nK\u0012KgM\u001a\u0005\u0007\u0005{2\u0004\u0019A'\u0002\t5,\u0017M\u001c\u0005\u0007\u0005\u00033\u0004\u0019A'\u0002\u0019M$H\rR3wS\u0006$\u0018n\u001c8\u0002+5Lgn\u0015;e\t\u00164\u0018.\u0019;j_:l\u0015\u000e\u001c7jg\u00061R.\u001b8Ti\u0012$UM^5bi&|g.T5mY&\u001c\b%A\ff]N,(/\u001a,bY&$7\u000b\u001e3EKZL\u0017\r^5p]R\u0019QJa#\t\r\t\u0005\u0015\b1\u0001N\u0001")
public class PhiAccrualFailureDetector
implements FailureDetector {
    private volatile PhiAccrualFailureDetector$State$ State$module;
    private final double threshold;
    private final int maxSampleSize;
    private final FiniteDuration minStdDeviation;
    private final FiniteDuration acceptableHeartbeatPause;
    private final FiniteDuration firstHeartbeatEstimate;
    private final Option<EventStream> eventStream;
    private final FailureDetector.Clock clock;
    private final HeartbeatHistory firstHeartbeat;
    private final long acceptableHeartbeatPauseMillis;
    private String address;
    private final AtomicReference<State> state;
    private final long minStdDeviationMillis;

    private PhiAccrualFailureDetector$State$ State() {
        if (this.State$module == null) {
            this.State$lzycompute$1();
        }
        return this.State$module;
    }

    public double threshold() {
        return this.threshold;
    }

    public int maxSampleSize() {
        return this.maxSampleSize;
    }

    public FiniteDuration minStdDeviation() {
        return this.minStdDeviation;
    }

    public FiniteDuration acceptableHeartbeatPause() {
        return this.acceptableHeartbeatPause;
    }

    public FiniteDuration firstHeartbeatEstimate() {
        return this.firstHeartbeatEstimate;
    }

    private HeartbeatHistory firstHeartbeat() {
        return this.firstHeartbeat;
    }

    private long acceptableHeartbeatPauseMillis() {
        return this.acceptableHeartbeatPauseMillis;
    }

    public String address() {
        return this.address;
    }

    public void address_$eq(String x$1) {
        this.address = x$1;
    }

    private AtomicReference<State> state() {
        return this.state;
    }

    @Override
    public boolean isAvailable() {
        return this.isAvailable(this.clock.apply$mcJ$sp());
    }

    private boolean isAvailable(long timestamp) {
        return this.phi(timestamp) < this.threshold();
    }

    @Override
    public boolean isMonitoring() {
        return this.state().get().timestamp().nonEmpty();
    }

    @Override
    public final void heartbeat() {
        State newState;
        State oldState;
        do {
            HeartbeatHistory heartbeatHistory;
            long timestamp = this.clock.apply$mcJ$sp();
            oldState = this.state().get();
            Option<Object> option = oldState.timestamp();
            if (None$.MODULE$.equals(option)) {
                heartbeatHistory = this.firstHeartbeat();
            } else if (option instanceof Some) {
                HeartbeatHistory heartbeatHistory2;
                Some some = (Some)option;
                long latestTimestamp = BoxesRunTime.unboxToLong((Object)some.value());
                long interval = timestamp - latestTimestamp;
                if (this.isAvailable(timestamp)) {
                    if (interval >= this.acceptableHeartbeatPauseMillis() / 3L * 2L && this.eventStream.isDefined()) {
                        ((SubchannelClassification)this.eventStream.get()).publish((Object)new Logging.Warning(this.toString(), this.getClass(), (Object)new StringBuilder(61).append("heartbeat interval is growing too large for address ").append(this.address()).append(": ").append(interval).append(" millis").toString()));
                    }
                    heartbeatHistory2 = oldState.history().$colon$plus(interval);
                } else {
                    heartbeatHistory2 = oldState.history();
                }
                heartbeatHistory = heartbeatHistory2;
            } else {
                throw new MatchError(option);
            }
            HeartbeatHistory newHistory = heartbeatHistory;
            newState = oldState.copy(newHistory, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)timestamp)));
        } while (!this.state().compareAndSet(oldState, newState));
    }

    public double phi() {
        return this.phi(this.clock.apply$mcJ$sp());
    }

    private double phi(long timestamp) {
        double d;
        State oldState = this.state().get();
        Option<Object> oldTimestamp = oldState.timestamp();
        if (oldTimestamp.isEmpty()) {
            d = 0.0;
        } else {
            long timeDiff = timestamp - BoxesRunTime.unboxToLong((Object)oldTimestamp.get());
            HeartbeatHistory history = oldState.history();
            double mean = history.mean();
            double stdDeviation = this.ensureValidStdDeviation(history.stdDeviation());
            d = this.phi(timeDiff, mean + (double)this.acceptableHeartbeatPauseMillis(), stdDeviation);
        }
        return d;
    }

    public double phi(long timeDiff, double mean, double stdDeviation) {
        double y = ((double)timeDiff - mean) / stdDeviation;
        double e = package$.MODULE$.exp(-y * (1.5976 + 0.070566 * y * y));
        return (double)timeDiff > mean ? -package$.MODULE$.log10(e / (1.0 + e)) : -package$.MODULE$.log10(1.0 - 1.0 / (1.0 + e));
    }

    private long minStdDeviationMillis() {
        return this.minStdDeviationMillis;
    }

    private double ensureValidStdDeviation(double stdDeviation) {
        return package$.MODULE$.max(stdDeviation, (double)this.minStdDeviationMillis());
    }

    private final void State$lzycompute$1() {
        PhiAccrualFailureDetector phiAccrualFailureDetector = this;
        synchronized (phiAccrualFailureDetector) {
            if (this.State$module == null) {
                this.State$module = new PhiAccrualFailureDetector$State$(this);
            }
        }
    }

    public PhiAccrualFailureDetector(double threshold, int maxSampleSize, FiniteDuration minStdDeviation, FiniteDuration acceptableHeartbeatPause, FiniteDuration firstHeartbeatEstimate, Option<EventStream> eventStream, FailureDetector.Clock clock) {
        this.threshold = threshold;
        this.maxSampleSize = maxSampleSize;
        this.minStdDeviation = minStdDeviation;
        this.acceptableHeartbeatPause = acceptableHeartbeatPause;
        this.firstHeartbeatEstimate = firstHeartbeatEstimate;
        this.eventStream = eventStream;
        this.clock = clock;
        Predef$.MODULE$.require(threshold > 0.0, (Function0 & Serializable & scala.Serializable)() -> "failure-detector.threshold must be > 0");
        Predef$.MODULE$.require(maxSampleSize > 0, (Function0 & Serializable & scala.Serializable)() -> "failure-detector.max-sample-size must be > 0");
        Predef$.MODULE$.require(minStdDeviation.$greater((Object)Duration$.MODULE$.Zero()), (Function0 & Serializable & scala.Serializable)() -> "failure-detector.min-std-deviation must be > 0");
        Predef$.MODULE$.require(acceptableHeartbeatPause.$greater$eq((Object)Duration$.MODULE$.Zero()), (Function0 & Serializable & scala.Serializable)() -> "failure-detector.acceptable-heartbeat-pause must be >= 0");
        Predef$.MODULE$.require(firstHeartbeatEstimate.$greater((Object)Duration$.MODULE$.Zero()), (Function0 & Serializable & scala.Serializable)() -> "failure-detector.heartbeat-interval must be > 0");
        long mean = firstHeartbeatEstimate.toMillis();
        long stdDeviation = mean / 4L;
        this.firstHeartbeat = HeartbeatHistory$.MODULE$.apply(maxSampleSize).$colon$plus(mean - stdDeviation).$colon$plus(mean + stdDeviation);
        this.acceptableHeartbeatPauseMillis = acceptableHeartbeatPause.toMillis();
        this.address = "N/A";
        this.state = new AtomicReference<State>(new State(this, this.firstHeartbeat(), (Option<Object>)None$.MODULE$));
        this.minStdDeviationMillis = minStdDeviation.toMillis();
    }

    public PhiAccrualFailureDetector(double threshold, int maxSampleSize, FiniteDuration minStdDeviation, FiniteDuration acceptableHeartbeatPause, FiniteDuration firstHeartbeatEstimate, FailureDetector.Clock clock) {
        this(threshold, maxSampleSize, minStdDeviation, acceptableHeartbeatPause, firstHeartbeatEstimate, (Option<EventStream>)None$.MODULE$, clock);
    }

    public PhiAccrualFailureDetector(Config config, EventStream ev) {
        this(config.getDouble("threshold"), config.getInt("max-sample-size"), Helpers.ConfigOps$.MODULE$.getMillisDuration$extension(Helpers$.MODULE$.ConfigOps(config), "min-std-deviation"), Helpers.ConfigOps$.MODULE$.getMillisDuration$extension(Helpers$.MODULE$.ConfigOps(config), "acceptable-heartbeat-pause"), Helpers.ConfigOps$.MODULE$.getMillisDuration$extension(Helpers$.MODULE$.ConfigOps(config), "heartbeat-interval"), (Option<EventStream>)new Some((Object)ev), FailureDetector$.MODULE$.defaultClock());
    }

    public class State
    implements Product,
    scala.Serializable {
        private final HeartbeatHistory history;
        private final Option<Object> timestamp;
        public final /* synthetic */ PhiAccrualFailureDetector $outer;

        public HeartbeatHistory history() {
            return this.history;
        }

        public Option<Object> timestamp() {
            return this.timestamp;
        }

        public State copy(HeartbeatHistory history, Option<Object> timestamp) {
            return new State(this.akka$remote$PhiAccrualFailureDetector$State$$$outer(), history, timestamp);
        }

        public HeartbeatHistory copy$default$1() {
            return this.history();
        }

        public Option<Object> copy$default$2() {
            return this.timestamp();
        }

        public String productPrefix() {
            return "State";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Option<Object> option;
            int n = x$1;
            switch (n) {
                case 0: {
                    option = this.history();
                    break;
                }
                case 1: {
                    option = this.timestamp();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return option;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof State;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof State)) return false;
            if (((State)object).akka$remote$PhiAccrualFailureDetector$State$$$outer() != this.akka$remote$PhiAccrualFailureDetector$State$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            State state = (State)x$1;
            HeartbeatHistory heartbeatHistory = this.history();
            HeartbeatHistory heartbeatHistory2 = state.history();
            if (heartbeatHistory == null) {
                if (heartbeatHistory2 != null) {
                    return false;
                }
            } else if (!((Object)heartbeatHistory).equals(heartbeatHistory2)) return false;
            Option<Object> option = this.timestamp();
            Option<Object> option2 = state.timestamp();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            if (!state.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ PhiAccrualFailureDetector akka$remote$PhiAccrualFailureDetector$State$$$outer() {
            return this.$outer;
        }

        public State(PhiAccrualFailureDetector $outer, HeartbeatHistory history, Option<Object> timestamp) {
            this.history = history;
            this.timestamp = timestamp;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

