/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.versioning.scm.connector.github;

import com.fasterxml.jackson.databind.exc.MismatchedInputException;
import com.xebialabs.deployit.util.PasswordEncrypter;
import com.xebialabs.xlrelease.versioning.TemplateVersioningException;
import com.xebialabs.xlrelease.versioning.TemplateVersioningException$;
import com.xebialabs.xlrelease.versioning.scm.connector.Attachments;
import com.xebialabs.xlrelease.versioning.scm.connector.BasicScmConnector;
import com.xebialabs.xlrelease.versioning.scm.connector.BinaryFile;
import com.xebialabs.xlrelease.versioning.scm.connector.Blobs;
import com.xebialabs.xlrelease.versioning.scm.connector.ValidatedCommitInfo;
import com.xebialabs.xlrelease.versioning.scm.connector.github.GitHubOAuth2Token;
import com.xebialabs.xlrelease.versioning.scm.connector.github.GitHubScmConnectorConfig;
import com.xebialabs.xlrelease.versioning.scm.connector.github.GitHubScmCredential;
import com.xebialabs.xlrelease.versioning.scm.connector.github.GitHubUsernamePasswordCredential;
import java.io.Serializable;
import org.kohsuke.github.AbuseLimitHandler;
import org.kohsuke.github.GHBlob;
import org.kohsuke.github.GHFileNotFoundException;
import org.kohsuke.github.GHRef;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GHTree;
import org.kohsuke.github.GHTreeBuilder;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.GitHubBuilder;
import org.kohsuke.github.HttpException;
import org.kohsuke.github.RateLimitHandler;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.mutable.Iterable$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0005mb\u0001\u0002\u0007\u000e\u0001qA\u0001\"\t\u0001\u0003\u0002\u0003\u0006IA\t\u0005\u0006M\u0001!\ta\n\u0005\tU\u0001A)\u0019!C\u0005W!)Q\b\u0001C)}!)A\t\u0001C)\u000b\")a\f\u0001C)?\")a\r\u0001C\u0005O\")A\u000f\u0001C\u0005k\u0016!!\u0010\u0001\u0001|\u0011\u001d\t\u0019\u0001\u0001C\u0005\u0003\u000bAq!a\n\u0001\t\u0013\tIC\u0001\nHSRDUOY*d[\u000e{gN\\3di>\u0014(B\u0001\b\u0010\u0003\u00199\u0017\u000e\u001e5vE*\u0011\u0001#E\u0001\nG>tg.Z2u_JT!AE\n\u0002\u0007M\u001cWN\u0003\u0002\u0015+\u0005Qa/\u001a:tS>t\u0017N\\4\u000b\u0005Y9\u0012!\u0003=me\u0016dW-Y:f\u0015\tA\u0012$A\u0005yK\nL\u0017\r\\1cg*\t!$A\u0002d_6\u001c\u0001a\u0005\u0002\u0001;A\u0011adH\u0007\u0002\u001f%\u0011\u0001e\u0004\u0002\u0012\u0005\u0006\u001c\u0018nY*d[\u000e{gN\\3di>\u0014\u0018AB2p]\u001aLw\r\u0005\u0002$I5\tQ\"\u0003\u0002&\u001b\tAr)\u001b;Ik\n\u001c6-\\\"p]:,7\r^8s\u0007>tg-[4\u0002\rqJg.\u001b;?)\tA\u0013\u0006\u0005\u0002$\u0001!)\u0011E\u0001a\u0001E\u0005)qL]3q_V\tA\u0006E\u0002.eQj\u0011A\f\u0006\u0003_A\nA!\u001e;jY*\t\u0011'A\u0003tG\u0006d\u0017-\u0003\u00024]\t\u0019AK]=\u0011\u0005UZT\"\u0001\u001c\u000b\u000599$B\u0001\u001d:\u0003\u001dYw\u000e[:vW\u0016T\u0011AO\u0001\u0004_J<\u0017B\u0001\u001f7\u000519\u0005JU3q_NLGo\u001c:z\u00039!Xm\u001d;SKB|7/\u001b;pef,\u0012a\u0010\t\u0004[I\u0002\u0005CA!C\u001b\u0005\u0001\u0014BA\"1\u0005\u0011)f.\u001b;\u0002\u0019\r|W.\\5u\u0003:$G+Y4\u0015\t\u0019\u0013v\u000b\u0018\t\u0004[I:\u0005C\u0001%P\u001d\tIU\n\u0005\u0002Ka5\t1J\u0003\u0002M7\u00051AH]8pizJ!A\u0014\u0019\u0002\rA\u0013X\rZ3g\u0013\t\u0001\u0016K\u0001\u0004TiJLgn\u001a\u0006\u0003\u001dBBQaU\u0003A\u0002Q\u000bQA\u00197pEN\u0004\"AH+\n\u0005Y{!!\u0002\"m_\n\u001c\b\"\u0002-\u0006\u0001\u0004I\u0016AC2p[6LG/\u00138g_B\u0011aDW\u0005\u00037>\u00111CV1mS\u0012\fG/\u001a3D_6l\u0017\u000e^%oM>DQ!X\u0003A\u0002\u001d\u000bA!^:fe\u0006iA/Y4O_R\u0004&/Z:f]R$\"\u0001\u00193\u0011\u00075\u0012\u0014\r\u0005\u0002BE&\u00111\r\r\u0002\b\u0005>|G.Z1o\u0011\u0015)g\u00011\u0001H\u0003\r!\u0018mZ\u0001$M&dG/\u001a:PkR\fEN]3bIf,\u0006\u000f\\8bI\u0016$\u0017\t\u001e;bG\"lWM\u001c;t)\u0011A7.\u001c:\u0011\u0005yI\u0017B\u00016\u0010\u0005-\tE\u000f^1dQ6,g\u000e^:\t\u000b1<\u0001\u0019\u0001\u001b\u0002\tI,\u0007o\u001c\u0005\u0006]\u001e\u0001\ra\\\u0001\tE\u0006\u001cX\r\u0016:fKB\u0011Q\u0007]\u0005\u0003cZ\u0012aa\u0012%Ue\u0016,\u0007\"B:\b\u0001\u0004A\u0017aC1ui\u0006\u001c\u0007.\\3oiN\f!\u0002\u001e:z\u0007>tg.Z2u)\u00051\bcA\u00173oB\u0011Q\u0007_\u0005\u0003sZ\u0012aaR5u\u0011V\u0014'a\u0003(b[\u0016$w\t\u0013\"m_\n\u0004B!\u0011?H}&\u0011Q\u0010\r\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u0005Uz\u0018bAA\u0001m\t1q\t\u0013\"m_\n\f1\"\u001e9m_\u0006$'\t\\8cgRA\u0011qAA\u0010\u0003G\t)\u0003\u0005\u0003.e\u0005%\u0001CBA\u0006\u0003+\tYB\u0004\u0003\u0002\u000e\u0005Eab\u0001&\u0002\u0010%\t\u0011'C\u0002\u0002\u0014A\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002\u0018\u0005e!\u0001\u0002'jgRT1!a\u00051!\r\ti\"C\u0007\u0002\u0001!1\u0011\u0011\u0005\u0006A\u0002\u001d\u000b\u0001BZ5mKB\fG\u000f\u001b\u0005\u0006'*\u0001\r\u0001\u0016\u0005\u0006Y*\u0001\r\u0001N\u0001\u000bGJ,\u0017\r^3Ue\u0016,G\u0003CA\u0016\u0003[\ty#a\r\u0011\u00075\u0012t\u000eC\u0003m\u0017\u0001\u0007A\u0007\u0003\u0004\u00022-\u0001\raR\u0001\fE\u0006\u001cX\r\u0016:fKNC\u0017\r\u0003\u0004T\u0017\u0001\u0007\u0011Q\u0007\t\u0007\u0003\u0017\t9$a\u0007\n\t\u0005e\u0012\u0011\u0004\u0002\t\u0013R,'/\u00192mK\u0002")
public class GitHubScmConnector
extends BasicScmConnector {
    private Try<GHRepository> _repo;
    private final GitHubScmConnectorConfig config;
    private volatile boolean bitmap$0;

    private Try<GHRepository> _repo$lzycompute() {
        GitHubScmConnector gitHubScmConnector = this;
        synchronized (gitHubScmConnector) {
            if (!this.bitmap$0) {
                Try repo = this.tryConnect().map((Function1 & Serializable & scala.Serializable)gh -> gh.getRepository($this.config.repository()));
                this._repo = repo.recoverWith((PartialFunction)new scala.Serializable(null){
                    public static final long serialVersionUID = 0L;

                    public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        HttpException httpException;
                        Object object;
                        A1 A1 = x1;
                        if (A1 instanceof GHFileNotFoundException) {
                            GHFileNotFoundException gHFileNotFoundException = (GHFileNotFoundException)A1;
                            object = new Failure((Throwable)((Object)new TemplateVersioningException("Repository not found", (Throwable)gHFileNotFoundException, 404)));
                        } else if (A1 instanceof HttpException && (httpException = (HttpException)A1).getResponseCode() == 401) {
                            object = new Failure((Throwable)((Object)new TemplateVersioningException("Invalid credentials", (Throwable)httpException, 401)));
                        } else if (A1 instanceof Exception) {
                            Exception exception = (Exception)A1;
                            object = new Failure((Throwable)((Object)new TemplateVersioningException(exception.getMessage(), TemplateVersioningException$.MODULE$.apply$default$2(), TemplateVersioningException$.MODULE$.apply$default$3())));
                        } else {
                            object = function1.apply(x1);
                        }
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(Throwable x1) {
                        HttpException httpException;
                        Throwable throwable = x1;
                        boolean bl = throwable instanceof GHFileNotFoundException ? true : (throwable instanceof HttpException && (httpException = (HttpException)throwable).getResponseCode() == 401 ? true : throwable instanceof Exception);
                        return bl;
                    }
                });
                this.bitmap$0 = true;
            }
        }
        return this._repo;
    }

    private Try<GHRepository> _repo() {
        return !this.bitmap$0 ? this._repo$lzycompute() : this._repo;
    }

    @Override
    public Try<BoxedUnit> testRepository() {
        return this._repo().map((Function1 & Serializable & scala.Serializable)x$1 -> {
            GitHubScmConnector.$anonfun$testRepository$1(x$1);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public Try<String> commitAndTag(Blobs blobs, ValidatedCommitInfo commitInfo, String user) {
        return this._repo().flatMap((Function1 & Serializable & scala.Serializable)repo -> Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> repo.getRef(new StringBuilder(6).append("heads/").append($this.config.branch()).toString())).recoverWith((PartialFunction)new scala.Serializable(this, (GHRepository)repo){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GitHubScmConnector $outer;
            private final GHRepository repo$2;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                HttpException httpException;
                A1 A1 = x1;
                Object object = A1 instanceof HttpException && (httpException = (HttpException)A1).getResponseCode() == 200 && httpException.getCause().getCause() instanceof MismatchedInputException ? this.$outer.com$xebialabs$xlrelease$versioning$scm$connector$github$GitHubScmConnector$$createBranch$1(this.repo$2) : (A1 instanceof GHFileNotFoundException ? this.$outer.com$xebialabs$xlrelease$versioning$scm$connector$github$GitHubScmConnector$$createBranch$1(this.repo$2) : function1.apply(x1));
                return (B1)object;
            }

            public final boolean isDefinedAt(Throwable x1) {
                HttpException httpException;
                Throwable throwable = x1;
                boolean bl = throwable instanceof HttpException && (httpException = (HttpException)throwable).getResponseCode() == 200 && httpException.getCause().getCause() instanceof MismatchedInputException ? true : throwable instanceof GHFileNotFoundException;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.repo$2 = repo$2;
            }
        }).flatMap((Function1 & Serializable & scala.Serializable)headRef -> Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> repo.getTree($this.config.branch())).map((Function1 & Serializable & scala.Serializable)baseTree -> {
            Blobs newBlobs = new Blobs(blobs.templateId(), blobs.dsl(), this.filterOutAlreadyUploadedAttachments((GHRepository)repo, (GHTree)baseTree, blobs.attachments()));
            return new Tuple2(baseTree, (Object)newBlobs);
        }).flatMap((Function1 & Serializable & scala.Serializable)x$2 -> {
            Tuple2 tuple2 = x$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            GHTree baseTree = (GHTree)tuple2._1();
            Blobs newBlobs = (Blobs)tuple2._2();
            Try try_ = this.uploadBlobs(blobs.filePath(), newBlobs, (GHRepository)repo).flatMap((Function1 & Serializable & scala.Serializable)ghNamedBlobs -> this.createTree((GHRepository)repo, baseTree.getSha(), (Iterable<Tuple2<String, GHBlob>>)ghNamedBlobs).flatMap((Function1 & Serializable & scala.Serializable)newTree -> Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> repo.createCommit().message(commitInfo.message()).tree(newTree.getSha()).parent(headRef.getObject().getSha()).create()).flatMap((Function1 & Serializable & scala.Serializable)commit -> Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> repo.createRef(commitInfo.tag().toString(), commit.getSHA1())).flatMap((Function1 & Serializable & scala.Serializable)_2 -> Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> headRef.updateTo(commit.getSHA1())).map((Function1 & Serializable & scala.Serializable)_ -> commit.getSHA1())))));
            return try_;
        })));
    }

    @Override
    public Try<Object> tagNotPresent(String tag) {
        return this._repo().map((Function1 & Serializable & scala.Serializable)repo -> BoxesRunTime.boxToBoolean((boolean)GitHubScmConnector.$anonfun$tagNotPresent$1(tag, repo)));
    }

    private Attachments filterOutAlreadyUploadedAttachments(GHRepository repo, GHTree baseTree, Attachments attachments) {
        Seq toUpload = attachments.files().isEmpty() ? (Seq)Seq$.MODULE$.empty() : (Seq)Option$.MODULE$.apply((Object)baseTree.getEntry("XLRelease")).flatMap((Function1 & Serializable & scala.Serializable)rootTreeEntry -> Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> rootTreeEntry.asTree()).toOption().filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)GitHubScmConnector.$anonfun$filterOutAlreadyUploadedAttachments$3(x$3))).flatMap((Function1 & Serializable & scala.Serializable)rootTree -> Option$.MODULE$.apply((Object)rootTree.getEntry(".attachments")).flatMap((Function1 & Serializable & scala.Serializable)attachmentTreeEntry -> Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> attachmentTreeEntry.asTree()).toOption().filter((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)GitHubScmConnector.$anonfun$filterOutAlreadyUploadedAttachments$7(x$4))).map((Function1 & Serializable & scala.Serializable)attachmentTree -> {
            BoxedUnit boxedUnit;
            Map filesMap = (Map)Map$.MODULE$.apply((Seq)attachments.files().map((Function1 & Serializable & scala.Serializable)file -> new Tuple2((Object)file.fileName(), file), Seq$.MODULE$.canBuildFrom()));
            ((IterableLike)((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(attachmentTree.getTree()).asScala()).view().takeWhile((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)filesMap.nonEmpty()))).foreach((Function1 & Serializable & scala.Serializable)entry -> (Map)filesMap.$minus$eq((Object)entry.getPath()));
            if (filesMap.nonEmpty() && attachmentTree.isTruncated()) {
                scala.collection.mutable.Iterable toRemove = (scala.collection.mutable.Iterable)filesMap.flatMap((Function1 & Serializable & scala.Serializable)filename -> Option$.MODULE$.option2Iterable(Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> repo.getFileContent(new StringBuilder(1).append(attachments.folderName()).append("/").append(filename).toString(), $this.config.branch())).toOption().map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.getName())), Iterable$.MODULE$.canBuildFrom());
                boxedUnit = filesMap.$minus$minus$eq((TraversableOnce)toRemove);
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return filesMap.values().toSeq();
        })))).getOrElse((Function0 & Serializable & scala.Serializable)() -> attachments.files());
        return new Attachments(attachments.folderName(), (Seq<BinaryFile>)toUpload);
    }

    private Try<GitHub> tryConnect() {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            GitHubBuilder gitHubBuilder;
            GitHubBuilder builder = new GitHubBuilder().withRateLimitHandler(RateLimitHandler.FAIL).withAbuseLimitHandler(AbuseLimitHandler.FAIL).withEndpoint($this.config.restApiUrl());
            GitHubScmCredential gitHubScmCredential = $this.config.credential();
            if (gitHubScmCredential instanceof GitHubUsernamePasswordCredential) {
                GitHubUsernamePasswordCredential gitHubUsernamePasswordCredential = (GitHubUsernamePasswordCredential)gitHubScmCredential;
                gitHubBuilder = builder.withPassword(gitHubUsernamePasswordCredential.username(), PasswordEncrypter.getInstance().ensureDecrypted(gitHubUsernamePasswordCredential.password()));
            } else if (gitHubScmCredential instanceof GitHubOAuth2Token) {
                GitHubOAuth2Token gitHubOAuth2Token = (GitHubOAuth2Token)gitHubScmCredential;
                gitHubBuilder = builder.withOAuthToken(PasswordEncrypter.getInstance().ensureDecrypted(gitHubOAuth2Token.token()));
            } else {
                if (gitHubScmCredential == null) {
                    throw new IllegalStateException(new StringBuilder(48).append("No credential provided for GitHub SCM config '").append($this.config.getTitle()).append("'.").toString());
                }
                throw new MatchError((Object)gitHubScmCredential);
            }
            return builder.build();
        });
    }

    private Try<List<Tuple2<String, GHBlob>>> uploadBlobs(String filepath, Blobs blobs, GHRepository repo) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            ListBuffer ghBlobs = (ListBuffer)ListBuffer$.MODULE$.empty();
            ghBlobs.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)filepath), (Object)repo.createBlob().binaryContent((byte[])blobs.dsl().getContent().apply()).create()));
            blobs.attachments().files().foreach((Function1 & Serializable & scala.Serializable)attachment -> ghBlobs.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(1).append(blobs.attachments().folderName()).append("/").append(attachment.fileName()).toString()), (Object)repo.createBlob().binaryContent((byte[])attachment.getContent().apply()).create())));
            return ghBlobs.toList();
        });
    }

    private Try<GHTree> createTree(GHRepository repo, String baseTreeSha, Iterable<Tuple2<String, GHBlob>> blobs) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            GHTreeBuilder builder = repo.createTree().baseTree(baseTreeSha);
            blobs.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String filename = (String)tuple2._1();
                GHBlob ghBlob = (GHBlob)tuple2._2();
                GHTreeBuilder gHTreeBuilder = builder.shaEntry(filename, ghBlob.getSha(), false);
                return gHTreeBuilder;
            });
            return builder.create();
        });
    }

    public static final /* synthetic */ void $anonfun$testRepository$1(GHRepository x$1) {
    }

    public final Try com$xebialabs$xlrelease$versioning$scm$connector$github$GitHubScmConnector$$createBranch$1(GHRepository repo) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            GHRef defaultBranch = repo.getRef(new StringBuilder(6).append("heads/").append(repo.getDefaultBranch()).toString());
            return repo.createRef(new StringBuilder(11).append("refs/heads/").append($this.config.branch()).toString(), defaultBranch.getObject().getSha());
        });
    }

    public static final /* synthetic */ boolean $anonfun$tagNotPresent$1(String tag$1, GHRepository repo) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> repo.getRef(new StringBuilder(5).append("tags/").append(tag$1).toString())).failed().isSuccess();
    }

    public static final /* synthetic */ boolean $anonfun$filterOutAlreadyUploadedAttachments$3(GHTree x$3) {
        return x$3 != null;
    }

    public static final /* synthetic */ boolean $anonfun$filterOutAlreadyUploadedAttachments$7(GHTree x$4) {
        return x$4 != null;
    }

    public GitHubScmConnector(GitHubScmConnectorConfig config) {
        this.config = config;
        super(config);
    }
}

