/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.util;

public abstract class TextEscapeUtils {
    public static String escapeEntities(String s) {
        if (s == null || s.length() == 0) {
            return s;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9') {
                sb.append(c);
                continue;
            }
            if (c == '<') {
                sb.append("&lt;");
                continue;
            }
            if (c == '>') {
                sb.append("&gt;");
                continue;
            }
            if (c == '&') {
                sb.append("&amp;");
                continue;
            }
            if (Character.isWhitespace(c)) {
                sb.append("&#").append((int)c).append(";");
                continue;
            }
            if (Character.isISOControl(c)) continue;
            if (Character.isHighSurrogate(c)) {
                if (i + 1 >= s.length()) {
                    throw new IllegalArgumentException("Missing low surrogate character at end of string");
                }
                char low = s.charAt(i + 1);
                if (!Character.isLowSurrogate(low)) {
                    throw new IllegalArgumentException("Expected low surrogate character but found value = " + low);
                }
                int codePoint = Character.toCodePoint(c, low);
                if (Character.isDefined(codePoint)) {
                    sb.append("&#").append(codePoint).append(";");
                }
                ++i;
                continue;
            }
            if (Character.isLowSurrogate(c)) {
                throw new IllegalArgumentException("Unexpected low surrogate character, value = " + c);
            }
            if (!Character.isDefined(c)) continue;
            sb.append("&#").append((int)c).append(";");
        }
        return sb.toString();
    }
}

