/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav.jcr.property;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.ValueFormatException;
import org.apache.jackrabbit.value.ValueHelper;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.jcr.ItemResourceConstants;
import org.apache.jackrabbit.webdav.property.AbstractDavProperty;
import org.apache.jackrabbit.webdav.property.DavProperty;
import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.apache.jackrabbit.webdav.xml.DomUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ValuesProperty
extends AbstractDavProperty
implements ItemResourceConstants {
    private static Logger log = LoggerFactory.getLogger((Class)ValuesProperty.class);
    private final Value[] jcrValues;

    public ValuesProperty(Value value) {
        super(JCR_VALUE, false);
        Value[] valueArray;
        if (value == null) {
            valueArray = new Value[]{};
        } else {
            Value[] valueArray2 = new Value[1];
            valueArray = valueArray2;
            valueArray2[0] = value;
        }
        this.jcrValues = valueArray;
    }

    public ValuesProperty(Value[] values) {
        super(JCR_VALUES, false);
        this.jcrValues = values == null ? new Value[]{} : values;
    }

    public ValuesProperty(DavProperty property, int defaultType, ValueFactory valueFactory) throws RepositoryException, DavException {
        super(property.getName(), false);
        if (!JCR_VALUES.equals(property.getName()) && !JCR_VALUE.equals(this.getName())) {
            throw new DavException(400, "ValuesProperty may only be created with a property that has name=" + JCR_VALUES.getName());
        }
        ArrayList<Object> valueElements = new ArrayList<Object>();
        Object propValue = property.getValue();
        if (propValue == null) {
            this.jcrValues = new Value[0];
        } else {
            if (ValuesProperty.isValueElement(propValue)) {
                valueElements.add(propValue);
            } else if (propValue instanceof List) {
                Iterator elemIt = ((List)property.getValue()).iterator();
                while (elemIt.hasNext()) {
                    Object el = elemIt.next();
                    if (!ValuesProperty.isValueElement(el)) continue;
                    valueElements.add(el);
                }
            }
            Element[] elems = valueElements.toArray(new Element[valueElements.size()]);
            this.jcrValues = new Value[elems.length];
            for (int i = 0; i < elems.length; ++i) {
                this.jcrValues[i] = ValuesProperty.getJcrValue(elems[i], defaultType, valueFactory);
            }
        }
    }

    private static boolean isValueElement(Object obj) {
        return obj instanceof Element && "value".equals(((Element)obj).getLocalName());
    }

    private void checkPropertyName(DavPropertyName reqName) throws ValueFormatException {
        if (!reqName.equals(this.getName())) {
            throw new ValueFormatException("Attempt to retrieve mulitple values from single property '" + this.getName() + "'.");
        }
    }

    private static Value getJcrValue(Element valueElement, int defaultType, ValueFactory valueFactory) throws ValueFormatException, RepositoryException {
        if (valueElement == null) {
            return null;
        }
        String value = DomUtil.getText(valueElement, "");
        String typeStr = DomUtil.getAttribute(valueElement, "type", ItemResourceConstants.NAMESPACE);
        int type = typeStr == null ? defaultType : PropertyType.valueFromName((String)typeStr);
        return ValueHelper.deserialize(value, type, true, valueFactory);
    }

    public Value[] getJcrValues(int propertyType, ValueFactory valueFactory) throws ValueFormatException {
        this.checkPropertyName(JCR_VALUES);
        Value[] vs = new Value[this.jcrValues.length];
        for (int i = 0; i < this.jcrValues.length; ++i) {
            vs[i] = ValueHelper.convert(this.jcrValues[i], propertyType, valueFactory);
        }
        return this.jcrValues;
    }

    public Value[] getJcrValues() throws ValueFormatException {
        this.checkPropertyName(JCR_VALUES);
        return this.jcrValues;
    }

    public Value getJcrValue(int propertyType, ValueFactory valueFactory) throws ValueFormatException {
        this.checkPropertyName(JCR_VALUE);
        return this.jcrValues.length == 0 ? null : ValueHelper.convert(this.jcrValues[0], propertyType, valueFactory);
    }

    public Value getJcrValue() throws ValueFormatException {
        this.checkPropertyName(JCR_VALUE);
        return this.jcrValues.length == 0 ? null : this.jcrValues[0];
    }

    public int getValueType() {
        return this.jcrValues.length > 0 ? this.jcrValues[0].getType() : 0;
    }

    public Object getValue() {
        return this.jcrValues;
    }

    public Element toXml(Document document) {
        Element elem = this.getName().toXml(document);
        try {
            for (int i = 0; i < this.jcrValues.length; ++i) {
                Value v = this.jcrValues[i];
                String type = PropertyType.nameFromValue((int)v.getType());
                String serializedValue = ValueHelper.serialize(v, true);
                Element xmlValue = DomUtil.createElement(document, "value", ItemResourceConstants.NAMESPACE, serializedValue);
                DomUtil.setAttribute(xmlValue, "type", ItemResourceConstants.NAMESPACE, type);
                elem.appendChild(xmlValue);
            }
        }
        catch (RepositoryException e) {
            log.error("Unexpected Error while converting jcr value to String: " + e.getMessage());
        }
        return elem;
    }
}

