global deliveryApi, deliveryId, trackedItems, stage, task, status

from com.xebialabs.xlrelease.delivery.domain import TrackedItemStatus
from com.xebialabs.xlrelease.delivery.domain import TrackedItemStatusChangeSubscriber

from delivery import handle_subscription

delivery = deliveryApi.getDelivery(deliveryId)
delivery_stage = delivery.getStageByIdOrTitle(stage)

if not trackedItems:
    print "No tracked items have been provided\n"
    sys.exit(1)

task.setStatusLine("[{0}](#/deliveries/{1})".format(delivery.title, delivery.id))
print("Waiting for tracked items in stage '{0}' of delivery : [{1}](#/deliveries/{2})\n".format(delivery_stage.title, delivery.title, delivery.id))

subscriber = TrackedItemStatusChangeSubscriber()
subscriber.setSourceId(task.getId())
subscriber.setItemIds(list(map(lambda item: delivery.getItemByIdOrTitle(item).getId(), set(trackedItems))))
subscriber.setStageId(delivery_stage.getId())
subscriber.setItemStatus(TrackedItemStatus.valueOf(status))
subscription = deliveryApi.registerSubscriber(deliveryId, subscriber)

waitForSignal = handle_subscription(subscription)

