/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import com.xebialabs.deployit.plumbing.scheduler.Scheduler;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.domain.Changes;
import com.xebialabs.xlrelease.domain.GateTask;
import com.xebialabs.xlrelease.domain.Phase;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.VisitableItem;
import com.xebialabs.xlrelease.domain.status.PhaseStatus;
import com.xebialabs.xlrelease.domain.status.TaskStatus;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.events.XLReleaseOperations$;
import com.xebialabs.xlrelease.repository.CiCloneHelper;
import com.xebialabs.xlrelease.repository.CiHelper;
import com.xebialabs.xlrelease.repository.FacetRepositoryDispatcher;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.PhaseVersion;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.repository.RetryTitleGenerator;
import com.xebialabs.xlrelease.repository.TaskRepository;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.service.CiIdService;
import com.xebialabs.xlrelease.service.DependencyService;
import com.xebialabs.xlrelease.service.PhaseRestart;
import com.xebialabs.xlrelease.service.PhaseRestart$;
import com.xebialabs.xlrelease.service.RestartPhasesException;
import com.xebialabs.xlrelease.service.TaskBackup;
import com.xebialabs.xlrelease.variable.VariablePersistenceHelper$;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import scala.Function1;
import scala.Predef$;
import scala.collection.GenSeqLike;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@Component
@ScalaSignature(bytes="\u0006\u0001\u0005Uh\u0001B\u000b\u0017\u0001}A\u0001B\u000b\u0001\u0003\u0002\u0003\u0006Ia\u000b\u0005\ti\u0001\u0011\t\u0011)A\u0005k!A\u0001\b\u0001B\u0001B\u0003%\u0011\b\u0003\u0005@\u0001\t\u0005\t\u0015!\u0003A\u0011!1\u0005A!A!\u0002\u00139\u0005\u0002\u0003&\u0001\u0005\u0003\u0005\u000b\u0011B&\t\u00119\u0003!\u0011!Q\u0001\n=C\u0001B\u0015\u0001\u0003\u0002\u0003\u0006Ia\u0015\u0005\t3\u0002\u0011\t\u0011)A\u00055\"AQ\f\u0001B\u0001B\u0003-a\fC\u0003e\u0001\u0011\u0005Q\rC\u0004\u0002\u0004\u0001!\t%!\u0002\t\u0013\u0005%\u0003!%A\u0005\u0002\u0005-\u0003\"CA0\u0001E\u0005I\u0011AA1\u0011\u001d\t)\u0007\u0001C!\u0003OBq!a!\u0001\t\u0013\t)\tC\u0004\u0002\f\u0002!I!!$\t\u000f\u0005\u0015\u0006\u0001\"\u0003\u0002(\"9\u0011\u0011\u0019\u0001\u0005\n\u0005\r\u0007bBAk\u0001\u0011%\u0011q\u001b\u0002\u0010'Fd\u0007\u000b[1tKJ+7\u000f^1si*\u0011q\u0003G\u0001\bg\u0016\u0014h/[2f\u0015\tI\"$A\u0005yYJ,G.Z1tK*\u00111\u0004H\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011!H\u0001\u0004G>l7\u0001A\n\u0004\u0001\u00012\u0003CA\u0011%\u001b\u0005\u0011#\"A\u0012\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0015\u0012#AB!osJ+g\r\u0005\u0002(Q5\ta#\u0003\u0002*-\ta\u0001\u000b[1tKJ+7\u000f^1si\u0006I1o\u00195fIVdWM\u001d\t\u0003YIj\u0011!\f\u0006\u0003U9R!a\f\u0019\u0002\u0011AdW/\u001c2j]\u001eT!!\r\u000e\u0002\u0011\u0011,\u0007\u000f\\8zSRL!aM\u0017\u0003\u0013M\u001b\u0007.\u001a3vY\u0016\u0014\u0018A\u0003;bg.\u0014\u0015mY6vaB\u0011qEN\u0005\u0003oY\u0011!\u0002V1tW\n\u000b7m[;q\u0003-\u0001XM]7jgNLwN\\:\u0011\u0005ijT\"A\u001e\u000b\u0005qB\u0012\u0001C:fGV\u0014\u0018\u000e^=\n\u0005yZ$!\u0005)fe6L7o]5p]\u000eCWmY6fe\u0006\t\"/\u001a7fCN,'+\u001a9pg&$xN]=\u0011\u0005\u0005#U\"\u0001\"\u000b\u0005\rC\u0012A\u0003:fa>\u001c\u0018\u000e^8ss&\u0011QI\u0011\u0002\u0012%\u0016dW-Y:f%\u0016\u0004xn]5u_JL\u0018aC2j\u0013\u0012\u001cVM\u001d<jG\u0016\u0004\"a\n%\n\u0005%3\"aC\"j\u0013\u0012\u001cVM\u001d<jG\u0016\f\u0011\u0003Z3qK:$WM\\2z'\u0016\u0014h/[2f!\t9C*\u0003\u0002N-\t\tB)\u001a9f]\u0012,gnY=TKJ4\u0018nY3\u0002\u001dQ\f7o\u001b*fa>\u001c\u0018\u000e^8ssB\u0011\u0011\tU\u0005\u0003#\n\u0013a\u0002V1tWJ+\u0007o\\:ji>\u0014\u00180A\nsK2,\u0017m]3BGR|'oU3sm&\u001cW\r\u0005\u0002U/6\tQK\u0003\u0002W1\u00051\u0011m\u0019;peNL!\u0001W+\u0003'I+G.Z1tK\u0006\u001bGo\u001c:TKJ4\u0018nY3\u00023\u0019\f7-\u001a;SKB|7/\u001b;pef$\u0015n\u001d9bi\u000eDWM\u001d\t\u0003\u0003nK!\u0001\u0018\"\u00033\u0019\u000b7-\u001a;SKB|7/\u001b;pef$\u0015n\u001d9bi\u000eDWM]\u0001\tKZ,g\u000e\u001e\"vgB\u0011qLY\u0007\u0002A*\u0011\u0011\rG\u0001\u0007KZ,g\u000e^:\n\u0005\r\u0004'!\u0005-M%\u0016dW-Y:f\u000bZ,g\u000e\u001e\"vg\u00061A(\u001b8jiz\"\"BZ5kW2lgn\u001c9r)\t9\u0007\u000e\u0005\u0002(\u0001!)Ql\u0003a\u0002=\")!f\u0003a\u0001W!)Ag\u0003a\u0001k!)\u0001h\u0003a\u0001s!)qh\u0003a\u0001\u0001\")ai\u0003a\u0001\u000f\")!j\u0003a\u0001\u0017\")aj\u0003a\u0001\u001f\")!k\u0003a\u0001'\")\u0011l\u0003a\u00015\"\u00121b\u001d\t\u0003i~l\u0011!\u001e\u0006\u0003m^\f!\"\u00198o_R\fG/[8o\u0015\tA\u00180A\u0004gC\u000e$xN]=\u000b\u0005i\\\u0018!\u00022fC:\u001c(B\u0001?~\u0003=\u0019\bO]5oO\u001a\u0014\u0018-\\3x_J\\'\"\u0001@\u0002\u0007=\u0014x-C\u0002\u0002\u0002U\u0014\u0011\"Q;u_^L'/\u001a3\u0002\u001bI,7\u000f^1siBC\u0017m]3t)1\t9!a\u0005\u0002.\u0005E\u0012QGA !\u0011\tI!a\u0004\u000e\u0005\u0005-!bAA\u00071\u00051Am\\7bS:LA!!\u0005\u0002\f\t9!+\u001a7fCN,\u0007bBA\u000b\u0019\u0001\u0007\u0011qC\u0001\ne\u0016dW-Y:f\u0013\u0012\u0004B!!\u0007\u0002(9!\u00111DA\u0012!\r\tiBI\u0007\u0003\u0003?Q1!!\t\u001f\u0003\u0019a$o\\8u}%\u0019\u0011Q\u0005\u0012\u0002\rA\u0013X\rZ3g\u0013\u0011\tI#a\u000b\u0003\rM#(/\u001b8h\u0015\r\t)C\t\u0005\b\u0003_a\u0001\u0019AA\f\u0003\u001d\u0001\b.Y:f\u0013\u0012Dq!a\r\r\u0001\u0004\t9\"\u0001\u0004uCN\\\u0017\n\u001a\u0005\n\u0003oa\u0001\u0013!a\u0001\u0003s\tA\u0002\u001d5bg\u00164VM]:j_:\u00042!QA\u001e\u0013\r\tiD\u0011\u0002\r!\"\f7/\u001a,feNLwN\u001c\u0005\n\u0003\u0003b\u0001\u0013!a\u0001\u0003\u0007\nQB]3tk6,'+\u001a7fCN,\u0007cA\u0011\u0002F%\u0019\u0011q\t\u0012\u0003\u000f\t{w\u000e\\3b]\u00069\"/Z:uCJ$\b\u000b[1tKN$C-\u001a4bk2$H\u0005N\u000b\u0003\u0003\u001bRC!!\u000f\u0002P-\u0012\u0011\u0011\u000b\t\u0005\u0003'\nY&\u0004\u0002\u0002V)!\u0011qKA-\u0003%)hn\u00195fG.,GM\u0003\u0002wE%!\u0011QLA+\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u0018e\u0016\u001cH/\u0019:u!\"\f7/Z:%I\u00164\u0017-\u001e7uIU*\"!a\u0019+\t\u0005\r\u0013qJ\u0001\u000ee\u0016\u001cHo\u001c:f!\"\f7/Z:\u0015\t\u0005%\u0014q\u0010\t\u0007\u0003W\n)(!\u001f\u000e\u0005\u00055$\u0002BA8\u0003c\nA!\u001e;jY*\u0011\u00111O\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002x\u00055$\u0001\u0002'jgR\u0004B!!\u0003\u0002|%!\u0011QPA\u0006\u0005\u0015\u0001\u0006.Y:f\u0011\u001d\t\ti\u0004a\u0001\u0003S\nq\u0002\u001d5bg\u0016\u001cHk\u001c*fgR|'/Z\u0001\re\u0016\u001cHo\u001c:f!\"\f7/\u001a\u000b\u0005\u0003s\n9\tC\u0004\u0002\nB\u0001\r!!\u001f\u0002\u000bAD\u0017m]3\u0002\u0019I,7\u000f^8sKR\u000b7o[:\u0015\r\u0005=\u0015QSAQ!\r\t\u0013\u0011S\u0005\u0004\u0003'\u0013#\u0001B+oSRDq!a&\u0012\u0001\u0004\tI*A\u0007pe&<\u0017N\\1m)\u0006\u001c8n\u001d\t\u0007\u0003W\n)(a'\u0011\t\u0005%\u0011QT\u0005\u0005\u0003?\u000bYA\u0001\u0003UCN\\\u0007bBAR#\u0001\u0007\u0011\u0011T\u0001\t]\u0016<H+Y:lg\u0006aR\u000f\u001d3bi\u0016<\u0015\r^3t%\u00164WM]3oG&tw\r\u00155bg\u0016\u001cHCBAH\u0003S\u000bi\fC\u0004\u0002\u0002J\u0001\r!a+\u0011\r\u00055\u0016qWA=\u001d\u0011\ty+a-\u000f\t\u0005u\u0011\u0011W\u0005\u0002G%\u0019\u0011Q\u0017\u0012\u0002\u000fA\f7m[1hK&!\u0011\u0011XA^\u0005\r\u0019V-\u001d\u0006\u0004\u0003k\u0013\u0003bBA`%\u0001\u0007\u00111V\u0001\u000fe\u0016\u001cHo\u001c:fIBC\u0017m]3t\u0003=\u00198.\u001b9UCN\\7OQ3g_J,G\u0003CAc\u0003\u0017\fi-!5\u0011\t\u0005%\u0011qY\u0005\u0005\u0003\u0013\fYAA\u0004DQ\u0006tw-Z:\t\u000f\u0005M2\u00031\u0001\u0002\u0018!9\u0011qZ\nA\u0002\u0005e\u0014!D8sS\u001eLg.\u00197QQ\u0006\u001cX\rC\u0004\u0002TN\u0001\r!!\u001f\u0002\u001bI,7\u000f^8sK\u0012\u0004\u0006.Y:f\u00039\u0001XM]:jgR\u0014V\r\\3bg\u0016$\"\"a$\u0002Z\u0006u\u0017\u0011]As\u0011\u001d\tY\u000e\u0006a\u0001\u0003\u000f\t\u0001b\u001c:jO&t\u0017\r\u001c\u0005\b\u0003?$\u0002\u0019AA\u0004\u0003\u001d\u0011X\r\\3bg\u0016Dq!a9\u0015\u0001\u0004\t)-A\u0004dQ\u0006tw-Z:\t\u000f\u0005}F\u00031\u0001\u0002j!\u001a\u0001!!;\u0011\t\u0005-\u0018\u0011_\u0007\u0003\u0003[T1!a<|\u0003)\u0019H/\u001a:f_RL\b/Z\u0005\u0005\u0003g\fiOA\u0005D_6\u0004xN\\3oi\u0002")
public class SqlPhaseRestart
implements PhaseRestart {
    private final Scheduler scheduler;
    private final TaskBackup taskBackup;
    private final PermissionChecker permissions;
    private final ReleaseRepository releaseRepository;
    private final CiIdService ciIdService;
    private final DependencyService dependencyService;
    private final TaskRepository taskRepository;
    private final ReleaseActorService releaseActorService;
    private final FacetRepositoryDispatcher facetRepositoryDispatcher;
    private final XLReleaseEventBus eventBus;

    @Timed
    public Release restartPhases(String releaseId, String phaseId, String taskId, PhaseVersion phaseVersion) {
        return PhaseRestart.restartPhases$((PhaseRestart)this, (String)releaseId, (String)phaseId, (String)taskId, (PhaseVersion)phaseVersion);
    }

    public void checkCanRestartPhases(Release release, String phaseId, String taskId, PhaseVersion phaseVersion, boolean resumeRelease) {
        PhaseRestart.checkCanRestartPhases$((PhaseRestart)this, (Release)release, (String)phaseId, (String)taskId, (PhaseVersion)phaseVersion, (boolean)resumeRelease);
    }

    public Release restartPhases(String releaseId, String phaseId, String taskId, PhaseVersion phaseVersion, boolean resumeRelease) {
        Release release = this.releaseRepository.findById(releaseId);
        ((IterableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(release.getAllTasks()).asScala()).filter((Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToBoolean((boolean)t.isPlanned()))).foreach((Function1 & Serializable & scala.Serializable)task -> {
            this.taskBackup.backupTask(task);
            return BoxedUnit.UNIT;
        });
        Release original = (Release)CiCloneHelper.cloneCi((ConfigurationItem)release);
        this.checkCanRestartPhases(release, phaseId, taskId, phaseVersion, resumeRelease);
        Seq phasesToRestore = (Seq)JavaConverters$.MODULE$.asScalaBufferConverter(PhaseRestart$.MODULE$.getPhasesToRestore(release, phaseId, phaseVersion)).asScala();
        if (phasesToRestore.isEmpty()) {
            throw new RestartPhasesException(releaseId, phaseId, taskId, phaseVersion, resumeRelease, new StringBuilder(37).append("There are no ").append(phaseVersion).append(" phases to restart from ").append(phaseId).toString());
        }
        PhaseRestart$.MODULE$.checkIfPhaseCanBeRestartedFrom(release.getTask(taskId), (Phase)phasesToRestore.head(), this.permissions);
        List<Phase> restoredPhases = this.restorePhases((List)JavaConverters$.MODULE$.seqAsJavaListConverter(phasesToRestore).asJava());
        this.updateGatesReferencingPhases((Seq<Phase>)phasesToRestore, (Seq<Phase>)((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(restoredPhases).asScala()));
        Changes changes = release.restorePhases(restoredPhases);
        changes.addAll(release.getCurrentPhase().close());
        changes.addAll(this.skipTasksBefore(taskId, (Phase)phasesToRestore.head(), restoredPhases.get(0)));
        this.persistRelease(original, release, changes, restoredPhases);
        return release;
    }

    public PhaseVersion restartPhases$default$4() {
        return PhaseVersion.ALL;
    }

    public boolean restartPhases$default$5() {
        return false;
    }

    public List<Phase> restorePhases(List<Phase> phasesToRestore) {
        return (List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(phasesToRestore).asScala()).map((Function1 & Serializable & scala.Serializable)originalPhase -> {
            void var2_2;
            Phase restoredPhase = this.restorePhase((Phase)originalPhase);
            this.restoreTasks(originalPhase.getTasks(), restoredPhase.getTasks());
            return var2_2;
        }, Buffer$.MODULE$.canBuildFrom())).asJava();
    }

    /*
     * WARNING - void declaration
     */
    private Phase restorePhase(Phase phase) {
        void var3_3;
        String restoredPhaseId = this.ciIdService.getUniqueId(Type.valueOf(Phase.class), Ids.releaseIdFrom((String)phase.getId()));
        Phase copiedPhase = (Phase)CiCloneHelper.cloneCi((ConfigurationItem)phase);
        CiHelper.rewriteWithNewId((ConfigurationItem)copiedPhase, (String)restoredPhaseId);
        copiedPhase.setTitle(RetryTitleGenerator.getNextTitle((String)phase.getTitle()));
        copiedPhase.setStatus(PhaseStatus.PLANNED);
        copiedPhase.setStartDate(null);
        copiedPhase.setEndDate(null);
        copiedPhase.setOriginId(phase.getId());
        return var3_3;
    }

    private void restoreTasks(List<Task> originalTasks, List<Task> newTasks) {
        ((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(originalTasks).asScala()).indices().foreach((Function1 & Serializable & scala.Serializable)i -> SqlPhaseRestart.$anonfun$restoreTasks$1(this, newTasks, originalTasks, BoxesRunTime.unboxToInt((Object)i)));
    }

    private void updateGatesReferencingPhases(Seq<Phase> phasesToRestore, Seq<Phase> restoredPhases) {
        scala.collection.immutable.Map originToRestored = PhaseRestart$.MODULE$.buildOriginToRestored(phasesToRestore, restoredPhases);
        this.scheduler.execute(() -> ((IterableLike)phasesToRestore.flatMap((Function1 & Serializable & scala.Serializable)phase -> (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter($this.dependencyService.findActiveIncomingGateIds(phase.getId())).asScala(), Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            this.releaseActorService.updateGateReferencingPhases(x$2, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)originToRestored).asJava());
            return BoxedUnit.UNIT;
        }));
    }

    private Changes skipTasksBefore(String taskId, Phase originalPhase, Phase restoredPhase) {
        Changes changes;
        block0: {
            int taskIndexToRestartFrom = ((GenSeqLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(originalPhase.getTasks()).asScala()).map((Function1 & Serializable & scala.Serializable)x$3 -> (String)CiHelper.TO_ID.apply(x$3), Buffer$.MODULE$.canBuildFrom())).indexOf((Object)taskId);
            changes = new Changes();
            if (taskIndexToRestartFrom <= 0) break block0;
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), taskIndexToRestartFrom).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                Task task = (Task)restoredPhase.getTasks().get(i);
                changes.addAll(task.markAsDone(task.getId(), TaskStatus.SKIPPED_IN_ADVANCE));
            });
        }
        return changes;
    }

    private void persistRelease(Release original, Release release, Changes changes, List<Phase> restoredPhases) {
        XLReleaseOperations$.MODULE$.runActionInterceptors(changes.getOperations(), this.eventBus);
        VariablePersistenceHelper$.MODULE$.scanAndBuildNewVariables(release, (VisitableItem)release, this.ciIdService);
        this.releaseRepository.update(original, release);
        ((IterableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaSetConverter(changes.getUpdatedItems()).asScala()).filter((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)SqlPhaseRestart.$anonfun$persistRelease$1(x$4)))).foreach((Function1 & Serializable & scala.Serializable)task -> {
            this.taskRepository.updateTaskProperties((Task)task);
            return BoxedUnit.UNIT;
        });
        this.facetRepositoryDispatcher.liveRepository().createFromTasks((Seq)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(restoredPhases).asScala()).flatMap((Function1 & Serializable & scala.Serializable)x$5 -> (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(x$5.getAllTasks()).asScala(), Buffer$.MODULE$.canBuildFrom()), this.facetRepositoryDispatcher.liveRepository().createFromTasks$default$2());
        XLReleaseOperations$.MODULE$.publishEvents(changes.getOperations(), this.eventBus);
    }

    public static final /* synthetic */ Task $anonfun$restoreTasks$1(SqlPhaseRestart $this, List newTasks$1, List originalTasks$1, int i) {
        Task restoredTask = $this.taskBackup.restoreTask((Task)newTasks$1.get(i), ((BaseConfigurationItem)originalTasks$1.get(i)).getId(), true);
        restoredTask.getAllTasks().forEach(subTask -> subTask.setStatus(TaskStatus.PLANNED));
        restoredTask.clearComments();
        restoredTask.setStartDate(null);
        restoredTask.setEndDate(null);
        Task task = restoredTask;
        if (task instanceof GateTask) {
            GateTask gateTask = (GateTask)task;
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(gateTask.getConditions()).asScala()).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                x$1.setChecked(false);
                return BoxedUnit.UNIT;
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        return newTasks$1.set(i, restoredTask);
    }

    public static final /* synthetic */ boolean $anonfun$persistRelease$1(ConfigurationItem x$4) {
        return x$4 instanceof Task;
    }

    @Autowired
    public SqlPhaseRestart(Scheduler scheduler, TaskBackup taskBackup, PermissionChecker permissions, ReleaseRepository releaseRepository, CiIdService ciIdService, DependencyService dependencyService, TaskRepository taskRepository, ReleaseActorService releaseActorService, FacetRepositoryDispatcher facetRepositoryDispatcher, XLReleaseEventBus eventBus) {
        this.scheduler = scheduler;
        this.taskBackup = taskBackup;
        this.permissions = permissions;
        this.releaseRepository = releaseRepository;
        this.ciIdService = ciIdService;
        this.dependencyService = dependencyService;
        this.taskRepository = taskRepository;
        this.releaseActorService = releaseActorService;
        this.facetRepositoryDispatcher = facetRepositoryDispatcher;
        this.eventBus = eventBus;
        PhaseRestart.$init$((PhaseRestart)this);
    }
}

