/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.io;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.xebialabs.deployit.io.ArtifactAwareFile;
import com.xebialabs.deployit.io.ArtifactFile;
import com.xebialabs.deployit.plugin.api.udm.artifact.Artifact;
import com.xebialabs.deployit.plugin.api.udm.artifact.DerivedArtifact;
import com.xebialabs.deployit.plugin.api.udm.artifact.FolderArtifact;
import com.xebialabs.deployit.plugin.api.udm.artifact.SourceArtifact;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.xldeploy.packager.SourceArtifactEnricher;
import com.xebialabs.xldeploy.packager.io.StreamerFactory;
import java.io.InputStream;
import java.io.Serializable;

public class DerivedArtifactFile
extends ArtifactFile
implements ArtifactAwareFile,
Serializable {
    private final DerivedArtifact<? extends SourceArtifact> derivedArtifact;
    private transient OverthereFile resolvedFile;

    public DerivedArtifactFile(DerivedArtifact<? extends SourceArtifact> derivedArtifact) {
        this.derivedArtifact = derivedArtifact;
    }

    @Override
    public boolean isResolvable() {
        return this.derivedArtifact.getSourceArtifact() != null && this.derivedArtifact.getSourceArtifact().getFile() != null;
    }

    @Override
    public InputStream getRawStream() {
        throw new UnsupportedOperationException("Raw stream is not available on derived artifact. Use source artifact or use input stream");
    }

    @Override
    protected synchronized OverthereFile getLazyFile() {
        if (this.resolvedFile == null) {
            SourceArtifactEnricher sae = new SourceArtifactEnricher(StreamerFactory.forConfig((Config)ConfigFactory.defaultReference()));
            this.resolvedFile = sae.createDerivedFile(this.derivedArtifact);
        }
        return this.resolvedFile;
    }

    @Override
    public Artifact underlyingArtifact() {
        return this.derivedArtifact;
    }

    @Override
    public String getName() {
        if (this.isResolvable()) {
            return this.derivedArtifact.getSourceArtifact().getFile().getName();
        }
        throw new RuntimeException("File name is not available because source artifact is not set");
    }

    @Override
    public boolean isFile() {
        return !this.isDirectory();
    }

    @Override
    public boolean isDirectory() {
        return this.derivedArtifact.getSourceArtifact() instanceof FolderArtifact;
    }

    @Override
    public boolean isResolved() {
        return this.resolvedFile != null;
    }
}

