global deliveryApi, deliveryId, task, stage

from com.xebialabs.xlrelease.delivery.domain import StageCompletionSubscriber
from delivery import handle_subscription

delivery = deliveryApi.getDelivery(deliveryId)
delivery_stage = delivery.getStageByIdOrTitle(stage)

task.setStatusLine("[{0}](#/deliveries/{1})".format(delivery.title, delivery.id))
print("Waiting for stage '{0}' in delivery : [{1}](#/deliveries/{2})\n".format(delivery_stage.title, delivery.title, delivery.id))

subscriber = StageCompletionSubscriber()
subscriber.setSourceId(task.getId())
subscriber.setStageId(delivery_stage.getId())
subscription = deliveryApi.registerSubscriber(deliveryId, subscriber)

waitForSignal = handle_subscription(subscription)

