/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.delivery.service;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xlrelease.delivery.domain.Delivery;
import com.xebialabs.xlrelease.delivery.domain.DeliveryStatus;
import com.xebialabs.xlrelease.delivery.domain.Stage;
import com.xebialabs.xlrelease.delivery.domain.StageStatus;
import com.xebialabs.xlrelease.delivery.domain.StageTrackedItem;
import com.xebialabs.xlrelease.delivery.domain.Subscriber;
import com.xebialabs.xlrelease.delivery.domain.SubscriptionResult;
import com.xebialabs.xlrelease.delivery.domain.SubscriptionStatus;
import com.xebialabs.xlrelease.delivery.domain.TrackedItem;
import com.xebialabs.xlrelease.delivery.domain.TrackedItemStatus;
import com.xebialabs.xlrelease.delivery.domain.Transition;
import com.xebialabs.xlrelease.delivery.domain.TransitionResult;
import com.xebialabs.xlrelease.delivery.domain.TransitionTrigger;
import com.xebialabs.xlrelease.delivery.events.DeliveryCompleted;
import com.xebialabs.xlrelease.delivery.events.DeliveryEvent;
import com.xebialabs.xlrelease.delivery.events.ItemAvailable;
import com.xebialabs.xlrelease.delivery.events.ItemCompleted;
import com.xebialabs.xlrelease.delivery.events.ItemCreated;
import com.xebialabs.xlrelease.delivery.events.ItemDescoped;
import com.xebialabs.xlrelease.delivery.events.ItemRemoved;
import com.xebialabs.xlrelease.delivery.events.ItemRescoped;
import com.xebialabs.xlrelease.delivery.events.ItemSkipped;
import com.xebialabs.xlrelease.delivery.events.ItemTransitionApproved;
import com.xebialabs.xlrelease.delivery.events.ItemUpdated;
import com.xebialabs.xlrelease.delivery.events.StageCompleted;
import com.xebialabs.xlrelease.delivery.events.StageReopened;
import com.xebialabs.xlrelease.delivery.events.StageStarted;
import com.xebialabs.xlrelease.delivery.service.DeliveryObjectFactory;
import com.xebialabs.xlrelease.delivery.service.DeliveryStateManager$;
import com.xebialabs.xlrelease.repository.CiCloneHelper;
import com.xebialabs.xlrelease.service.CiIdService;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.Date;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenSeqLike;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.SeqView$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t\u001ds!\u0002\u0016,\u0011\u00031d!\u0002\u001d,\u0011\u0003I\u0004\"\u0002!\u0002\t\u0003\t\u0005\"\u0002\"\u0002\t\u0003\u0019e\u0001\u0002\u001d,\u0001\u0015C\u0001B\u0012\u0003\u0003\u0002\u0003\u0006Ia\u0012\u0005\u0006\u0001\u0012!\tA\u0013\u0005\b]\u0011\u0011\r\u0011\"\u0001M\u0011\u0019\u0019F\u0001)A\u0005\u001b\"9A\u000b\u0002b\u0001\n\u0013)\u0006BB2\u0005A\u0003%a\u000bC\u0004e\t\t\u0007I\u0011B3\t\rI$\u0001\u0015!\u0003g\u0011\u0015\u0019H\u0001\"\u0001u\u0011\u0015qH\u0001\"\u0001\u0000\u0011\u001d\t\u0019\u0001\u0002C\u0001\u0003\u000bAq!!\u0005\u0005\t\u0003\t\u0019\u0002C\u0004\u0002\u0018\u0011!\t!!\u0007\t\u000f\u0005\u0015B\u0001\"\u0001\u0002(!9\u0011q\u0006\u0003\u0005\u0002\u0005E\u0002bBA\"\t\u0011\u0005\u0011Q\t\u0005\b\u0003\u000f\"A\u0011AA%\u0011%\t9\bBI\u0001\n\u0003\tI\bC\u0005\u0002\u0010\u0012\t\n\u0011\"\u0001\u0002\u0012\"9\u0011Q\u0013\u0003\u0005\u0002\u0005]\u0005bBAQ\t\u0011\u0005\u00111\u0015\u0005\n\u0003W#\u0011\u0013!C\u0001\u0003#Cq!!,\u0005\t\u0003\ty\u000bC\u0004\u00024\u0012!\t!!.\t\u000f\u0005eF\u0001\"\u0001\u0002<\"9\u0011q\u0018\u0003\u0005\u0002\u0005\u0005\u0007bBAc\t\u0011\u0005\u0011q\u0019\u0005\b\u0003\u001b$A\u0011AAh\u0011\u001d\tI\u000e\u0002C\u0001\u00037Dq!a?\u0005\t\u0013\ti\u0010C\u0005\u0003\u0006\u0011\t\n\u0011\"\u0003\u0003\b!9!1\u0002\u0003\u0005\n\t5\u0001b\u0002B\u000f\t\u0011%!q\u0004\u0005\b\u0005C!A\u0011\u0002B\u0012\u0011\u001d\u00119\u0003\u0002C\u0005\u0005SAqA!\f\u0005\t\u0013\u0011y\u0003C\u0004\u00032\u0011!IAa\r\u0002)\u0011+G.\u001b<fef\u001cF/\u0019;f\u001b\u0006t\u0017mZ3s\u0015\taS&A\u0004tKJ4\u0018nY3\u000b\u00059z\u0013\u0001\u00033fY&4XM]=\u000b\u0005A\n\u0014!\u0003=me\u0016dW-Y:f\u0015\t\u00114'A\u0005yK\nL\u0017\r\\1cg*\tA'A\u0002d_6\u001c\u0001\u0001\u0005\u00028\u00035\t1F\u0001\u000bEK2Lg/\u001a:z'R\fG/Z'b]\u0006<WM]\n\u0003\u0003i\u0002\"a\u000f \u000e\u0003qR\u0011!P\u0001\u0006g\u000e\fG.Y\u0005\u0003\u007fq\u0012a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u00017\u0003\u0015\t\u0007\u000f\u001d7z)\u0015!%q\u0007B\u001d!\t9Da\u0005\u0002\u0005u\u00059a-Y2u_JL\bCA\u001cI\u0013\tI5FA\u000bEK2Lg/\u001a:z\u001f\nTWm\u0019;GC\u000e$xN]=\u0015\u0005\u0011[\u0005\"\u0002$\u0007\u0001\u00049U#A'\u0011\u00059\u000bV\"A(\u000b\u0005Ak\u0013A\u00023p[\u0006Lg.\u0003\u0002S\u001f\nAA)\u001a7jm\u0016\u0014\u00180A\u0005eK2Lg/\u001a:zA\u00051QM^3oiN,\u0012A\u0016\t\u0004/rsV\"\u0001-\u000b\u0005eS\u0016aB7vi\u0006\u0014G.\u001a\u0006\u00037r\n!bY8mY\u0016\u001cG/[8o\u0013\ti\u0006L\u0001\u0004Ck\u001a4WM\u001d\t\u0003?\u0006l\u0011\u0001\u0019\u0006\u0003)6J!A\u00191\u0003\u001b\u0011+G.\u001b<fef,e/\u001a8u\u0003\u001d)g/\u001a8ug\u0002\n\u0001\"\\3tg\u0006<Wm]\u000b\u0002MB\u0019q\u000bX4\u0011\u0005!|gBA5n!\tQG(D\u0001l\u0015\taW'\u0001\u0004=e>|GOP\u0005\u0003]r\na\u0001\u0015:fI\u00164\u0017B\u00019r\u0005\u0019\u0019FO]5oO*\u0011a\u000eP\u0001\n[\u0016\u001c8/Y4fg\u0002\n\u0011bZ3u\u000bZ,g\u000e^:\u0016\u0003U\u00042A^>_\u001d\t9\u0018P\u0004\u0002kq&\tQ(\u0003\u0002{y\u00059\u0001/Y2lC\u001e,\u0017B\u0001?~\u0005\u0011a\u0015n\u001d;\u000b\u0005id\u0014aC4fi6+7o]1hKN,\"!!\u0001\u0011\u0007Y\\x-\u0001\bbI\u0012$&/Y2lK\u0012LE/Z7\u0015\t\u0005\u001d\u0011Q\u0002\t\u0004\u001d\u0006%\u0011bAA\u0006\u001f\nYAK]1dW\u0016$\u0017\n^3n\u0011\u001d\tya\u0004a\u0001\u0003\u000f\tA!\u001b;f[\u0006\tR\u000f\u001d3bi\u0016$&/Y2lK\u0012LE/Z7\u0015\t\u0005\u001d\u0011Q\u0003\u0005\b\u0003\u001f\u0001\u0002\u0019AA\u0004\u0003E!W\r\\3uKR\u0013\u0018mY6fI&#X-\u001c\u000b\u0005\u00037\t\t\u0003E\u0002<\u0003;I1!a\b=\u0005\u0011)f.\u001b;\t\r\u0005\r\u0012\u00031\u0001h\u0003\u0019IG/Z7JI\u0006\u0001\u0012\r\u001a3SK2,\u0017m]3U_&#X-\u001c\u000b\u0007\u00037\tI#a\u000b\t\u000f\u0005=!\u00031\u0001\u0002\b!1\u0011Q\u0006\nA\u0002\u001d\f\u0011B]3mK\u0006\u001cX-\u00133\u0002%I,w-[:uKJ\u001cVOY:de&\u0014WM\u001d\u000b\u0005\u0003g\tI\u0004E\u0002O\u0003kI1!a\u000eP\u0005I\u0019VOY:de&\u0004H/[8o%\u0016\u001cX\u000f\u001c;\t\u000f\u0005m2\u00031\u0001\u0002>\u0005Q1/\u001e2tGJL'-\u001a:\u0011\u00079\u000by$C\u0002\u0002B=\u0013!bU;cg\u000e\u0014\u0018NY3s\u0003\u0015\u0019H/\u0019:u)\u0005i\u0015aF7be.$&/Y2lK\u0012LE/Z7t\u0013:\u001cF/Y4f)1\tY%!\u0015\u0002V\u0005}\u0013\u0011NA:!\u00151\u0018QJA\u0004\u0013\r\ty% \u0002\u0004'\u0016\f\bbBA*+\u0001\u0007\u00111J\u0001\u0006SR,Wn\u001d\u0005\b\u0003/*\u0002\u0019AA-\u0003\u0015\u0019H/Y4f!\rq\u00151L\u0005\u0004\u0003;z%!B*uC\u001e,\u0007bBA1+\u0001\u0007\u00111M\u0001\u0007gR\fG/^:\u0011\u00079\u000b)'C\u0002\u0002h=\u0013\u0011\u0003\u0016:bG.,G-\u0013;f[N#\u0018\r^;t\u0011%\tY'\u0006I\u0001\u0002\u0004\ti'A\bqe\u0016\u001cW\rZ5oON#\u0018mZ3t!\rY\u0014qN\u0005\u0004\u0003cb$a\u0002\"p_2,\u0017M\u001c\u0005\t\u0003k*\u0002\u0013!a\u0001O\u0006iaM]8n%\u0016dW-Y:f\u0013\u0012\f\u0011%\\1sWR\u0013\u0018mY6fI&#X-\\:J]N#\u0018mZ3%I\u00164\u0017-\u001e7uIQ*\"!a\u001f+\t\u00055\u0014QP\u0016\u0003\u0003\u007f\u0002B!!!\u0002\f6\u0011\u00111\u0011\u0006\u0005\u0003\u000b\u000b9)A\u0005v]\u000eDWmY6fI*\u0019\u0011\u0011\u0012\u001f\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002\u000e\u0006\r%!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006\tS.\u0019:l)J\f7m[3e\u0013R,Wn]%o'R\fw-\u001a\u0013eK\u001a\fW\u000f\u001c;%kU\u0011\u00111\u0013\u0016\u0004O\u0006u\u0014AF7be.$&/Y2lK\u0012LE/Z7J]N#\u0018mZ3\u0015\u0015\u0005m\u0011\u0011TAN\u0003;\u000by\nC\u0004\u0002\u0010a\u0001\r!a\u0002\t\u000f\u0005]\u0003\u00041\u0001\u0002Z!9\u0011\u0011\r\rA\u0002\u0005\r\u0004BBA;1\u0001\u0007q-\u0001\u000ed_6\u0004H.\u001a;f)J\f7m[3e\u0013R,W.\u00138Ti\u0006<W\rF\u0004N\u0003K\u000b9+!+\t\u000f\u0005=\u0011\u00041\u0001\u0002\b!9\u0011qK\rA\u0002\u0005e\u0003\u0002CA;3A\u0005\t\u0019A4\u0002I\r|W\u000e\u001d7fi\u0016$&/Y2lK\u0012LE/Z7J]N#\u0018mZ3%I\u00164\u0017-\u001e7uIM\nQbY8na2,G/Z*uC\u001e,G\u0003BA\u000e\u0003cCq!a\u0016\u001c\u0001\u0004\tI&A\u0006sK>\u0004XM\\*uC\u001e,G\u0003BA\u000e\u0003oCq!a\u0016\u001d\u0001\u0004\tI&\u0001\u0007eKN\u001cw\u000e]3Ji\u0016l7\u000f\u0006\u0003\u0002\u001c\u0005u\u0006bBA*;\u0001\u0007\u00111J\u0001\re\u0016\u001c8m\u001c9f\u0013R,Wn\u001d\u000b\u0005\u00037\t\u0019\rC\u0004\u0002Ty\u0001\r!a\u0013\u0002-M\\\u0017\u000e\u001d+sC\u000e\\W\rZ%uK6Len\u0015;bO\u0016$R!TAe\u0003\u0017Dq!a\u0004 \u0001\u0004\t9\u0001C\u0004\u0002X}\u0001\r!!\u0017\u0002\u001fM$\u0018M\u001d;Ti\u0006<Wm\u0012:pkB$b!a\u0007\u0002R\u0006]\u0007bBAjA\u0001\u0007\u0011Q[\u0001\u0007gR\fw-Z:\u0011\u000bY\fi%!\u0017\t\u000f\u0005M\u0003\u00051\u0001\u0002L\u0005\u0001\u0002.\u00198eY\u0016$&/\u00198tSRLwN\u001c\u000b\t\u00037\ti.a:\u0002r\"9\u0011q\\\u0011A\u0002\u0005\u0005\u0018A\u0003;sC:\u001c\u0018\u000e^5p]B\u0019a*a9\n\u0007\u0005\u0015xJ\u0001\u0006Ue\u0006t7/\u001b;j_:Dq!!;\"\u0001\u0004\tY/A\u0004ue&<w-\u001a:\u0011\u00079\u000bi/C\u0002\u0002p>\u0013\u0011\u0003\u0016:b]NLG/[8o)JLwmZ3s\u0011\u001d\t\u00190\ta\u0001\u0003k\f\u0001\u0003\u001e:b]NLG/[8o%\u0016\u001cX\u000f\u001c;\u0011\u00079\u000b90C\u0002\u0002z>\u0013\u0001\u0003\u0016:b]NLG/[8o%\u0016\u001cX\u000f\u001c;\u00027\u0019|'oY3DY>\u001cXm\u0015;bO\u0016\u001c\u0018J\u001a(pi\u000ecwn]3e)\u0019\tY\"a@\u0003\u0002!9\u00111\u001b\u0012A\u0002\u0005U\u0007\"\u0003B\u0002EA\u0005\t\u0019AA&\u00039IG/Z7t)>$Um]2pa\u0016\fQEZ8sG\u0016\u001cEn\\:f'R\fw-Z:JM:{Go\u00117pg\u0016$G\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\t%!\u0006BA&\u0003{\nQEZ8sG\u0016\u001c6.\u001b9Ue\u0006\u001c7.\u001a3Ji\u0016l\u0017J\\*uC\u001e,\u0017J\u001a(piJ+\u0017\rZ=\u0015\u0011\u0005m!q\u0002B\t\u0005'Aq!a\u0004%\u0001\u0004\t9\u0001C\u0004\u0002X\u0011\u0002\r!!\u0017\t\u000f\tUA\u00051\u0001\u0003\u0018\u0005\u00012\u000f^1hKR\u0013\u0018mY6fI&#X-\u001c\t\u0004\u001d\ne\u0011b\u0001B\u000e\u001f\n\u00012\u000b^1hKR\u0013\u0018mY6fI&#X-\\\u0001\nQ\u0006\u001c8\u000b^1hKN,\"!!\u001c\u0002+%\u001c\u0018\t\u001c7po\u0016$Gk\\\"m_N,7\u000b^1hKR!\u0011Q\u000eB\u0013\u0011\u001d\t9F\na\u0001\u00033\na#[:BY2|w/\u001a3U_J+w\u000e]3o'R\fw-\u001a\u000b\u0005\u0003[\u0012Y\u0003C\u0004\u0002X\u001d\u0002\r!!\u0017\u0002+\rDWmY6EK2Lg/\u001a:z\u0013N\f5\r^5wKR\u0011\u00111D\u0001\u000eC\u0012$7+\u001e2tGJL'-\u001a:\u0015\t\u0005M\"Q\u0007\u0005\b\u0003wI\u0003\u0019AA\u001f\u0011\u0015q3\u00011\u0001N\u0011\u001d\u0011Yd\u0001a\u0001\u0005{\t1bY5JIN+'O^5dKB!!q\bB\"\u001b\t\u0011\tE\u0003\u0002-_%!!Q\tB!\u0005-\u0019\u0015.\u00133TKJ4\u0018nY3")
public class DeliveryStateManager {
    private final DeliveryObjectFactory factory;
    private final Delivery delivery;
    private final Buffer<DeliveryEvent> events;
    private final Buffer<String> messages;

    public static DeliveryStateManager apply(Delivery delivery, CiIdService ciIdService) {
        return DeliveryStateManager$.MODULE$.apply(delivery, ciIdService);
    }

    public Delivery delivery() {
        return this.delivery;
    }

    private Buffer<DeliveryEvent> events() {
        return this.events;
    }

    private Buffer<String> messages() {
        return this.messages;
    }

    public List<DeliveryEvent> getEvents() {
        return this.events().toList();
    }

    public List<String> getMessages() {
        return this.messages().toList();
    }

    public TrackedItem addTrackedItem(TrackedItem item) {
        block0: {
            this.checkDeliveryIsActive();
            String itemId = this.factory.genTrackedItemId();
            item.setId(itemId);
            item.setModifiedDate(new Date());
            this.delivery().addTrackedItem(item);
            this.delivery().addReleaseIds(item.getReleaseIds());
            this.events().$plus$eq((Object)new ItemCreated(item, this.delivery()));
            if (this.delivery().isTemplate()) break block0;
            this.delivery().getStagesBeforeFirstOpenTransition().forEach(stage -> {
                block0: {
                    StageTrackedItem stageTrackedItem = $this.factory.createStageTrackedItem(stage.getId(), itemId);
                    stage.getItems().add(stageTrackedItem);
                    this.events().$plus$eq((Object)new ItemAvailable(item, (Stage)((Object)stage), this.delivery()));
                    if (!stage.isClosed()) break block0;
                    stageTrackedItem.setStatus(TrackedItemStatus.SKIPPED);
                    this.events().$plus$eq((Object)new ItemSkipped(item, (Stage)((Object)stage), this.delivery()));
                }
            });
        }
        return item;
    }

    /*
     * WARNING - void declaration
     */
    public TrackedItem updateTrackedItem(TrackedItem item) {
        void var2_2;
        this.checkDeliveryIsActive();
        TrackedItem updatedItem = this.delivery().getItemByIdOrTitle(item.getId());
        TrackedItem originalItem = (TrackedItem)CiCloneHelper.cloneCi((ConfigurationItem)updatedItem);
        updatedItem.setTitle(item.getTitle());
        updatedItem.setModifiedDate(new Date());
        this.events().$plus$eq((Object)new ItemUpdated(updatedItem, this.delivery(), originalItem));
        return var2_2;
    }

    public void deleteTrackedItem(String itemId) {
        this.checkDeliveryIsActive();
        TrackedItem item = this.delivery().getItemByIdOrTitle(itemId);
        this.delivery().removeTrackedItem(itemId);
        if (!this.delivery().isTemplate()) {
            this.delivery().getStages().forEach(x$1 -> x$1.removeTrackedItem(itemId));
        }
        this.events().$plus$eq((Object)new ItemRemoved(item, this.delivery()));
    }

    public void addReleaseToItem(TrackedItem item, String releaseId) {
        this.checkDeliveryIsActive();
        item.addReleaseId(releaseId);
        this.delivery().addReleaseId(releaseId);
    }

    public SubscriptionResult registerSubscriber(Subscriber subscriber) {
        this.checkDeliveryIsActive();
        return this.addSubscriber(subscriber);
    }

    public Delivery start() {
        block0: {
            this.delivery().setStatus(DeliveryStatus.IN_PROGRESS);
            if (!this.hasStages()) break block0;
            Buffer firstStageGroup = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(this.delivery().getStagesBeforeFirstOpenTransition()).asScala();
            this.startStageGroup((Seq<Stage>)firstStageGroup, (Seq<TrackedItem>)((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(this.delivery().getTrackedItems()).asScala()));
        }
        return this.delivery();
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public Seq<TrackedItem> markTrackedItemsInStage(Seq<TrackedItem> items, Stage stage, TrackedItemStatus status, boolean precedingStages, String fromReleaseId) {
        v0 = this.delivery().getStatus();
        var8_6 = DeliveryStatus.IN_PROGRESS;
        Checks.checkTrue((boolean)(!(v0 != null ? v0.equals((Object)var8_6) == false : var8_6 != null)), (String)"Only in-progress release deliveries may complete or skip items", (Object[])new Object[0]);
        Checks.checkTrue((boolean)stage.isOpen(), (String)"Stage must be open in order to update items in it", (Object[])new Object[0]);
        v1 = status;
        var9_7 = TrackedItemStatus.READY;
        if (!(v1 == null ? var9_7 != null : v1.equals((Object)var9_7) == false)) ** GOTO lbl-1000
        v2 = status;
        var10_8 = TrackedItemStatus.SKIPPED;
        if (!(v2 != null ? v2.equals((Object)var10_8) == false : var10_8 != null)) lbl-1000:
        // 2 sources

        {
            v3 = true;
        } else {
            v3 = false;
        }
        Checks.checkTrue((boolean)v3, (String)new StringBuilder(29).append("Not allowed to mark items as ").append((Object)status).toString(), (Object[])new Object[0]);
        descopedItems = (Seq)items.filter((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$markTrackedItemsInStage$1$adapted(com.xebialabs.xlrelease.delivery.domain.TrackedItem ), (Lcom/xebialabs/xlrelease/delivery/domain/TrackedItem;)Ljava/lang/Object;)());
        Checks.checkTrue((boolean)descopedItems.isEmpty(), (String)new StringBuilder(72).append("Unable to complete task, the following tracked items are de-scoped:\n * ").append(((TraversableOnce)descopedItems.map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$markTrackedItemsInStage$2(com.xebialabs.xlrelease.delivery.domain.TrackedItem ), (Lcom/xebialabs/xlrelease/delivery/domain/TrackedItem;)Ljava/lang/String;)(), Seq$.MODULE$.canBuildFrom())).mkString("\n * ")).append("\n").toString(), (Object[])new Object[0]);
        if (precedingStages) {
            ((IterableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.delivery().getStagesBefore(stage)).asScala()).dropWhile((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$markTrackedItemsInStage$3$adapted(com.xebialabs.xlrelease.delivery.domain.Stage ), (Lcom/xebialabs/xlrelease/delivery/domain/Stage;)Ljava/lang/Object;)())).foreach((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$markTrackedItemsInStage$4(com.xebialabs.xlrelease.delivery.service.DeliveryStateManager scala.collection.Seq com.xebialabs.xlrelease.delivery.domain.TrackedItemStatus java.lang.String com.xebialabs.xlrelease.delivery.domain.Stage ), (Lcom/xebialabs/xlrelease/delivery/domain/Stage;)Lscala/collection/Seq;)((DeliveryStateManager)this, items, (TrackedItemStatus)status, (String)fromReleaseId));
        }
        var7_11 = TrackedItemStatus.READY.equals((Object)(var13_10 = status)) != false ? (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TrackedItemStatus[]{TrackedItemStatus.READY})) : (TrackedItemStatus.SKIPPED.equals((Object)var13_10) != false ? (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TrackedItemStatus[]{TrackedItemStatus.READY, TrackedItemStatus.SKIPPED})) : (Seq)Seq$.MODULE$.empty());
        doneStatuses = var7_11;
        doneItems = ((TraversableOnce)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(stage.getItems()).asScala()).filter((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$markTrackedItemsInStage$6$adapted(scala.collection.Seq com.xebialabs.xlrelease.delivery.domain.StageTrackedItem ), (Lcom/xebialabs/xlrelease/delivery/domain/StageTrackedItem;)Ljava/lang/Object;)((Seq)doneStatuses))).map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$markTrackedItemsInStage$7(com.xebialabs.xlrelease.delivery.domain.StageTrackedItem ), (Lcom/xebialabs/xlrelease/delivery/domain/StageTrackedItem;)Ljava/lang/String;)(), Buffer$.MODULE$.canBuildFrom())).toSet();
        var16_14 = items.partition((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$markTrackedItemsInStage$8$adapted(scala.collection.immutable.Set com.xebialabs.xlrelease.delivery.domain.TrackedItem ), (Lcom/xebialabs/xlrelease/delivery/domain/TrackedItem;)Ljava/lang/Object;)((Set)doneItems));
        if (var16_14 == null) {
            throw new MatchError((Object)var16_14);
        }
        done = (Seq)var16_14._1();
        notDone = (Seq)var16_14._2();
        var6_17 = new Tuple2((Object)done, (Object)notDone);
        var15_18 = var6_17;
        done = (Seq)var15_18._1();
        notDone = (Seq)var15_18._2();
        v4 /* !! */  = done.nonEmpty() != false ? this.messages().$plus$eq((Object)new StringBuilder(57).append("Tracked items [").append(((TraversableOnce)done.map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$markTrackedItemsInStage$9(com.xebialabs.xlrelease.delivery.domain.TrackedItem ), (Lcom/xebialabs/xlrelease/delivery/domain/TrackedItem;)Ljava/lang/String;)(), Seq$.MODULE$.canBuildFrom())).mkString(", ")).append("] already completed or skipped on stage '").append(stage.getId()).append("'").toString()) : BoxedUnit.UNIT;
        notDone.foreach((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$markTrackedItemsInStage$10$adapted(com.xebialabs.xlrelease.delivery.service.DeliveryStateManager com.xebialabs.xlrelease.delivery.domain.Stage com.xebialabs.xlrelease.delivery.domain.TrackedItemStatus java.lang.String com.xebialabs.xlrelease.delivery.domain.TrackedItem ), (Lcom/xebialabs/xlrelease/delivery/domain/TrackedItem;)Ljava/lang/Object;)((DeliveryStateManager)this, (Stage)stage, (TrackedItemStatus)status, (String)fromReleaseId));
        return notDone;
    }

    public boolean markTrackedItemsInStage$default$4() {
        return false;
    }

    public String markTrackedItemsInStage$default$5() {
        return null;
    }

    public void markTrackedItemInStage(TrackedItem item, Stage stage, TrackedItemStatus status, String fromReleaseId) {
        TrackedItemStatus trackedItemStatus = status;
        if (((Object)((Object)TrackedItemStatus.READY)).equals((Object)trackedItemStatus)) {
            this.completeTrackedItemInStage(item, stage, fromReleaseId);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (((Object)((Object)TrackedItemStatus.SKIPPED)).equals((Object)trackedItemStatus)) {
            this.skipTrackedItemInStage(item, stage);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public Delivery completeTrackedItemInStage(TrackedItem item, Stage stage, String fromReleaseId) {
        DeliveryStatus deliveryStatus = this.delivery().getStatus();
        DeliveryStatus deliveryStatus2 = DeliveryStatus.IN_PROGRESS;
        Checks.checkTrue((!(deliveryStatus != null ? !((Object)((Object)deliveryStatus)).equals((Object)deliveryStatus2) : deliveryStatus2 != null) ? 1 : 0) != 0, (String)"Only in-progress release deliveries may complete items", (Object[])new Object[0]);
        Checks.checkTrue((boolean)stage.isOpen(), (String)"Stage must be open in order to complete items in it", (Object[])new Object[0]);
        Checks.checkTrue((!item.isDescoped() ? 1 : 0) != 0, (String)"Cannot complete de-scoped item", (Object[])new Object[0]);
        StageTrackedItem stageItem = stage.getItemById(item.getId());
        TrackedItemStatus trackedItemStatus = stageItem.getStatus();
        TrackedItemStatus trackedItemStatus2 = TrackedItemStatus.READY;
        Checks.checkTrue(((trackedItemStatus == null ? trackedItemStatus2 != null : !((Object)((Object)trackedItemStatus)).equals((Object)trackedItemStatus2)) ? 1 : 0) != 0, (String)"Only not completed tracked items can be completed", (Object[])new Object[0]);
        stageItem.setStatus(TrackedItemStatus.READY);
        this.events().$plus$eq((Object)new ItemCompleted(item, stage, this.delivery(), fromReleaseId));
        return this.delivery();
    }

    public String completeTrackedItemInStage$default$3() {
        return null;
    }

    public void completeStage(Stage stage) {
        DeliveryStatus deliveryStatus = this.delivery().getStatus();
        DeliveryStatus deliveryStatus2 = DeliveryStatus.IN_PROGRESS;
        Checks.checkTrue((!(deliveryStatus != null ? !((Object)((Object)deliveryStatus)).equals((Object)deliveryStatus2) : deliveryStatus2 != null) ? 1 : 0) != 0, (String)"Only in-progress release deliveries may complete stages", (Object[])new Object[0]);
        Checks.checkTrue((boolean)stage.isOpen(), (String)"Only open stages may be completed", (Object[])new Object[0]);
        Checks.checkTrue((boolean)this.isAllowedToCloseStage(stage), (String)"Stages cannot be completed if their preceding stages are not closed", (Object[])new Object[0]);
        Buffer toDescopeAndSkip = (Buffer)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(stage.getItems()).asScala()).filter((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)DeliveryStateManager.$anonfun$completeStage$1(x$9)))).map((Function1 & Serializable & scala.Serializable)stageItem -> this.delivery().getItemByIdOrTitle(stageItem.getTrackedItemId()), Buffer$.MODULE$.canBuildFrom());
        this.forceCloseStagesIfNotClosed((Seq<Stage>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Stage[]{stage}))), (Seq<TrackedItem>)toDescopeAndSkip);
    }

    public void reopenStage(Stage stage) {
        block0: {
            DeliveryStatus deliveryStatus = this.delivery().getStatus();
            DeliveryStatus deliveryStatus2 = DeliveryStatus.IN_PROGRESS;
            Checks.checkTrue((!(deliveryStatus != null ? !((Object)((Object)deliveryStatus)).equals((Object)deliveryStatus2) : deliveryStatus2 != null) ? 1 : 0) != 0, (String)"Only in-progress release deliveries may reopen stages", (Object[])new Object[0]);
            Checks.checkTrue((boolean)stage.isClosed(), (String)"Only closed stages may be reopened", (Object[])new Object[0]);
            Checks.checkTrue((boolean)this.isAllowedToReopenStage(stage), (String)"Stages cannot be reopened if their subsequent stages are closed", (Object[])new Object[0]);
            if (!stage.isClosed()) break block0;
            stage.setStatus(StageStatus.OPEN);
            this.events().$plus$eq((Object)new StageReopened(stage, this.delivery()));
        }
    }

    public void descopeItems(Seq<TrackedItem> items) {
        Map itemsNotYetDescoped = ((TraversableOnce)items.view().filterNot((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)x$10.isDescoped())).map((Function1 & Serializable & scala.Serializable)item -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)item.getId()), (Object)item), SeqView$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        itemsNotYetDescoped.valuesIterator().foreach((Function1 & Serializable & scala.Serializable)item -> {
            item.setDescoped(true);
            return this.events().$plus$eq((Object)new ItemDescoped((TrackedItem)((Object)item), this.delivery()));
        });
    }

    public void rescopeItems(Seq<TrackedItem> items) {
        Map descopedItems = ((TraversableOnce)items.view().filter((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)x$11.isDescoped())).map((Function1 & Serializable & scala.Serializable)item -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)item.getId()), (Object)item), SeqView$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        descopedItems.valuesIterator().foreach((Function1 & Serializable & scala.Serializable)item -> {
            item.setDescoped(false);
            return this.events().$plus$eq((Object)new ItemRescoped((TrackedItem)((Object)item), this.delivery()));
        });
    }

    public Delivery skipTrackedItemInStage(TrackedItem item, Stage stage) {
        DeliveryStatus deliveryStatus = this.delivery().getStatus();
        DeliveryStatus deliveryStatus2 = DeliveryStatus.IN_PROGRESS;
        Checks.checkTrue((!(deliveryStatus != null ? !((Object)((Object)deliveryStatus)).equals((Object)deliveryStatus2) : deliveryStatus2 != null) ? 1 : 0) != 0, (String)"Only in-progress release deliveries may skip items", (Object[])new Object[0]);
        Checks.checkTrue((boolean)stage.isOpen(), (String)"Items can only be skipped in OPEN stages", (Object[])new Object[0]);
        Checks.checkTrue((!item.isDescoped() ? 1 : 0) != 0, (String)"Cannot skip a descoped item", (Object[])new Object[0]);
        StageTrackedItem stageItem = stage.getItemById(item.getId());
        TrackedItemStatus trackedItemStatus = stageItem.getStatus();
        TrackedItemStatus trackedItemStatus2 = TrackedItemStatus.NOT_READY;
        Checks.checkTrue((!(trackedItemStatus != null ? !((Object)((Object)trackedItemStatus)).equals((Object)trackedItemStatus2) : trackedItemStatus2 != null) ? 1 : 0) != 0, (String)"Only NOT_READY items can be skipped", (Object[])new Object[0]);
        this.forceSkipTrackedItemInStageIfNotReady(item, stage, stageItem);
        return this.delivery();
    }

    public void startStageGroup(Seq<Stage> stages, Seq<TrackedItem> items) {
        stages.foreach((Function1 & Serializable & scala.Serializable)stage -> {
            DeliveryStateManager.$anonfun$startStageGroup$1(this, items, stage);
            return BoxedUnit.UNIT;
        });
    }

    public void handleTransition(Transition transition, TransitionTrigger trigger, TransitionResult transitionResult) {
        if (transitionResult.closeStages()) {
            Buffer stagesToClose = (Buffer)((SeqLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.delivery().getStagesBefore(trigger.transitionStage())).asScala()).filter((Function1 & Serializable & scala.Serializable)stage -> BoxesRunTime.boxToBoolean((boolean)stage.isOpen()))).$colon$plus((Object)trigger.transitionStage(), Buffer$.MODULE$.canBuildFrom());
            this.forceCloseStagesIfNotClosed((Seq<Stage>)stagesToClose, (Seq<TrackedItem>)transitionResult.toDescope().toList());
        }
        Buffer nextStageGroup = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(this.delivery().getStageGroupAfterTransition(transition)).asScala();
        this.startStageGroup((Seq<Stage>)nextStageGroup, (Seq<TrackedItem>)transitionResult.toTransition().toList());
        Stage stage2 = (Stage)((Object)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.delivery().getStages()).asScala()).find((Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)DeliveryStateManager.$anonfun$handleTransition$2(transition, x$15))).get());
        transitionResult.toTransition().toList().foreach((Function1 & Serializable & scala.Serializable)item -> this.events().$plus$eq((Object)new ItemTransitionApproved((TrackedItem)((Object)item), stage2.findItemById(item.getId()).get(), transition, stage2, this.delivery())));
    }

    private void forceCloseStagesIfNotClosed(Seq<Stage> stages, Seq<TrackedItem> itemsToDescope) {
        stages.foreach((Function1 & Serializable & scala.Serializable)stage -> {
            BoxedUnit boxedUnit;
            BoxedUnit boxedUnit2;
            itemsToDescope.foreach((Function1 & Serializable & scala.Serializable)item -> {
                DeliveryStateManager.$anonfun$forceCloseStagesIfNotClosed$2(this, stage, item);
                return BoxedUnit.UNIT;
            });
            if (stage.isOpen()) {
                stage.setStatus(StageStatus.CLOSED);
                boxedUnit2 = this.events().$plus$eq((Object)new StageCompleted((Stage)((Object)stage), this.delivery()));
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            if (this.delivery().isLastStage((Stage)((Object)stage))) {
                this.delivery().setStatus(DeliveryStatus.COMPLETED);
                boxedUnit = this.events().$plus$eq((Object)new DeliveryCompleted(this.delivery()));
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return boxedUnit;
        });
        this.descopeItems(itemsToDescope);
    }

    private Seq<TrackedItem> forceCloseStagesIfNotClosed$default$2() {
        return (Seq)Seq$.MODULE$.empty();
    }

    private void forceSkipTrackedItemInStageIfNotReady(TrackedItem item, Stage stage, StageTrackedItem stageTrackedItem) {
        block0: {
            TrackedItemStatus trackedItemStatus = stageTrackedItem.getStatus();
            TrackedItemStatus trackedItemStatus2 = TrackedItemStatus.NOT_READY;
            if (trackedItemStatus != null ? !((Object)((Object)trackedItemStatus)).equals((Object)trackedItemStatus2) : trackedItemStatus2 != null) break block0;
            stageTrackedItem.setStatus(TrackedItemStatus.SKIPPED);
            this.events().$plus$eq((Object)new ItemSkipped(item, stage, this.delivery()));
        }
    }

    private boolean hasStages() {
        return this.delivery().getStages() != null && !this.delivery().getStages().isEmpty();
    }

    private boolean isAllowedToCloseStage(Stage stage) {
        return OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.delivery().findPreviousStage(stage))).forall((Function1 & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)DeliveryStateManager.$anonfun$isAllowedToCloseStage$1(x$16)));
    }

    private boolean isAllowedToReopenStage(Stage stage) {
        return OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.delivery().findNextStage(stage))).forall((Function1 & Serializable & scala.Serializable)x$17 -> BoxesRunTime.boxToBoolean((boolean)DeliveryStateManager.$anonfun$isAllowedToReopenStage$1(x$17)));
    }

    private void checkDeliveryIsActive() {
        Checks.checkTrue((!new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])DeliveryStatus.INACTIVE_STATUSES)).contains((Object)this.delivery().getStatus()) ? 1 : 0) != 0, (String)"Can't modify ABORTED or COMPLETED release delivery", (Object[])new Object[0]);
    }

    private SubscriptionResult addSubscriber(Subscriber subscriber) {
        Subscriber subscriber2;
        SubscriptionStatus subscriptionStatus;
        subscriber.validate(this.delivery());
        SubscriptionResult result = subscriber.evaluate(this.delivery());
        int subscriberIndex = ((GenSeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.delivery().getSubscribers()).asScala()).indexWhere((Function1 & Serializable & scala.Serializable)x$18 -> BoxesRunTime.boxToBoolean((boolean)x$18.isEqual(subscriber)));
        SubscriptionResult subscriptionResult = result;
        if (subscriptionResult != null && ((Object)((Object)SubscriptionStatus.COMPLETED)).equals((Object)(subscriptionStatus = subscriptionResult.status())) && subscriberIndex != -1) {
            subscriber2 = this.delivery().getSubscribers().remove(subscriberIndex);
        } else {
            SubscriptionStatus subscriptionStatus2;
            SubscriptionStatus subscriptionStatus3;
            boolean bl = subscriptionResult != null && ((Object)((Object)SubscriptionStatus.FAILED)).equals((Object)(subscriptionStatus3 = subscriptionResult.status())) ? true : subscriptionResult != null && ((Object)((Object)SubscriptionStatus.IN_PROGRESS)).equals((Object)(subscriptionStatus2 = subscriptionResult.status()));
            if (bl && subscriberIndex != -1) {
                subscriber2 = this.delivery().getSubscribers().set(subscriberIndex, subscriber);
            } else {
                SubscriptionStatus subscriptionStatus4;
                SubscriptionStatus subscriptionStatus5;
                boolean bl2 = subscriptionResult != null && ((Object)((Object)SubscriptionStatus.FAILED)).equals((Object)(subscriptionStatus5 = subscriptionResult.status())) ? true : subscriptionResult != null && ((Object)((Object)SubscriptionStatus.IN_PROGRESS)).equals((Object)(subscriptionStatus4 = subscriptionResult.status()));
                if (bl2) {
                    this.delivery().addSubscriber(subscriber);
                    subscriber2 = BoxedUnit.UNIT;
                } else {
                    subscriber2 = BoxedUnit.UNIT;
                }
            }
        }
        return result;
    }

    public static final /* synthetic */ String $anonfun$markTrackedItemsInStage$2(TrackedItem x$3) {
        return x$3.getTitle();
    }

    public static final /* synthetic */ boolean $anonfun$markTrackedItemsInStage$5(Stage stage$1, TrackedItem item) {
        return stage$1.findItemById(item.getId()).isPresent();
    }

    public static final /* synthetic */ Seq $anonfun$markTrackedItemsInStage$4(DeliveryStateManager $this, Seq items$1, TrackedItemStatus status$1, String fromReleaseId$1, Stage stage) {
        Seq itemsInStage = (Seq)items$1.filter((Function1 & Serializable & scala.Serializable)item -> BoxesRunTime.boxToBoolean((boolean)DeliveryStateManager.$anonfun$markTrackedItemsInStage$5(stage, item)));
        return $this.markTrackedItemsInStage((Seq<TrackedItem>)itemsInStage, stage, status$1, false, fromReleaseId$1);
    }

    public static final /* synthetic */ String $anonfun$markTrackedItemsInStage$7(StageTrackedItem x$5) {
        return x$5.getTrackedItemId();
    }

    public static final /* synthetic */ String $anonfun$markTrackedItemsInStage$9(TrackedItem x$7) {
        return x$7.getId();
    }

    public static final /* synthetic */ boolean $anonfun$completeStage$1(StageTrackedItem x$9) {
        TrackedItemStatus trackedItemStatus = x$9.getStatus();
        TrackedItemStatus trackedItemStatus2 = TrackedItemStatus.NOT_READY;
        return !(trackedItemStatus != null ? !((Object)((Object)trackedItemStatus)).equals((Object)trackedItemStatus2) : trackedItemStatus2 != null);
    }

    public static final /* synthetic */ void $anonfun$startStageGroup$1(DeliveryStateManager $this, Seq items$2, Stage stage) {
        block0: {
            Set existingItems = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(stage.getItems()).asScala()).map((Function1 & Serializable & scala.Serializable)x$12 -> x$12.getTrackedItemId(), Buffer$.MODULE$.canBuildFrom())).toSet();
            Seq newItems = (Seq)items$2.filterNot((Function1 & Serializable & scala.Serializable)item -> BoxesRunTime.boxToBoolean((boolean)existingItems.apply((Object)item.getId())));
            java.util.List stageItems = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)newItems.map((Function1 & Serializable & scala.Serializable)item -> $this.factory.createStageTrackedItem(stage.getId(), item.getId()), Seq$.MODULE$.canBuildFrom())).asJava();
            stage.addTrackedItems(stageItems);
            $this.events().$plus$eq((Object)new StageStarted(stage, $this.delivery()));
            items$2.foreach((Function1 & Serializable & scala.Serializable)x$13 -> $this.events().$plus$eq((Object)new ItemAvailable((TrackedItem)((Object)x$13), stage, $this.delivery())));
            if (!stage.isClosed()) break block0;
            stageItems.forEach(stageItem -> stageItem.setStatus(TrackedItemStatus.SKIPPED));
            newItems.foreach((Function1 & Serializable & scala.Serializable)x$14 -> $this.events().$plus$eq((Object)new ItemSkipped((TrackedItem)((Object)x$14), stage, $this.delivery())));
        }
    }

    public static final /* synthetic */ boolean $anonfun$handleTransition$2(Transition transition$1, Stage x$15) {
        String string = x$15.getId();
        String string2 = transition$1.getFromStageId();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$forceCloseStagesIfNotClosed$2(DeliveryStateManager $this, Stage stage$5, TrackedItem item) {
        stage$5.findItemById(item.getId()).ifPresent(stageItem -> $this.forceSkipTrackedItemInStageIfNotReady(item, stage$5, (StageTrackedItem)((Object)stageItem)));
    }

    public static final /* synthetic */ boolean $anonfun$isAllowedToCloseStage$1(Stage x$16) {
        StageStatus stageStatus = x$16.getStatus();
        StageStatus stageStatus2 = StageStatus.CLOSED;
        return !(stageStatus != null ? !((Object)((Object)stageStatus)).equals((Object)stageStatus2) : stageStatus2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$isAllowedToReopenStage$1(Stage x$17) {
        StageStatus stageStatus = x$17.getStatus();
        StageStatus stageStatus2 = StageStatus.CLOSED;
        return stageStatus == null ? stageStatus2 != null : !((Object)((Object)stageStatus)).equals((Object)stageStatus2);
    }

    public DeliveryStateManager(DeliveryObjectFactory factory) {
        this.factory = factory;
        this.delivery = factory.delivery();
        this.events = (Buffer)Buffer$.MODULE$.empty();
        this.messages = (Buffer)Buffer$.MODULE$.empty();
    }

    public static final /* synthetic */ Object $anonfun$markTrackedItemsInStage$1$adapted(TrackedItem x$2) {
        return BoxesRunTime.boxToBoolean((boolean)x$2.isDescoped());
    }

    public static final /* synthetic */ Object $anonfun$markTrackedItemsInStage$3$adapted(Stage x$4) {
        return BoxesRunTime.boxToBoolean((boolean)x$4.isClosed());
    }

    public static final /* synthetic */ Object $anonfun$markTrackedItemsInStage$6$adapted(Seq doneStatuses$1, StageTrackedItem stageItem) {
        return BoxesRunTime.boxToBoolean((boolean)doneStatuses$1.contains((Object)stageItem.getStatus()));
    }

    public static final /* synthetic */ Object $anonfun$markTrackedItemsInStage$8$adapted(Set doneItems$1, TrackedItem item) {
        return BoxesRunTime.boxToBoolean((boolean)doneItems$1.contains((Object)item.getId()));
    }

    public static final /* synthetic */ Object $anonfun$markTrackedItemsInStage$10$adapted(DeliveryStateManager $this, Stage stage$2, TrackedItemStatus status$1, String fromReleaseId$1, TrackedItem x$8) {
        $this.markTrackedItemInStage(x$8, stage$2, status$1, fromReleaseId$1);
        return BoxedUnit.UNIT;
    }
}

