/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.delivery.service;

import com.codahale.metrics.annotation.Timed;
import com.google.common.annotations.VisibleForTesting;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.xlrelease.api.v1.forms.AbstractDeliveryFilters;
import com.xebialabs.xlrelease.api.v1.forms.DeliveryOrderMode;
import com.xebialabs.xlrelease.api.v1.views.DeliveryFlowReleaseInfo;
import com.xebialabs.xlrelease.api.v1.views.DeliveryTimeline;
import com.xebialabs.xlrelease.db.ArchivedReleases;
import com.xebialabs.xlrelease.delivery.domain.Delivery;
import com.xebialabs.xlrelease.delivery.events.DeliveryCreatedEvent;
import com.xebialabs.xlrelease.delivery.repository.DeliveryRepository;
import com.xebialabs.xlrelease.delivery.repository.sql.persistence.CiIdWithTitle;
import com.xebialabs.xlrelease.delivery.security.DeliveryPermissions$;
import com.xebialabs.xlrelease.delivery.service.DeliveryServiceUtils;
import com.xebialabs.xlrelease.delivery.service.DeliveryStateManager;
import com.xebialabs.xlrelease.delivery.service.DeliveryStateManager$;
import com.xebialabs.xlrelease.delivery.service.DeliveryTimelineCalculator;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.repository.CiHelper;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.Page;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.service.ArchivingService;
import com.xebialabs.xlrelease.service.CiIdService;
import com.xebialabs.xlrelease.service.FolderService;
import com.xebialabs.xlrelease.service.ReleaseSearchService;
import com.xebialabs.xlrelease.service.ReleaseService;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.joda.time.DateTime;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.SetLike;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Service
@ScalaSignature(bytes="\u0006\u0001\t5g\u0001B\u0012%\u0001=B\u0001\"\u0012\u0001\u0003\u0006\u0004%\tA\u0012\u0005\t\u001b\u0002\u0011\t\u0011)A\u0005\u000f\"Aa\n\u0001BC\u0002\u0013\u0005q\n\u0003\u0005V\u0001\t\u0005\t\u0015!\u0003Q\u0011!1\u0006A!b\u0001\n\u00039\u0006\u0002C/\u0001\u0005\u0003\u0005\u000b\u0011\u0002-\t\u0011y\u0003!Q1A\u0005\u0002}C\u0001b\u0019\u0001\u0003\u0002\u0003\u0006I\u0001\u0019\u0005\tI\u0002\u0011)\u0019!C\u0001K\"A\u0011\u000e\u0001B\u0001B\u0003%a\r\u0003\u0005k\u0001\t\u0015\r\u0011\"\u0001l\u0011!y\u0007A!A!\u0002\u0013a\u0007\u0002\u00039\u0001\u0005\u000b\u0007I\u0011A9\t\u0011a\u0004!\u0011!Q\u0001\nID\u0001\"\u001f\u0001\u0003\u0006\u0004%\tA\u001f\u0005\t}\u0002\u0011\t\u0011)A\u0005w\"Iq\u0010\u0001BC\u0002\u0013\u0005\u0011\u0011\u0001\u0005\u000b\u0003'\u0001!\u0011!Q\u0001\n\u0005\r\u0001BCA\u000b\u0001\t\u0015\r\u0011\"\u0001\u0002\u0018!Q\u0011Q\u0005\u0001\u0003\u0002\u0003\u0006I!!\u0007\t\u000f\u0005\u001d\u0002\u0001\"\u0001\u0002*!9\u0011q\f\u0001\u0005\u0002\u0005\u0005\u0004bBAO\u0001\u0011\u0005\u0011q\u0014\u0005\b\u0003W\u0003A\u0011AAW\u0011\u001d\tY\u000b\u0001C\u0001\u0003\u0013Dq!a5\u0001\t\u0003\t)\u000eC\u0004\u0002^\u0002!\t!a8\t\u000f\u0005-\b\u0001\"\u0001\u0002n\"9!Q\u0006\u0001\u0005\u0002\t=\u0002b\u0002B+\u0001\u0011\u0005!q\u000b\u0005\b\u0005K\u0002A\u0011\u0001B4\u0011\u001d\u0011\t\t\u0001C\u0001\u0005\u0007CqA!(\u0001\t#\u0012y\nC\u0005\u0003*\u0002\t\n\u0011\"\u0005\u0003,\nyA)\u001a7jm\u0016\u0014\u0018pU3sm&\u001cWM\u0003\u0002&M\u000591/\u001a:wS\u000e,'BA\u0014)\u0003!!W\r\\5wKJL(BA\u0015+\u0003%AHN]3mK\u0006\u001cXM\u0003\u0002,Y\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u0002[\u0005\u00191m\\7\u0004\u0001M)\u0001\u0001\r\u001c?\u0005B\u0011\u0011\u0007N\u0007\u0002e)\t1'A\u0003tG\u0006d\u0017-\u0003\u00026e\t1\u0011I\\=SK\u001a\u0004\"a\u000e\u001f\u000e\u0003aR!!\u000f\u001e\u0002\u000bMdg\r\u000e6\u000b\u0003m\n\u0001b\u001a:jujdW\rZ\u0005\u0003{a\u0012q\u0001T8hO&tw\r\u0005\u0002@\u00016\tA%\u0003\u0002BI\tQB)\u001a7jm\u0016\u0014\u0018\u0010V5nK2Lg.Z\"bY\u000e,H.\u0019;peB\u0011qhQ\u0005\u0003\t\u0012\u0012A\u0003R3mSZ,'/_*feZL7-Z+uS2\u001c\u0018A\u00053fY&4XM]=SKB|7/\u001b;pef,\u0012a\u0012\t\u0003\u0011.k\u0011!\u0013\u0006\u0003\u0015\u001a\n!B]3q_NLGo\u001c:z\u0013\ta\u0015J\u0001\nEK2Lg/\u001a:z%\u0016\u0004xn]5u_JL\u0018a\u00053fY&4XM]=SKB|7/\u001b;pef\u0004\u0013!\u0005:fY\u0016\f7/\u001a*fa>\u001c\u0018\u000e^8ssV\t\u0001\u000b\u0005\u0002R'6\t!K\u0003\u0002KQ%\u0011AK\u0015\u0002\u0012%\u0016dW-Y:f%\u0016\u0004xn]5u_JL\u0018A\u0005:fY\u0016\f7/\u001a*fa>\u001c\u0018\u000e^8ss\u0002\naB]3mK\u0006\u001cXmU3sm&\u001cW-F\u0001Y!\tI6,D\u0001[\u0015\t)\u0003&\u0003\u0002]5\nq!+\u001a7fCN,7+\u001a:wS\u000e,\u0017a\u0004:fY\u0016\f7/Z*feZL7-\u001a\u0011\u0002!\u0005\u00148\r[5wS:<7+\u001a:wS\u000e,W#\u00011\u0011\u0005e\u000b\u0017B\u00012[\u0005A\t%o\u00195jm&twmU3sm&\u001cW-A\tbe\u000eD\u0017N^5oON+'O^5dK\u0002\nAC]3mK\u0006\u001cXmU3be\u000eD7+\u001a:wS\u000e,W#\u00014\u0011\u0005e;\u0017B\u00015[\u0005Q\u0011V\r\\3bg\u0016\u001cV-\u0019:dQN+'O^5dK\u0006)\"/\u001a7fCN,7+Z1sG\"\u001cVM\u001d<jG\u0016\u0004\u0013aC2j\u0013\u0012\u001cVM\u001d<jG\u0016,\u0012\u0001\u001c\t\u000336L!A\u001c.\u0003\u0017\rK\u0017\nZ*feZL7-Z\u0001\rG&LEmU3sm&\u001cW\rI\u0001\u0011CJ\u001c\u0007.\u001b<fIJ+G.Z1tKN,\u0012A\u001d\t\u0003gZl\u0011\u0001\u001e\u0006\u0003k\"\n!\u0001\u001a2\n\u0005]$(\u0001E!sG\"Lg/\u001a3SK2,\u0017m]3t\u0003E\t'o\u00195jm\u0016$'+\u001a7fCN,7\u000fI\u0001\u000eM>dG-\u001a:TKJ4\u0018nY3\u0016\u0003m\u0004\"!\u0017?\n\u0005uT&!\u0004$pY\u0012,'oU3sm&\u001cW-\u0001\bg_2$WM]*feZL7-\u001a\u0011\u0002\u0017I|G.Z*feZL7-Z\u000b\u0003\u0003\u0007\u0001B!!\u0002\u0002\u00105\u0011\u0011q\u0001\u0006\u0005\u0003\u0013\tY!\u0001\u0005tK\u000e,(/\u001b;z\u0015\r\tiAK\u0001\tI\u0016\u0004Hn\\=ji&!\u0011\u0011CA\u0004\u0005-\u0011v\u000e\\3TKJ4\u0018nY3\u0002\u0019I|G.Z*feZL7-\u001a\u0011\u0002\u0011\u00154XM\u001c;CkN,\"!!\u0007\u0011\t\u0005m\u0011\u0011E\u0007\u0003\u0003;Q1!a\b)\u0003\u0019)g/\u001a8ug&!\u00111EA\u000f\u0005EAFJU3mK\u0006\u001cX-\u0012<f]R\u0014Uo]\u0001\nKZ,g\u000e\u001e\"vg\u0002\na\u0001P5oSRtDCFA\u0016\u0003[\ty#!\r\u00024\u0005U\u0012qGA\u001d\u0003w\ti$a\u0010\u0011\u0005}\u0002\u0001\"B#\u0016\u0001\u00049\u0005\"\u0002(\u0016\u0001\u0004\u0001\u0006\"\u0002,\u0016\u0001\u0004A\u0006\"\u00020\u0016\u0001\u0004\u0001\u0007\"\u00023\u0016\u0001\u00041\u0007\"\u00026\u0016\u0001\u0004a\u0007\"\u00029\u0016\u0001\u0004\u0011\b\"B=\u0016\u0001\u0004Y\bBB@\u0016\u0001\u0004\t\u0019\u0001C\u0004\u0002\u0016U\u0001\r!!\u0007)\u0007U\t\u0019\u0005\u0005\u0003\u0002F\u0005mSBAA$\u0015\u0011\tI%a\u0013\u0002\u0015\u0005tgn\u001c;bi&|gN\u0003\u0003\u0002N\u0005=\u0013a\u00024bGR|'/\u001f\u0006\u0005\u0003#\n\u0019&A\u0003cK\u0006t7O\u0003\u0003\u0002V\u0005]\u0013aD:qe&twM\u001a:b[\u0016<xN]6\u000b\u0005\u0005e\u0013aA8sO&!\u0011QLA$\u0005%\tU\u000f^8xSJ,G-A\u0006hKR$U\r\\5wKJLH\u0003BA2\u0003_\u0002B!!\u001a\u0002l5\u0011\u0011q\r\u0006\u0004\u0003S2\u0013A\u00023p[\u0006Lg.\u0003\u0003\u0002n\u0005\u001d$\u0001\u0003#fY&4XM]=\t\u000f\u0005Ed\u00031\u0001\u0002t\u0005QA-\u001a7jm\u0016\u0014\u00180\u00133\u0011\t\u0005U\u00141\u0011\b\u0005\u0003o\ny\bE\u0002\u0002zIj!!a\u001f\u000b\u0007\u0005ud&\u0001\u0004=e>|GOP\u0005\u0004\u0003\u0003\u0013\u0014A\u0002)sK\u0012,g-\u0003\u0003\u0002\u0006\u0006\u001d%AB*ue&twMC\u0002\u0002\u0002JB3AFAF!\u0011\ti)!'\u000e\u0005\u0005=%\u0002BA%\u0003#SA!a%\u0002\u0016\u00069Q.\u001a;sS\u000e\u001c(bAALY\u0005A1m\u001c3bQ\u0006dW-\u0003\u0003\u0002\u001c\u0006=%!\u0002+j[\u0016$\u0017AD3ySN$8\u000fR3mSZ,'/\u001f\u000b\u0005\u0003C\u000b9\u000bE\u00022\u0003GK1!!*3\u0005\u001d\u0011un\u001c7fC:Dq!!\u001d\u0018\u0001\u0004\t\u0019\bK\u0002\u0018\u0003\u0017\u000bab\u0019:fCR,G)\u001a7jm\u0016\u0014\u0018\u0010\u0006\u0003\u0002d\u0005=\u0006BB\u0014\u0019\u0001\u0004\t\u0019\u0007K\u0002\u0019\u0003g\u0003B!!.\u0002D6\u0011\u0011q\u0017\u0006\u0005\u0003s\u000bY,A\u0006b]:|G/\u0019;j_:\u001c(\u0002BA_\u0003\u007f\u000baaY8n[>t'bAAaY\u00051qm\\8hY\u0016LA!!2\u00028\n\tb+[:jE2,gi\u001c:UKN$\u0018N\\4)\u0007a\tY\t\u0006\u0004\u0002d\u0005-\u0017Q\u001a\u0005\u0007Oe\u0001\r!a\u0019\t\u000f\u0005=\u0017\u00041\u0001\u0002\"\u0006I!/Z<sSR,\u0017\n\u001a\u0015\u00043\u0005-\u0015AD;qI\u0006$X\rR3mSZ,'/\u001f\u000b\u0005\u0003G\n9\u000eC\u0004\u0002Zj\u0001\r!a\u0019\u0002\u000fU\u0004H-\u0019;fI\"\u001a!$a#\u0002\u001d\u0011,G.\u001a;f\t\u0016d\u0017N^3ssR!\u0011\u0011]At!\r\t\u00141]\u0005\u0004\u0003K\u0014$\u0001B+oSRDq!!\u001d\u001c\u0001\u0004\t\u0019\bK\u0002\u001c\u0003\u0017\u000baa]3be\u000eDG\u0003CAx\u0003\u007f\u00149B!\t\u0011\r\u0005E\u00181`A2\u001b\t\t\u0019P\u0003\u0003\u0002v\u0006]\u0018\u0001B;uS2T!!!?\u0002\t)\fg/Y\u0005\u0005\u0003{\f\u0019P\u0001\u0003MSN$\bb\u0002B\u00019\u0001\u0007!1A\u0001\bM&dG/\u001a:t!\u0011\u0011)Aa\u0005\u000e\u0005\t\u001d!\u0002\u0002B\u0005\u0005\u0017\tQAZ8s[NTAA!\u0004\u0003\u0010\u0005\u0011a/\r\u0006\u0004\u0005#A\u0013aA1qS&!!Q\u0003B\u0004\u0005]\t%m\u001d;sC\u000e$H)\u001a7jm\u0016\u0014\u0018PR5mi\u0016\u00148\u000fC\u0004\u0003\u001aq\u0001\rAa\u0007\u0002\tA\fw-\u001a\t\u0004#\nu\u0011b\u0001B\u0010%\n!\u0001+Y4f\u0011\u001d\u0011\u0019\u0003\ba\u0001\u0005K\tqa\u001c:eKJ\u0014\u0015\u0010\u0005\u0003\u0003\u0006\t\u001d\u0012\u0002\u0002B\u0015\u0005\u000f\u0011\u0011\u0003R3mSZ,'/_(sI\u0016\u0014Xj\u001c3fQ\ra\u00121R\u0001\fO\u0016$H+[7fY&tW\r\u0006\u0004\u00032\tu\"q\b\t\u0005\u0005g\u0011I$\u0004\u0002\u00036)!!q\u0007B\u0006\u0003\u00151\u0018.Z<t\u0013\u0011\u0011YD!\u000e\u0003!\u0011+G.\u001b<fef$\u0016.\\3mS:,\u0007bBA9;\u0001\u0007\u00111\u000f\u0005\b\u0005\u0003j\u0002\u0019\u0001B\"\u0003\rqwn\u001e\t\u0005\u0005\u000b\u0012y%\u0004\u0002\u0003H)!!\u0011\nB&\u0003\u0011!\u0018.\\3\u000b\t\t5\u0013qK\u0001\u0005U>$\u0017-\u0003\u0003\u0003R\t\u001d#\u0001\u0003#bi\u0016$\u0016.\\3)\u0007u\tY)A\u0006hKR\u0014V\r\\3bg\u0016\u001cH\u0003\u0002B-\u0005C\u0002b!!=\u0002|\nm\u0003\u0003\u0002B\u001a\u0005;JAAa\u0018\u00036\t9B)\u001a7jm\u0016\u0014\u0018P\u00127poJ+G.Z1tK&sgm\u001c\u0005\b\u0003cr\u0002\u0019AA:Q\rq\u00121R\u0001!M&tG\rR3mSZ,'/[3t%\u00164WM]3oG&twMU3mK\u0006\u001cX\r\u0006\u0003\u0003j\tm\u0004C\u0002B6\u0005k\n\u0019H\u0004\u0003\u0003n\tEd\u0002BA=\u0005_J\u0011aM\u0005\u0004\u0005g\u0012\u0014a\u00029bG.\fw-Z\u0005\u0005\u0005o\u0012IHA\u0002TKFT1Aa\u001d3\u0011\u001d\u0011ih\ba\u0001\u0003g\n\u0011B]3mK\u0006\u001cX-\u00133)\u0007}\tY)A\u0013gS:$\u0017i\u0019;jm\u0016$U\r\\5wKJLWm\u001d*fM\u0016\u0014XM\\2j]\u001e4u\u000e\u001c3feR!!Q\u0011BL!\u0019\u0011YG!\u001e\u0003\bB!!\u0011\u0012BJ\u001b\t\u0011YI\u0003\u0003\u0003\u000e\n=\u0015a\u00039feNL7\u000f^3oG\u0016T1A!%J\u0003\r\u0019\u0018\u000f\\\u0005\u0005\u0005+\u0013YIA\u0007DS&#w+\u001b;i)&$H.\u001a\u0005\b\u00053\u0003\u0003\u0019AA:\u0003!1w\u000e\u001c3fe&#\u0007f\u0001\u0011\u0002\f\u0006\u00012\r[3dW&\u001bX\u000b\u001d3bi\u0006\u0014G.\u001a\u000b\u0007\u0003C\u0014\tK!*\t\u000f\t\r\u0016\u00051\u0001\u0002d\u0005\u0001R\r_5ti&tw\rR3mSZ,'/\u001f\u0005\n\u0005O\u000b\u0003\u0013!a\u0001\u0003g\na!Y2uS>t\u0017AG2iK\u000e\\\u0017j]+qI\u0006$\u0018M\u00197fI\u0011,g-Y;mi\u0012\u0012TC\u0001BWU\u0011\t\u0019Ha,,\u0005\tE\u0006\u0003\u0002BZ\u0005wk!A!.\u000b\t\t]&\u0011X\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\u00133\u0013\u0011\u0011iL!.\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rK\u0002\u0001\u0005\u0003\u0004BAa1\u0003J6\u0011!Q\u0019\u0006\u0005\u0005\u000f\f\u0019&\u0001\u0006ti\u0016\u0014Xm\u001c;za\u0016LAAa3\u0003F\n91+\u001a:wS\u000e,\u0007")
public class DeliveryService
implements DeliveryTimelineCalculator,
DeliveryServiceUtils {
    private final DeliveryRepository deliveryRepository;
    private final ReleaseRepository releaseRepository;
    private final ReleaseService releaseService;
    private final ArchivingService archivingService;
    private final ReleaseSearchService releaseSearchService;
    private final CiIdService ciIdService;
    private final ArchivedReleases archivedReleases;
    private final FolderService folderService;
    private final RoleService roleService;
    private final XLReleaseEventBus eventBus;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    @Override
    @Timed
    public Delivery getDeliveryOrPattern(String deliveryId) {
        return DeliveryServiceUtils.getDeliveryOrPattern$(this, deliveryId);
    }

    @Override
    @Timed
    public String getFolderId(String deliveryId) {
        return DeliveryServiceUtils.getFolderId$(this, deliveryId);
    }

    @Override
    public Delivery doUpdate(Delivery updated) {
        return DeliveryServiceUtils.doUpdate$(this, updated);
    }

    @Override
    public void doDelete(String deliveryId) {
        DeliveryServiceUtils.doDelete$(this, deliveryId);
    }

    @Override
    public void validate(Delivery delivery) {
        DeliveryServiceUtils.validate$(this, delivery);
    }

    @Override
    public void validateDelivery(Delivery delivery) {
        DeliveryServiceUtils.validateDelivery$(this, delivery);
    }

    @Override
    public void checkIsDelivery(Delivery delivery) {
        DeliveryServiceUtils.checkIsDelivery$(this, delivery);
    }

    @Override
    public Iterable<String> currentPrincipals() {
        return DeliveryServiceUtils.currentPrincipals$(this);
    }

    @Override
    public Buffer<String> currentRoleIds() {
        return DeliveryServiceUtils.currentRoleIds$(this);
    }

    @Override
    public void computeAndUpdateDates(Delivery delivery, int durationOpt, Date startDateOpt, Date endDateOpt) {
        DeliveryServiceUtils.computeAndUpdateDates$(this, delivery, durationOpt, startDateOpt, endDateOpt);
    }

    @Override
    public int computeAndUpdateDates$default$2() {
        return DeliveryServiceUtils.computeAndUpdateDates$default$2$(this);
    }

    @Override
    public Date computeAndUpdateDates$default$3() {
        return DeliveryServiceUtils.computeAndUpdateDates$default$3$(this);
    }

    @Override
    public Date computeAndUpdateDates$default$4() {
        return DeliveryServiceUtils.computeAndUpdateDates$default$4$(this);
    }

    @Override
    public DeliveryTimeline calculateTimeline(Delivery delivery, DateTime now) {
        return DeliveryTimelineCalculator.calculateTimeline$(this, delivery, now);
    }

    @Override
    public <A extends DateTime> Ordering<A> dateOrdering() {
        return DeliveryTimelineCalculator.dateOrdering$(this);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        DeliveryService deliveryService = this;
        synchronized (deliveryService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    @Override
    public DeliveryRepository deliveryRepository() {
        return this.deliveryRepository;
    }

    @Override
    public ReleaseRepository releaseRepository() {
        return this.releaseRepository;
    }

    @Override
    public ReleaseService releaseService() {
        return this.releaseService;
    }

    public ArchivingService archivingService() {
        return this.archivingService;
    }

    public ReleaseSearchService releaseSearchService() {
        return this.releaseSearchService;
    }

    public CiIdService ciIdService() {
        return this.ciIdService;
    }

    @Override
    public ArchivedReleases archivedReleases() {
        return this.archivedReleases;
    }

    @Override
    public FolderService folderService() {
        return this.folderService;
    }

    @Override
    public RoleService roleService() {
        return this.roleService;
    }

    @Override
    public XLReleaseEventBus eventBus() {
        return this.eventBus;
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public Delivery getDelivery(String deliveryId) {
        void var2_2;
        Delivery delivery = this.getDeliveryOrPattern(deliveryId);
        this.checkIsDelivery(delivery);
        return var2_2;
    }

    @Timed
    public boolean existsDelivery(String deliveryId) {
        return this.deliveryRepository().exists(deliveryId);
    }

    @Timed
    @VisibleForTesting
    public Delivery createDelivery(Delivery delivery) {
        return this.createDelivery(delivery, true);
    }

    @Timed
    public Delivery createDelivery(Delivery delivery, boolean rewriteId) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(32).append("Creating new release delivery [").append((Object)delivery).append("]").toString());
        this.validateDelivery(delivery);
        String deliveryId = rewriteId || delivery.getId() == null || !Ids.isDeliveryId((String)delivery.getId()) ? this.ciIdService().getUniqueId(Type.valueOf(Delivery.class), "Deliveries") : delivery.getId();
        delivery.setId(deliveryId);
        CiHelper.rewriteWithNewId((ConfigurationItem)delivery, (String)deliveryId);
        DeliveryStateManager manager = DeliveryStateManager$.MODULE$.apply(delivery, this.ciIdService());
        Delivery startedDelivery = manager.start();
        this.deliveryRepository().create(delivery);
        this.eventBus().publish((XLReleaseEvent)new DeliveryCreatedEvent(delivery));
        manager.getEvents().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            DeliveryService.$anonfun$createDelivery$2(this, x$1);
            return BoxedUnit.UNIT;
        });
        return startedDelivery;
    }

    @Timed
    public Delivery updateDelivery(Delivery updated) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("Updating release delivery [").append((Object)updated).append("]").toString());
        this.validateDelivery(updated);
        return this.doUpdate(updated);
    }

    @Timed
    public void deleteDelivery(String deliveryId) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("Deleting release delivery [").append(deliveryId).append("]").toString());
        Delivery delivery = this.deliveryRepository().read(deliveryId);
        this.checkIsDelivery(delivery);
        this.doDelete(deliveryId);
    }

    @Timed
    public List<Delivery> search(AbstractDeliveryFilters filters, Page page, DeliveryOrderMode orderBy) {
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.deliveryRepository().search(filters, page, orderBy, this.currentPrincipals(), (Iterable<String>)this.currentRoleIds(), DeliveryPermissions$.MODULE$.VIEW_DELIVERY_PERMISSION_SET())).asJava();
    }

    @Timed
    public DeliveryTimeline getTimeline(String deliveryId, DateTime now) {
        Delivery delivery = this.getDelivery(deliveryId);
        return this.calculateTimeline(delivery, now);
    }

    @Timed
    public List<DeliveryFlowReleaseInfo> getReleases(String deliveryId) {
        Seq<DeliveryFlowReleaseInfo> releases = this.deliveryRepository().findReleasesByDeliveryId(deliveryId);
        Set<String> allReleaseIds = this.deliveryRepository().getByIdOrTitle(deliveryId).getReleaseIds();
        Seq seq = ((SetLike)((TraversableLike)JavaConverters$.MODULE$.asScalaSetConverter(allReleaseIds).asScala()).filterNot((Function1 & Serializable & scala.Serializable)fullId -> BoxesRunTime.boxToBoolean((boolean)DeliveryService.$anonfun$getReleases$1(releases, fullId)))).toSeq();
        Seq seq2 = Nil$.MODULE$.equals(seq) ? (Seq)Seq$.MODULE$.empty() : (Seq)this.archivingService().searchReleasesBasicExtByReleaseIds(seq).map((Function1 & Serializable & scala.Serializable)item -> new DeliveryFlowReleaseInfo(Ids.getName((String)item.id()), item.title(), item.status(), item.startDate(), item.endDate(), true), Seq$.MODULE$.canBuildFrom());
        Seq archivedReleases = seq2;
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)releases.$plus$plus((GenTraversableOnce)archivedReleases, Seq$.MODULE$.canBuildFrom())).asJava();
    }

    @Timed
    public Seq<String> findDeliveriesReferencingRelease(String releaseId) {
        return this.deliveryRepository().findDeliveriesReferencingReleaseId(releaseId);
    }

    @Timed
    public Seq<CiIdWithTitle> findActiveDeliveriesReferencingFolder(String folderId) {
        return this.deliveryRepository().findActiveDeliveriesReferencingFolderId(folderId);
    }

    @Override
    public void checkIsUpdatable(Delivery existingDelivery, String action) {
        Checks.checkArgument((boolean)existingDelivery.isUpdatable(), (String)new StringBuilder(42).append("Cannot ").append(action).append(" release delivery '").append(existingDelivery.getTitle()).append("' because it is ").append((Object)existingDelivery.getStatus()).toString(), (Object[])new Object[0]);
    }

    @Override
    public String checkIsUpdatable$default$2() {
        return "update";
    }

    public static final /* synthetic */ void $anonfun$createDelivery$2(DeliveryService $this, XLReleaseEvent x$1) {
        $this.eventBus().publish(x$1);
    }

    public static final /* synthetic */ boolean $anonfun$getReleases$1(Seq releases$1, String fullId) {
        return ((SeqLike)releases$1.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getId(), Seq$.MODULE$.canBuildFrom())).contains((Object)Ids.getName((String)fullId));
    }

    @Autowired
    public DeliveryService(DeliveryRepository deliveryRepository, ReleaseRepository releaseRepository, ReleaseService releaseService, ArchivingService archivingService, ReleaseSearchService releaseSearchService, CiIdService ciIdService, ArchivedReleases archivedReleases, FolderService folderService, RoleService roleService, XLReleaseEventBus eventBus) {
        this.deliveryRepository = deliveryRepository;
        this.releaseRepository = releaseRepository;
        this.releaseService = releaseService;
        this.archivingService = archivingService;
        this.releaseSearchService = releaseSearchService;
        this.ciIdService = ciIdService;
        this.archivedReleases = archivedReleases;
        this.folderService = folderService;
        this.roleService = roleService;
        this.eventBus = eventBus;
        Logging.$init$((Logging)this);
        DeliveryTimelineCalculator.$init$(this);
        DeliveryServiceUtils.$init$(this);
    }
}

