/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.security.authentication;

import com.xebialabs.xlrelease.principaldata.LdapGroupEmailProvider;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.authentication.InternalAuthenticationServiceException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.ldap.authentication.LdapAuthenticator;
import org.springframework.security.ldap.userdetails.LdapAuthoritiesPopulator;

public class LdapAuthenticationProvider
extends org.springframework.security.ldap.authentication.LdapAuthenticationProvider {
    private LdapGroupEmailProvider groupEmailProvider;

    public LdapAuthenticationProvider(LdapAuthenticator authenticator, LdapAuthoritiesPopulator authoritiesPopulator, LdapGroupEmailProvider groupEmailProvider) {
        super(authenticator, authoritiesPopulator);
        this.groupEmailProvider = groupEmailProvider;
    }

    public LdapAuthenticationProvider(LdapAuthenticator authenticator, LdapAuthoritiesPopulator authoritiesPopulator) {
        super(authenticator, authoritiesPopulator);
    }

    public LdapAuthenticationProvider(LdapAuthenticator authenticator) {
        super(authenticator);
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        try {
            return super.authenticate(authentication);
        }
        catch (InternalAuthenticationServiceException e) {
            throw new AuthenticationServiceException(e.getMessage(), e.getCause());
        }
    }

    public LdapGroupEmailProvider getGroupEmailProvider() {
        return this.groupEmailProvider;
    }
}

