/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.script;

import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xlrelease.api.XLReleaseServiceHolder;
import com.xebialabs.xlrelease.api.v1.TaskReportingApi;
import com.xebialabs.xlrelease.api.v1.script.TaskReportingApiHolder;
import com.xebialabs.xlrelease.domain.Configuration;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.security.FacetPermissionChecker;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import com.xebialabs.xlrelease.service.FacetService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.script.ScriptContext;
import javax.script.SimpleScriptContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XlrScriptContext
extends SimpleScriptContext {
    private static final Logger scriptLogger = LoggerFactory.getLogger((String)"xlrelease.script");
    static final String ATTRIBUTE_RELEASE_VARIABLES = "_releaseVariables";
    static final String ATTRIBUTE_GLOBAL_VARIABLES = "_globalVariables";
    static final String ATTRIBUTE_FOLDER_VARIABLES = "_folderVariables";
    public static final String ATTR_RELEASE = "release";
    public static final String ATTR_PHASE = "phase";
    public static final String ATTR_TASK = "task";
    public static final String ATTR_VALUE_PROVIDER = "_valueProvider";
    public static final String ATTR_VALUE_PROVIDER_RESULT = "result";
    public static final String CONFIGURATION_ID_PROPERTY_NAME = "id";
    private String scriptPathForLog;

    public void addDomainObjects(Task task) {
        Release release = task.getRelease();
        this.setAttribute(ATTR_RELEASE, release, 100);
        this.setAttribute(ATTR_PHASE, task.getPhase(), 100);
        this.setAttribute(ATTR_TASK, task, 100);
    }

    public void addApi() {
        XLReleaseServiceHolder.getApiServices().forEach(apiService -> this.setAttribute("_" + apiService.serviceName(), apiService, 100));
    }

    public void addCustomScriptApi(FacetService facetService, PermissionChecker permissions, FacetPermissionChecker facetPermissions) {
        XLReleaseServiceHolder.getApiServices().stream().filter(service -> !(service instanceof TaskReportingApi)).forEach(apiService -> this.setAttribute("_" + apiService.serviceName(), apiService, 100));
        this.setAttribute("_taskReportingApi", TaskReportingApiHolder.apply(facetService, permissions, facetPermissions), 100);
    }

    public void addScriptLogger() {
        this.setAttribute("logger", scriptLogger, 100);
    }

    void addReleaseVariables(Release release, PermissionChecker permissions, Map<String, Object> releaseVariables) {
        if (permissions.isNotAuthenticated() || !permissions.hasPermission(XLReleasePermissions.EDIT_RELEASE, release)) {
            releaseVariables = Collections.unmodifiableMap(releaseVariables);
        }
        this.setAttribute(ATTRIBUTE_RELEASE_VARIABLES, releaseVariables, 100);
    }

    void addGlobalVariables(PermissionChecker permissions, Map<String, Object> globalVariables) {
        if (permissions.isNotAuthenticated() || !permissions.hasGlobalPermission(XLReleasePermissions.EDIT_GLOBAL_VARIABLES)) {
            globalVariables = Collections.unmodifiableMap(globalVariables);
        }
        this.setAttribute(ATTRIBUTE_GLOBAL_VARIABLES, globalVariables, 100);
    }

    void addFolderVariables(String folderId, PermissionChecker permissions, Map<String, Object> folderVariables) {
        if (permissions.isNotAuthenticated() || !permissions.hasPermission(XLReleasePermissions.EDIT_FOLDER_VARIABLES, folderId)) {
            folderVariables = Collections.unmodifiableMap(folderVariables);
        }
        this.setAttribute(ATTRIBUTE_FOLDER_VARIABLES, folderVariables, 100);
    }

    public void addProperties(ConfigurationItem configurationItem, Collection<PropertyDescriptor> properties) {
        for (PropertyDescriptor propertyDescriptor : properties) {
            String propertyName = propertyDescriptor.getName();
            if (this.ciIsSubTypeOfConfiguration(propertyDescriptor)) {
                this.setAttribute(propertyName, this.getPropertiesMap(configurationItem, propertyName), 100);
                continue;
            }
            this.setAttribute(propertyName, configurationItem.getProperty(propertyName), 100);
            this.addBindingToSugarify(propertyName, this, "_contextBindingsToWrap");
        }
    }

    public void addPropertyBindings(Collection<PropertyDescriptor> properties) {
        properties.forEach(pd -> this.addBindingToSugarify(pd.getName(), this, "_contextBindingsToUnwrap"));
    }

    public void setScriptPathForLog(String scriptPathForLog) {
        this.scriptPathForLog = scriptPathForLog;
    }

    public String getScriptPathForLog() {
        return this.scriptPathForLog;
    }

    private Map<String, Object> getPropertiesMap(ConfigurationItem configurationItem, String propertyName) {
        Configuration ciProperty = (Configuration)configurationItem.getProperty(propertyName);
        HashMap<String, Object> ciProperties = null;
        if (null != ciProperty) {
            ciProperties = new HashMap<String, Object>();
            ciProperties.put(CONFIGURATION_ID_PROPERTY_NAME, ciProperty.getId());
            Descriptor descriptor = ciProperty.getType().getDescriptor();
            for (PropertyDescriptor ciPropertyDescriptor : descriptor.getPropertyDescriptors()) {
                ciProperties.put(ciPropertyDescriptor.getName(), ciProperty.getProperty(ciPropertyDescriptor.getName()));
            }
        }
        return ciProperties;
    }

    private boolean ciIsSubTypeOfConfiguration(PropertyDescriptor propertyDescriptor) {
        return propertyDescriptor.getKind() == PropertyKind.CI && propertyDescriptor.getReferencedType().isSubTypeOf(Type.valueOf(Configuration.class));
    }

    private void addBindingToSugarify(String bindingName, ScriptContext scriptContext, String sugarifyType) {
        ArrayList<String> sugarifiedNames = (ArrayList<String>)scriptContext.getAttribute(sugarifyType);
        if (sugarifiedNames == null) {
            sugarifiedNames = new ArrayList<String>();
            scriptContext.setAttribute(sugarifyType, sugarifiedNames, 100);
        }
        sugarifiedNames.add(bindingName);
    }

    public Collection<Object> getValueProviderResult() {
        return (Collection)this.getAttribute(ATTR_VALUE_PROVIDER_RESULT, 100);
    }
}

