/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.events;

import com.xebialabs.xlrelease.domain.events.EventBus;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.user.User;
import java.lang.reflect.InvocationTargetException;
import net.engio.mbassy.bus.IMessagePublication;
import net.engio.mbassy.bus.MBassador;
import net.engio.mbassy.bus.error.PublicationError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class XLReleaseEventBus
implements EventBus {
    private static final Logger logger = LoggerFactory.getLogger(XLReleaseEventBus.class);
    private MBassador bus = new MBassador(this::handleError);

    public void register(Object listener) {
        this.bus.subscribe(listener);
    }

    public void deregister(Object listener) {
        this.bus.unsubscribe(listener);
    }

    public void publish(XLReleaseEvent event) {
        this.fillUsername(event);
        logger.debug("Publishing event [{}]", (Object)event);
        this.bus.publish((Object)event);
    }

    public void publishAndFailOnError(XLReleaseEvent event) {
        this.fillUsername(event);
        IMessagePublication pub = this.bus.publish((Object)event);
        if (pub.hasError()) {
            Throwable target;
            Throwable cause = pub.getError().getCause();
            if (cause instanceof InvocationTargetException && (target = ((InvocationTargetException)cause).getTargetException()) instanceof RuntimeException) {
                throw (RuntimeException)target;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
        }
    }

    private void fillUsername(XLReleaseEvent event) {
        String userName = User.AUTHENTICATED_USER.getName();
        event.username_$eq(userName != null ? userName : "SYSTEM");
    }

    private void handleError(PublicationError error) {
        if (null != error.getCause()) {
            logger.error(error.getMessage(), error.getCause());
        } else {
            logger.error(error.toString());
        }
    }
}

