/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github.extras;

import com.squareup.okhttp.ConnectionSpec;
import com.squareup.okhttp.OkUrlFactory;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import org.kohsuke.github.HttpConnector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OkHttpConnector
implements HttpConnector {
    private final OkUrlFactory urlFactory;

    public OkHttpConnector(OkUrlFactory urlFactory) {
        urlFactory.client().setSslSocketFactory(this.TlsSocketFactory());
        urlFactory.client().setConnectionSpecs(this.TlsConnectionSpecs());
        this.urlFactory = urlFactory;
    }

    @Override
    public HttpURLConnection connect(URL url) throws IOException {
        return this.urlFactory.open(url);
    }

    private SSLSocketFactory TlsSocketFactory() {
        SSLContext sc;
        try {
            sc = SSLContext.getInstance("TLSv1.2");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        try {
            sc.init(null, null, null);
            return sc.getSocketFactory();
        }
        catch (KeyManagementException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private List<ConnectionSpec> TlsConnectionSpecs() {
        return Arrays.asList(ConnectionSpec.MODERN_TLS, ConnectionSpec.CLEARTEXT);
    }
}

