import React, {Component} from 'react';
import PropTypes from 'prop-types';
import moment from 'moment';

const angularJsDateFormatToMomentFormat = {
    'd/M/yy': 'D/M/YY',
    'M/d/yy': 'M/D/YY',
    'dd/MM/yy': 'DD/MM/YY',
    'yy/MM/dd': 'YY/MM/DD'
};

const angularJsTimeFormatToMomentFormat = {
    'HH:mm': 'HH:mm',
    'h:mm a': 'h:mm A',
};

export class DisplayDateComponent extends Component {
    static propTypes = {
        color: PropTypes.string,
        date: PropTypes.number.isRequired,
        dateFormat: PropTypes.string,
        isLink: PropTypes.bool,
        timeFormat: PropTypes.string
    };

    static defaultProps = {
        dateFormat: 'YYYY-MM-DD',
        timeFormat: 'h:mm A'
    };

    constructor(props) {
        super(props);
    }

    parseDateTime = (date, dateFormat, timeFormat) => {
        let format = `${dateFormat} ${timeFormat}`;
        if (angularJsDateFormatToMomentFormat[dateFormat] ) {
            format = `${angularJsDateFormatToMomentFormat[dateFormat]}`;
            if (angularJsTimeFormatToMomentFormat[timeFormat]) {
                format = `${format} ${angularJsTimeFormatToMomentFormat[timeFormat]}`;
            } else {
                format = `${format} ${timeFormat}`;
            }
        } else {
            // can't find an appropriate format, use default
            format = `YYYY-MM-DD h:mm A`;
        }
        return format;
    };

    render() {
        const {date, dateFormat, isLink, color, timeFormat} = this.props;
        const format = this.parseDateTime(date, dateFormat, timeFormat);

        const style = {
            color: color || '#333333'
        };
        let displayDate = <span style={style}>{moment(date).format(format)}</span>;

        if (isLink) {
            displayDate = <a href={'#/calendar?month=' + moment(date).format('MM-YYYY')} style={style}>{moment(date).format(format)}</a>;
        }
        return displayDate;
    }
}
