/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.io;

import de.schlichtherle.truezip.io.InputException;
import de.schlichtherle.truezip.util.ThreadGroups;
import de.schlichtherle.truezip.util.Throwables;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.Queue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.WillClose;
import javax.annotation.WillNotClose;
import javax.annotation.concurrent.Immutable;

@Immutable
public class Streams {
    static final int FIFO_SIZE = 4;
    public static final int BUFFER_SIZE = 8192;
    private static final ExecutorService executor = Executors.newCachedThreadPool(new ReaderThreadFactory());

    private Streams() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(@WillClose InputStream in, @WillClose OutputStream out) throws IOException {
        try {
            Streams.cat(in, out);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException ex) {
                throw new InputException(ex);
            }
            finally {
                out.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static void cat(final @WillNotClose InputStream in, @WillNotClose OutputStream out) throws IOException {
        if (null == in || null == out) {
            throw new NullPointerException();
        }
        lock = new ReentrantLock();
        signal = lock.newCondition();
        buffers = Buffer.allocate();
        interrupted = false;
        try {
            reader = new ReaderTask();
            result = Streams.executor.submit(reader);
            buffersLength = buffers.length;
            while (true) lbl-1000:
            // 3 sources

            {
                lock.lock();
                try {
                    while (0 >= reader.size) {
                        try {
                            signal.await();
                        }
                        catch (InterruptedException interrupt) {
                            interrupted = true;
                        }
                    }
                    off = reader.off;
                    buffer = buffers[off];
                }
                finally {
                    lock.unlock();
                }
                write = buffer.read;
                if (write == -1) ** break;
                try {
                    buf = buffer.buf;
                    out.write(buf, 0, write);
                }
                catch (IOException ex) {
                    Streams.cancel(result);
                    throw ex;
                }
                catch (RuntimeException ex) {
                    Streams.cancel(result);
                    throw ex;
                }
                catch (Error ex) {
                    Streams.cancel(result);
                    throw ex;
                }
                lock.lock();
                try {
                    reader.off = (off + 1) % buffersLength;
                    --reader.size;
                    signal.signal();
                }
                finally {
                    lock.unlock();
                    continue;
                }
                break;
            }
            ** GOTO lbl-1000
            out.flush();
            ex = reader.exception;
            if (null != ex) {
                if (ex instanceof InputException) {
                    throw (InputException)ex;
                }
                if (ex instanceof IOException) {
                    throw new InputException((IOException)ex);
                }
                if (ex instanceof RuntimeException) {
                    throw (RuntimeException)Throwables.wrap(ex);
                }
                throw (Error)Throwables.wrap(ex);
            }
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
            Buffer.release(buffers);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cancel(Future<?> result) {
        result.cancel(true);
        boolean interrupted = false;
        try {
            while (true) {
                try {
                    result.get();
                }
                catch (CancellationException cancelled) {
                }
                catch (ExecutionException cannotHappen) {
                    throw new AssertionError((Object)cannotHappen);
                }
                catch (InterruptedException interrupt) {
                    interrupted = true;
                    continue;
                }
                break;
            }
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public static final class ReaderThread
    extends Thread {
        ReaderThread(Runnable r) {
            super(ThreadGroups.getServerThreadGroup(), r, ReaderThread.class.getName());
            this.setDaemon(true);
        }
    }

    private static final class ReaderThreadFactory
    implements ThreadFactory {
        private ReaderThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            return new ReaderThread(r);
        }
    }

    private static final class Buffer {
        static final Queue<Reference<Buffer[]>> queue = new ConcurrentLinkedQueue<Reference<Buffer[]>>();
        final byte[] buf = new byte[8192];
        int read;

        private Buffer() {
        }

        static Buffer[] allocate() {
            Reference<Buffer[]> reference;
            while (null != (reference = queue.poll())) {
                Buffer[] buffers = reference.get();
                if (null == buffers) continue;
                return buffers;
            }
            Buffer[] buffers = new Buffer[4];
            int i = buffers.length;
            while (0 <= --i) {
                buffers[i] = new Buffer();
            }
            return buffers;
        }

        static void release(Buffer[] buffers) {
            queue.add(new SoftReference<Buffer[]>(buffers));
        }
    }
}

