/*
 * Decompiled with CFR 0.152.
 */
package akka.cluster;

import akka.actor.Actor;
import akka.actor.ActorContext;
import akka.actor.ActorLogging;
import akka.actor.ActorRef;
import akka.actor.ActorSelection;
import akka.actor.ActorSelection$;
import akka.actor.Address;
import akka.actor.Cancellable;
import akka.actor.NoSerializationVerificationNeeded;
import akka.actor.SupervisorStrategy;
import akka.actor.package$;
import akka.annotation.InternalApi;
import akka.cluster.Cluster;
import akka.cluster.Cluster$;
import akka.cluster.ClusterEvent;
import akka.cluster.ClusterHeartbeatReceiver$;
import akka.cluster.ClusterHeartbeatSender;
import akka.cluster.ClusterHeartbeatSender$HeartbeatTick$;
import akka.cluster.ClusterSettings;
import akka.cluster.CrossDcHeartbeatingState;
import akka.cluster.CrossDcHeartbeatingState$;
import akka.cluster.Member;
import akka.cluster.Member$;
import akka.cluster.UniqueAddress;
import akka.event.LoggingAdapter;
import akka.remote.FailureDetectorRegistry;
import java.io.Serializable;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.SortedSet$;
import scala.collection.immutable.SortedSet;
import scala.concurrent.ExecutionContext;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\r%c!\u00023f\u0005\u0015L\u0007\"B=\u0001\t\u0003Y\bb\u00024\u0001\u0005\u0004%\tA \u0005\b\u0003\u000b\u0001\u0001\u0015!\u0003\u0000\u0011%\t9\u0001\u0001b\u0001\n\u0003\tI\u0001\u0003\u0005\u0002\u0012\u0001\u0001\u000b\u0011BA\u0006\u0011%\t\u0019\u0002\u0001a\u0001\n\u0003\tI\u0001C\u0005\u0002\u0016\u0001\u0001\r\u0011\"\u0001\u0002\u0018!A\u00111\u0005\u0001!B\u0013\tY\u0001C\u0005\u0002&\u0001\u0011\r\u0011\"\u0001\u0002(!A\u0011Q\u0007\u0001!\u0002\u0013\tI\u0003C\u0005\u00028\u0001\u0011\r\u0011\"\u0001\u0002:!A\u0011q\n\u0001!\u0002\u0013\tY\u0004C\u0005\u0002R\u0001\u0011\r\u0011\"\u0001\u0002T!A\u0011q\r\u0001!\u0002\u0013\t)\u0006C\u0005\u0002j\u0001\u0011\r\u0011\"\u0001\u0002l!A\u00111\u0010\u0001!\u0002\u0013\ti\u0007C\u0005\u0002~\u0001\u0001\r\u0011\"\u0001\u0002\u0000!I\u0011q\u0011\u0001A\u0002\u0013\u0005\u0011\u0011\u0012\u0005\t\u0003\u001b\u0003\u0001\u0015)\u0003\u0002\u0002\"I\u0011q\u0012\u0001C\u0002\u0013\u0005\u0011\u0011\u0013\u0005\t\u00033\u0003\u0001\u0015!\u0003\u0002\u0014\"9\u00111\u0014\u0001\u0005B\u0005u\u0005bBAP\u0001\u0011\u0005\u0013Q\u0014\u0005\b\u0003C\u0003A\u0011AAR\u0011\u001d\ty\u000b\u0001C\u0001\u0003cCq!!1\u0001\t\u0003\t\t\fC\u0004\u0002D\u0002!\t!!-\t\u000f\u0005\u0015\u0007\u0001\"\u0001\u00022\"9\u0011q\u0019\u0001\u0005\u0002\u0005%\u0007bBAv\u0001\u0011\u0005\u0011Q\u001e\u0005\b\u0003g\u0004A\u0011AA{\u0011\u001d\tI\u0010\u0001C\u0001\u0003;Cq!a?\u0001\t\u0003\ti\u0010C\u0004\u0003\n\u0001!\tAa\u0003\t\u000f\t=\u0001\u0001\"\u0003\u0003\u0012!9!1\u0003\u0001\u0005\n\u0005uu\u0001\u0003B\u0012K\"\u0005qM!\n\u0007\u000f\u0011,\u0007\u0012A4\u0003(!1\u0011P\nC\u0001\u0005S1\u0011Ba\u000b'!\u0003\r\nC!\f\u0007\r\tUbE\u0011B\u001c\u0011\u0019I\u0018\u0006\"\u0001\u0003F!I!1J\u0015\u0002\u0002\u0013\u0005!Q\t\u0005\n\u0005\u001bJ\u0013\u0011!C!\u0005\u001fB\u0011B!\u0019*\u0003\u0003%\tAa\u0019\t\u0013\t-\u0014&!A\u0005\u0002\t5\u0004\"\u0003B<S\u0005\u0005I\u0011\tB=\u0011%\u00119)KA\u0001\n\u0003\u0011I\tC\u0005\u0003\u000e&\n\t\u0011\"\u0011\u0003\u0010\"I!\u0011S\u0015\u0002\u0002\u0013\u0005#1\u0013\u0005\n\u0005+K\u0013\u0011!C!\u0005/;\u0011Ba''\u0003\u0003E\tA!(\u0007\u0013\tUb%!A\t\u0002\t}\u0005BB=6\t\u0003\u0011i\u000bC\u0005\u0003\u0012V\n\t\u0011\"\u0012\u0003\u0014\"I!qV\u001b\u0002\u0002\u0013\u0005%Q\t\u0005\n\u0005c+\u0014\u0011!CA\u0005gC\u0011B!/6\u0003\u0003%IAa/\u0007\u0013\t\rg\u0005%A\u0012\"\t\u0015g!\u0003BeMA\u0005\u0019\u0013\u0005Bf\r\u0019\u0011\tN\n\"\u0003T\"Q!q[\u001f\u0003\u0016\u0004%\t!a \t\u0015\teWH!E!\u0002\u0013\t\t\t\u0003\u0004z{\u0011\u0005!1\u001c\u0005\n\u0005\u0017j\u0014\u0011!C\u0001\u0005CD\u0011B!:>#\u0003%\tAa:\t\u0013\t5S(!A\u0005B\t=\u0003\"\u0003B1{\u0005\u0005I\u0011\u0001B2\u0011%\u0011Y'PA\u0001\n\u0003\u0011Y\u0010C\u0005\u0003xu\n\t\u0011\"\u0011\u0003z!I!qQ\u001f\u0002\u0002\u0013\u0005!q \u0005\n\u0005\u001bk\u0014\u0011!C!\u0005\u001fC\u0011B!%>\u0003\u0003%\tEa%\t\u0013\tUU(!A\u0005B\r\rq!CB\u000eM\u0005\u0005\t\u0012AB\u000f\r%\u0011\tNJA\u0001\u0012\u0003\u0019y\u0002\u0003\u0004z\u0019\u0012\u00051q\u0005\u0005\n\u0005#c\u0015\u0011!C#\u0005'C\u0011Ba,M\u0003\u0003%\ti!\u000b\t\u0013\tEF*!A\u0005\u0002\u000e5\u0002\"\u0003B]\u0019\u0006\u0005I\u0011\u0002B^\r\u0019\u00199A\n\"\u0004\n!1\u0011P\u0015C\u0001\u0007\u0017A\u0011Ba\u0013S\u0003\u0003%\taa\u0003\t\u0013\t5#+!A\u0005B\t=\u0003\"\u0003B1%\u0006\u0005I\u0011\u0001B2\u0011%\u0011YGUA\u0001\n\u0003\u0019y\u0001C\u0005\u0003xI\u000b\t\u0011\"\u0011\u0003z!I!q\u0011*\u0002\u0002\u0013\u000511\u0003\u0005\n\u0005\u001b\u0013\u0016\u0011!C!\u0005\u001fC\u0011B!%S\u0003\u0003%\tEa%\t\u0013\tU%+!A\u0005B\r]q!CB\u001cM\u0005\u0005\t\u0012AB\u001d\r%\u00199AJA\u0001\u0012\u0003\u0019Y\u0004\u0003\u0004z=\u0012\u00051q\b\u0005\n\u0005#s\u0016\u0011!C#\u0005'C\u0011Ba,_\u0003\u0003%\tia\u0003\t\u0013\tEf,!A\u0005\u0002\u000e\u0005\u0003\"\u0003B]=\u0006\u0005I\u0011\u0002B^\u0005Y\u0019%o\\:t\t\u000eDU-\u0019:uE\u0016\fGoU3oI\u0016\u0014(B\u00014h\u0003\u001d\u0019G.^:uKJT\u0011\u0001[\u0001\u0005C.\\\u0017m\u0005\u0003\u0001UB4\bCA6o\u001b\u0005a'\"A7\u0002\u000bM\u001c\u0017\r\\1\n\u0005=d'AB!osJ+g\r\u0005\u0002ri6\t!O\u0003\u0002tO\u0006)\u0011m\u0019;pe&\u0011QO\u001d\u0002\u0006\u0003\u000e$xN\u001d\t\u0003c^L!\u0001\u001f:\u0003\u0019\u0005\u001bGo\u001c:M_\u001e<\u0017N\\4\u0002\rqJg.\u001b;?\u0007\u0001!\u0012\u0001 \t\u0003{\u0002i\u0011!Z\u000b\u0002\u007fB\u0019Q0!\u0001\n\u0007\u0005\rQMA\u0004DYV\u001cH/\u001a:\u0002\u0011\rdWo\u001d;fe\u0002\n\u0001C^3sE>\u001cX\rS3beR\u0014W-\u0019;\u0016\u0005\u0005-\u0001cA6\u0002\u000e%\u0019\u0011q\u00027\u0003\u000f\t{w\u000e\\3b]\u0006\tb/\u001a:c_N,\u0007*Z1si\n,\u0017\r\u001e\u0011\u0002%\u0005\u001cG/\u001b<fYfluN\\5u_JLgnZ\u0001\u0017C\u000e$\u0018N^3ms6{g.\u001b;pe&twm\u0018\u0013fcR!\u0011\u0011DA\u0010!\rY\u00171D\u0005\u0004\u0003;a'\u0001B+oSRD\u0011\"!\t\b\u0003\u0003\u0005\r!a\u0003\u0002\u0007a$\u0013'A\nbGRLg/\u001a7z\u001b>t\u0017\u000e^8sS:<\u0007%A\fjg\u0016CH/\u001a:oC2\u001cE.^:uKJlU-\u001c2feV\u0011\u0011\u0011\u0006\t\bW\u0006-\u0012qFA\u0006\u0013\r\ti\u0003\u001c\u0002\n\rVt7\r^5p]F\u00022!`A\u0019\u0013\r\t\u0019$\u001a\u0002\u0007\u001b\u0016l'-\u001a:\u00021%\u001cX\t\u001f;fe:\fGn\u00117vgR,'/T3nE\u0016\u0014\b%A\bde>\u001c8\u000fR2TKR$\u0018N\\4t+\t\tY\u0004\u0005\u0003\u0002>\u0005\u001dc\u0002BA \u0003\u0007r1!!\u0011\u0003\u001b\u0005\u0001\u0011\u0002BA#\u0003\u0003\t\u0001b]3ui&twm]\u0005\u0005\u0003\u0013\nYE\u0001\u0010De>\u001c8\u000fR2GC&dWO]3EKR,7\r^8s'\u0016$H/\u001b8hg&\u0019\u0011QJ3\u0003\u001f\rcWo\u001d;feN+G\u000f^5oON\f\u0001c\u0019:pgN$5mU3ui&twm\u001d\u0011\u0002-\r\u0014xn]:EG\u001a\u000b\u0017\u000e\\;sK\u0012+G/Z2u_J,\"!!\u0016\u0011\r\u0005]\u0013QLA1\u001b\t\tIFC\u0002\u0002\\\u001d\faA]3n_R,\u0017\u0002BA0\u00033\u0012qCR1jYV\u0014X\rR3uK\u000e$xN\u001d*fO&\u001cHO]=\u0011\u0007E\f\u0019'C\u0002\u0002fI\u0014q!\u00113ee\u0016\u001c8/A\fde>\u001c8\u000fR2GC&dWO]3EKR,7\r^8sA\u0005i1/\u001a7g\u0011\u0016\f'\u000f\u001e2fCR,\"!!\u001c\u0011\t\u0005=\u0014Q\u000f\b\u0004{\u0006E\u0014bAA:K\u000612\t\\;ti\u0016\u0014\b*Z1si\n,\u0017\r^*f]\u0012,'/\u0003\u0003\u0002x\u0005e$!\u0003%fCJ$(-Z1u\u0015\r\t\u0019(Z\u0001\u000fg\u0016dg\rS3beR\u0014W-\u0019;!\u0003A!\u0017\r^1DK:$XM]:Ti\u0006$X-\u0006\u0002\u0002\u0002B\u0019Q0a!\n\u0007\u0005\u0015UM\u0001\rDe>\u001c8\u000fR2IK\u0006\u0014HOY3bi&twm\u0015;bi\u0016\fA\u0003Z1uC\u000e+g\u000e^3sgN#\u0018\r^3`I\u0015\fH\u0003BA\r\u0003\u0017C\u0011\"!\t\u0013\u0003\u0003\u0005\r!!!\u0002#\u0011\fG/Y\"f]R,'o]*uCR,\u0007%A\u0007iK\u0006\u0014HOY3biR\u000b7o[\u000b\u0003\u0003'\u00032!]AK\u0013\r\t9J\u001d\u0002\f\u0007\u0006t7-\u001a7mC\ndW-\u0001\biK\u0006\u0014HOY3biR\u000b7o\u001b\u0011\u0002\u0011A\u0014Xm\u0015;beR$\"!!\u0007\u0002\u0011A|7\u000f^*u_B\f\u0011\u0003[3beR\u0014W-\u0019;SK\u000e,\u0017N^3s)\u0011\t)+a+\u0011\u0007E\f9+C\u0002\u0002*J\u0014a\"Q2u_J\u001cV\r\\3di&|g\u000eC\u0004\u0002.b\u0001\r!!\u0019\u0002\u000f\u0005$GM]3tg\u00069!/Z2fSZ,WCAAZ!\u0011\t),a/\u000f\u0007E\f9,C\u0002\u0002:J\fQ!Q2u_JLA!!0\u0002@\n9!+Z2fSZ,'bAA]e\u00069Am\u001c:nC:$\u0018AB1di&4X-A\u0007j]R\u0014xn\u001d9fGRLgnZ\u0001\u0005S:LG\u000f\u0006\u0003\u0002\u001a\u0005-\u0007bBAg;\u0001\u0007\u0011qZ\u0001\tg:\f\u0007o\u001d5piB!\u0011\u0011[As\u001d\u0011\t\u0019.!9\u000f\t\u0005U\u0017q\u001c\b\u0005\u0003/\fi.\u0004\u0002\u0002Z*\u0019\u00111\u001c>\u0002\rq\u0012xn\u001c;?\u0013\u0005A\u0017B\u00014h\u0013\r\t\u0019/Z\u0001\r\u00072,8\u000f^3s\u000bZ,g\u000e^\u0005\u0005\u0003O\fIOA\nDkJ\u0014XM\u001c;DYV\u001cH/\u001a:Ti\u0006$XMC\u0002\u0002d\u0016\f\u0011\"\u00193e\u001b\u0016l'-\u001a:\u0015\t\u0005e\u0011q\u001e\u0005\b\u0003ct\u0002\u0019AA\u0018\u0003\u0005i\u0017\u0001\u0004:f[>4X-T3nE\u0016\u0014H\u0003BA\r\u0003oDq!!= \u0001\u0004\ty#A\u0005iK\u0006\u0014HOY3bi\u0006a\u0001.Z1si\n,\u0017\r\u001e*taR!\u0011\u0011DA\u0000\u0011\u001d\u0011\t!\ta\u0001\u0005\u0007\tAA\u001a:p[B\u0019QP!\u0002\n\u0007\t\u001dQMA\u0007V]&\fX/Z!eIJ,7o]\u0001\u0016iJLwmZ3s\r&\u00148\u000f\u001e%fCJ$(-Z1u)\u0011\tIB!\u0004\t\u000f\t\u0005!\u00051\u0001\u0003\u0004\u0005!3/\u001a7g\u0013N\u0014Vm\u001d9p]NL'\r\\3G_J\u001c%o\\:t\t\u000eDU-\u0019:uE\u0016\fG\u000f\u0006\u0002\u0002\f\u0005)#-Z2p[\u0016\f5\r^5wK&3'+Z:q_:\u001c\u0018N\u00197f\r>\u0014\b*Z1si\n,\u0017\r\u001e\u0015\u0004\u0001\t]\u0001\u0003\u0002B\r\u0005?i!Aa\u0007\u000b\u0007\tuq-\u0001\u0006b]:|G/\u0019;j_:LAA!\t\u0003\u001c\tY\u0011J\u001c;fe:\fG.\u00119j\u0003Y\u0019%o\\:t\t\u000eDU-\u0019:uE\u0016\fGoU3oI\u0016\u0014\bCA?''\t1#\u000e\u0006\u0002\u0003&\t\t\u0012J\\:qK\u000e$\u0018n\u001c8D_6l\u0017M\u001c3\u0014\t!R'q\u0006\t\u0004c\nE\u0012b\u0001B\u001ae\n\tcj\\*fe&\fG.\u001b>bi&|gNV3sS\u001aL7-\u0019;j_:tU-\u001a3fI\na!+\u001a9peR\u001cF/\u0019;vgN1\u0011F\u001bB\u001d\u0005\u007f\u00012a\u001bB\u001e\u0013\r\u0011i\u0004\u001c\u0002\b!J|G-^2u!\rY'\u0011I\u0005\u0004\u0005\u0007b'\u0001D*fe&\fG.\u001b>bE2,GC\u0001B$!\r\u0011I%K\u0007\u0002M\u0005!1m\u001c9z\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011!\u0011\u000b\t\u0005\u0005'\u0012i&\u0004\u0002\u0003V)!!q\u000bB-\u0003\u0011a\u0017M\\4\u000b\u0005\tm\u0013\u0001\u00026bm\u0006LAAa\u0018\u0003V\t11\u000b\u001e:j]\u001e\fA\u0002\u001d:pIV\u001cG/\u0011:jif,\"A!\u001a\u0011\u0007-\u00149'C\u0002\u0003j1\u00141!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$BAa\u001c\u0003vA\u00191N!\u001d\n\u0007\tMDNA\u0002B]fD\u0011\"!\t/\u0003\u0003\u0005\rA!\u001a\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"Aa\u001f\u0011\r\tu$1\u0011B8\u001b\t\u0011yHC\u0002\u0003\u00022\f!bY8mY\u0016\u001cG/[8o\u0013\u0011\u0011)Ia \u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003\u0017\u0011Y\tC\u0005\u0002\"A\n\t\u00111\u0001\u0003p\u0005A\u0001.Y:i\u0007>$W\r\u0006\u0002\u0003f\u0005AAo\\*ue&tw\r\u0006\u0002\u0003R\u00051Q-];bYN$B!a\u0003\u0003\u001a\"I\u0011\u0011E\u001a\u0002\u0002\u0003\u0007!qN\u0001\r%\u0016\u0004xN\u001d;Ti\u0006$Xo\u001d\t\u0004\u0005\u0013*4#B\u001b\u0003\"\n}\u0002C\u0002BR\u0005S\u00139%\u0004\u0002\u0003&*\u0019!q\u00157\u0002\u000fI,h\u000e^5nK&!!1\u0016BS\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|g\u000e\r\u000b\u0003\u0005;\u000bQ!\u00199qYf\fq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002\f\tU\u0006\"\u0003B\\s\u0005\u0005\t\u0019\u0001B$\u0003\rAH\u0005M\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0003>B!!1\u000bB`\u0013\u0011\u0011\tM!\u0016\u0003\r=\u0013'.Z2u\u00051\u0019F/\u0019;vgJ+\u0007o\u001c:u'\u0011Y$Na\f*\u0005mb$!F'p]&$xN]5oON#\u0018\r^3SKB|'\u000f^\n\u0005y)\u0014i\rE\u0002\u0003JmJ3\u0001P\u001fS\u0005AiuN\\5u_JLgnZ!di&4Xm\u0005\u0005>U\nU'\u0011\bB !\r\u0011I\u0005P\u0001\u0006gR\fG/Z\u0001\u0007gR\fG/\u001a\u0011\u0015\t\tu'q\u001c\t\u0004\u0005\u0013j\u0004b\u0002Bl\u0001\u0002\u0007\u0011\u0011\u0011\u000b\u0005\u0005;\u0014\u0019\u000fC\u0005\u0003X\u0006\u0003\n\u00111\u0001\u0002\u0002\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTC\u0001BuU\u0011\t\tIa;,\u0005\t5\b\u0003\u0002Bx\u0005ol!A!=\u000b\t\tM(Q_\u0001\nk:\u001c\u0007.Z2lK\u0012T1A!\bm\u0013\u0011\u0011IP!=\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\r\u0006\u0003\u0003p\tu\b\"CA\u0011\u000b\u0006\u0005\t\u0019\u0001B3)\u0011\tYa!\u0001\t\u0013\u0005\u0005r)!AA\u0002\t=D\u0003BA\u0006\u0007\u000bA\u0011\"!\tK\u0003\u0003\u0005\rAa\u001c\u0003#5{g.\u001b;pe&tw\rR8s[\u0006tGo\u0005\u0005SU\nU'\u0011\bB )\t\u0019i\u0001E\u0002\u0003JI#BAa\u001c\u0004\u0012!I\u0011\u0011E,\u0002\u0002\u0003\u0007!Q\r\u000b\u0005\u0003\u0017\u0019)\u0002C\u0005\u0002\"e\u000b\t\u00111\u0001\u0003pQ!\u00111BB\r\u0011%\t\t\u0003XA\u0001\u0002\u0004\u0011y'\u0001\tN_:LGo\u001c:j]\u001e\f5\r^5wKB\u0019!\u0011\n'\u0014\u000b1\u001b\tCa\u0010\u0011\u0011\t\r61EAA\u0005;LAa!\n\u0003&\n\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\\\u0019\u0015\u0005\ruA\u0003\u0002Bo\u0007WAqAa6P\u0001\u0004\t\t\t\u0006\u0003\u00040\rU\u0002#B6\u00042\u0005\u0005\u0015bAB\u001aY\n1q\n\u001d;j_:D\u0011Ba.Q\u0003\u0003\u0005\rA!8\u0002#5{g.\u001b;pe&tw\rR8s[\u0006tG\u000fE\u0002\u0003Jy\u001bRAXB\u001f\u0005\u007f\u0001bAa)\u0003*\u000e5ACAB\u001d)\u0011\tYaa\u0011\t\u0013\t]&-!AA\u0002\r5\u0001f\u0001\u0014\u0003\u0018!\u001aQEa\u0006")
@InternalApi
public final class CrossDcHeartbeatSender
implements Actor,
ActorLogging {
    private final Cluster cluster;
    private final boolean verboseHeartbeat;
    private boolean activelyMonitoring;
    private final Function1<Member, Object> isExternalClusterMember;
    private final ClusterSettings.CrossDcFailureDetectorSettings crossDcSettings;
    private final FailureDetectorRegistry<Address> crossDcFailureDetector;
    private final ClusterHeartbeatSender.Heartbeat selfHeartbeat;
    private CrossDcHeartbeatingState dataCentersState;
    private final Cancellable heartbeatTask;
    private LoggingAdapter akka$actor$ActorLogging$$_log;
    private final ActorContext context;
    private final ActorRef self;

    public LoggingAdapter log() {
        return ActorLogging.log$((ActorLogging)this);
    }

    public final ActorRef sender() {
        return Actor.sender$((Actor)this);
    }

    @InternalApi
    public void aroundReceive(PartialFunction<Object, BoxedUnit> receive2, Object msg) {
        Actor.aroundReceive$((Actor)this, receive2, (Object)msg);
    }

    @InternalApi
    public void aroundPreStart() {
        Actor.aroundPreStart$((Actor)this);
    }

    @InternalApi
    public void aroundPostStop() {
        Actor.aroundPostStop$((Actor)this);
    }

    @InternalApi
    public void aroundPreRestart(Throwable reason, Option<Object> message) {
        Actor.aroundPreRestart$((Actor)this, (Throwable)reason, message);
    }

    @InternalApi
    public void aroundPostRestart(Throwable reason) {
        Actor.aroundPostRestart$((Actor)this, (Throwable)reason);
    }

    public SupervisorStrategy supervisorStrategy() {
        return Actor.supervisorStrategy$((Actor)this);
    }

    public void preRestart(Throwable reason, Option<Object> message) throws Exception {
        Actor.preRestart$((Actor)this, (Throwable)reason, message);
    }

    public void postRestart(Throwable reason) throws Exception {
        Actor.postRestart$((Actor)this, (Throwable)reason);
    }

    public void unhandled(Object message) {
        Actor.unhandled$((Actor)this, (Object)message);
    }

    public LoggingAdapter akka$actor$ActorLogging$$_log() {
        return this.akka$actor$ActorLogging$$_log;
    }

    public void akka$actor$ActorLogging$$_log_$eq(LoggingAdapter x$1) {
        this.akka$actor$ActorLogging$$_log = x$1;
    }

    public ActorContext context() {
        return this.context;
    }

    public final ActorRef self() {
        return this.self;
    }

    public void akka$actor$Actor$_setter_$context_$eq(ActorContext x$1) {
        this.context = x$1;
    }

    public final void akka$actor$Actor$_setter_$self_$eq(ActorRef x$1) {
        this.self = x$1;
    }

    public Cluster cluster() {
        return this.cluster;
    }

    public boolean verboseHeartbeat() {
        return this.verboseHeartbeat;
    }

    public boolean activelyMonitoring() {
        return this.activelyMonitoring;
    }

    public void activelyMonitoring_$eq(boolean x$1) {
        this.activelyMonitoring = x$1;
    }

    public Function1<Member, Object> isExternalClusterMember() {
        return this.isExternalClusterMember;
    }

    public ClusterSettings.CrossDcFailureDetectorSettings crossDcSettings() {
        return this.crossDcSettings;
    }

    public FailureDetectorRegistry<Address> crossDcFailureDetector() {
        return this.crossDcFailureDetector;
    }

    public ClusterHeartbeatSender.Heartbeat selfHeartbeat() {
        return this.selfHeartbeat;
    }

    public CrossDcHeartbeatingState dataCentersState() {
        return this.dataCentersState;
    }

    public void dataCentersState_$eq(CrossDcHeartbeatingState x$1) {
        this.dataCentersState = x$1;
    }

    public Cancellable heartbeatTask() {
        return this.heartbeatTask;
    }

    public void preStart() {
        block0: {
            this.cluster().subscribe(this.self(), (Seq<Class<?>>)Predef$.MODULE$.wrapRefArray((Object[])new Class[]{ClusterEvent.MemberEvent.class}));
            if (!this.verboseHeartbeat()) break block0;
            this.log().debug("Initialized cross-dc heartbeat sender as DORMANT in DC: [{}]", (Object)this.cluster().selfDataCenter());
        }
    }

    public void postStop() {
        this.dataCentersState().activeReceivers().foreach((Function1 & Serializable & scala.Serializable)a -> {
            CrossDcHeartbeatSender.$anonfun$postStop$1(this, a);
            return BoxedUnit.UNIT;
        });
        this.heartbeatTask().cancel();
        this.cluster().unsubscribe(this.self());
    }

    public ActorSelection heartbeatReceiver(Address address) {
        return this.context().actorSelection(ClusterHeartbeatReceiver$.MODULE$.path(address));
    }

    public PartialFunction<Object, BoxedUnit> receive() {
        return this.dormant().orElse(this.introspecting());
    }

    public PartialFunction<Object, BoxedUnit> dormant() {
        return new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CrossDcHeartbeatSender $outer;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof ClusterEvent.CurrentClusterState) {
                    ClusterEvent.CurrentClusterState currentClusterState = (ClusterEvent.CurrentClusterState)A1;
                    this.$outer.init(currentClusterState);
                    object = BoxedUnit.UNIT;
                } else if (A1 instanceof ClusterEvent.MemberRemoved) {
                    ClusterEvent.MemberRemoved memberRemoved = (ClusterEvent.MemberRemoved)A1;
                    Member m = memberRemoved.member();
                    this.$outer.removeMember(m);
                    object = BoxedUnit.UNIT;
                } else if (A1 instanceof ClusterEvent.MemberEvent) {
                    ClusterEvent.MemberEvent memberEvent = (ClusterEvent.MemberEvent)A1;
                    this.$outer.addMember(memberEvent.member());
                    object = BoxedUnit.UNIT;
                } else {
                    object = ClusterHeartbeatSender$HeartbeatTick$.MODULE$.equals(A1) ? BoxedUnit.UNIT : function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Object x1) {
                Object object = x1;
                boolean bl = object instanceof ClusterEvent.CurrentClusterState ? true : (object instanceof ClusterEvent.MemberRemoved ? true : (object instanceof ClusterEvent.MemberEvent ? true : ClusterHeartbeatSender$HeartbeatTick$.MODULE$.equals(object)));
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
    }

    public PartialFunction<Object, BoxedUnit> active() {
        return new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CrossDcHeartbeatSender $outer;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (ClusterHeartbeatSender$HeartbeatTick$.MODULE$.equals(A1)) {
                    this.$outer.heartbeat();
                    object = BoxedUnit.UNIT;
                } else if (A1 instanceof ClusterHeartbeatSender.HeartbeatRsp) {
                    ClusterHeartbeatSender.HeartbeatRsp heartbeatRsp = (ClusterHeartbeatSender.HeartbeatRsp)A1;
                    UniqueAddress from = heartbeatRsp.from();
                    this.$outer.heartbeatRsp(from);
                    object = BoxedUnit.UNIT;
                } else if (A1 instanceof ClusterEvent.MemberRemoved) {
                    ClusterEvent.MemberRemoved memberRemoved = (ClusterEvent.MemberRemoved)A1;
                    Member m = memberRemoved.member();
                    this.$outer.removeMember(m);
                    object = BoxedUnit.UNIT;
                } else if (A1 instanceof ClusterEvent.MemberEvent) {
                    ClusterEvent.MemberEvent memberEvent = (ClusterEvent.MemberEvent)A1;
                    this.$outer.addMember(memberEvent.member());
                    object = BoxedUnit.UNIT;
                } else if (A1 instanceof ClusterHeartbeatSender.ExpectedFirstHeartbeat) {
                    ClusterHeartbeatSender.ExpectedFirstHeartbeat expectedFirstHeartbeat = (ClusterHeartbeatSender.ExpectedFirstHeartbeat)A1;
                    UniqueAddress from = expectedFirstHeartbeat.from();
                    this.$outer.triggerFirstHeartbeat(from);
                    object = BoxedUnit.UNIT;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Object x1) {
                Object object = x1;
                boolean bl = ClusterHeartbeatSender$HeartbeatTick$.MODULE$.equals(object) ? true : (object instanceof ClusterHeartbeatSender.HeartbeatRsp ? true : (object instanceof ClusterEvent.MemberRemoved ? true : (object instanceof ClusterEvent.MemberEvent ? true : object instanceof ClusterHeartbeatSender.ExpectedFirstHeartbeat)));
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
    }

    public PartialFunction<Object, BoxedUnit> introspecting() {
        return new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CrossDcHeartbeatSender $outer;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof ReportStatus) {
                    package$.MODULE$.actorRef2Scala(this.$outer.sender()).$bang((Object)(this.$outer.activelyMonitoring() ? new MonitoringActive(this.$outer.dataCentersState()) : new MonitoringDormant()), this.$outer.self());
                    object = BoxedUnit.UNIT;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Object x1) {
                Object object = x1;
                boolean bl = object instanceof ReportStatus;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
    }

    public void init(ClusterEvent.CurrentClusterState snapshot) {
        SortedSet<Member> nodes2 = snapshot.members();
        int nrOfMonitoredNodes = this.crossDcSettings().NrOfMonitoringActors();
        this.dataCentersState_$eq(CrossDcHeartbeatingState$.MODULE$.init(this.cluster().selfDataCenter(), this.crossDcFailureDetector(), nrOfMonitoredNodes, (scala.collection.SortedSet<Member>)nodes2));
        this.becomeActiveIfResponsibleForHeartbeat();
    }

    public void addMember(Member m) {
        block2: {
            if (!CrossDcHeartbeatingState$.MODULE$.atLeastInUpState(m)) break block2;
            this.dataCentersState_$eq(this.dataCentersState().addMember(m));
            if (this.verboseHeartbeat()) {
                String string = m.dataCenter();
                String string2 = this.cluster().selfDataCenter();
                if (string == null ? string2 != null : !string.equals(string2)) {
                    this.log().debug("Register member {} for cross DC heartbeat (will only heartbeat if oldest)", (Object)m);
                }
            }
            this.becomeActiveIfResponsibleForHeartbeat();
        }
    }

    public void removeMember(Member m) {
        UniqueAddress uniqueAddress = m.uniqueAddress();
        UniqueAddress uniqueAddress2 = this.cluster().selfUniqueAddress();
        if (!(uniqueAddress != null ? !((Object)uniqueAddress).equals(uniqueAddress2) : uniqueAddress2 != null)) {
            this.context().stop(this.self());
        } else {
            this.dataCentersState_$eq(this.dataCentersState().removeMember(m));
            this.becomeActiveIfResponsibleForHeartbeat();
        }
    }

    public void heartbeat() {
        this.dataCentersState().activeReceivers().foreach((Function1 & Serializable & scala.Serializable)to -> {
            CrossDcHeartbeatSender.$anonfun$heartbeat$1(this, to);
            return BoxedUnit.UNIT;
        });
    }

    public void heartbeatRsp(UniqueAddress from) {
        if (this.verboseHeartbeat()) {
            this.cluster().ClusterLogger().logDebug("(Cross) Heartbeat response from [{}]", from.address());
        }
        this.dataCentersState_$eq(this.dataCentersState().heartbeatRsp(from));
    }

    public void triggerFirstHeartbeat(UniqueAddress from) {
        block1: {
            if (!this.dataCentersState().activeReceivers().contains((Object)from) || this.crossDcFailureDetector().isMonitoring((Object)from.address())) break block1;
            if (this.verboseHeartbeat()) {
                this.cluster().ClusterLogger().logDebug("Trigger extra expected (cross) heartbeat from [{}]", from.address());
            }
            this.crossDcFailureDetector().heartbeat((Object)from.address());
        }
    }

    private boolean selfIsResponsibleForCrossDcHeartbeat() {
        int activeDcs = this.dataCentersState().dataCenters().size();
        return activeDcs > 1 ? this.dataCentersState().shouldActivelyMonitorNodes(this.cluster().selfDataCenter(), this.cluster().selfUniqueAddress()) : false;
    }

    private void becomeActiveIfResponsibleForHeartbeat() {
        block1: {
            block0: {
                if (this.activelyMonitoring() || !this.selfIsResponsibleForCrossDcHeartbeat()) break block0;
                this.log().info("Cross DC heartbeat becoming ACTIVE on this node (for DC: {}), monitoring other DCs oldest nodes", (Object)this.cluster().selfDataCenter());
                this.activelyMonitoring_$eq(true);
                this.context().become(this.active().orElse(this.introspecting()));
                break block1;
            }
            if (this.activelyMonitoring() || !this.verboseHeartbeat()) break block1;
            this.log().info("Remaining DORMANT; others in {} handle heartbeating other DCs", (Object)this.cluster().selfDataCenter());
        }
    }

    public static final /* synthetic */ boolean $anonfun$isExternalClusterMember$1(CrossDcHeartbeatSender $this, Member member) {
        String string = member.dataCenter();
        String string2 = $this.cluster().selfDataCenter();
        return string == null ? string2 != null : !string.equals(string2);
    }

    public static final /* synthetic */ void $anonfun$postStop$1(CrossDcHeartbeatSender $this, UniqueAddress a) {
        $this.crossDcFailureDetector().remove((Object)a.address());
    }

    public static final /* synthetic */ void $anonfun$heartbeat$1(CrossDcHeartbeatSender $this, UniqueAddress to) {
        BoxedUnit boxedUnit;
        if ($this.crossDcFailureDetector().isMonitoring((Object)to.address())) {
            if ($this.verboseHeartbeat()) {
                $this.cluster().ClusterLogger().logDebug("(Cross) Heartbeat to [{}]", to.address());
            }
            boxedUnit = BoxedUnit.UNIT;
        } else {
            if ($this.verboseHeartbeat()) {
                $this.cluster().ClusterLogger().logDebug("First (Cross) Heartbeat to [{}]", to.address());
            }
            boxedUnit = $this.cluster().scheduler().scheduleOnce($this.cluster().settings().HeartbeatExpectedResponseAfter(), $this.self(), (Object)new ClusterHeartbeatSender.ExpectedFirstHeartbeat(to), (ExecutionContext)$this.context().dispatcher(), $this.self());
        }
        ActorSelection$.MODULE$.toScala($this.heartbeatReceiver(to.address())).$bang((Object)$this.selfHeartbeat(), $this.self());
    }

    public CrossDcHeartbeatSender() {
        Actor.$init$((Actor)this);
        ActorLogging.$init$((ActorLogging)this);
        this.cluster = (Cluster)Cluster$.MODULE$.apply(this.context().system());
        this.verboseHeartbeat = this.cluster().settings().Debug().VerboseHeartbeatLogging();
        this.activelyMonitoring = false;
        this.isExternalClusterMember = (Function1 & Serializable & scala.Serializable)member -> BoxesRunTime.boxToBoolean((boolean)CrossDcHeartbeatSender.$anonfun$isExternalClusterMember$1(this, member));
        this.crossDcSettings = this.cluster().settings().MultiDataCenter().CrossDcFailureDetectorSettings();
        this.crossDcFailureDetector = this.cluster().crossDcFailureDetector();
        this.selfHeartbeat = new ClusterHeartbeatSender.Heartbeat(this.cluster().selfAddress());
        this.dataCentersState = CrossDcHeartbeatingState$.MODULE$.init(this.cluster().selfDataCenter(), this.crossDcFailureDetector(), this.crossDcSettings().NrOfMonitoringActors(), (scala.collection.SortedSet<Member>)SortedSet$.MODULE$.empty(Member$.MODULE$.ordering()));
        this.heartbeatTask = this.cluster().scheduler().schedule(this.cluster().settings().PeriodicTasksInitialDelay().max(this.cluster().settings().HeartbeatInterval()), this.cluster().settings().HeartbeatInterval(), this.self(), (Object)ClusterHeartbeatSender$HeartbeatTick$.MODULE$, (ExecutionContext)this.context().dispatcher(), this.self());
    }

    public static interface InspectionCommand
    extends NoSerializationVerificationNeeded {
    }

    public static final class MonitoringActive
    implements MonitoringStateReport,
    Product,
    scala.Serializable {
        private final CrossDcHeartbeatingState state;

        public CrossDcHeartbeatingState state() {
            return this.state;
        }

        public MonitoringActive copy(CrossDcHeartbeatingState state) {
            return new MonitoringActive(state);
        }

        public CrossDcHeartbeatingState copy$default$1() {
            return this.state();
        }

        public String productPrefix() {
            return "MonitoringActive";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return this.state();
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof MonitoringActive;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof MonitoringActive)) return false;
            boolean bl = true;
            if (!bl) return false;
            MonitoringActive monitoringActive = (MonitoringActive)x$1;
            CrossDcHeartbeatingState crossDcHeartbeatingState = this.state();
            CrossDcHeartbeatingState crossDcHeartbeatingState2 = monitoringActive.state();
            if (crossDcHeartbeatingState != null) {
                if (!((Object)crossDcHeartbeatingState).equals(crossDcHeartbeatingState2)) return false;
                return true;
            }
            if (crossDcHeartbeatingState2 == null) return true;
            return false;
        }

        public MonitoringActive(CrossDcHeartbeatingState state) {
            this.state = state;
            Product.$init$((Product)this);
        }
    }

    public static final class MonitoringDormant
    implements MonitoringStateReport,
    Product,
    scala.Serializable {
        public MonitoringDormant copy() {
            return new MonitoringDormant();
        }

        public String productPrefix() {
            return "MonitoringDormant";
        }

        public int productArity() {
            return 0;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof MonitoringDormant;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean equals(Object x$1) {
            Object object = x$1;
            boolean bl = object instanceof MonitoringDormant;
            return bl;
        }

        public MonitoringDormant() {
            Product.$init$((Product)this);
        }
    }

    public static interface MonitoringStateReport
    extends StatusReport {
    }

    public static final class ReportStatus
    implements Product,
    scala.Serializable {
        public ReportStatus copy() {
            return new ReportStatus();
        }

        public String productPrefix() {
            return "ReportStatus";
        }

        public int productArity() {
            return 0;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ReportStatus;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean equals(Object x$1) {
            Object object = x$1;
            boolean bl = object instanceof ReportStatus;
            return bl;
        }

        public ReportStatus() {
            Product.$init$((Product)this);
        }
    }

    public static interface StatusReport
    extends NoSerializationVerificationNeeded {
    }
}

