/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.springsecurity;

import com.atlassian.crowd.integration.http.util.CrowdHttpTokenHelper;
import com.atlassian.crowd.integration.springsecurity.CrowdSSOAuthenticationDetails;
import com.atlassian.crowd.integration.springsecurity.CrowdSSOAuthenticationToken;
import com.atlassian.crowd.integration.springsecurity.RequestToApplicationMapper;
import com.atlassian.crowd.model.authentication.CookieConfiguration;
import com.atlassian.crowd.service.client.ClientProperties;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nullable;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.LoginUrlAuthenticationEntryPoint;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;
import org.springframework.security.web.savedrequest.DefaultSavedRequest;
import org.springframework.security.web.savedrequest.HttpSessionRequestCache;

public abstract class AbstractCrowdSSOAuthenticationProcessingFilter
extends UsernamePasswordAuthenticationFilter {
    private static final Logger logger = LoggerFactory.getLogger(AbstractCrowdSSOAuthenticationProcessingFilter.class);
    protected final ClientProperties clientProperties;
    protected final CrowdHttpTokenHelper tokenHelper;
    @Nullable
    private RequestToApplicationMapper requestToApplicationMapper;
    @Nullable
    private LoginUrlAuthenticationEntryPoint authenticationProcessingFilterEntryPoint;

    protected AbstractCrowdSSOAuthenticationProcessingFilter(ClientProperties clientProperties, CrowdHttpTokenHelper tokenHelper) {
        this.clientProperties = clientProperties;
        this.tokenHelper = tokenHelper;
    }

    protected boolean requiresAuthentication(HttpServletRequest request, HttpServletResponse response) {
        boolean usernamePasswordAuthentication = super.requiresAuthentication(request, response);
        if (!usernamePasswordAuthentication) {
            Authentication authenticatedToken = null;
            try {
                String token = this.tokenHelper.getCrowdToken(request, this.clientProperties.getCookieTokenKey());
                if (token != null) {
                    CrowdSSOAuthenticationToken crowdAuthRequest = new CrowdSSOAuthenticationToken(token);
                    this.doSetDetails(request, crowdAuthRequest);
                    authenticatedToken = this.getAuthenticationManager().authenticate((Authentication)crowdAuthRequest);
                }
            }
            catch (AuthenticationException authenticationException) {
                // empty catch block
            }
            if (authenticatedToken == null) {
                SecurityContextHolder.clearContext();
            } else {
                SecurityContextHolder.getContext().setAuthentication(authenticatedToken);
                this.storeTokenIfCrowd(request, response, authenticatedToken);
            }
        }
        return usernamePasswordAuthentication;
    }

    protected void setDetails(HttpServletRequest request, UsernamePasswordAuthenticationToken authRequest) {
        this.doSetDetails(request, (AbstractAuthenticationToken)authRequest);
    }

    private static String requestUriWithoutContext(HttpServletRequest request) {
        return request.getRequestURI().substring(request.getContextPath().length());
    }

    protected boolean canUseSavedRequestToAuthenticate(HttpServletRequest request) {
        if (super.requiresAuthentication(request, null)) {
            return true;
        }
        if (this.authenticationProcessingFilterEntryPoint != null) {
            String loginFormUrl = this.authenticationProcessingFilterEntryPoint.getLoginFormUrl();
            return AbstractCrowdSSOAuthenticationProcessingFilter.requestUriWithoutContext(request).equals(loginFormUrl);
        }
        return false;
    }

    protected void doSetDetails(HttpServletRequest request, AbstractAuthenticationToken authRequest) {
        String application;
        List validationFactors = this.tokenHelper.getValidationFactorExtractor().getValidationFactors(request);
        if (this.requestToApplicationMapper != null) {
            DefaultSavedRequest savedRequest = (DefaultSavedRequest)new HttpSessionRequestCache().getRequest(request, null);
            String path = this.canUseSavedRequestToAuthenticate(request) && savedRequest != null ? savedRequest.getRequestURI().substring(savedRequest.getContextPath().length()) : AbstractCrowdSSOAuthenticationProcessingFilter.requestUriWithoutContext(request);
            application = this.requestToApplicationMapper.getApplication(path);
        } else {
            application = this.clientProperties.getApplicationName();
        }
        authRequest.setDetails((Object)new CrowdSSOAuthenticationDetails(application, validationFactors));
    }

    protected void successfulAuthentication(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain, Authentication authResult) throws IOException, ServletException {
        this.storeTokenIfCrowd(request, response, authResult);
        super.successfulAuthentication(request, response, filterChain, authResult);
    }

    protected void storeTokenIfCrowd(HttpServletRequest request, HttpServletResponse response, Authentication authResult) {
        if (authResult instanceof CrowdSSOAuthenticationToken && authResult.getCredentials() != null) {
            try {
                this.tokenHelper.setCrowdToken(request, response, (String)authResult.getCredentials(), this.clientProperties, this.getCookieConfiguration());
            }
            catch (Exception e) {
                logger.error("Unable to set Crowd SSO token", (Throwable)e);
            }
        }
    }

    protected void unsuccessfulAuthentication(HttpServletRequest request, HttpServletResponse response, AuthenticationException failed) throws IOException, ServletException {
        this.onUnsuccessfulAuthentication(request, response);
        super.unsuccessfulAuthentication(request, response, failed);
    }

    protected abstract void onUnsuccessfulAuthentication(HttpServletRequest var1, HttpServletResponse var2);

    protected abstract CookieConfiguration getCookieConfiguration() throws Exception;

    public void setRequestToApplicationMapper(RequestToApplicationMapper requestToApplicationMapper) {
        this.requestToApplicationMapper = requestToApplicationMapper;
    }

    public void setLoginUrlAuthenticationEntryPoint(LoginUrlAuthenticationEntryPoint filterEntryPoint) {
        this.authenticationProcessingFilterEntryPoint = filterEntryPoint;
    }
}

