/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository.sql.persistence;

import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.xlrelease.db.sql.SqlBuilder;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.domain.Dependency;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.sql.persistence.CiId$;
import com.xebialabs.xlrelease.repository.sql.persistence.CompressionSupport;
import com.xebialabs.xlrelease.repository.sql.persistence.FolderId$;
import com.xebialabs.xlrelease.repository.sql.persistence.PersistenceSupport;
import com.xebialabs.xlrelease.repository.sql.persistence.ReleaseStoreException;
import com.xebialabs.xlrelease.repository.sql.persistence.ReleasesSqlBuilder$;
import com.xebialabs.xlrelease.repository.sql.persistence.Schema$DEPENDENCIES$;
import com.xebialabs.xlrelease.repository.sql.persistence.Schema$FOLDERS$;
import com.xebialabs.xlrelease.repository.sql.persistence.Schema$RELEASES$;
import com.xebialabs.xlrelease.repository.sql.persistence.Schema$TASKS$;
import com.xebialabs.xlrelease.repository.sql.persistence.TaskPersistence$;
import com.xebialabs.xlrelease.repository.sql.persistence.Utils;
import com.xebialabs.xlrelease.repository.sql.persistence.Utils$;
import com.xebialabs.xlrelease.repository.sql.persistence.data.DependencyRow;
import com.xebialabs.xlrelease.repository.sql.persistence.data.DependencyRow$;
import com.xebialabs.xlrelease.repository.sql.persistence.data.TargetRow$;
import com.xebialabs.xlrelease.repository.sql.persistence.data.TargetRow$TargetRowOps$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.InputStream;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.UUID;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Profile;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCallback;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.stereotype.Repository;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@Profile(value={"sql"})
@Repository
@IsTransactional
@ScalaSignature(bytes="\u0006\u0001\t\rf\u0001B\u0016-\u0001eB\u0001\u0002\u0014\u0001\u0003\u0006\u0004%\t!\u0014\u0005\t5\u0002\u0011\t\u0011)A\u0005\u001d\"A1\f\u0001BC\u0002\u0013\rA\f\u0003\u0005u\u0001\t\u0005\t\u0015!\u0003^\u0011\u0015)\b\u0001\"\u0001w\u0011\u001d\ty\u0002\u0001C\u0005\u0003CAq!!\u001c\u0001\t\u0013\ty\u0007C\u0005\u0002\u0002\u0002\u0011\r\u0011\"\u0003\u0002\u0004\"A\u0011q\u0013\u0001!\u0002\u0013\t)\tC\u0005\u0002\u001a\u0002\u0011\r\u0011\"\u0003\u0002\u001c\"A\u0011Q\u0014\u0001!\u0002\u0013\tY\u0003C\u0005\u0002 \u0002\u0011\r\u0011\"\u0003\u0002\u001c\"A\u0011\u0011\u0015\u0001!\u0002\u0013\tY\u0003C\u0005\u0002$\u0002\u0011\r\u0011\"\u0003\u0002\u001c\"A\u0011Q\u0015\u0001!\u0002\u0013\tY\u0003C\u0004\u0002(\u0002!I!!+\t\u000f\u0005=\u0006\u0001\"\u0001\u00022\"9\u0011q\u001b\u0001\u0005\u0002\u0005e\u0007\"CAr\u0001\t\u0007I\u0011BAN\u0011!\t)\u000f\u0001Q\u0001\n\u0005-\u0002bBAt\u0001\u0011\u0005\u0011\u0011\u001e\u0005\n\u0003_\u0004!\u0019!C\u0005\u00037C\u0001\"!=\u0001A\u0003%\u00111\u0006\u0005\b\u0003g\u0004A\u0011AA{\u0011\u001d\tY\u0010\u0001C\u0001\u0003{D\u0011B!\u0002\u0001\u0005\u0004%I!a'\t\u0011\t\u001d\u0001\u0001)A\u0005\u0003WAqA!\u0003\u0001\t\u0003\u0011Y\u0001C\u0005\u0003$\u0001\u0011\r\u0011\"\u0003\u0002\u001c\"A!Q\u0005\u0001!\u0002\u0013\tY\u0003C\u0004\u0003(\u0001!\tA!\u000b\t\u0013\t}\u0002A1A\u0005\n\u0005m\u0005\u0002\u0003B!\u0001\u0001\u0006I!a\u000b\t\u000f\t\r\u0003\u0001\"\u0001\u0003F!9!1\t\u0001\u0005\u0002\t-\u0003\"\u0003B(\u0001\t\u0007I\u0011BAN\u0011!\u0011\t\u0006\u0001Q\u0001\n\u0005-\u0002b\u0002B*\u0001\u0011\u0005!Q\u000b\u0005\n\u0005C\u0002!\u0019!C\u0005\u00037C\u0001Ba\u0019\u0001A\u0003%\u00111\u0006\u0005\b\u0005K\u0002A\u0011\u0001B4\u0011\u001d\u0011Y\u0007\u0001C\u0005\u0005[\u0012Q\u0003R3qK:$WM\\2z!\u0016\u00148/[:uK:\u001cWM\u0003\u0002.]\u0005Y\u0001/\u001a:tSN$XM\\2f\u0015\ty\u0003'A\u0002tc2T!!\r\u001a\u0002\u0015I,\u0007o\\:ji>\u0014\u0018P\u0003\u00024i\u0005I\u0001\u0010\u001c:fY\u0016\f7/\u001a\u0006\u0003kY\n\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003]\n1aY8n\u0007\u0001\u0019B\u0001\u0001\u001eA\tB\u00111HP\u0007\u0002y)\tQ(A\u0003tG\u0006d\u0017-\u0003\u0002@y\t1\u0011I\\=SK\u001a\u0004\"!\u0011\"\u000e\u00031J!a\u0011\u0017\u0003%A+'o]5ti\u0016t7-Z*vaB|'\u000f\u001e\t\u0003\u000b*k\u0011A\u0012\u0006\u0003\u000f\"\u000bQa\u001d7gi)T\u0011!S\u0001\tOJL'P\u001f7fI&\u00111J\u0012\u0002\b\u0019><w-\u001b8h\u00031QGMY2UK6\u0004H.\u0019;f+\u0005q\u0005CA(Y\u001b\u0005\u0001&BA)S\u0003\u0011\u0019wN]3\u000b\u0005M#\u0016\u0001\u00026eE\u000eT!!\u0016,\u0002\u001fM\u0004(/\u001b8hMJ\fW.Z<pe.T\u0011aV\u0001\u0004_J<\u0017BA-Q\u00051QEMY2UK6\u0004H.\u0019;f\u00035QGMY2UK6\u0004H.\u0019;fA\u00059A-[1mK\u000e$X#A/\u0011\u0005y\u000bhBA0o\u001d\t\u0001GN\u0004\u0002bU:\u0011!-\u001b\b\u0003G\"t!\u0001Z4\u000e\u0003\u0015T!A\u001a\u001d\u0002\rq\u0012xn\u001c;?\u0013\u00059\u0014BA\u001b7\u0013\t\u0019D'\u0003\u0002le\u0005\u0011AMY\u0005\u0003_5T!a\u001b\u001a\n\u0005=\u0004\u0018AC*rY\n+\u0018\u000e\u001c3fe*\u0011q&\\\u0005\u0003eN\u0014q\u0001R5bY\u0016\u001cGO\u0003\u0002pa\u0006AA-[1mK\u000e$\b%\u0001\u0004=S:LGO\u0010\u000b\u0005ob\fy\u0001\u0005\u0002B\u0001!)A*\u0002a\u0001\u001d\"2\u0001P_A\u0005\u0003\u0017\u00012a_A\u0003\u001b\u0005a(BA?\u007f\u0003)\tgN\\8uCRLwN\u001c\u0006\u0004\u007f\u0006\u0005\u0011a\u00024bGR|'/\u001f\u0006\u0004\u0003\u0007!\u0016!\u00022fC:\u001c\u0018bAA\u0004y\nI\u0011+^1mS\u001aLWM]\u0001\u0006m\u0006dW/Z\u0011\u0003\u0003\u001b\t\u0011\u0004\u001f7s%\u0016\u0004xn]5u_JL(\n\u001a2d)\u0016l\u0007\u000f\\1uK\")1,\u0002a\u0002;\":\u0011q\u0002>\u0002\n\u0005M\u0011EAA\u000b\u0003]AHN\u001d*fa>\u001c\u0018\u000e^8ssN\u000bH\u000eR5bY\u0016\u001cG\u000fK\u0002\u0006\u00033\u00012a_A\u000e\u0013\r\ti\u0002 \u0002\n\u0003V$xn^5sK\u0012\fqA^1sCJ<7/\u0006\u0003\u0002$\u0005mC\u0003BA\u0013\u0003\u0003\u0002raOA\u0014\u0003W\tY$C\u0002\u0002*q\u0012a\u0001V;qY\u0016\u0014\u0004\u0003BA\u0017\u0003kqA!a\f\u00022A\u0011A\rP\u0005\u0004\u0003ga\u0014A\u0002)sK\u0012,g-\u0003\u0003\u00028\u0005e\"AB*ue&twMC\u0002\u00024q\u0002BaOA\u001fu%\u0019\u0011q\b\u001f\u0003\u000b\u0005\u0013(/Y=\t\u000f\u0005\rc\u00011\u0001\u0002F\u0005!\u0011M]4t!\u0019\t9%!\u0015\u0002X9!\u0011\u0011JA'\u001d\r!\u00171J\u0005\u0002{%\u0019\u0011q\n\u001f\u0002\u000fA\f7m[1hK&!\u00111KA+\u0005!IE/\u001a:bE2,'bAA(yA!\u0011\u0011LA.\u0019\u0001!q!!\u0018\u0007\u0005\u0004\tyFA\u0001U#\u0011\t\t'a\u001a\u0011\u0007m\n\u0019'C\u0002\u0002fq\u0012qAT8uQ&tw\rE\u0002<\u0003SJ1!a\u001b=\u0005\r\te._\u0001\rM&dG/\u001a:Ti\u0006$Xo\u001d\u000b\u0005\u0003K\t\t\bC\u0004\u0002t\u001d\u0001\r!!\u001e\u0002\rM$\u0018\r^;t!\u0015Y\u0014qOA>\u0013\r\tI\b\u0010\u0002\u0007\u001fB$\u0018n\u001c8\u0011\r\u00055\u0012QPA\u0016\u0013\u0011\ty(!\u000f\u0003\u0007M+G/A\u0007eK\u001a\fW\u000f\u001c;NCB\u0004XM]\u000b\u0003\u0003\u000b\u0003RaTAD\u0003\u0017K1!!#Q\u0005%\u0011vn^'baB,'\u000f\u0005\u0003\u0002\u000e\u0006MUBAAH\u0015\r\t\t\nL\u0001\u0005I\u0006$\u0018-\u0003\u0003\u0002\u0016\u0006=%!\u0004#fa\u0016tG-\u001a8dsJ{w/\u0001\beK\u001a\fW\u000f\u001c;NCB\u0004XM\u001d\u0011\u0002\u0019\u0011,g-Y;miF+XM]=\u0016\u0005\u0005-\u0012!\u00043fM\u0006,H\u000e^)vKJL\b%\u0001\u000fT)6#vLR%O\t~\u0013\u0015lX$B)\u0016{&+\u0012'F\u0003N+u,\u0013#\u0002;M#V\nV0G\u0013:#uLQ-`\u000f\u0006#Vi\u0018*F\u0019\u0016\u000b5+R0J\t\u0002\nQBZ5oIR\u000b7o[\"j+&$\u0017A\u00044j]\u0012$\u0016m]6DSVKG\rI\u0001\u000bi\u0006\u001c8.\u00133ICNDG\u0003BA\u0016\u0003WCq!!,\u0011\u0001\u0004\tY#\u0001\u0004uCN\\\u0017\nZ\u0001\u0014M&tGMQ=HCR,'+\u001a7fCN,\u0017\n\u001a\u000b\u0005\u0003g\u000bI\f\u0005\u0004\u0002H\u0005U\u00161R\u0005\u0005\u0003o\u000b)FA\u0002TKFDq!a/\u0012\u0001\u0004\ti,A\u0005sK2,\u0017m]3JIB!\u0011qXAi\u001d\u0011\t\t-!4\u000f\t\u0005\r\u00171\u001a\b\u0005\u0003\u000b\fIMD\u0002b\u0003\u000fL!!\r\u001a\n\u0005=\u0002\u0014BA\u0017/\u0013\r\ty\rL\u0001\u0005\u0007&LE-\u0003\u0003\u0002T\u0006U'\u0001B\"j\u0013\u0012T1!a4-\u0003Y1\u0017N\u001c3CsB\u000b'\u000f^5bYR\u000b'oZ3u\u0013\u0012\u001cHCBAZ\u00037\f\t\u000fC\u0004\u0002^J\u0001\r!a8\u0002\u0013A\f'/\u001a8u\u0013\u0012\u001c\bCBA\u0017\u0003{\ni\fC\u0004\u0002tI\u0001\r!!\u001e\u0002\u001fM#V\nV0G\u0013:#uLQ-`\u0013\u0012\u000b\u0001c\u0015+N)~3\u0015J\u0014#`\u0005f{\u0016\n\u0012\u0011\u0002\u0011\u0019Lg\u000e\u001a\"z\u0013\u0012$B!a#\u0002l\"9\u0011Q^\u000bA\u0002\u0005u\u0016\u0001\u00043fa\u0016tG-\u001a8ds&#\u0017AE*U\u001bR{v)\u0012+`)\u0006\u0013v)\u0012+`\u0013\u0012\u000b1c\u0015+N)~;U\tV0U\u0003J;U\tV0J\t\u0002\n1bZ3u)\u0006\u0014x-\u001a;JIR!\u0011q_A}!\u0015Y\u0014qOA\u0016\u0011\u001d\ti\u000f\u0007a\u0001\u0003{\u000bqBZ5oI\nKH+\u0019:hKRLEm\u001d\u000b\u0007\u0003g\u000byPa\u0001\t\u000f\t\u0005\u0011\u00041\u0001\u0002`\u0006IA/\u0019:hKRLEm\u001d\u0005\b\u0003gJ\u0002\u0019AA;\u0003Y\u0019F+\u0014+`\u0013:\u001bVI\u0015+`\t\u0016\u0003VI\u0014#F\u001d\u000eK\u0016aF*U\u001bR{\u0016JT*F%R{F)\u0012)F\u001d\u0012+ejQ-!\u0003AIgn]3si\u0012+\u0007/\u001a8eK:\u001c\u0017\u0010\u0006\u0003\u0003\u000e\tM\u0001cA\u001e\u0003\u0010%\u0019!\u0011\u0003\u001f\u0003\tUs\u0017\u000e\u001e\u0005\b\u0005+a\u0002\u0019\u0001B\f\u0003)!W\r]3oI\u0016t7-\u001f\t\u0005\u00053\u0011y\"\u0004\u0002\u0003\u001c)\u0019!Q\u0004\u001a\u0002\r\u0011|W.Y5o\u0013\u0011\u0011\tCa\u0007\u0003\u0015\u0011+\u0007/\u001a8eK:\u001c\u00170A\u0015T)6#v,\u0013(T\u000bJ#v\fR#Q\u000b:#UIT\"Z?^KE\u000bS0H\u0003R+u\fV!T\u0017~+\u0016\nR\u0001+'RkEkX%O'\u0016\u0013Fk\u0018#F!\u0016sE)\u0012(D3~;\u0016\n\u0016%`\u000f\u0006#Vi\u0018+B'.{V+\u0013#!\u0003}Ign]3si\u0012+\u0007/\u001a8eK:\u001c\u0017pV5uQ\u001e\u000bG/\u001a+bg.,\u0016\u000e\u001a\u000b\u0005\u0005W\u0011y\u0003\u0006\u0003\u0003\u000e\t5\u0002b\u0002B\u000b?\u0001\u0007!q\u0003\u0005\b\u0005cy\u0002\u0019\u0001B\u001a\u0003-9\u0017\r^3UCN\\W+\u001b3\u0011\t\tU\"\u0011\b\b\u0004\u0003\n]\u0012bAA(Y%!!1\bB\u001f\u0005\u0015\u0019\u0015.V5e\u0015\r\ty\u0005L\u0001\f'RkEk\u0018#F\u0019\u0016#V)\u0001\u0007T)6#v\fR#M\u000bR+\u0005%\u0001\teK2,G/\u001a#fa\u0016tG-\u001a8dsR!!Q\u0002B$\u0011\u001d\u0011IE\ta\u0001\u0003W\t!!\u001b3\u0015\t\t5!Q\n\u0005\b\u0005+\u0019\u0003\u0019\u0001B\f\u0003i\u0019F+\u0014+`\t\u0016cU\tV#`\u0005f{&+\u0012'F\u0003N+u,V%E\u0003m\u0019F+\u0014+`\t\u0016cU\tV#`\u0005f{&+\u0012'F\u0003N+u,V%EA\u0005\u0011B-\u001a7fi\u0016\u0014\u0015PU3mK\u0006\u001cX-V5e)\u0011\u00119F!\u0018\u0011\u0007m\u0012I&C\u0002\u0003\\q\u0012qAQ8pY\u0016\fg\u000eC\u0004\u0003`\u0019\u0002\rAa\r\u0002\u0015I,G.Z1tKVKG-A\u0006T)6#v,\u0016)E\u0003R+\u0015\u0001D*U\u001bR{V\u000b\u0015#B)\u0016\u0003\u0013\u0001E;qI\u0006$X\rR3qK:$WM\\2z)\u0011\u0011iA!\u001b\t\u000f\tU\u0011\u00061\u0001\u0003\u0018\u0005Qq-\u001a;UCJ<W\r^:\u0015\t\t=$\u0011\u000f\t\bw\u0005\u001d\u00121FA\u0016\u0011\u001d\u0011)B\u000ba\u0001\u0005/A3\u0001\u0001B;!\u0011\u00119H! \u000e\u0005\te$b\u0001B>a\u0006YAO]1og\u0006\u001cG/[8o\u0013\u0011\u0011yH!\u001f\u0003\u001f%\u001bHK]1og\u0006\u001cG/[8oC2D3\u0001\u0001BB!\u0011\u0011)Ia#\u000e\u0005\t\u001d%b\u0001BE)\u0006Q1\u000f^3sK>$\u0018\u0010]3\n\t\t5%q\u0011\u0002\u000b%\u0016\u0004xn]5u_JL\bf\u0002\u0001\u0003\u0012\u0006%!q\u0014\t\u0005\u0005'\u0013Y*\u0004\u0002\u0003\u0016*\u0019QPa&\u000b\u0007\teE+A\u0004d_:$X\r\u001f;\n\t\tu%Q\u0013\u0002\b!J|g-\u001b7fY\t\u0011\t+I\u00010\u0001")
public class DependencyPersistence
implements PersistenceSupport,
Logging {
    private final JdbcTemplate jdbcTemplate;
    private final SqlBuilder.Dialect dialect;
    private final RowMapper<DependencyRow> defaultMapper;
    private final String defaultQuery;
    private final String STMT_FIND_BY_GATE_RELEASE_ID;
    private final String findTaskCiUid;
    private final String STMT_FIND_BY_ID;
    private final String STMT_GET_TARGET_ID;
    private final String STMT_INSERT_DEPENDENCY;
    private final String STMT_INSERT_DEPENDENCY_WITH_GATE_TASK_UID;
    private final String STMT_DELETE;
    private final String STMT_DELETE_BY_RELEASE_UID;
    private final String STMT_UPDATE;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private NamedParameterJdbcTemplate namedTemplate;
    private volatile boolean bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    @Override
    public Integer sqlInsert(String pkColumn, String sqlStatement, Map<String, Object> params) {
        return PersistenceSupport.sqlInsert$(this, pkColumn, sqlStatement, params);
    }

    @Override
    public <R> R sqlInsert(String pkColumn, String sqlStatement, Map<String, Object> params, Function1<Integer, R> mapper) {
        return (R)PersistenceSupport.sqlInsert$((PersistenceSupport)this, pkColumn, sqlStatement, params, mapper);
    }

    @Override
    public <R> R sqlInsert(String pkColumn, String sqlStatement, MapSqlParameterSource params, Function1<Integer, R> mapper) {
        return (R)PersistenceSupport.sqlInsert$((PersistenceSupport)this, pkColumn, sqlStatement, params, mapper);
    }

    @Override
    public void sqlInsert(String sqlStatement, Map<String, Object> params) {
        PersistenceSupport.sqlInsert$(this, sqlStatement, params);
    }

    @Override
    public <R> R sqlExec(String sqlStatement, Map<String, Object> params, PreparedStatementCallback<R> callback) {
        return (R)PersistenceSupport.sqlExec$(this, sqlStatement, params, callback);
    }

    @Override
    public <R> R sqlExecWithContent(String sqlStatement, Map<String, Object> params, Tuple2<String, String> contentParam, Function1<Object, R> mapper) {
        return (R)PersistenceSupport.sqlExecWithContent$(this, sqlStatement, params, contentParam, mapper);
    }

    @Override
    public <R> R sqlInsertWithContent(String pkColumn, String sqlStatement, Map<String, Object> params, Tuple2<String, String> contentParam, Function1<Integer, R> mapper) {
        return (R)PersistenceSupport.sqlInsertWithContent$(this, pkColumn, sqlStatement, params, contentParam, mapper);
    }

    @Override
    public <R> R sqlUpdate(String sqlStatement, Map<String, Object> params, Function1<Object, R> mapper) {
        return (R)PersistenceSupport.sqlUpdate$(this, sqlStatement, params, mapper);
    }

    @Override
    public <R> R sqlSet(String sqlStatement, Function1<PreparedStatement, PreparedStatement> setup, Function1<Object, R> callback) {
        return (R)PersistenceSupport.sqlSet$(this, sqlStatement, setup, callback);
    }

    @Override
    public Function1<Object, BoxedUnit> checkCiUpdated(String entityId) {
        return PersistenceSupport.checkCiUpdated$(this, entityId);
    }

    @Override
    public Function1<Object, UUID> checkCiUpdated(Integer uid, Option<UUID> token, UUID freshToken) {
        return PersistenceSupport.checkCiUpdated$(this, uid, token, freshToken);
    }

    @Override
    public Function1<Object, BoxedUnit> checkCiDeleted(Integer uid) {
        return PersistenceSupport.checkCiDeleted$(this, uid);
    }

    @Override
    public <R> Buffer<R> sqlQuery(String sqlStatement, Map<String, Object> params, RowMapper<R> mapper) {
        return PersistenceSupport.sqlQuery$((PersistenceSupport)this, sqlStatement, params, mapper);
    }

    @Override
    public <R> Buffer<R> sqlQuery(String sqlStatement, Map<String, Object> params, Function1<ResultSet, R> mapper) {
        return PersistenceSupport.sqlQuery$((PersistenceSupport)this, sqlStatement, params, mapper);
    }

    @Override
    public <R> R sqlQuery(String sqlStatement, Map<String, Object> params, ResultSetExtractor<R> extractor) {
        return (R)PersistenceSupport.sqlQuery$((PersistenceSupport)this, sqlStatement, params, extractor);
    }

    @Override
    public Seq<Object> sqlBatch(String sqlStatement, Set<Map<String, Object>> parameters) {
        return PersistenceSupport.sqlBatch$(this, sqlStatement, parameters);
    }

    @Override
    public Seq<Object> sqlBatchWithContent(String sqlStatement, Seq<Tuple2<Map<String, Object>, Tuple2<String, String>>> params) {
        return PersistenceSupport.sqlBatchWithContent$(this, sqlStatement, params);
    }

    @Override
    public String pkName(String pkColumn) {
        return PersistenceSupport.pkName$(this, pkColumn);
    }

    @Override
    public byte[] compress(String text) {
        return CompressionSupport.compress$((CompressionSupport)this, text);
    }

    @Override
    public String decompress(InputStream inputStream) {
        return CompressionSupport.decompress$((CompressionSupport)this, inputStream);
    }

    @Override
    public byte[] compress(byte[] byteArray) {
        return CompressionSupport.compress$((CompressionSupport)this, byteArray);
    }

    @Override
    public byte[] decompress(byte[] byteArray) {
        return CompressionSupport.decompress$((CompressionSupport)this, byteArray);
    }

    @Override
    public <A> Option<A> findOptional(Function1<JdbcTemplate, A> body, JdbcTemplate jdbcTemplate) {
        return Utils.findOptional$(this, body, jdbcTemplate);
    }

    @Override
    public <A> Option<A> findOne(Function0<Buffer<A>> body) {
        return Utils.findOne$(this, body);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        DependencyPersistence dependencyPersistence = this;
        synchronized (dependencyPersistence) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    private NamedParameterJdbcTemplate namedTemplate$lzycompute() {
        DependencyPersistence dependencyPersistence = this;
        synchronized (dependencyPersistence) {
            if (!this.bitmap$0) {
                this.namedTemplate = PersistenceSupport.namedTemplate$(this);
                this.bitmap$0 = true;
            }
        }
        return this.namedTemplate;
    }

    @Override
    public NamedParameterJdbcTemplate namedTemplate() {
        return !this.bitmap$0 ? this.namedTemplate$lzycompute() : this.namedTemplate;
    }

    @Override
    public JdbcTemplate jdbcTemplate() {
        return this.jdbcTemplate;
    }

    @Override
    public SqlBuilder.Dialect dialect() {
        return this.dialect;
    }

    private <T> Tuple2<String, Object[]> varargs(Iterable<T> args) {
        Seq seq = args.toSeq();
        Tuple2 tuple2 = new Tuple2((Object)((TraversableOnce)seq.map((Function1 & Serializable & scala.Serializable)x$1 -> "?", Seq$.MODULE$.canBuildFrom())).mkString(", "), ((TraversableOnce)seq.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.AnyRef()));
        return tuple2;
    }

    private Tuple2<String, Object[]> filterStatus(Option<Set<String>> status) {
        return (Tuple2)status.fold((Function0 & Serializable & scala.Serializable)() -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)""), Array$.MODULE$.empty(ClassTag$.MODULE$.AnyRef())), (Function1 & Serializable & scala.Serializable)statuses -> {
            Tuple2<String, Object[]> tuple2 = this.varargs((Iterable)statuses);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            String placeholdersStatus = (String)tuple2._1();
            Object[] argsStatus = (Object[])tuple2._2();
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(12).append("AND d.").append(Schema$DEPENDENCIES$.MODULE$.GATE_STATUS()).append(" IN (").append(placeholdersStatus).append(")").toString()), (Object)argsStatus);
            return tuple22;
        });
    }

    private RowMapper<DependencyRow> defaultMapper() {
        return this.defaultMapper;
    }

    private String defaultQuery() {
        return this.defaultQuery;
    }

    private String STMT_FIND_BY_GATE_RELEASE_ID() {
        return this.STMT_FIND_BY_GATE_RELEASE_ID;
    }

    private String findTaskCiUid() {
        return this.findTaskCiUid;
    }

    private String taskIdHash(String taskId) {
        return TaskPersistence$.MODULE$.hash(Ids.getFolderlessId((String)taskId));
    }

    public Seq<DependencyRow> findByGateReleaseId(String releaseId) {
        this.logger().trace((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("Find dependencies by gate releaseId: '").append(releaseId).append("'").toString());
        return this.sqlQuery(this.STMT_FIND_BY_GATE_RELEASE_ID(), Utils$.MODULE$.params((Seq<Tuple2<String, ?>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"releaseId"), (Object)Ids.getName((String)CiId$.MODULE$.RichCiId(releaseId).normalized()))})), this.defaultMapper());
    }

    public Seq<DependencyRow> findByPartialTargetIds(Set<String> parentIds, Option<Set<String>> status) {
        Nil$ nil$;
        this.logger().trace((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(60).append("Find dependencies by targetIds starting with ").append(parentIds).append(" with statuses ").append(status).toString());
        if (parentIds.isEmpty()) {
            nil$ = Nil$.MODULE$;
        } else {
            String clause = ((TraversableOnce)parentIds.map((Function1 & Serializable & scala.Serializable)id -> {
                Tuple2 tuple2 = new Tuple2((Object)Ids.getReleaselessChildId((String)CiId$.MODULE$.RichCiId((String)id).normalized()), (Object)Ids.getName((String)Ids.releaseIdFrom((String)CiId$.MODULE$.RichCiId((String)id).normalized())));
                if (tuple2 != null) {
                    String string = (String)tuple2._1();
                    String releaseId = (String)tuple2._2();
                    if (string == null) {
                        return new StringBuilder(11).append("t.").append(Schema$RELEASES$.MODULE$.RELEASE_ID()).append(" LIKE '").append(releaseId).append("%'").toString();
                    }
                }
                if (tuple2 == null) throw new MatchError((Object)tuple2);
                String targetId = (String)tuple2._1();
                String releaseId = (String)tuple2._2();
                return new StringBuilder(23).append("d.").append(Schema$DEPENDENCIES$.MODULE$.TARGET_ID()).append(" LIKE '").append(targetId).append("%' AND t.").append(Schema$RELEASES$.MODULE$.RELEASE_ID()).append(" = '").append(releaseId).append("'").toString();
            }, Set$.MODULE$.canBuildFrom())).mkString("(", " OR ", ")");
            Tuple2<String, Object[]> tuple2 = this.filterStatus(status);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            String statusClause = (String)tuple2._1();
            Object[] args = (Object[])tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)statusClause, (Object)args);
            Tuple2 tuple23 = tuple22;
            String statusClause2 = (String)tuple23._1();
            Object[] args2 = (Object[])tuple23._2();
            nil$ = (Seq)JavaConverters$.MODULE$.asScalaBufferConverter(this.jdbcTemplate().query(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(36).append(this.defaultQuery()).append("\n           |  WHERE ").append(clause).append("\n           |  ").append(statusClause2).toString())).stripMargin(), args2, this.defaultMapper())).asScala();
        }
        return nil$;
    }

    private String STMT_FIND_BY_ID() {
        return this.STMT_FIND_BY_ID;
    }

    public DependencyRow findById(String dependencyId) {
        this.logger().trace((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(25).append("Find dependency by id: '").append(dependencyId).append("'").toString());
        return (DependencyRow)Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (DependencyRow)this.sqlQuery(this.STMT_FIND_BY_ID(), Utils$.MODULE$.params((Seq<Tuple2<String, ?>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dependencyId"), (Object)Ids.getName((String)dependencyId)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"taskIdHash"), (Object)this.taskIdHash(Ids.getParentId((String)CiId$.MODULE$.RichCiId(dependencyId).normalized())))})), this.defaultMapper()).headOption().getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NotFoundException(new StringBuilder(32).append("Dependency with Id '").append(dependencyId).append("' not found.").toString(), new Object[0]);
        })).recoverWith((PartialFunction)new scala.Serializable(null, dependencyId){
            public static final long serialVersionUID = 0L;
            private final String dependencyId$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof EmptyResultDataAccessException) {
                    EmptyResultDataAccessException emptyResultDataAccessException = (EmptyResultDataAccessException)A1;
                    object = new Failure((Throwable)new NotFoundException((Throwable)emptyResultDataAccessException, new StringBuilder(32).append("Dependency with Id '").append(this.dependencyId$1).append("' not found.").toString(), new Object[0]));
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = throwable instanceof EmptyResultDataAccessException;
                return bl;
            }
            {
                this.dependencyId$1 = dependencyId$1;
            }
        }).fold((Function1 & Serializable & scala.Serializable)x$6 -> {
            throw x$6;
        }, (Function1 & Serializable & scala.Serializable)x -> (DependencyRow)Predef$.MODULE$.identity(x));
    }

    private String STMT_GET_TARGET_ID() {
        return this.STMT_GET_TARGET_ID;
    }

    public Option<String> getTargetId(String dependencyId) {
        this.logger().trace((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Loading targetId of a dependency ").append(dependencyId).toString());
        return this.sqlQuery(this.STMT_GET_TARGET_ID(), Utils$.MODULE$.params((Seq<Tuple2<String, ?>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dependencyId"), (Object)Ids.getName((String)dependencyId)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"taskIdHash"), (Object)this.taskIdHash(Ids.getParentId((String)CiId$.MODULE$.RichCiId(dependencyId).normalized())))})), (Function1 & Serializable & scala.Serializable)rs -> (String)TargetRow$TargetRowOps$.MODULE$.getTargetId$extension(TargetRow$.MODULE$.TargetRowOps(TargetRow$.MODULE$.apply(rs.getString(Schema$FOLDERS$.MODULE$.FOLDER_PATH()), rs.getString(Schema$FOLDERS$.MODULE$.FOLDER_ID()), rs.getString(Schema$RELEASES$.MODULE$.RELEASE_ID()), rs.getString(Schema$DEPENDENCIES$.MODULE$.TARGET_ID())))).getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).headOption();
    }

    public Seq<DependencyRow> findByTargetIds(Set<String> targetIds, Option<Set<String>> status) {
        Nil$ nil$;
        this.logger().trace((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(47).append("Find dependencies by targetIds: ").append(targetIds).append(" with statuses ").append(status).toString());
        if (targetIds.isEmpty()) {
            nil$ = Nil$.MODULE$;
        } else {
            String clause = ((TraversableOnce)targetIds.map((Function1 & Serializable & scala.Serializable)id -> {
                Tuple2 tuple2 = new Tuple2((Object)Ids.getReleaselessChildId((String)CiId$.MODULE$.RichCiId((String)id).normalized()), (Object)Ids.getName((String)Ids.releaseIdFrom((String)id)));
                if (tuple2 != null) {
                    String string = (String)tuple2._1();
                    String releaseId = (String)tuple2._2();
                    if (string == null) {
                        return new StringBuilder(22).append("d.").append(Schema$DEPENDENCIES$.MODULE$.TARGET_ID()).append(" is NULL AND t.").append(Schema$RELEASES$.MODULE$.RELEASE_ID()).append(" = '").append(releaseId).append("'").toString();
                    }
                }
                if (tuple2 == null) throw new MatchError((Object)tuple2);
                String targetId = (String)tuple2._1();
                String releaseId = (String)tuple2._2();
                return new StringBuilder(19).append("d.").append(Schema$DEPENDENCIES$.MODULE$.TARGET_ID()).append(" = '").append(targetId).append("' AND t.").append(Schema$RELEASES$.MODULE$.RELEASE_ID()).append(" = '").append(releaseId).append("'").toString();
            }, Set$.MODULE$.canBuildFrom())).mkString("(", " OR ", ")");
            Tuple2<String, Object[]> tuple2 = this.filterStatus(status);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            String statusQuery = (String)tuple2._1();
            Object[] statusArgs = (Object[])tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)statusQuery, (Object)statusArgs);
            Tuple2 tuple23 = tuple22;
            String statusQuery2 = (String)tuple23._1();
            Object[] statusArgs2 = (Object[])tuple23._2();
            nil$ = (Seq)JavaConverters$.MODULE$.asScalaBufferConverter(this.jdbcTemplate().query(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(45).append(this.defaultQuery()).append("\n           |  WHERE ").append(clause).append("\n           |  ").append(statusQuery2).append("\n        ").toString())).stripMargin(), statusArgs2, this.defaultMapper())).asScala();
        }
        return nil$;
    }

    private String STMT_INSERT_DEPENDENCY() {
        return this.STMT_INSERT_DEPENDENCY;
    }

    public void insertDependency(Dependency dependency) {
        this.logger().trace((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Inserting dependency ").append(dependency.getId()).append(" of Gate ").append(dependency.getGateTask().getId()).append(" to Target ").append(dependency.getTargetId()).toString());
        Tuple2<String, String> tuple2 = this.getTargets(dependency);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String targetId = (String)tuple2._1();
        String targetReleaseId = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)targetId, (Object)targetReleaseId);
        Tuple2 tuple23 = tuple22;
        String targetId2 = (String)tuple23._1();
        String targetReleaseId2 = (String)tuple23._2();
        this.sqlExec(this.STMT_INSERT_DEPENDENCY(), Utils$.MODULE$.params((Seq<Tuple2<String, ?>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dependencyId"), (Object)Ids.getName((String)dependency.getId())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"taskIdHash"), (Object)this.taskIdHash(Ids.getParentId((String)CiId$.MODULE$.RichCiId(dependency.getId()).normalized()))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"gateStatus"), (Object)dependency.getGateTask().getStatus().name()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"targetId"), (Object)targetId2), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"targetReleaseId"), Option$.MODULE$.apply((Object)targetReleaseId2).getOrElse((Function0 & Serializable & scala.Serializable)() -> ""))})), ps -> {
            DependencyPersistence.$anonfun$insertDependency$3(dependency, ps);
            return BoxedUnit.UNIT;
        });
    }

    private String STMT_INSERT_DEPENDENCY_WITH_GATE_TASK_UID() {
        return this.STMT_INSERT_DEPENDENCY_WITH_GATE_TASK_UID;
    }

    public void insertDependencyWithGateTaskUid(Integer gateTaskUid, Dependency dependency) {
        this.logger().trace((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Inserting dependency ").append(dependency.getId()).append(" of Gate ").append(dependency.getGateTask().getId()).append(" to Target ").append(dependency.getTargetId()).toString());
        Tuple2<String, String> tuple2 = this.getTargets(dependency);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String targetId = (String)tuple2._1();
        String targetReleaseId = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)targetId, (Object)targetReleaseId);
        Tuple2 tuple23 = tuple22;
        String targetId2 = (String)tuple23._1();
        String targetReleaseId2 = (String)tuple23._2();
        this.sqlExec(this.STMT_INSERT_DEPENDENCY_WITH_GATE_TASK_UID(), Utils$.MODULE$.params((Seq<Tuple2<String, ?>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dependencyId"), (Object)Ids.getName((String)dependency.getId())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"gateTaskUid"), (Object)gateTaskUid), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"gateStatus"), (Object)dependency.getGateTask().getStatus().name()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"targetId"), (Object)targetId2), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"targetReleaseId"), Option$.MODULE$.apply((Object)targetReleaseId2).getOrElse((Function0 & Serializable & scala.Serializable)() -> ""))})), ps -> {
            DependencyPersistence.$anonfun$insertDependencyWithGateTaskUid$3(dependency, ps);
            return BoxedUnit.UNIT;
        });
    }

    private String STMT_DELETE() {
        return this.STMT_DELETE;
    }

    public void deleteDependency(String id) {
        this.sqlUpdate(this.STMT_DELETE(), Utils$.MODULE$.params((Seq<Tuple2<String, ?>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dependencyId"), (Object)Ids.getName((String)id)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"taskIdHash"), (Object)this.taskIdHash(Ids.getParentId((String)CiId$.MODULE$.RichCiId(id).normalized())))})), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$12 -> {});
    }

    public void deleteDependency(Dependency dependency) {
        this.logger().trace((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(40).append("Deleting dependency ").append(dependency.getId()).append(" of Gate ").append(dependency.getGateTask().getId()).append(" to Target ").append(dependency.getTargetId()).toString());
        this.deleteDependency(dependency.getId());
    }

    private String STMT_DELETE_BY_RELEASE_UID() {
        return this.STMT_DELETE_BY_RELEASE_UID;
    }

    public boolean deleteByReleaseUid(Integer releaseUid) {
        return BoxesRunTime.unboxToBoolean(this.sqlUpdate(this.STMT_DELETE_BY_RELEASE_UID(), Utils$.MODULE$.params((Seq<Tuple2<String, ?>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"releaseUid"), (Object)releaseUid)})), (Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$13 -> x$13 != 0));
    }

    private String STMT_UPDATE() {
        return this.STMT_UPDATE;
    }

    public void updateDependency(Dependency dependency) {
        this.logger().trace((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(40).append("Updating dependency ").append(dependency.getId()).append(" of Gate ").append(dependency.getGateTask().getId()).append(" to Target ").append(dependency.getTargetId()).toString());
        Tuple2<String, String> tuple2 = this.getTargets(dependency);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String targetId = (String)tuple2._1();
        String targetReleaseId = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)targetId, (Object)targetReleaseId);
        Tuple2 tuple23 = tuple22;
        String targetId2 = (String)tuple23._1();
        String targetReleaseId2 = (String)tuple23._2();
        this.sqlExec(this.STMT_UPDATE(), Utils$.MODULE$.params((Seq<Tuple2<String, ?>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"gateStatus"), (Object)dependency.getGateTask().getStatus().name()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"targetId"), (Object)targetId2), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"targetReleaseId"), Option$.MODULE$.apply((Object)targetReleaseId2).getOrElse((Function0 & Serializable & scala.Serializable)() -> "")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dependencyId"), (Object)Ids.getName((String)dependency.getId())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"taskIdHash"), (Object)this.taskIdHash(Ids.getParentId((String)CiId$.MODULE$.RichCiId(dependency.getId()).normalized())))})), ps -> {
            DependencyPersistence.$anonfun$updateDependency$3(dependency, ps);
            return BoxedUnit.UNIT;
        });
    }

    private Tuple2<String, String> getTargets(Dependency dependency) {
        String targetId = CiId$.MODULE$.RichCiId(dependency.getTargetId()).normalized();
        return !dependency.hasVariableTarget() && !dependency.isArchived() ? (Ids.isReleaseId((String)targetId) ? new Tuple2(null, (Object)Ids.getName((String)targetId)) : (Tuple2)Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> new Tuple2((Object)Ids.getReleaselessChildId((String)targetId), (Object)Ids.getName((String)Ids.releaseIdFrom((String)targetId)))).getOrElse((Function0 & Serializable & scala.Serializable)() -> new Tuple2((Object)targetId, null))) : new Tuple2((Object)targetId, null);
    }

    public static final /* synthetic */ void $anonfun$insertDependency$6(boolean x$9) {
    }

    public static final /* synthetic */ void $anonfun$insertDependency$3(Dependency dependency$1, PreparedStatement ps) {
        Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> ps.execute()).fold((Function1 & Serializable & scala.Serializable)t -> {
            throw new ReleaseStoreException(new StringBuilder(28).append("Failed to insert dependency ").append(dependency$1.getId()).toString(), (Throwable)t);
        }, (Function1 & Serializable & scala.Serializable)x$9 -> {
            DependencyPersistence.$anonfun$insertDependency$6(BoxesRunTime.unboxToBoolean((Object)x$9));
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$insertDependencyWithGateTaskUid$6(boolean x$11) {
    }

    public static final /* synthetic */ void $anonfun$insertDependencyWithGateTaskUid$3(Dependency dependency$2, PreparedStatement ps) {
        Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> ps.execute()).fold((Function1 & Serializable & scala.Serializable)t -> {
            throw new ReleaseStoreException(new StringBuilder(28).append("Failed to insert dependency ").append(dependency$2.getId()).toString(), (Throwable)t);
        }, (Function1 & Serializable & scala.Serializable)x$11 -> {
            DependencyPersistence.$anonfun$insertDependencyWithGateTaskUid$6(BoxesRunTime.unboxToBoolean((Object)x$11));
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$updateDependency$3(Dependency dependency$4, PreparedStatement ps) {
        Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> ps.executeUpdate());
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            int n = BoxesRunTime.unboxToInt((Object)success.value());
            if (n == 0) {
                throw new NotFoundException(new StringBuilder(42).append("Could not find dependency to update by ID ").append(dependency$4.getId()).toString(), new Object[0]);
            }
        } else {
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable ex = failure.exception();
                throw new ReleaseStoreException(new StringBuilder(28).append("Failed to update dependency ").append(dependency$4.getId()).toString(), ex);
            }
            throw new MatchError((Object)try_);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    @Autowired
    public DependencyPersistence(@Qualifier(value="xlrRepositoryJdbcTemplate") JdbcTemplate jdbcTemplate, @Qualifier(value="xlrRepositorySqlDialect") SqlBuilder.Dialect dialect) {
        this.jdbcTemplate = jdbcTemplate;
        this.dialect = dialect;
        Utils.$init$(this);
        CompressionSupport.$init$(this);
        PersistenceSupport.$init$(this);
        Logging.$init$((Logging)this);
        this.defaultMapper = (rs, x$3) -> DependencyRow$.MODULE$.apply(FolderId$.MODULE$.$div$extension(FolderId$.MODULE$.apply(rs.getString(Schema$FOLDERS$.MODULE$.FOLDER_PATH())), rs.getString(Schema$FOLDERS$.MODULE$.FOLDER_ID())), rs.getString(Schema$TASKS$.MODULE$.TASK_ID()), rs.getString(Schema$DEPENDENCIES$.MODULE$.DEPENDENCY_ID()), rs.getString(Schema$DEPENDENCIES$.MODULE$.GATE_STATUS()), (Option<String>)Option$.MODULE$.apply((Object)rs.getString(Schema$DEPENDENCIES$.MODULE$.TARGET_RELEASE_ID())).map((Function1 & Serializable & scala.Serializable)x$4 -> FolderId$.MODULE$.absolute$extension(FolderId$.MODULE$.apply((String)x$4))), rs.getString(Schema$DEPENDENCIES$.MODULE$.TARGET_ID()));
        this.defaultQuery = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(323).append("SELECT\n       | fr.").append(Schema$FOLDERS$.MODULE$.FOLDER_PATH()).append(",\n       | fr.").append(Schema$FOLDERS$.MODULE$.FOLDER_ID()).append(",\n       | k.").append(Schema$TASKS$.MODULE$.TASK_ID()).append(",\n       | d.").append(Schema$DEPENDENCIES$.MODULE$.DEPENDENCY_ID()).append(",\n       | d.").append(Schema$DEPENDENCIES$.MODULE$.GATE_STATUS()).append(",\n       | d.").append(Schema$DEPENDENCIES$.MODULE$.TARGET_ID()).append(",\n       | ").append(ReleasesSqlBuilder$.MODULE$.selectReleaseFullPathSql("t", "ft", Schema$DEPENDENCIES$.MODULE$.TARGET_RELEASE_ID(), dialect)).append("\n       |  FROM ").append(Schema$DEPENDENCIES$.MODULE$.TABLE()).append(" d\n       |  JOIN ").append(Schema$TASKS$.MODULE$.TABLE()).append(" k ON\n       |    k.").append(Schema$TASKS$.MODULE$.CI_UID()).append(" = d.").append(Schema$DEPENDENCIES$.MODULE$.GATE_TASK_UID()).append("\n       |  JOIN ").append(Schema$RELEASES$.MODULE$.TABLE()).append(" r ON\n       |    r.").append(Schema$RELEASES$.MODULE$.CI_UID()).append(" = k.").append(Schema$TASKS$.MODULE$.RELEASE_UID()).append("\n       |  JOIN ").append(Schema$FOLDERS$.MODULE$.TABLE()).append(" fr ON\n       |    fr.").append(Schema$FOLDERS$.MODULE$.CI_UID()).append(" = r.").append(Schema$RELEASES$.MODULE$.FOLDER_CI_UID()).append("\n       |  JOIN ").append(Schema$RELEASES$.MODULE$.TABLE()).append(" t ON\n       |    t.").append(Schema$RELEASES$.MODULE$.CI_UID()).append(" = d.").append(Schema$DEPENDENCIES$.MODULE$.TARGET_RELEASE_UID()).append("\n       |  JOIN ").append(Schema$FOLDERS$.MODULE$.TABLE()).append(" ft ON\n       |    ft.").append(Schema$FOLDERS$.MODULE$.CI_UID()).append(" = t.").append(Schema$RELEASES$.MODULE$.FOLDER_CI_UID()).toString())).stripMargin();
        this.STMT_FIND_BY_GATE_RELEASE_ID = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(44).append(this.defaultQuery()).append("\n       |  WHERE\n       |    r.").append(Schema$RELEASES$.MODULE$.RELEASE_ID()).append(" = :releaseId").toString())).stripMargin();
        this.findTaskCiUid = new StringBuilder(36).append("(SELECT ").append(Schema$TASKS$.MODULE$.CI_UID()).append(" FROM ").append(Schema$TASKS$.MODULE$.TABLE()).append(" WHERE ").append(Schema$TASKS$.MODULE$.TASK_ID_HASH()).append(" = :taskIdHash)").toString();
        this.STMT_FIND_BY_ID = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(69).append(this.defaultQuery()).append("\n       |  WHERE\n       |    d.").append(Schema$DEPENDENCIES$.MODULE$.DEPENDENCY_ID()).append(" = :dependencyId\n       |    AND d.").append(Schema$DEPENDENCIES$.MODULE$.GATE_TASK_UID()).append(" = ").append(this.findTaskCiUid()).toString())).stripMargin();
        this.STMT_GET_TARGET_ID = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(212).append("SELECT\n       |  f.").append(Schema$FOLDERS$.MODULE$.FOLDER_PATH()).append(",\n       |  f.").append(Schema$FOLDERS$.MODULE$.FOLDER_ID()).append(",\n       |  r.").append(Schema$RELEASES$.MODULE$.RELEASE_ID()).append(",\n       |  d.").append(Schema$DEPENDENCIES$.MODULE$.TARGET_ID()).append("\n       |  FROM ").append(Schema$DEPENDENCIES$.MODULE$.TABLE()).append(" d\n       |  LEFT OUTER JOIN ").append(Schema$RELEASES$.MODULE$.TABLE()).append(" r ON r.").append(Schema$RELEASES$.MODULE$.CI_UID()).append(" = d.").append(Schema$DEPENDENCIES$.MODULE$.TARGET_RELEASE_UID()).append("\n       |  LEFT OUTER JOIN ").append(Schema$FOLDERS$.MODULE$.TABLE()).append(" f ON f.").append(Schema$FOLDERS$.MODULE$.CI_UID()).append(" = r.").append(Schema$RELEASES$.MODULE$.FOLDER_CI_UID()).append("\n       |  WHERE ").append(Schema$DEPENDENCIES$.MODULE$.DEPENDENCY_ID()).append(" = :dependencyId\n       |  AND d.").append(Schema$DEPENDENCIES$.MODULE$.GATE_TASK_UID()).append(" = ").append(this.findTaskCiUid()).toString())).stripMargin();
        this.STMT_INSERT_DEPENDENCY = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(236).append("INSERT INTO ").append(Schema$DEPENDENCIES$.MODULE$.TABLE()).append(" (\n       | ").append(Schema$DEPENDENCIES$.MODULE$.DEPENDENCY_ID()).append(",\n       | ").append(Schema$DEPENDENCIES$.MODULE$.GATE_TASK_UID()).append(",\n       | ").append(Schema$DEPENDENCIES$.MODULE$.GATE_STATUS()).append(",\n       | ").append(Schema$DEPENDENCIES$.MODULE$.TARGET_ID()).append(",\n       | ").append(Schema$DEPENDENCIES$.MODULE$.TARGET_RELEASE_UID()).append("\n       |) VALUES (\n       |  :dependencyId,\n       |  ").append(this.findTaskCiUid()).append(",\n       |  :gateStatus,\n       |  :targetId,\n       |  (SELECT r.").append(Schema$RELEASES$.MODULE$.CI_UID()).append(" FROM ").append(Schema$RELEASES$.MODULE$.TABLE()).append(" r WHERE r.").append(Schema$RELEASES$.MODULE$.RELEASE_ID()).append(" = :targetReleaseId)\n       |)").toString())).stripMargin();
        this.STMT_INSERT_DEPENDENCY_WITH_GATE_TASK_UID = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(248).append("INSERT INTO ").append(Schema$DEPENDENCIES$.MODULE$.TABLE()).append(" (\n       | ").append(Schema$DEPENDENCIES$.MODULE$.DEPENDENCY_ID()).append(",\n       | ").append(Schema$DEPENDENCIES$.MODULE$.GATE_TASK_UID()).append(",\n       | ").append(Schema$DEPENDENCIES$.MODULE$.GATE_STATUS()).append(",\n       | ").append(Schema$DEPENDENCIES$.MODULE$.TARGET_ID()).append(",\n       | ").append(Schema$DEPENDENCIES$.MODULE$.TARGET_RELEASE_UID()).append("\n       |) VALUES (\n       |  :dependencyId,\n       |  :gateTaskUid,\n       |  :gateStatus,\n       |  :targetId,\n       |  (SELECT r.").append(Schema$RELEASES$.MODULE$.CI_UID()).append(" FROM ").append(Schema$RELEASES$.MODULE$.TABLE()).append(" r WHERE r.").append(Schema$RELEASES$.MODULE$.RELEASE_ID()).append(" = :targetReleaseId)\n       |)").toString())).stripMargin();
        this.STMT_DELETE = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(72).append("DELETE FROM ").append(Schema$DEPENDENCIES$.MODULE$.TABLE()).append("\n       | WHERE\n       |  ").append(Schema$DEPENDENCIES$.MODULE$.DEPENDENCY_ID()).append(" = :dependencyId\n       |  AND ").append(Schema$DEPENDENCIES$.MODULE$.GATE_TASK_UID()).append(" = ").append(this.findTaskCiUid()).toString())).stripMargin();
        this.STMT_DELETE_BY_RELEASE_UID = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(148).append("DELETE FROM ").append(Schema$DEPENDENCIES$.MODULE$.TABLE()).append("\n       | WHERE\n       |  ").append(Schema$DEPENDENCIES$.MODULE$.TARGET_RELEASE_UID()).append(" = :releaseUid OR EXISTS (\n       |    SELECT 1 FROM ").append(Schema$TASKS$.MODULE$.TABLE()).append(" t\n       |    WHERE t.").append(Schema$TASKS$.MODULE$.CI_UID()).append(" = ").append(Schema$DEPENDENCIES$.MODULE$.GATE_TASK_UID()).append(" AND t.").append(Schema$TASKS$.MODULE$.RELEASE_UID()).append(" = :releaseUid\n       |)").toString())).stripMargin();
        this.STMT_UPDATE = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(207).append("UPDATE ").append(Schema$DEPENDENCIES$.MODULE$.TABLE()).append("\n       | SET\n       |  ").append(Schema$DEPENDENCIES$.MODULE$.GATE_STATUS()).append(" = :gateStatus,\n       |  ").append(Schema$DEPENDENCIES$.MODULE$.TARGET_ID()).append(" = :targetId,\n       |  ").append(Schema$DEPENDENCIES$.MODULE$.TARGET_RELEASE_UID()).append(" =\n       |   (SELECT r.").append(Schema$RELEASES$.MODULE$.CI_UID()).append(" FROM ").append(Schema$RELEASES$.MODULE$.TABLE()).append(" r WHERE r.").append(Schema$RELEASES$.MODULE$.RELEASE_ID()).append(" = :targetReleaseId)\n       |  WHERE\n       |    ").append(Schema$DEPENDENCIES$.MODULE$.DEPENDENCY_ID()).append(" = :dependencyId\n       |    AND ").append(Schema$DEPENDENCIES$.MODULE$.GATE_TASK_UID()).append(" = ").append(this.findTaskCiUid()).toString())).stripMargin();
    }
}

