/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.domain.Attachment;
import com.xebialabs.xlrelease.domain.Changes;
import com.xebialabs.xlrelease.domain.Comment;
import com.xebialabs.xlrelease.domain.PlanItem;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.events.AttachmentCreatedEvent;
import com.xebialabs.xlrelease.domain.events.CommentCreatedEvent;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.domain.facet.Facet;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.repository.AttachmentRepository;
import com.xebialabs.xlrelease.repository.FacetRepository;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.repository.TaskRepository;
import com.xebialabs.xlrelease.service.AttachmentService;
import com.xebialabs.xlrelease.service.CommentService;
import com.xebialabs.xlrelease.user.User;
import com.xebialabs.xlrelease.utils.CloseableUtils$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Collection;
import org.joda.time.DateTime;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Service
@ScalaSignature(bytes="\u0006\u0001\u0005-f\u0001B\u000b\u0017\u0001}A\u0001B\f\u0001\u0003\u0006\u0004%\ta\f\u0005\ti\u0001\u0011\t\u0011)A\u0005a!AQ\u0007\u0001BC\u0002\u0013\u0005a\u0007\u0003\u0005;\u0001\t\u0005\t\u0015!\u00038\u0011!Y\u0004A!b\u0001\n\u0003a\u0004\u0002C\"\u0001\u0005\u0003\u0005\u000b\u0011B\u001f\t\u0011\u0011\u0003!Q1A\u0005\u0002\u0015C\u0001\"\u0013\u0001\u0003\u0002\u0003\u0006IA\u0012\u0005\t\u0015\u0002\u0011)\u0019!C\u0001\u0017\"Aq\n\u0001B\u0001B\u0003%A\n\u0003\u0005Q\u0001\t\u0015\r\u0011\"\u0001R\u0011!)\u0006A!A!\u0002\u0013\u0011\u0006\u0002\u0003,\u0001\u0005\u000b\u0007I\u0011A,\t\u0011y\u0003!\u0011!Q\u0001\naCQa\u0018\u0001\u0005\u0002\u0001DQ\u0001\u001f\u0001\u0005\u0002eDq!a\f\u0001\t\u0013\t\t\u0004C\u0004\u0002l\u0001!I!!\u001c\t\u000f\u0005m\u0004\u0001\"\u0005\u0002~!9\u00111\u0013\u0001\u0005\u0012\u0005U%AF\"iC:<W-\u0012=fGV$\u0018n\u001c8TKJ4\u0018nY3\u000b\u0005]A\u0012aB:feZL7-\u001a\u0006\u00033i\t\u0011\u0002\u001f7sK2,\u0017m]3\u000b\u0005ma\u0012!\u0003=fE&\fG.\u00192t\u0015\u0005i\u0012aA2p[\u000e\u00011c\u0001\u0001!MA\u0011\u0011\u0005J\u0007\u0002E)\t1%A\u0003tG\u0006d\u0017-\u0003\u0002&E\t1\u0011I\\=SK\u001a\u0004\"a\n\u0017\u000e\u0003!R!!\u000b\u0016\u0002\u000bMdg\r\u000e6\u000b\u0003-\n\u0001b\u001a:jujdW\rZ\u0005\u0003[!\u0012q\u0001T8hO&tw-\u0001\bd_6lWM\u001c;TKJ4\u0018nY3\u0016\u0003A\u0002\"!\r\u001a\u000e\u0003YI!a\r\f\u0003\u001d\r{W.\\3oiN+'O^5dK\u0006y1m\\7nK:$8+\u001a:wS\u000e,\u0007%A\tbiR\f7\r[7f]R\u001cVM\u001d<jG\u0016,\u0012a\u000e\t\u0003caJ!!\u000f\f\u0003#\u0005#H/Y2i[\u0016tGoU3sm&\u001cW-\u0001\nbiR\f7\r[7f]R\u001cVM\u001d<jG\u0016\u0004\u0013A\u0004;bg.\u0014V\r]8tSR|'/_\u000b\u0002{A\u0011a(Q\u0007\u0002\u007f)\u0011\u0001\tG\u0001\u000be\u0016\u0004xn]5u_JL\u0018B\u0001\"@\u00059!\u0016m]6SKB|7/\u001b;pef\fq\u0002^1tWJ+\u0007o\\:ji>\u0014\u0018\u0010I\u0001\u0015CR$\u0018m\u00195nK:$(+\u001a9pg&$xN]=\u0016\u0003\u0019\u0003\"AP$\n\u0005!{$\u0001F!ui\u0006\u001c\u0007.\\3oiJ+\u0007o\\:ji>\u0014\u00180A\u000bbiR\f7\r[7f]R\u0014V\r]8tSR|'/\u001f\u0011\u0002#I,G.Z1tKJ+\u0007o\\:ji>\u0014\u00180F\u0001M!\tqT*\u0003\u0002O\u007f\t\t\"+\u001a7fCN,'+\u001a9pg&$xN]=\u0002%I,G.Z1tKJ+\u0007o\\:ji>\u0014\u0018\u0010I\u0001\u0010M\u0006\u001cW\r\u001e*fa>\u001c\u0018\u000e^8ssV\t!\u000b\u0005\u0002?'&\u0011Ak\u0010\u0002\u0010\r\u0006\u001cW\r\u001e*fa>\u001c\u0018\u000e^8ss\u0006\u0001b-Y2fiJ+\u0007o\\:ji>\u0014\u0018\u0010I\u0001\tKZ,g\u000e\u001e\"vgV\t\u0001\f\u0005\u0002Z96\t!L\u0003\u0002\\1\u00051QM^3oiNL!!\u0018.\u0003#ac%+\u001a7fCN,WI^3oi\n+8/A\u0005fm\u0016tGOQ;tA\u00051A(\u001b8jiz\"\u0002\"\u00192dI\u00164w\r\u001b\t\u0003c\u0001AQAL\bA\u0002ABQ!N\bA\u0002]BQaO\bA\u0002uBQ\u0001R\bA\u0002\u0019CQAS\bA\u00021CQ\u0001U\bA\u0002ICQAV\bA\u0002aC#a\u00046\u0011\u0005-4X\"\u00017\u000b\u00055t\u0017AC1o]>$\u0018\r^5p]*\u0011q\u000e]\u0001\bM\u0006\u001cGo\u001c:z\u0015\t\t(/A\u0003cK\u0006t7O\u0003\u0002ti\u0006y1\u000f\u001d:j]\u001e4'/Y7fo>\u00148NC\u0001v\u0003\ry'oZ\u0005\u0003o2\u0014\u0011\"Q;u_^L'/\u001a3\u0002\u000f\u0015DXmY;uKR!!0`A\u0006!\t\t30\u0003\u0002}E\t!QK\\5u\u0011\u0015q\b\u00031\u0001\u0000\u0003\u001d\u0019\u0007.\u00198hKN\u0004B!!\u0001\u0002\b5\u0011\u00111\u0001\u0006\u0004\u0003\u000bA\u0012A\u00023p[\u0006Lg.\u0003\u0003\u0002\n\u0005\r!aB\"iC:<Wm\u001d\u0005\b\u0003\u001b\u0001\u0002\u0019AA\b\u0003\u0011)8/\u001a:\u0011\t\u0005E\u0011QC\u0007\u0003\u0003'Q1!!\u0004\u0019\u0013\u0011\t9\"a\u0005\u0003\tU\u001bXM\u001d\u0015\u0004!\u0005m\u0001\u0003BA\u000f\u0003Wi!!a\b\u000b\t\u0005\u0005\u00121E\u0001\fiJ\fgn]1di&|gN\u0003\u0003\u0002&\u0005\u001d\u0012aA:rY*\u0019\u0011\u0011\u0006\r\u0002\u0005\u0011\u0014\u0017\u0002BA\u0017\u0003?\u0011q\"S:Ue\u0006t7/Y2uS>t\u0017\r\\\u0001\u0010G>dG.Z2u\u0007>lW.\u001a8ugR1\u00111GA4\u0003S\u0002\u0002\"!\u000e\u0002D\u0005%\u0013q\n\b\u0005\u0003o\ty\u0004E\u0002\u0002:\tj!!a\u000f\u000b\u0007\u0005ub$\u0001\u0004=e>|GOP\u0005\u0004\u0003\u0003\u0012\u0013A\u0002)sK\u0012,g-\u0003\u0003\u0002F\u0005\u001d#aA'ba*\u0019\u0011\u0011\t\u0012\u0011\t\u0005\u0005\u00111J\u0005\u0005\u0003\u001b\n\u0019A\u0001\u0003UCN\\\u0007CBA)\u00037\n\tG\u0004\u0003\u0002T\u0005]c\u0002BA\u001d\u0003+J\u0011aI\u0005\u0004\u00033\u0012\u0013a\u00029bG.\fw-Z\u0005\u0005\u0003;\nyFA\u0002TKFT1!!\u0017#!\u0011\t\t!a\u0019\n\t\u0005\u0015\u00141\u0001\u0002\b\u0007>lW.\u001a8u\u0011\u0015q\u0018\u00031\u0001\u0000\u0011\u001d\ti!\u0005a\u0001\u0003\u001f\t!cY8mY\u0016\u001cG/\u0011;uC\u000eDW.\u001a8ugR!\u0011qNA=!!\t)$a\u0011\u0002J\u0005E\u0004CBA)\u00037\n\u0019\b\u0005\u0003\u0002\u0002\u0005U\u0014\u0002BA<\u0003\u0007\u0011!\"\u0011;uC\u000eDW.\u001a8u\u0011\u0015q(\u00031\u0001\u0000\u0003I\u0001(o\\2fgN\fE\u000f^1dQ6,g\u000e^:\u0015\u000bi\fy(a$\t\u000f\u0005\u00055\u00031\u0001\u0002\u0004\u0006A!/\u001a7fCN,7\u000f\u0005\u0004\u00026\u0005\u0015\u0015\u0011R\u0005\u0005\u0003\u000f\u000b9EA\u0002TKR\u0004B!!\u0001\u0002\f&!\u0011QRA\u0002\u0005\u001d\u0011V\r\\3bg\u0016Dq!!%\u0014\u0001\u0004\ty'A\tbiR\f7\r[7f]R\u001c()\u001f+bg.\fq\u0002\u001d:pG\u0016\u001c8oQ8n[\u0016tGo\u001d\u000b\u0006u\u0006]\u00151\u0014\u0005\b\u00033#\u0002\u0019AA\u001a\u00039\u0019w.\\7f]R\u001c()\u001f+bg.Dq!!\u0004\u0015\u0001\u0004\ty\u0001K\u0002\u0001\u0003?\u0003B!!)\u0002(6\u0011\u00111\u0015\u0006\u0004\u0003K\u0013\u0018AC:uKJ,w\u000e^=qK&!\u0011\u0011VAR\u0005\u001d\u0019VM\u001d<jG\u0016\u0004")
public class ChangeExecutionService
implements Logging {
    private final CommentService commentService;
    private final AttachmentService attachmentService;
    private final TaskRepository taskRepository;
    private final AttachmentRepository attachmentRepository;
    private final ReleaseRepository releaseRepository;
    private final FacetRepository facetRepository;
    private final XLReleaseEventBus eventBus;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        ChangeExecutionService changeExecutionService = this;
        synchronized (changeExecutionService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public CommentService commentService() {
        return this.commentService;
    }

    public AttachmentService attachmentService() {
        return this.attachmentService;
    }

    public TaskRepository taskRepository() {
        return this.taskRepository;
    }

    public AttachmentRepository attachmentRepository() {
        return this.attachmentRepository;
    }

    public ReleaseRepository releaseRepository() {
        return this.releaseRepository;
    }

    public FacetRepository facetRepository() {
        return this.facetRepository;
    }

    public XLReleaseEventBus eventBus() {
        return this.eventBus;
    }

    @IsTransactional
    public void execute(Changes changes, User user) {
        Set releases = ((TraversableOnce)((SetLike)((TraversableLike)JavaConverters$.MODULE$.asScalaSetConverter(changes.getUpdatedItems()).asScala()).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ChangeExecutionService.$anonfun$execute$1(x$1)))).map((Function1 & Serializable & scala.Serializable)x$2 -> ((PlanItem)x$2).getRelease(), Set$.MODULE$.canBuildFrom())).toSet();
        Set tasks = ((TraversableOnce)((SetLike)((TraversableLike)JavaConverters$.MODULE$.asScalaSetConverter(changes.getUpdatedItems()).asScala()).filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)ChangeExecutionService.$anonfun$execute$3(x$3)))).map((Function1 & Serializable & scala.Serializable)x$4 -> (Task)x$4, Set$.MODULE$.canBuildFrom())).toSet();
        Set facets = ((TraversableOnce)((SetLike)((TraversableLike)JavaConverters$.MODULE$.asScalaSetConverter(changes.getUpdatedItems()).asScala()).filter((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)ChangeExecutionService.$anonfun$execute$5(x$5)))).map((Function1 & Serializable & scala.Serializable)x$6 -> (Facet)x$6, Set$.MODULE$.canBuildFrom())).toSet();
        facets.foreach((Function1 & Serializable & scala.Serializable)facet -> this.facetRepository().update((Facet)facet));
        this.processAttachments((Set<Release>)releases, this.collectAttachments(changes));
        tasks.foreach((Function1 & Serializable & scala.Serializable)task -> {
            ChangeExecutionService.$anonfun$execute$8(this, task);
            return BoxedUnit.UNIT;
        });
        this.processComments(this.collectComments(changes, user), user);
    }

    private Map<Task, Seq<Comment>> collectComments(Changes changes, User user) {
        return ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(changes.getCommentsByTask().asMap()).asScala()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Task task = (Task)tuple2._1();
            Collection commentTexts = (Collection)tuple2._2();
            Seq userComments = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(commentTexts).asScala()).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Tuple3 tuple3 = x0$2;
                if (tuple3 == null) {
                    throw new MatchError((Object)tuple3);
                }
                User u = (User)tuple3._1();
                String text = (String)tuple3._2();
                DateTime date = (DateTime)tuple3._3();
                User actualUser = (User)Option$.MODULE$.apply((Object)u).getOrElse((Function0 & Serializable & scala.Serializable)() -> user);
                Comment comment = this.commentService().buildComment(task, text, actualUser, date.toDate(), CommentService.COMMENT_PREFIX_MANUAL, CommentService.COMMENT_SUFFIX);
                return comment;
            }, scala.collection.Iterable$.MODULE$.canBuildFrom())).toSeq();
            task.getComments().addAll((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(userComments).asJava());
            Tuple2 tuple22 = new Tuple2((Object)task, (Object)userComments);
            return tuple22;
        }, Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    private Map<Task, Seq<Attachment>> collectAttachments(Changes changes) {
        return ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(changes.getAttachmentsByTask().asMap()).asScala()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Task task = (Task)tuple2._1();
            Collection attachments = (Collection)tuple2._2();
            Seq updatedAttachments = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(attachments).asScala()).map((Function1 & Serializable & scala.Serializable)attachment -> (Attachment)CloseableUtils$.MODULE$.using(attachment.getFile().getInputStream(), (Function1 & Serializable & scala.Serializable)is -> this.attachmentService().attachToRelease(task.getRelease(), attachment.getFile().getName(), attachment.getContentType(), (InputStream)is)), scala.collection.Iterable$.MODULE$.canBuildFrom())).toSeq();
            task.getAttachments().addAll((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(updatedAttachments).asJava());
            Tuple2 tuple22 = new Tuple2((Object)task, (Object)updatedAttachments);
            return tuple22;
        }, Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public void processAttachments(Set<Release> releases, Map<Task, Seq<Attachment>> attachmentsByTask) {
        attachmentsByTask.groupBy((Function1 & Serializable & scala.Serializable)x$7 -> ((Task)x$7._1()).getRelease()).mapValues((Function1 & Serializable & scala.Serializable)x$8 -> ((TraversableOnce)x$8.flatMap((Function1 & Serializable & scala.Serializable)x$9 -> (Seq)x$9._2(), Iterable$.MODULE$.canBuildFrom())).toSeq()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ChangeExecutionService.$anonfun$processAttachments$4(this, x0$1);
            return BoxedUnit.UNIT;
        });
        releases.$plus$plus((GenTraversableOnce)attachmentsByTask.map((Function1 & Serializable & scala.Serializable)x$10 -> ((Task)x$10._1()).getRelease(), Iterable$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)release -> this.releaseRepository().update((Release)release));
        attachmentsByTask.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            ChangeExecutionService.$anonfun$processAttachments$7(this, x0$2);
            return BoxedUnit.UNIT;
        });
    }

    public void processComments(Map<Task, Seq<Comment>> commentsByTask, User user) {
        commentsByTask.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ChangeExecutionService.$anonfun$processComments$1(this, user, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$execute$1(ConfigurationItem x$1) {
        return x$1 instanceof PlanItem;
    }

    public static final /* synthetic */ boolean $anonfun$execute$3(ConfigurationItem x$3) {
        return x$3 instanceof Task;
    }

    public static final /* synthetic */ boolean $anonfun$execute$5(ConfigurationItem x$5) {
        return x$5 instanceof Facet;
    }

    public static final /* synthetic */ void $anonfun$execute$8(ChangeExecutionService $this, Task task) {
        $this.taskRepository().updateTaskProperties(task);
    }

    public static final /* synthetic */ void $anonfun$processAttachments$4(ChangeExecutionService $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Release release = (Release)tuple2._1();
        Seq attachments = (Seq)tuple2._2();
        $this.attachmentRepository().batchInsert(release, (Seq<Attachment>)attachments);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$processAttachments$8(ChangeExecutionService $this, Task task$3, Attachment attachment) {
        $this.eventBus().publish((XLReleaseEvent)new AttachmentCreatedEvent(task$3.getId(), attachment));
    }

    public static final /* synthetic */ void $anonfun$processAttachments$7(ChangeExecutionService $this, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Task task = (Task)tuple2._1();
        Seq attachments = (Seq)tuple2._2();
        attachments.foreach((Function1 & Serializable & scala.Serializable)attachment -> {
            ChangeExecutionService.$anonfun$processAttachments$8($this, task, attachment);
            return BoxedUnit.UNIT;
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$processComments$2(ChangeExecutionService $this, Task task$4, User user$2, Comment comment) {
        $this.commentService().create(task$4, comment);
        $this.eventBus().publish((XLReleaseEvent)new CommentCreatedEvent(task$4, comment, user$2.getName(), false));
    }

    public static final /* synthetic */ void $anonfun$processComments$1(ChangeExecutionService $this, User user$2, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Task task = (Task)tuple2._1();
        Seq comments = (Seq)tuple2._2();
        comments.foreach((Function1 & Serializable & scala.Serializable)comment -> {
            ChangeExecutionService.$anonfun$processComments$2($this, task, user$2, comment);
            return BoxedUnit.UNIT;
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    @Autowired
    public ChangeExecutionService(CommentService commentService, AttachmentService attachmentService, TaskRepository taskRepository, AttachmentRepository attachmentRepository, ReleaseRepository releaseRepository, FacetRepository facetRepository, XLReleaseEventBus eventBus) {
        this.commentService = commentService;
        this.attachmentService = attachmentService;
        this.taskRepository = taskRepository;
        this.attachmentRepository = attachmentRepository;
        this.releaseRepository = releaseRepository;
        this.facetRepository = facetRepository;
        this.eventBus = eventBus;
        Logging.$init$((Logging)this);
    }
}

