/*
 * Decompiled with CFR 0.152.
 */
package akka.stream.impl.io;

import akka.Done;
import akka.Done$;
import akka.NotUsed;
import akka.actor.ActorRef;
import akka.actor.Terminated;
import akka.actor.package$;
import akka.annotation.InternalApi;
import akka.dispatch.ExecutionContexts;
import akka.io.Inet;
import akka.io.Tcp;
import akka.stream.Attributes;
import akka.stream.Attributes$;
import akka.stream.BindFailedException;
import akka.stream.IOSettings;
import akka.stream.Outlet;
import akka.stream.Outlet$;
import akka.stream.SourceShape;
import akka.stream.impl.fusing.GraphStages$;
import akka.stream.impl.io.ConnectionSourceStage$;
import akka.stream.impl.io.IncomingConnectionStage;
import akka.stream.impl.io.TcpIdleTimeout$;
import akka.stream.scaladsl.Flow;
import akka.stream.scaladsl.Flow$;
import akka.stream.scaladsl.Tcp;
import akka.stream.scaladsl.Tcp$ServerBinding$;
import akka.stream.stage.GraphStageLogic;
import akka.stream.stage.GraphStageWithMaterializedValue;
import akka.stream.stage.OutHandler;
import akka.stream.stage.TimerGraphStageLogic;
import akka.util.ByteString;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.InetSocketAddress;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicLong;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Traversable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005mf!B\u0010!\u0001\u0011B\u0003\u0002\u0003%\u0001\u0005\u000b\u0007I\u0011\u0001&\t\u0011E\u0003!\u0011!Q\u0001\n-C\u0001B\u0015\u0001\u0003\u0006\u0004%\ta\u0015\u0005\t9\u0002\u0011\t\u0011)A\u0005)\"AQ\f\u0001BC\u0002\u0013\u0005a\f\u0003\u0005d\u0001\t\u0005\t\u0015!\u0003`\u0011!!\u0007A!b\u0001\n\u0003)\u0007\u0002C?\u0001\u0005\u0003\u0005\u000b\u0011\u00024\t\u0011y\u0004!Q1A\u0005\u0002}D!\"a\u0002\u0001\u0005\u0003\u0005\u000b\u0011BA\u0001\u0011)\tI\u0001\u0001BC\u0002\u0013\u0005\u00111\u0002\u0005\u000b\u00033\u0001!\u0011!Q\u0001\n\u00055\u0001BCA\u000e\u0001\t\u0015\r\u0011\"\u0001\u0002\u001e!Q\u0011Q\u0005\u0001\u0003\u0002\u0003\u0006I!a\b\t\u0015\u0005\u001d\u0002A!b\u0001\n\u0003\tI\u0003\u0003\u0006\u00022\u0001\u0011\t\u0011)A\u0005\u0003WAq!a\r\u0001\t\u0003\t)\u0004C\u0005\u0002L\u0001\u0011\r\u0011\"\u0001\u0002N!A\u0011Q\u000b\u0001!\u0002\u0013\ty\u0005C\u0004\u0002X\u0001!\t%!\u0017\t\u0013\u0005\u0005\u0004A1A\u0005\u0002\u0005\r\u0004bBA3\u0001\u0001\u0006Ia\f\u0005\b\u0003O\u0002A\u0011IA5\u000f!\t9\n\tE\u0001I\u0005eeaB\u0010!\u0011\u0003!\u00131\u0014\u0005\b\u0003gIB\u0011AAR\u0011%\t)+\u0007b\u0001\n\u0003\t9\u000b\u0003\u0005\u00026f\u0001\u000b\u0011BAU\u0011%\t9,\u0007b\u0001\n\u0003\t9\u000b\u0003\u0005\u0002:f\u0001\u000b\u0011BAU\u0005U\u0019uN\u001c8fGRLwN\\*pkJ\u001cWm\u0015;bO\u0016T!!\t\u0012\u0002\u0005%|'BA\u0012%\u0003\u0011IW\u000e\u001d7\u000b\u0005\u00152\u0013AB:ue\u0016\fWNC\u0001(\u0003\u0011\t7n[1\u0014\u0005\u0001I\u0003\u0003\u0002\u0016._uj\u0011a\u000b\u0006\u0003Y\u0011\nQa\u001d;bO\u0016L!AL\u0016\u0003?\u001d\u0013\u0018\r\u001d5Ti\u0006<WmV5uQ6\u000bG/\u001a:jC2L'0\u001a3WC2,X\rE\u00021cMj\u0011\u0001J\u0005\u0003e\u0011\u00121bU8ve\u000e,7\u000b[1qKB\u0011AG\u000f\b\u0003kaj\u0011A\u000e\u0006\u0003o\u0011\n\u0001b]2bY\u0006$7\u000f\\\u0005\u0003sY\n1\u0001V2q\u0013\tYDH\u0001\nJ]\u000e|W.\u001b8h\u0007>tg.Z2uS>t'BA\u001d7!\rq4)R\u0007\u0002\u007f)\u0011\u0001)Q\u0001\u000bG>t7-\u001e:sK:$(\"\u0001\"\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0011{$A\u0002$viV\u0014X\r\u0005\u00025\r&\u0011q\t\u0010\u0002\u000e'\u0016\u0014h/\u001a:CS:$\u0017N\\4\u0002\u0015Q\u001c\u0007/T1oC\u001e,'o\u0001\u0001\u0016\u0003-\u0003\"\u0001T(\u000e\u00035S!A\u0014\u0014\u0002\u000b\u0005\u001cGo\u001c:\n\u0005Ak%\u0001C!di>\u0014(+\u001a4\u0002\u0017Q\u001c\u0007/T1oC\u001e,'\u000fI\u0001\tK:$\u0007o\\5oiV\tA\u000b\u0005\u0002V56\taK\u0003\u0002X1\u0006\u0019a.\u001a;\u000b\u0003e\u000bAA[1wC&\u00111L\u0016\u0002\u0012\u0013:,GoU8dW\u0016$\u0018\t\u001a3sKN\u001c\u0018!C3oIB|\u0017N\u001c;!\u0003\u001d\u0011\u0017mY6m_\u001e,\u0012a\u0018\t\u0003A\u0006l\u0011!Q\u0005\u0003E\u0006\u00131!\u00138u\u0003!\u0011\u0017mY6m_\u001e\u0004\u0013aB8qi&|gn]\u000b\u0002MB\u0019q\r\u001c8\u000e\u0003!T!!\u001b6\u0002\u0013%lW.\u001e;bE2,'BA6B\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003[\"\u00141\u0002\u0016:bm\u0016\u00148/\u00192mKB\u0011qN\u001f\b\u0003a^t!!\u001d<\u000f\u0005I,X\"A:\u000b\u0005QL\u0015A\u0002\u001fs_>$h(C\u0001(\u0013\t\tc%\u0003\u0002ys\u0006!\u0011J\\3u\u0015\t\tc%\u0003\u0002|y\na1k\\2lKR|\u0005\u000f^5p]*\u0011\u00010_\u0001\t_B$\u0018n\u001c8tA\u0005I\u0001.\u00197g\u00072|7/Z\u000b\u0003\u0003\u0003\u00012\u0001YA\u0002\u0013\r\t)!\u0011\u0002\b\u0005>|G.Z1o\u0003)A\u0017\r\u001c4DY>\u001cX\rI\u0001\fS\u0012dW\rV5nK>,H/\u0006\u0002\u0002\u000eA!\u0011qBA\u000b\u001b\t\t\tBC\u0002\u0002\u0014}\n\u0001\u0002Z;sCRLwN\\\u0005\u0005\u0003/\t\tB\u0001\u0005EkJ\fG/[8o\u00031IG\r\\3US6,w.\u001e;!\u0003M\u0011\u0017N\u001c3TQV$Hm\\<o)&lWm\\;u+\t\ty\u0002\u0005\u0003\u0002\u0010\u0005\u0005\u0012\u0002BA\u0012\u0003#\u0011aBR5oSR,G)\u001e:bi&|g.\u0001\u000bcS:$7\u000b[;uI><h\u000eV5nK>,H\u000fI\u0001\u000bS>\u001cV\r\u001e;j]\u001e\u001cXCAA\u0016!\r\u0001\u0014QF\u0005\u0004\u0003_!#AC%P'\u0016$H/\u001b8hg\u0006Y\u0011n\\*fiRLgnZ:!\u0003\u0019a\u0014N\\5u}Q\u0011\u0012qGA\u001e\u0003{\ty$!\u0011\u0002D\u0005\u0015\u0013qIA%!\r\tI\u0004A\u0007\u0002A!)\u0001*\u0005a\u0001\u0017\")!+\u0005a\u0001)\")Q,\u0005a\u0001?\")A-\u0005a\u0001M\"1a0\u0005a\u0001\u0003\u0003Aq!!\u0003\u0012\u0001\u0004\ti\u0001C\u0004\u0002\u001cE\u0001\r!a\b\t\u000f\u0005\u001d\u0012\u00031\u0001\u0002,\u0005\u0019q.\u001e;\u0016\u0005\u0005=\u0003\u0003\u0002\u0019\u0002RMJ1!a\u0015%\u0005\u0019yU\u000f\u001e7fi\u0006!q.\u001e;!\u0003EIg.\u001b;jC2\fE\u000f\u001e:jEV$Xm]\u000b\u0003\u00037\u00022\u0001MA/\u0013\r\ty\u0006\n\u0002\u000b\u0003R$(/\u001b2vi\u0016\u001c\u0018!B:iCB,W#A\u0018\u0002\rMD\u0017\r]3!\u0003}\u0019'/Z1uK2{w-[2B]\u0012l\u0015\r^3sS\u0006d\u0017N_3e-\u0006dW/\u001a\u000b\u0005\u0003W\n)\tE\u0004a\u0003[\n\t(a\u001e\n\u0007\u0005=\u0014I\u0001\u0004UkBdWM\r\t\u0004U\u0005M\u0014bAA;W\tyqI]1qQN#\u0018mZ3M_\u001eL7\r\u0005\u0003?\u0007\u0006e\u0004cAA>\r:\u0019\u0011Q\u0010\u001d\u000f\t\u0005}\u00141\u0011\b\u0004c\u0006\u0005\u0015BA\u0013'\u0013\t9D\u0005C\u0004\u0002\b^\u0001\r!a\u0017\u0002'%t\u0007.\u001a:ji\u0016$\u0017\t\u001e;sS\n,H/Z:)\u0007\u0001\tY\t\u0005\u0003\u0002\u000e\u0006MUBAAH\u0015\r\t\tJJ\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAK\u0003\u001f\u00131\"\u00138uKJt\u0017\r\\!qS\u0006)2i\u001c8oK\u000e$\u0018n\u001c8T_V\u00148-Z*uC\u001e,\u0007cAA\u001d3M\u0019\u0011$!(\u0011\u0007\u0001\fy*C\u0002\u0002\"\u0006\u0013a!\u00118z%\u00164GCAAM\u0003%\u0011\u0015N\u001c3US6,'/\u0006\u0002\u0002*B!\u00111VAY\u001b\t\tiKC\u0002\u00020b\u000bA\u0001\\1oO&!\u00111WAW\u0005\u0019\u0019FO]5oO\u0006Q!)\u001b8e)&lWM\u001d\u0011\u0002#\tKg\u000eZ*ikR$wn\u001e8US6,'/\u0001\nCS:$7\u000b[;uI><h\u000eV5nKJ\u0004\u0003")
@InternalApi
public class ConnectionSourceStage
extends GraphStageWithMaterializedValue<SourceShape<Tcp.IncomingConnection>, Future<Tcp.ServerBinding>> {
    private final ActorRef tcpManager;
    private final InetSocketAddress endpoint;
    private final int backlog;
    private final Traversable<Inet.SocketOption> options;
    private final boolean halfClose;
    private final Duration idleTimeout;
    private final FiniteDuration bindShutdownTimeout;
    private final IOSettings ioSettings;
    private final Outlet<Tcp.IncomingConnection> out;
    private final SourceShape<Tcp.IncomingConnection> shape;

    public static String BindShutdownTimer() {
        return ConnectionSourceStage$.MODULE$.BindShutdownTimer();
    }

    public static String BindTimer() {
        return ConnectionSourceStage$.MODULE$.BindTimer();
    }

    public ActorRef tcpManager() {
        return this.tcpManager;
    }

    public InetSocketAddress endpoint() {
        return this.endpoint;
    }

    public int backlog() {
        return this.backlog;
    }

    public Traversable<Inet.SocketOption> options() {
        return this.options;
    }

    public boolean halfClose() {
        return this.halfClose;
    }

    public Duration idleTimeout() {
        return this.idleTimeout;
    }

    public FiniteDuration bindShutdownTimeout() {
        return this.bindShutdownTimeout;
    }

    public IOSettings ioSettings() {
        return this.ioSettings;
    }

    public Outlet<Tcp.IncomingConnection> out() {
        return this.out;
    }

    @Override
    public Attributes initialAttributes() {
        return Attributes$.MODULE$.name("ConnectionSource");
    }

    @Override
    public SourceShape<Tcp.IncomingConnection> shape() {
        return this.shape;
    }

    @Override
    public Tuple2<GraphStageLogic, Future<Tcp.ServerBinding>> createLogicAndMaterializedValue(Attributes inheritedAttributes) {
        Promise bindingPromise = Promise$.MODULE$.apply();
        TimerGraphStageLogic logic = new TimerGraphStageLogic(this, bindingPromise){
            private final AtomicLong connectionFlowsAwaitingInitialization;
            private ActorRef listener;
            private final Promise<BoxedUnit> unbindPromise;
            private boolean unbindStarted;
            private final /* synthetic */ ConnectionSourceStage $outer;
            private final Promise bindingPromise$1;

            public ActorRef self() {
                return this.stageActor().ref();
            }

            public AtomicLong connectionFlowsAwaitingInitialization() {
                return this.connectionFlowsAwaitingInitialization;
            }

            public ActorRef listener() {
                return this.listener;
            }

            public void listener_$eq(ActorRef x$1) {
                this.listener = x$1;
            }

            public Promise<BoxedUnit> unbindPromise() {
                return this.unbindPromise;
            }

            public boolean unbindStarted() {
                return this.unbindStarted;
            }

            public void unbindStarted_$eq(boolean x$1) {
                this.unbindStarted = x$1;
            }

            public void preStart() {
                this.getStageActor((Function1<Tuple2<ActorRef, Object>, BoxedUnit>)(Function1 & Serializable & scala.Serializable)evt -> {
                    $anon$1.$anonfun$preStart$1(this, evt);
                    return BoxedUnit.UNIT;
                });
                package$.MODULE$.actorRef2Scala(this.$outer.tcpManager()).$bang((Object)new Tcp.Bind(this.self(), this.$outer.endpoint(), this.$outer.backlog(), this.$outer.options(), true), this.self());
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            private void receive(Tuple2<ActorRef, Object> evt) {
                ActorRef sender = (ActorRef)evt._1();
                Object msg = evt._2();
                Object object = msg;
                if (object instanceof Tcp.Bound) {
                    Tcp.Bound bound = (Tcp.Bound)object;
                    InetSocketAddress localAddress = bound.localAddress();
                    this.listener_$eq(sender);
                    this.stageActor().watch(this.listener());
                    if (this.isAvailable(this.$outer.out())) {
                        package$.MODULE$.actorRef2Scala(this.listener()).$bang((Object)new Tcp.ResumeAccepting(1), this.self());
                    }
                    ActorRef thisStage = this.self();
                    this.bindingPromise$1.success((Object)Tcp$ServerBinding$.MODULE$.apply(localAddress, (Function0<Future<BoxedUnit>>)(Function0 & Serializable & scala.Serializable)() -> {
                        thisStage.tell((Object)Tcp.Unbind$.MODULE$, thisStage);
                        return this.unbindPromise().future();
                    }, (Future<Done>)this.unbindPromise().future().map((Function1 & Serializable & scala.Serializable)x$1 -> Done$.MODULE$, (ExecutionContext)ExecutionContexts.sameThreadExecutionContext$.MODULE$)));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                } else if (object instanceof Tcp.CommandFailed) {
                    Tcp.CommandFailed commandFailed = (Tcp.CommandFailed)object;
                    BindFailedException ex = new BindFailedException(null, commandFailed){
                        private final Tcp.CommandFailed x4$1;

                        public String getMessage() {
                            return new StringBuilder(11).append("Bind failed").append(this.x4$1.causedByString()).toString();
                        }
                        {
                            this.x4$1 = x4$1;
                        }
                    };
                    commandFailed.cause().foreach((Function1 & Serializable & scala.Serializable)x$1 -> ex.initCause((Throwable)x$1));
                    this.bindingPromise$1.failure((Throwable)ex);
                    this.unbindPromise().tryFailure((Throwable)ex);
                    this.failStage(ex);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                } else if (object instanceof Tcp.Connected) {
                    Tcp.Connected connected = (Tcp.Connected)object;
                    this.push(this.$outer.out(), this.connectionFor(connected, sender));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                } else if (Tcp.Unbind$.MODULE$.equals(object)) {
                    BoxedUnit boxedUnit;
                    if (!this.isClosed(this.$outer.out()) && this.listener() != null) {
                        this.akka$stream$impl$io$ConnectionSourceStage$$anon$$tryUnbind();
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit2 = boxedUnit;
                    return;
                } else if (Tcp.Unbound$.MODULE$.equals(object)) {
                    this.unbindCompleted();
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                } else {
                    BoxedUnit boxedUnit;
                    ActorRef ref;
                    if (!(object instanceof Terminated)) throw new MatchError(object);
                    Terminated terminated = (Terminated)object;
                    ActorRef actorRef2 = ref = terminated.actor();
                    ActorRef actorRef3 = this.listener();
                    if (actorRef2 != null ? !actorRef2.equals(actorRef3) : actorRef3 != null) throw new MatchError(object);
                    if (this.unbindStarted()) {
                        this.unbindCompleted();
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        IllegalStateException ex = new IllegalStateException(new StringBuilder(65).append("IO Listener actor terminated unexpectedly for remote endpoint [").append(this.$outer.endpoint().getHostString()).append(":").append(this.$outer.endpoint().getPort()).append("]").toString());
                        this.unbindPromise().tryFailure((Throwable)ex);
                        this.failStage(ex);
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit3 = boxedUnit;
                }
            }

            private Tcp.IncomingConnection connectionFor(Tcp.Connected connected, ActorRef connection) {
                Flow<ByteString, ByteString, NotUsed> flow;
                this.connectionFlowsAwaitingInitialization().incrementAndGet();
                Flow<ByteString, ByteString, NotUsed> tcpFlow = Flow$.MODULE$.fromGraph(new IncomingConnectionStage(connection, connected.remoteAddress(), this.$outer.halfClose(), this.$outer.ioSettings(), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.connectionFlowsAwaitingInitialization().decrementAndGet())).via(GraphStages$.MODULE$.detacher());
                Duration duration = this.$outer.idleTimeout();
                if (duration instanceof FiniteDuration) {
                    FiniteDuration finiteDuration = (FiniteDuration)duration;
                    flow = tcpFlow.join(TcpIdleTimeout$.MODULE$.apply(finiteDuration, (Option<InetSocketAddress>)new Some((Object)connected.remoteAddress())));
                } else {
                    flow = tcpFlow;
                }
                Flow<ByteString, ByteString, NotUsed> handler = flow;
                return new Tcp.IncomingConnection(connected.localAddress(), connected.remoteAddress(), handler);
            }

            public void akka$stream$impl$io$ConnectionSourceStage$$anon$$tryUnbind() {
                block0: {
                    if (this.listener() == null || this.unbindStarted()) break block0;
                    this.unbindStarted_$eq(true);
                    this.setKeepGoing(true);
                    package$.MODULE$.actorRef2Scala(this.listener()).$bang((Object)Tcp.Unbind$.MODULE$, this.self());
                }
            }

            private void unbindCompleted() {
                this.stageActor().unwatch(this.listener());
                this.unbindPromise().trySuccess((Object)BoxedUnit.UNIT);
                if (this.connectionFlowsAwaitingInitialization().get() == 0L) {
                    this.completeStage();
                } else {
                    this.scheduleOnce((Object)ConnectionSourceStage$.MODULE$.BindShutdownTimer(), this.$outer.bindShutdownTimeout());
                }
            }

            public void onTimer(Object timerKey) {
                Object object = timerKey;
                String string = ConnectionSourceStage$.MODULE$.BindShutdownTimer();
                Object object2 = object;
                if (string != null ? !string.equals(object2) : object2 != null) {
                    throw new MatchError(object);
                }
                this.completeStage();
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }

            public void postStop() {
                this.unbindPromise().trySuccess((Object)BoxedUnit.UNIT);
                this.bindingPromise$1.tryFailure((Throwable)new NoSuchElementException("Binding was unbound before it was completely finished"));
            }

            public static final /* synthetic */ void $anonfun$preStart$1($anon$1 $this, Tuple2 evt) {
                $this.receive((Tuple2<ActorRef, Object>)evt);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.bindingPromise$1 = bindingPromise$1;
                super($outer.shape());
                this.connectionFlowsAwaitingInitialization = new AtomicLong();
                this.unbindPromise = Promise$.MODULE$.apply();
                this.unbindStarted = false;
                this.setHandler($outer.out(), new OutHandler(this){
                    private final /* synthetic */ $anon$1 $outer;

                    public void onPull() {
                        block0: {
                            if (this.$outer.listener() == null) break block0;
                            package$.MODULE$.actorRef2Scala(this.$outer.listener()).$bang((Object)new Tcp.ResumeAccepting(1), this.$outer.self());
                        }
                    }

                    public void onDownstreamFinish() {
                        this.$outer.akka$stream$impl$io$ConnectionSourceStage$$anon$$tryUnbind();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        OutHandler.$init$(this);
                    }
                });
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$preStart$1$adapted(akka.stream.impl.io.ConnectionSourceStage$$anon$1 scala.Tuple2 ), $anonfun$receive$1(akka.stream.impl.io.ConnectionSourceStage$$anon$1 akka.actor.ActorRef ), $anonfun$receive$2(scala.runtime.BoxedUnit ), $anonfun$receive$3(akka.stream.BindFailedException java.lang.Throwable ), $anonfun$connectionFor$1(akka.stream.impl.io.ConnectionSourceStage$$anon$1 )}, serializedLambda);
            }
        };
        return new Tuple2((Object)logic, (Object)bindingPromise.future());
    }

    public ConnectionSourceStage(ActorRef tcpManager, InetSocketAddress endpoint, int backlog, Traversable<Inet.SocketOption> options, boolean halfClose, Duration idleTimeout, FiniteDuration bindShutdownTimeout, IOSettings ioSettings) {
        this.tcpManager = tcpManager;
        this.endpoint = endpoint;
        this.backlog = backlog;
        this.options = options;
        this.halfClose = halfClose;
        this.idleTimeout = idleTimeout;
        this.bindShutdownTimeout = bindShutdownTimeout;
        this.ioSettings = ioSettings;
        this.out = Outlet$.MODULE$.apply("IncomingConnections.out");
        this.shape = new SourceShape<Tcp.IncomingConnection>(this.out());
    }
}

