/*
 * Decompiled with CFR 0.152.
 */
package org.prevayler.foundation;

import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.prevayler.foundation.Chunk;

public class Chunking {
    private static final String ASCII = "US-ASCII";
    private static final byte[] CRLF = new byte[]{13, 10};
    private static final String SIZE = "0|[1-9A-F][0-9A-F]{0,6}|[1-7][0-9A-F]{7}";
    private static final String TOKEN = "[^\u0000- ()<>@,;:\\\\\"/\\[\\]?={}\u007f-\uffff]+";
    private static final String HEADER = "(0|[1-9A-F][0-9A-F]{0,6}|[1-7][0-9A-F]{7})(;[^\u0000- ()<>@,;:\\\\\"/\\[\\]?={}\u007f-\uffff]+=[^\u0000- ()<>@,;:\\\\\"/\\[\\]?={}\u007f-\uffff]+)*\r\n";
    private static final Pattern TOKEN_PATTERN = Pattern.compile("[^\u0000- ()<>@,;:\\\\\"/\\[\\]?={}\u007f-\uffff]+");
    private static final Pattern HEADER_PATTERN = Pattern.compile("(0|[1-9A-F][0-9A-F]{0,6}|[1-7][0-9A-F]{7})(;[^\u0000- ()<>@,;:\\\\\"/\\[\\]?={}\u007f-\uffff]+=[^\u0000- ()<>@,;:\\\\\"/\\[\\]?={}\u007f-\uffff]+)*\r\n");

    private static boolean validToken(String token) {
        return TOKEN_PATTERN.matcher(token).matches();
    }

    public static void writeChunk(OutputStream stream, Chunk chunk) throws IOException {
        stream.write(Integer.toHexString(chunk.getBytes().length).toUpperCase().getBytes(ASCII));
        for (Map.Entry entry : chunk.getParameters().entrySet()) {
            String name = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (!Chunking.validToken(name)) {
                throw new IOException("Invalid parameter name '" + name + "'");
            }
            if (!Chunking.validToken(value)) {
                throw new IOException("Invalid parameter value '" + value + "'");
            }
            stream.write(59);
            stream.write(name.getBytes(ASCII));
            stream.write(61);
            stream.write(value.getBytes(ASCII));
        }
        stream.write(CRLF);
        stream.write(chunk.getBytes());
        stream.write(CRLF);
    }

    public static Chunk readChunk(InputStream stream) throws IOException {
        int read;
        String header = Chunking.readLine(stream);
        if (header == null) {
            return null;
        }
        if (!HEADER_PATTERN.matcher(header).matches()) {
            throw new IOException("Chunk header corrupted");
        }
        StringTokenizer tokenizer = new StringTokenizer(header, ";=\r\n");
        int size = Integer.parseInt(tokenizer.nextToken(), 16);
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
        while (tokenizer.hasMoreTokens()) {
            String name = tokenizer.nextToken();
            String value = tokenizer.nextToken();
            parameters.put(name, value);
        }
        byte[] bytes = new byte[size];
        for (int total = 0; total < size; total += read) {
            read = stream.read(bytes, total, size - total);
            if (read != -1) continue;
            throw new EOFException("Unexpected end of stream in chunk data");
        }
        int cr = stream.read();
        int lf = stream.read();
        if (cr == -1 || cr == 13 && lf == -1) {
            throw new EOFException("Unexpected end of stream in chunk trailer");
        }
        if (cr != 13 || lf != 10) {
            throw new IOException("Chunk trailer corrupted");
        }
        return new Chunk(bytes, parameters);
    }

    private static String readLine(InputStream stream) throws IOException {
        int b;
        ByteArrayOutputStream header = new ByteArrayOutputStream();
        do {
            if ((b = stream.read()) == -1) {
                if (header.size() == 0) {
                    return null;
                }
                throw new EOFException("Unexpected end of stream in chunk header");
            }
            header.write(b);
        } while (b != 10);
        return header.toString(ASCII);
    }
}

