/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlplatform.artifact;

import com.xebialabs.deployit.booter.local.utils.Closeables;
import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.engine.replacer.PlaceholderScanner;
import com.xebialabs.deployit.engine.replacer.Placeholders;
import com.xebialabs.deployit.exception.RuntimeIOException;
import com.xebialabs.deployit.io.ArtifactFileUtils;
import com.xebialabs.deployit.io.Exploder;
import com.xebialabs.deployit.plugin.api.udm.artifact.Artifact;
import com.xebialabs.deployit.plugin.api.udm.artifact.FolderArtifact;
import com.xebialabs.deployit.plugin.api.udm.artifact.SourceArtifact;
import com.xebialabs.deployit.repository.WorkDir;
import com.xebialabs.deployit.service.replacement.MustachePlaceholderScanner;
import com.xebialabs.deployit.service.replacement.PlaceholderScanningFailedException;
import com.xebialabs.deployit.util.DevNull;
import com.xebialabs.deployit.util.JavaCryptoUtils;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.util.OverthereUtils;
import com.xebialabs.xlplatform.artifact.ExternalArtifactDownloader$;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.util.function.Supplier;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\t4A\u0001C\u0005\u0001%!A!\u0002\u0001B\u0001B\u0003%\u0011\u0004\u0003\u0005'\u0001\t\u0005\t\u0015!\u0003(\u0011\u0015i\u0003\u0001\"\u0001/\u0011\u0015\u0019\u0004\u0001\"\u00015\u0011\u0019A\u0004\u0001\"\u0001\ni!)\u0011\b\u0001C\u0005u!)\u0001\t\u0001C\u0001\u0003\n\u0001\u0012I\u001d;jM\u0006\u001cG/\u00128sS\u000eDWM\u001d\u0006\u0003\u0015-\t\u0001\"\u0019:uS\u001a\f7\r\u001e\u0006\u0003\u00195\t!\u0002\u001f7qY\u0006$hm\u001c:n\u0015\tqq\"A\u0005yK\nL\u0017\r\\1cg*\t\u0001#A\u0002d_6\u001c\u0001a\u0005\u0002\u0001'A\u0011AcF\u0007\u0002+)\ta#A\u0003tG\u0006d\u0017-\u0003\u0002\u0019+\t1\u0011I\\=SK\u001a\u0004\"A\u0007\u0013\u000e\u0003mQ!A\u0003\u000f\u000b\u0005uq\u0012aA;e[*\u0011q\u0004I\u0001\u0004CBL'BA\u0011#\u0003\u0019\u0001H.^4j]*\u00111%D\u0001\tI\u0016\u0004Hn\\=ji&\u0011Qe\u0007\u0002\t\u0003J$\u0018NZ1di\u00069qo\u001c:l\t&\u0014\bC\u0001\u0015,\u001b\u0005I#B\u0001\u0016#\u0003)\u0011X\r]8tSR|'/_\u0005\u0003Y%\u0012qaV8sW\u0012K'/\u0001\u0004=S:LGO\u0010\u000b\u0004_E\u0012\u0004C\u0001\u0019\u0001\u001b\u0005I\u0001\"\u0002\u0006\u0004\u0001\u0004I\u0002\"\u0002\u0014\u0004\u0001\u00049\u0013AB3oe&\u001c\u0007\u000eF\u00016!\t!b'\u0003\u00028+\t!QK\\5u\u00039)gN]5dQ\u0006\u0013H/\u001b4bGR\f!\u0003Z8TG\u0006t\u0007\u000b\\1dK\"|G\u000eZ3sgR\u0011Qg\u000f\u0005\u0006y\u0019\u0001\r!P\u0001\u000fg>,(oY3BeRLg-Y2u!\tQb(\u0003\u0002@7\tq1k\\;sG\u0016\f%\u000f^5gC\u000e$\u0018aC:fi\u000eCWmY6tk6$\"!\u000e\"\t\u000b\r;\u0001\u0019A\u001f\u0002\t%$X-\u001c\u0015\u0005\u0001\u0015CU\f\u0005\u0002\u0015\r&\u0011q)\u0006\u0002\u000bI\u0016\u0004(/Z2bi\u0016$\u0017'B\u0012J)b+\u0006C\u0001&R\u001d\tYu\n\u0005\u0002M+5\tQJ\u0003\u0002O#\u00051AH]8pizJ!\u0001U\u000b\u0002\rA\u0013X\rZ3g\u0013\t\u00116K\u0001\u0004TiJLgn\u001a\u0006\u0003!VI!!\u0016,\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00132\u0015\t9V#\u0001\u0006eKB\u0014XmY1uK\u0012\fTaI-[7^s!\u0001\u0006.\n\u0005]+\u0012\u0007\u0002\u0012\u0015+q\u0013Qa]2bY\u0006\fTaI%_A~K!a\u0018,\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00133c\u0015\u0019\u0013LW1Xc\u0011\u0011C#\u0006/")
public class ArtifactEnricher {
    private final Artifact artifact;
    private final WorkDir workDir;

    public void enrich() {
        this.enrichArtifact();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void enrichArtifact() {
        boolean bl = false;
        SourceArtifact sourceArtifact = null;
        Artifact artifact = this.artifact;
        if (artifact instanceof SourceArtifact) {
            bl = true;
            sourceArtifact = (SourceArtifact)artifact;
            if (!ArtifactFileUtils.hasRealOrResolvedFile((Artifact)sourceArtifact)) {
                BoxedUnit boxedUnit;
                sourceArtifact.setFile((OverthereFile)ExternalArtifactDownloader$.MODULE$.downloadResolvedFile(sourceArtifact, this.workDir));
                this.setChecksum(sourceArtifact);
                if (Placeholders.shouldScanPlaceholders((SourceArtifact)sourceArtifact)) {
                    this.doScanPlaceholders(sourceArtifact);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit2 = boxedUnit;
                return;
            }
        }
        if (bl && Placeholders.shouldScanPlaceholders((SourceArtifact)sourceArtifact)) {
            this.doScanPlaceholders(sourceArtifact);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private void doScanPlaceholders(SourceArtifact sourceArtifact) {
        try {
            Placeholders.scanPlaceholders((SourceArtifact)sourceArtifact, (PlaceholderScanner)new MustachePlaceholderScanner());
        }
        catch (RuntimeException re) {
            PlaceholderScanningFailedException.throwException((String)sourceArtifact.getId(), (RuntimeException)re);
        }
    }

    public void setChecksum(SourceArtifact item) {
        SourceArtifact sourceArtifact;
        MessageDigest sha1 = JavaCryptoUtils.getSha1();
        SourceArtifact sourceArtifact2 = item;
        if (sourceArtifact2 != null && (sourceArtifact = sourceArtifact2).hasProperty("checksum") && Strings.isBlank((String)((String)sourceArtifact.getProperty("checksum")))) {
            block8: {
                try {
                    BoxedUnit boxedUnit;
                    SourceArtifact sourceArtifact3 = sourceArtifact;
                    if (sourceArtifact3 instanceof FolderArtifact) {
                        FolderArtifact folderArtifact = (FolderArtifact)sourceArtifact3;
                        Exploder.calculateCheckSum((Supplier)new Supplier<InputStream>(null, folderArtifact){
                            private final FolderArtifact x2$1;

                            public InputStream get() {
                                return this.x2$1.getFile().getInputStream();
                            }
                            {
                                this.x2$1 = x2$1;
                            }
                        }, (MessageDigest)sha1);
                        BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                        break block8;
                    }
                    DigestInputStream dataInput = new DigestInputStream(sourceArtifact3.getFile().getInputStream(), sha1);
                    try {
                        OverthereUtils.write((InputStream)dataInput, (OutputStream)new DevNull());
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    finally {
                        Closeables.closeQuietly((Closeable)dataInput);
                    }
                    BoxedUnit boxedUnit3 = boxedUnit;
                }
                catch (IOException e) {
                    throw new RuntimeIOException("Could not calculate checksum for the artifact.", (Throwable)e);
                }
            }
            sourceArtifact.setProperty("checksum", (Object)JavaCryptoUtils.digest((MessageDigest)sha1));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public ArtifactEnricher(Artifact artifact, WorkDir workDir) {
        this.artifact = artifact;
        this.workDir = workDir;
    }
}

