import React from 'react';
import PropTypes from 'prop-types';

import './help-block.less';

export const HelpBlock = ({className, children}) => (
    <div className={`help-block-component ${className}`}>
        {children}
    </div>
);

HelpBlock.propTypes = {
    children: PropTypes.string.isRequired,
    className: PropTypes.string,
};

HelpBlock.defaultProps = {
    className: ''
};
