/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.v1;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.xlplatform.documentation.PublicApi;
import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.api.ApiService;
import com.xebialabs.xlrelease.api.v1.filter.TriggerFilters;
import com.xebialabs.xlrelease.domain.ReleaseTrigger;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.ReleaseTriggerRepository;
import com.xebialabs.xlrelease.rest.AllCILevels;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import com.xebialabs.xlrelease.triggers.management.service.ReleaseTriggerManagementService;
import com.xebialabs.xlrelease.triggers.management.util.SortSupport;
import com.xebialabs.xlrelease.view.ReleaseTriggerOverview;
import com.xebialabs.xlrelease.views.BulkActionResultView;
import java.util.List;
import javax.ws.rs.BeanParam;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Controller;

@Path(value="/api/v1/triggers")
@AllCILevels
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Controller
@PublicApi
@ShowOnlyPublicApiMembers
public class TriggersApi
implements ApiService {
    private PermissionChecker permissions;
    private ReleaseActorService releaseActorService;
    private ReleaseTriggerManagementService releaseTriggerManagementService;
    private ReleaseTriggerRepository releaseTriggerRepository;

    @Autowired
    public TriggersApi(PermissionChecker permissions, ReleaseActorService releaseActorService, ReleaseTriggerManagementService releaseTriggerManagementService, ReleaseTriggerRepository releaseTriggerRepository) {
        this.permissions = permissions;
        this.releaseActorService = releaseActorService;
        this.releaseTriggerManagementService = releaseTriggerManagementService;
        this.releaseTriggerRepository = releaseTriggerRepository;
    }

    public String serviceName() {
        return "triggersApi";
    }

    @GET
    @Timed
    public Page<ReleaseTriggerOverview> searchTriggers(@BeanParam TriggerFilters triggerFilters, @DefaultValue(value="0") @QueryParam(value="page") int page, @DefaultValue(value="100") @QueryParam(value="resultsPerPage") int resultsPerPage, @Context UriInfo uriInfo) {
        Checks.checkArgument(((long)resultsPerPage <= 100L ? 1 : 0) != 0, (String)"Number of results per page cannot be more than 100", (Object[])new Object[0]);
        PageRequest pageable = PageRequest.of((int)page, (int)resultsPerPage, (Sort)SortSupport.toSort(uriInfo));
        return this.searchTriggers(triggerFilters, (Pageable)pageable);
    }

    @PublicApiMember
    @Timed
    public List<ReleaseTriggerOverview> searchTriggers(TriggerFilters triggerFilters, int page, int resultsPerPage, Sort sort) {
        PageRequest pageable = PageRequest.of((int)page, (int)resultsPerPage, (Sort)sort);
        return this.searchTriggers(triggerFilters, (Pageable)pageable).getContent();
    }

    @PublicApiMember
    @Timed
    public List<ReleaseTriggerOverview> searchTriggers(TriggerFilters triggerFilters, int page, int resultsPerPage) {
        return this.searchTriggers(triggerFilters, page, resultsPerPage, Sort.unsorted());
    }

    @Timed
    public Page<ReleaseTriggerOverview> searchTriggers(TriggerFilters triggerFilters, Pageable pageable) {
        if (triggerFilters == null) {
            triggerFilters = new TriggerFilters();
        }
        return this.releaseTriggerManagementService.findBy(triggerFilters, pageable);
    }

    @PUT
    @Path(value="/{triggerId:.*/Trigger[^/]*}/enable")
    @PublicApiMember
    @Timed
    public void enableTrigger(@PathParam(value="triggerId") String triggerId) {
        String templateId = Ids.releaseIdFrom((String)triggerId);
        this.permissions.check(XLReleasePermissions.EDIT_TRIGGERS, templateId);
        this.updateTrigger(triggerId, true);
    }

    @POST
    @Path(value="enable")
    @PublicApiMember
    @Timed
    public BulkActionResultView enableTriggers(List<String> triggerIds) {
        List allowedTriggers = this.permissions.filterEditableTriggers(triggerIds);
        if (allowedTriggers.isEmpty()) {
            return new BulkActionResultView(allowedTriggers);
        }
        allowedTriggers.forEach(triggerId -> this.updateTrigger((String)triggerId, true));
        return new BulkActionResultView(allowedTriggers);
    }

    @POST
    @Path(value="enable/all")
    @PublicApiMember
    @Timed
    public BulkActionResultView enableAllTriggers() {
        List<String> triggers = this.releaseTriggerManagementService.findAllTriggerIds();
        triggers.forEach(triggerId -> this.updateTrigger((String)triggerId, true));
        return new BulkActionResultView(triggers);
    }

    @PUT
    @Path(value="/{triggerId:.*/Trigger[^/]*}/disable")
    @PublicApiMember
    @Timed
    public void disableTrigger(@PathParam(value="triggerId") String triggerId) {
        String templateId = Ids.releaseIdFrom((String)triggerId);
        this.permissions.check(XLReleasePermissions.EDIT_TRIGGERS, templateId);
        this.updateTrigger(triggerId, false);
    }

    @POST
    @Path(value="disable")
    @PublicApiMember
    @Timed
    public BulkActionResultView disableTriggers(List<String> triggerIds) {
        List allowedTriggers = this.permissions.filterEditableTriggers(triggerIds);
        if (allowedTriggers.isEmpty()) {
            return new BulkActionResultView(allowedTriggers);
        }
        allowedTriggers.forEach(triggerId -> this.updateTrigger((String)triggerId, false));
        return new BulkActionResultView(allowedTriggers);
    }

    @POST
    @Path(value="disable/all")
    @PublicApiMember
    @Timed
    public BulkActionResultView disableAllTriggers() {
        List<String> triggers = this.releaseTriggerManagementService.findAllTriggerIds();
        triggers.forEach(triggerId -> this.updateTrigger((String)triggerId, false));
        return new BulkActionResultView(triggers);
    }

    private void updateTrigger(String triggerId, boolean enable) {
        ReleaseTrigger releaseTrigger = this.releaseTriggerRepository.find(triggerId);
        if (releaseTrigger.isEnabled() != enable) {
            releaseTrigger.setEnabled(enable);
            this.releaseActorService.updateTrigger(releaseTrigger.getTemplate().getId(), releaseTrigger);
        }
    }

    @DELETE
    @Path(value="/{triggerId:.*/Trigger[^/]*}")
    @PublicApiMember
    @Timed
    public void removeTrigger(@PathParam(value="triggerId") String triggerId) {
        String templateId = Ids.releaseIdFrom((String)triggerId);
        this.permissions.check(XLReleasePermissions.EDIT_TRIGGERS, templateId);
        this.releaseActorService.deleteTrigger(templateId, triggerId);
    }

    @POST
    @Path(value="/{triggerId:.*/Trigger[^/]*}/run")
    @Timed
    public void runTrigger(@PathParam(value="triggerId") String triggerId) {
        String templateId = Ids.releaseIdFrom((String)triggerId);
        this.permissions.check(XLReleasePermissions.EDIT_TRIGGERS, templateId);
        this.releaseActorService.runNowTrigger(templateId, triggerId);
    }
}

