/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository.sql;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.ItemAlreadyExistsException;
import com.xebialabs.deployit.repository.ItemInUseException;
import com.xebialabs.xlrelease.db.sql.SqlBuilder;
import com.xebialabs.xlrelease.db.sql.transaction.IsReadOnly;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.domain.Comment;
import com.xebialabs.xlrelease.domain.Dependency;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.ReleaseTrigger;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.events.ReleaseCreationSource;
import com.xebialabs.xlrelease.domain.status.ReleaseStatus;
import com.xebialabs.xlrelease.domain.utils.Diff;
import com.xebialabs.xlrelease.domain.utils.Diff$;
import com.xebialabs.xlrelease.domain.utils.syntax;
import com.xebialabs.xlrelease.domain.utils.syntax$;
import com.xebialabs.xlrelease.repository.FacetRepository;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.Page;
import com.xebialabs.xlrelease.repository.PersistenceInterceptor;
import com.xebialabs.xlrelease.repository.ReleaseExtensionsRepository;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.repository.ReleaseSearchByParams;
import com.xebialabs.xlrelease.repository.TeamRepository;
import com.xebialabs.xlrelease.repository.query.ResolveOptions;
import com.xebialabs.xlrelease.repository.query.ResolveOptionsBuilder;
import com.xebialabs.xlrelease.repository.sql.ConfigurationReferencesSupport;
import com.xebialabs.xlrelease.repository.sql.DeserializationSupport;
import com.xebialabs.xlrelease.repository.sql.InterceptedRepository;
import com.xebialabs.xlrelease.repository.sql.SqlReleaseRepositoryHelper;
import com.xebialabs.xlrelease.repository.sql.SqlRepositoryAdapter;
import com.xebialabs.xlrelease.repository.sql.persistence.CiId$;
import com.xebialabs.xlrelease.repository.sql.persistence.CommentPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.CommentPersistence$CommentRow$;
import com.xebialabs.xlrelease.repository.sql.persistence.ConfigurationPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.DependencyPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.ReleasePersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.ReleasesSqlBuilder;
import com.xebialabs.xlrelease.repository.sql.persistence.TaskPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.TriggerPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.data.DependencyRow;
import com.xebialabs.xlrelease.repository.sql.persistence.data.DependencyRow$;
import com.xebialabs.xlrelease.repository.sql.persistence.data.ReleaseRow;
import com.xebialabs.xlrelease.security.SecuredCi;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.slf4j.Marker;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;

@IsTransactional
@ScalaSignature(bytes="\u0006\u0001\ree\u0001B\u00193\u0001uB\u0001b\u0019\u0001\u0003\u0002\u0003\u0006I\u0001\u001a\u0005\tU\u0002\u0011)\u0019!C\tW\"Aq\u000e\u0001B\u0001B\u0003%A\u000e\u0003\u0005q\u0001\t\u0015\r\u0011\"\u0005r\u0011!)\bA!A!\u0002\u0013\u0011\b\u0002\u0003<\u0001\u0005\u000b\u0007I\u0011C<\t\u0011m\u0004!\u0011!Q\u0001\naD\u0001\u0002 \u0001\u0003\u0006\u0004%\t\" \u0005\n\u0003\u0007\u0001!\u0011!Q\u0001\nyD!\"!\u0002\u0001\u0005\u000b\u0007I\u0011CA\u0004\u0011)\ty\u0001\u0001B\u0001B\u0003%\u0011\u0011\u0002\u0005\u000b\u0003#\u0001!Q1A\u0005\u0002\u0005M\u0001BCA\u000e\u0001\t\u0005\t\u0015!\u0003\u0002\u0016!Q\u0011Q\u0004\u0001\u0003\u0006\u0004%\t!a\b\t\u0015\u0005\u001d\u0002A!A!\u0002\u0013\t\t\u0003\u0003\u0006\u0002*\u0001\u0011)\u0019!C\t\u0003WA!\"a\r\u0001\u0005\u0003\u0005\u000b\u0011BA\u0017\u0011)\t)\u0004\u0001B\u0001B\u0003%\u0011q\u0007\u0005\u000b\u0003{\u0001!Q1A\u0005\u0004\u0005}\u0002BCA8\u0001\t\u0005\t\u0015!\u0003\u0002B!9\u0011\u0011\u000f\u0001\u0005\u0002\u0005M\u0004bBAH\u0001\u0011\u0005\u0013\u0011\u0013\u0005\b\u0003#\u0004A\u0011IAj\u0011\u001d\tY\u000f\u0001C!\u0003[Dq!a;\u0001\t\u0003\n\u0019\u0010C\u0004\u0003\n\u0001!\tEa\u0003\t\u000f\t\r\u0003\u0001\"\u0011\u0003F!9!Q\n\u0001\u0005\u0002\t=\u0003b\u0002B:\u0001\u0011\u0005#Q\u000f\u0005\b\u0005\u000f\u0003A\u0011\u0001BE\u0011\u001d\u00119\n\u0001C!\u00053CqA!,\u0001\t\u0003\u0012y\u000bC\u0004\u00036\u0002!IAa.\t\u000f\t}\u0006\u0001\"\u0011\u0003B\"9!\u0011\u001a\u0001\u0005B\t-\u0007b\u0002Bl\u0001\u0011\u0005#\u0011\u001c\u0005\b\u0005?\u0004A\u0011\tBq\u0011\u001d\u0011Y\u000f\u0001C!\u0005[DqAa>\u0001\t\u0003\u0012I\u0010C\u0004\u0004\b\u0001!\te!\u0003\t\u000f\rE\u0001\u0001\"\u0011\u0004\u0014!911\u0004\u0001\u0005B\ru\u0001bBB\u000e\u0001\u0011\u000531\u0005\u0005\b\u0007_\u0001A\u0011IB\u0019\u0011\u001d\u0019I\u0004\u0001C!\u0007wAqaa\u0013\u0001\t\u0013\u0019i\u0005C\u0004\u0004n\u0001!Iaa\u001c\t\u000f\rU\u0004\u0001\"\u0011\u0004x\t!2+\u001d7SK2,\u0017m]3SKB|7/\u001b;pefT!a\r\u001b\u0002\u0007M\fHN\u0003\u00026m\u0005Q!/\u001a9pg&$xN]=\u000b\u0005]B\u0014!\u0003=me\u0016dW-Y:f\u0015\tI$(A\u0005yK\nL\u0017\r\\1cg*\t1(A\u0002d_6\u001c\u0001a\u0005\u0005\u0001}\u0011C%KW/a!\ty$)D\u0001A\u0015\u0005\t\u0015!B:dC2\f\u0017BA\"A\u0005\u0019\te.\u001f*fMB\u0011QIR\u0007\u0002i%\u0011q\t\u000e\u0002\u0012%\u0016dW-Y:f%\u0016\u0004xn]5u_JL\bcA%K\u00196\t!'\u0003\u0002Le\t)\u0012J\u001c;fe\u000e,\u0007\u000f^3e%\u0016\u0004xn]5u_JL\bCA'Q\u001b\u0005q%BA(7\u0003\u0019!w.\\1j]&\u0011\u0011K\u0014\u0002\b%\u0016dW-Y:f!\t\u0019\u0006,D\u0001U\u0015\t)f+A\u0003tY\u001a$$NC\u0001X\u0003!9'/\u001b>{Y\u0016$\u0017BA-U\u0005\u001daunZ4j]\u001e\u0004\"!S.\n\u0005q\u0013$A\u0006#fg\u0016\u0014\u0018.\u00197ju\u0006$\u0018n\u001c8TkB\u0004xN\u001d;\u0011\u0005%s\u0016BA03\u0005y\u0019uN\u001c4jOV\u0014\u0018\r^5p]J+g-\u001a:f]\u000e,7oU;qa>\u0014H\u000f\u0005\u0002JC&\u0011!M\r\u0002\u001b'Fd'+\u001a7fCN,'+\u001a9pg&$xN]=IK2\u0004XM]\u0001\u0013e\u0016dW-Y:f!\u0016\u00148/[:uK:\u001cW\r\u0005\u0002fQ6\taM\u0003\u0002he\u0005Y\u0001/\u001a:tSN$XM\\2f\u0013\tIgM\u0001\nSK2,\u0017m]3QKJ\u001c\u0018n\u001d;f]\u000e,\u0017a\u0004;bg.\u0004VM]:jgR,gnY3\u0016\u00031\u0004\"!Z7\n\u000594'a\u0004+bg.\u0004VM]:jgR,gnY3\u0002!Q\f7o\u001b)feNL7\u000f^3oG\u0016\u0004\u0013!\u00063fa\u0016tG-\u001a8dsB+'o]5ti\u0016t7-Z\u000b\u0002eB\u0011Qm]\u0005\u0003i\u001a\u0014Q\u0003R3qK:$WM\\2z!\u0016\u00148/[:uK:\u001cW-\u0001\feKB,g\u000eZ3oGf\u0004VM]:jgR,gnY3!\u0003I\u0019w.\\7f]R\u0004VM]:jgR,gnY3\u0016\u0003a\u0004\"!Z=\n\u0005i4'AE\"p[6,g\u000e\u001e)feNL7\u000f^3oG\u0016\f1cY8n[\u0016tG\u000fU3sg&\u001cH/\u001a8dK\u0002\na\u0002^3b[J+\u0007o\\:ji>\u0014\u00180F\u0001\u007f!\t)u0C\u0002\u0002\u0002Q\u0012a\u0002V3b[J+\u0007o\\:ji>\u0014\u00180A\buK\u0006l'+\u001a9pg&$xN]=!\u0003m\u0011X\r\\3bg\u0016,\u0005\u0010^3og&|gn\u001d*fa>\u001c\u0018\u000e^8ssV\u0011\u0011\u0011\u0002\t\u0004\u000b\u0006-\u0011bAA\u0007i\tY\"+\u001a7fCN,W\t\u001f;f]NLwN\\:SKB|7/\u001b;pef\fAD]3mK\u0006\u001cX-\u0012=uK:\u001c\u0018n\u001c8t%\u0016\u0004xn]5u_JL\b%\u0001\rd_:4\u0017nZ;sCRLwN\u001c)feNL7\u000f^3oG\u0016,\"!!\u0006\u0011\u0007\u0015\f9\"C\u0002\u0002\u001a\u0019\u0014\u0001dQ8oM&<WO]1uS>t\u0007+\u001a:tSN$XM\\2f\u0003e\u0019wN\u001c4jOV\u0014\u0018\r^5p]B+'o]5ti\u0016t7-\u001a\u0011\u0002#I,\u0007o\\:ji>\u0014\u00180\u00113baR,'/\u0006\u0002\u0002\"A\u0019\u0011*a\t\n\u0007\u0005\u0015\"G\u0001\u000bTc2\u0014V\r]8tSR|'/_!eCB$XM]\u0001\u0013e\u0016\u0004xn]5u_JL\u0018\tZ1qi\u0016\u0014\b%\u0001\nue&<w-\u001a:QKJ\u001c\u0018n\u001d;f]\u000e,WCAA\u0017!\r)\u0017qF\u0005\u0004\u0003c1'A\u0005+sS\u001e<WM\u001d)feNL7\u000f^3oG\u0016\f1\u0003\u001e:jO\u001e,'\u000fU3sg&\u001cH/\u001a8dK\u0002\nqBZ1dKR\u0014V\r]8tSR|'/\u001f\t\u0004\u000b\u0006e\u0012bAA\u001ei\tya)Y2fiJ+\u0007o\\:ji>\u0014\u00180\u0001\u0006tc2$\u0015.\u00197fGR,\"!!\u0011\u0011\t\u0005\r\u0013\u0011\u000e\b\u0005\u0003\u000b\n\u0019G\u0004\u0003\u0002H\u0005}c\u0002BA%\u00037rA!a\u0013\u0002Z9!\u0011QJA,\u001d\u0011\ty%!\u0016\u000e\u0005\u0005E#bAA*y\u00051AH]8pizJ\u0011aO\u0005\u0003siJ!a\u000e\u001d\n\u0007\u0005uc'\u0001\u0002eE&\u00191'!\u0019\u000b\u0007\u0005uc'\u0003\u0003\u0002f\u0005\u001d\u0014AC*rY\n+\u0018\u000e\u001c3fe*\u00191'!\u0019\n\t\u0005-\u0014Q\u000e\u0002\b\t&\fG.Z2u\u0015\u0011\t)'a\u001a\u0002\u0017M\fH\u000eR5bY\u0016\u001cG\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015-\u0005U\u00141PA?\u0003\u007f\n\t)a!\u0002\u0006\u0006\u001d\u0015\u0011RAF\u0003\u001b#B!a\u001e\u0002zA\u0011\u0011\n\u0001\u0005\b\u0003{)\u00029AA!\u0011\u0015\u0019W\u00031\u0001e\u0011\u0015QW\u00031\u0001m\u0011\u0015\u0001X\u00031\u0001s\u0011\u00151X\u00031\u0001y\u0011\u0015aX\u00031\u0001\u007f\u0011\u001d\t)!\u0006a\u0001\u0003\u0013Aq!!\u0005\u0016\u0001\u0004\t)\u0002C\u0004\u0002\u001eU\u0001\r!!\t\t\u000f\u0005%R\u00031\u0001\u0002.!9\u0011QG\u000bA\u0002\u0005]\u0012AB3ySN$8\u000f\u0006\u0003\u0002\u0014\u0006e\u0005cA \u0002\u0016&\u0019\u0011q\u0013!\u0003\u000f\t{w\u000e\\3b]\"9\u00111\u0014\fA\u0002\u0005u\u0015AA5e!\u0011\ty*a*\u000f\t\u0005\u0005\u00161\u0015\t\u0004\u0003\u001f\u0002\u0015bAAS\u0001\u00061\u0001K]3eK\u001aLA!!+\u0002,\n11\u000b\u001e:j]\u001eT1!!*AQ\r1\u0012q\u0016\t\u0005\u0003c\u000b9,\u0004\u0002\u00024*!\u0011QWA4\u0003-!(/\u00198tC\u000e$\u0018n\u001c8\n\t\u0005e\u00161\u0017\u0002\u000b\u0013N\u0014V-\u00193P]2L\bf\u0001\f\u0002>B!\u0011qXAg\u001b\t\t\tM\u0003\u0003\u0002D\u0006\u0015\u0017AC1o]>$\u0018\r^5p]*!\u0011qYAe\u0003\u001diW\r\u001e:jGNT1!a3;\u0003!\u0019w\u000eZ1iC2,\u0017\u0002BAh\u0003\u0003\u0014Q\u0001V5nK\u0012\faa\u0019:fCR,G#\u0002'\u0002V\u0006e\u0007BBAl/\u0001\u0007A*A\u0004sK2,\u0017m]3\t\u000f\u0005mw\u00031\u0001\u0002^\u0006)\"/\u001a7fCN,7I]3bi&|gnU8ve\u000e,\u0007\u0003BAp\u0003Kl!!!9\u000b\u0007\u0005\rh*\u0001\u0004fm\u0016tGo]\u0005\u0005\u0003O\f\tOA\u000bSK2,\u0017m]3De\u0016\fG/[8o'>,(oY3)\u0007]\ti,\u0001\u0005gS:$')_%e)\ra\u0015q\u001e\u0005\b\u00037C\u0002\u0019AAOQ\rA\u0012Q\u0018\u000b\u0006\u0019\u0006U\u0018q\u001f\u0005\b\u00037K\u0002\u0019AAO\u0011\u001d\tI0\u0007a\u0001\u0003w\faB]3t_24Xm\u00149uS>t7\u000f\u0005\u0003\u0002~\n\rQBAA\u0000\u0015\r\u0011\t\u0001N\u0001\u0006cV,'/_\u0005\u0005\u0005\u000b\tyP\u0001\bSKN|GN^3PaRLwN\\:)\u0007e\ti,A\bgS:$\u0017\nZ:CsN#\u0018\r^;t)\u0011\u0011iAa\b\u0011\r\t=!\u0011DAO\u001d\u0011\u0011\tB!\u0006\u000f\t\u0005=#1C\u0005\u0002\u0003&\u0019!q\u0003!\u0002\u000fA\f7m[1hK&!!1\u0004B\u000f\u0005\r\u0019V-\u001d\u0006\u0004\u0005/\u0001\u0005b\u0002B\u00115\u0001\u0007!1E\u0001\tgR\fG/^:fgB)qH!\n\u0003*%\u0019!q\u0005!\u0003\u0015q\u0012X\r]3bi\u0016$g\b\u0005\u0003\u0003,\tERB\u0001B\u0017\u0015\r\u0011yCT\u0001\u0007gR\fG/^:\n\t\tM\"Q\u0006\u0002\u000e%\u0016dW-Y:f'R\fG/^:)\u0007i\ti\fK\u0002\u001b\u0005s\u0001BAa\u000f\u0003@5\u0011!Q\b\u0006\u0004\u0003\u0007\u0004\u0015\u0002\u0002B!\u0005{\u0011qA^1sCJ<7/A\ngS:$')_\"bY\u0016tG-\u0019:U_.,g\u000eF\u0002M\u0005\u000fBqA!\u0013\u001c\u0001\u0004\ti*A\u0007dC2,g\u000eZ1s)>\\WM\u001c\u0015\u00047\u0005u\u0016\u0001\u00074j]\u0012\f%o\u00195jm\u0006\u0014G.\u001a*fY\u0016\f7/Z%egR1!Q\u0002B)\u0005KBqAa\u0015\u001d\u0001\u0004\u0011)&\u0001\u0003eCR,\u0007\u0003\u0002B,\u0005Cj!A!\u0017\u000b\t\tm#QL\u0001\u0005kRLGN\u0003\u0002\u0003`\u0005!!.\u0019<b\u0013\u0011\u0011\u0019G!\u0017\u0003\t\u0011\u000bG/\u001a\u0005\b\u0005Ob\u0002\u0019\u0001B5\u0003!\u0001\u0018mZ3TSj,\u0007cA \u0003l%\u0019!Q\u000e!\u0003\u0007%sG\u000fK\u0002\u001d\u0003_C3\u0001HA_\u00039\u0019X\r\u001e)sK\u0006\u00138\r[5wK\u0012$bAa\u001e\u0003~\t\u0005\u0005cA \u0003z%\u0019!1\u0010!\u0003\tUs\u0017\u000e\u001e\u0005\b\u0005\u007fj\u0002\u0019AAO\u0003%\u0011X\r\\3bg\u0016LE\rC\u0004\u0003\u0004v\u0001\r!a%\u0002\u0017A\u0014X-\u0011:dQ&4X\r\u001a\u0015\u0004;\u0005u\u0016!\u00074j]\u0012\u0004&/Z!sG\"Lg/\u00192mKJ+G.Z1tKN$bAa#\u0003\u000e\nE\u0005#\u0002B\b\u00053a\u0005b\u0002BH=\u0001\u0007!\u0011N\u0001\u0005a\u0006<W\rC\u0004\u0003hy\u0001\rA!\u001b)\u0007y\ty\u000bK\u0002\u001f\u0003{\u000baa]3be\u000eDG\u0003\u0002BN\u0005C\u0003RAa\u0016\u0003\u001e2KAAa(\u0003Z\t!A*[:u\u0011\u001d\u0011\u0019k\ba\u0001\u0005K\u000bAb]3be\u000eD\u0007+\u0019:b[N\u00042!\u0012BT\u0013\r\u0011I\u000b\u000e\u0002\u0016%\u0016dW-Y:f'\u0016\f'o\u00195CsB\u000b'/Y7tQ\ry\u0012QX\u0001\u0007I\u0016dW\r^3\u0015\t\t]$\u0011\u0017\u0005\b\u00037\u0003\u0003\u0019AAOQ\r\u0001\u0013QX\u0001\u0018I\u0016dW\r^3SK2,\u0017m]3SK\u001a,'/\u001a8dKN$bAa\u001e\u0003:\nm\u0006bBANC\u0001\u0007\u0011Q\u0014\u0005\b\u0005{\u000b\u0003\u0019\u0001B5\u0003)\u0011X\r\\3bg\u0016,\u0016\u000eZ\u0001\u000eI\u0016dW\r^3XSRDW+\u001b3\u0015\r\t]$1\u0019Bc\u0011\u001d\tYJ\ta\u0001\u0003;CqA!0#\u0001\u0004\u0011I\u0007K\u0002#\u0003{\u000bA!\\8wKR1!q\u000fBg\u0005#DqAa4$\u0001\u0004\ti*\u0001\u0006pe&<\u0017N\\1m\u0013\u0012DqAa5$\u0001\u0004\ti*A\u0003oK^LE\rK\u0002$\u0003{\u000b\u0011bZ3u'R\fG/^:\u0015\t\t%\"1\u001c\u0005\b\u00037#\u0003\u0019AAOQ\r!\u0013QX\u0001\fO\u0016$8\u000b^1ukN,7\u000f\u0006\u0003\u0003d\n\u0015\bC\u0002B\b\u00053\u0011I\u0003C\u0004\u0003h\u0016\u0002\rA!\u0004\u0002\u0007%$7\u000fK\u0002&\u0003{\u000bQbZ3u%&\u001c8nU2pe\u0016\u001cH\u0003\u0002Bx\u0005c\u0004bAa\u0004\u0003\u001a\t%\u0004b\u0002BtM\u0001\u0007!Q\u0002\u0015\u0004M\u0005=\u0006f\u0001\u0014\u0002>\u0006i1/\u001a;SSN\\7kY8sKN$\u0002Ba\u001e\u0003|\nu8\u0011\u0001\u0005\b\u0005\u007f:\u0003\u0019AAO\u0011\u001d\u0011yp\na\u0001\u0005S\nQa]2pe\u0016Dqaa\u0001(\u0001\u0004\u0011I'\u0001\u0006u_R\fGnU2pe\u0016D3aJA_\u0003)I7\u000fV3na2\fG/\u001a\u000b\u0005\u0003'\u001bY\u0001C\u0004\u0003\u0000!\u0002\r!!()\u0007!\ny\u000bK\u0002)\u0003{\u000b\u0001bZ3u)&$H.\u001a\u000b\u0005\u0003;\u001b)\u0002C\u0004\u0002\u001c&\u0002\r!!()\u0007%\ny\u000bK\u0002*\u0003{\u000ba!\u001e9eCR,Gc\u0001'\u0004 !1\u0011q\u001b\u0016A\u00021C3AKA_)\u0015a5QEB\u0015\u0011\u0019\u00199c\u000ba\u0001\u0019\u0006AqN]5hS:\fG\u000e\u0003\u0004\u0004,-\u0002\r\u0001T\u0001\bkB$\u0017\r^3eQ\rY\u0013QX\u0001\be\u0016\u0004H.Y2f)\u0015a51GB\u001b\u0011\u0019\u00199\u0003\fa\u0001\u0019\"111\u0006\u0017A\u00021C3\u0001LA_\u0003)9W\r^!mYR\u000bwm\u001d\u000b\u0005\u0007{\u0019\u0019\u0005\u0005\u0004\u0003X\r}\u0012QT\u0005\u0005\u0007\u0003\u0012IFA\u0002TKRDqa!\u0012.\u0001\u0004\u0011I'A\u0006mS6LGOT;nE\u0016\u0014\bfA\u0017\u00020\"\u001aQ&!0\u0002\u0015\u001d,GOU3mK\u0006\u001cX\rF\u0003M\u0007\u001f\u001aY\u0007C\u0004\u0003\u00009\u0002\ra!\u0015\u0011\t\rM3Q\r\b\u0005\u0007+\u001a\tG\u0004\u0003\u0004X\r}c\u0002BB-\u0007;rA!!\u0013\u0004\\%\u0011QGN\u0005\u0003gQJ!a\u001a\u001a\n\u0007\r\rd-\u0001\u0003DS&#\u0017\u0002BB4\u0007S\u0012AaQ5JI*\u001911\r4\t\u000f\u0005eh\u00061\u0001\u0002|\u0006\u00113\r[3dW&\u001bhj\u001c;SK\u001a,'/\u001a8dK\u0012\u0014\u0015\u0010R3qK:$WM\\2jKN$BAa\u001e\u0004r!911O\u0018A\u0002\rE\u0013a\u00069mC:LE/Z7JI>\u0013\u0018\n^:DQ&dGM]3o\u0003=1\u0017N\u001c3T\u00076#\u0015\r^1Cs&#G\u0003BB=\u0007\u0017\u0003RaPB>\u0007\u007fJ1a! A\u0005\u0019y\u0005\u000f^5p]B!1\u0011QBD\u001b\t\u0019\u0019I\u0003\u0003\u0004\u0006\nu\u0013\u0001\u00027b]\u001eLAa!#\u0004\u0004\n9\u0011J\u001c;fO\u0016\u0014\bbBANa\u0001\u0007\u0011Q\u0014\u0015\u0004a\u0005=\u0006f\u0001\u0019\u0002>\"\u001a\u0001aa%\u0011\t\u0005E6QS\u0005\u0005\u0007/\u000b\u0019LA\bJgR\u0013\u0018M\\:bGRLwN\\1m\u0001")
public class SqlReleaseRepository
implements ReleaseRepository,
InterceptedRepository<Release>,
Logging,
DeserializationSupport,
ConfigurationReferencesSupport,
SqlReleaseRepositoryHelper {
    private final ReleasePersistence releasePersistence;
    private final TaskPersistence taskPersistence;
    private final DependencyPersistence dependencyPersistence;
    private final CommentPersistence commentPersistence;
    private final TeamRepository teamRepository;
    private final ReleaseExtensionsRepository releaseExtensionsRepository;
    private final ConfigurationPersistence configurationPersistence;
    private final SqlRepositoryAdapter repositoryAdapter;
    private final TriggerPersistence triggerPersistence;
    private final FacetRepository facetRepository;
    private final SqlBuilder.Dialect sqlDialect;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private Seq<PersistenceInterceptor<Release>> persistenceInterceptors;
    private volatile transient boolean bitmap$trans$0;

    @Override
    public void replaceTasks(Release original, Release updated) {
        SqlReleaseRepositoryHelper.replaceTasks$(this, original, updated);
    }

    @Override
    public void replaceTriggers(Release original, Release updated) {
        SqlReleaseRepositoryHelper.replaceTriggers$(this, original, updated);
    }

    @Override
    public void replaceReleaseExtensions(Release original, Release updated) {
        SqlReleaseRepositoryHelper.replaceReleaseExtensions$(this, original, updated);
    }

    @Override
    public void replaceReleaseTeams(Release original, Release updated) {
        SqlReleaseRepositoryHelper.replaceReleaseTeams$(this, original, updated);
    }

    @Override
    public void updateCommentsOnTasks(Task originalTask, Task updatedTask) {
        SqlReleaseRepositoryHelper.updateCommentsOnTasks$(this, originalTask, updatedTask);
    }

    @Override
    public void insertDependency(Integer gateTaskUid, Dependency dependency) {
        SqlReleaseRepositoryHelper.insertDependency$(this, gateTaskUid, dependency);
    }

    @Override
    public void updateConfigurationRefs(Release release) {
        ConfigurationReferencesSupport.updateConfigurationRefs$(this, release);
    }

    @Override
    public void deleteConfigurationRefs(Integer releaseUid) {
        ConfigurationReferencesSupport.deleteConfigurationRefs$(this, releaseUid);
    }

    @Override
    public Release deserializeRelease(ReleaseRow releaseData, ResolveOptions resolveOptions) {
        return DeserializationSupport.deserializeRelease$(this, releaseData, resolveOptions);
    }

    @Override
    public Option<Release> tryDeserializeRelease(ReleaseRow releaseData, ResolveOptions resolveOptions) {
        return DeserializationSupport.tryDeserializeRelease$(this, releaseData, resolveOptions);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    @Override
    public void registerPersistenceInterceptor(PersistenceInterceptor<Release> persistenceInterceptor) {
        InterceptedRepository.registerPersistenceInterceptor$(this, persistenceInterceptor);
    }

    @Override
    public void interceptCreate(ConfigurationItem ci) {
        InterceptedRepository.interceptCreate$(this, ci);
    }

    @Override
    public void interceptDelete(String ciId) {
        InterceptedRepository.interceptDelete$(this, ciId);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        SqlReleaseRepository sqlReleaseRepository = this;
        synchronized (sqlReleaseRepository) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    @Override
    public Seq<PersistenceInterceptor<Release>> persistenceInterceptors() {
        return this.persistenceInterceptors;
    }

    @Override
    public void persistenceInterceptors_$eq(Seq<PersistenceInterceptor<Release>> x$1) {
        this.persistenceInterceptors = x$1;
    }

    public Seq<String> findIdsByStatus(ReleaseStatus ... statuses) {
        return this.findIdsByStatus((Seq<ReleaseStatus>)Predef$.MODULE$.wrapRefArray((Object[])statuses));
    }

    public TaskPersistence taskPersistence() {
        return this.taskPersistence;
    }

    public DependencyPersistence dependencyPersistence() {
        return this.dependencyPersistence;
    }

    public CommentPersistence commentPersistence() {
        return this.commentPersistence;
    }

    public TeamRepository teamRepository() {
        return this.teamRepository;
    }

    public ReleaseExtensionsRepository releaseExtensionsRepository() {
        return this.releaseExtensionsRepository;
    }

    @Override
    public ConfigurationPersistence configurationPersistence() {
        return this.configurationPersistence;
    }

    @Override
    public SqlRepositoryAdapter repositoryAdapter() {
        return this.repositoryAdapter;
    }

    public TriggerPersistence triggerPersistence() {
        return this.triggerPersistence;
    }

    public SqlBuilder.Dialect sqlDialect() {
        return this.sqlDialect;
    }

    @Timed
    @IsReadOnly
    public boolean exists(String id) {
        return this.releasePersistence.existsRelease(CiId$.MODULE$.RichCiId(id).normalized());
    }

    @Timed
    public Release create(Release release, ReleaseCreationSource releaseCreationSource) {
        if (this.releasePersistence.existsRelease(release.getId())) {
            throw new ItemAlreadyExistsException("A release with ID [%s] already exists", new Object[]{release.getId()});
        }
        this.interceptCreate((ConfigurationItem)release);
        this.releasePersistence.insert(release);
        release.getReleaseTriggers().forEach(trigger -> this.triggerPersistence().insert((ReleaseTrigger)trigger));
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(release.getAllTasks()).asScala()).foreach((Function1 & Serializable & scala.Serializable)task -> {
            SqlReleaseRepository.$anonfun$create$2(this, release, task);
            return BoxedUnit.UNIT;
        });
        release.getExtensions().forEach(extension -> this.releaseExtensionsRepository().create(extension));
        this.updateConfigurationRefs(release);
        this.facetRepository.createFromTasks((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(release.getAllTasks()).asScala());
        return release;
    }

    @Timed
    public Release findById(String id) {
        return this.getRelease(id, new ResolveOptionsBuilder().withEverything().build());
    }

    @Timed
    public Release findById(String id, ResolveOptions resolveOptions) {
        return this.getRelease(id, resolveOptions);
    }

    @Timed
    public Seq<String> findIdsByStatus(Seq<ReleaseStatus> statuses) {
        Tuple2 sqlWithParams = new ReleasesSqlBuilder(this.sqlDialect()).selectReleaseId().withOneOfStatuses(statuses).build();
        return this.releasePersistence.findReleaseIdsByQuery((Tuple2<String, Seq<Object>>)sqlWithParams);
    }

    @Timed
    public Release findByCalendarToken(String calendarToken) {
        Tuple2 sqlWithParams = new ReleasesSqlBuilder(this.sqlDialect()).selectReleaseData().withCalendarToken(calendarToken).build();
        Seq<ReleaseRow> releases = this.releasePersistence.findReleaseDatasByQuery((Tuple2<String, Seq<Object>>)sqlWithParams);
        return (Release)releases.headOption().map((Function1 & Serializable & scala.Serializable)x$1 -> this.deserializeRelease((ReleaseRow)x$1, new ResolveOptionsBuilder().withEverything().build())).orNull(Predef$.MODULE$.$conforms());
    }

    @Timed
    @IsReadOnly
    public Seq<String> findArchivableReleaseIds(Date date, int pageSize) {
        ReleasesSqlBuilder qual$1 = (ReleasesSqlBuilder)new ReleasesSqlBuilder(this.sqlDialect()).selectReleaseId().withOneOfStatuses((Seq<ReleaseStatus>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReleaseStatus[]{ReleaseStatus.COMPLETED, ReleaseStatus.ABORTED})))).withEndDateBefore(date).withPage(new Page(0L, (long)pageSize, Predef$.MODULE$.int2Integer(0)));
        boolean x$1 = qual$1.withPreArchived$default$1();
        Tuple2 sqlWithParams = qual$1.withPreArchived(x$1).build();
        return this.releasePersistence.findReleaseIdsByQuery((Tuple2<String, Seq<Object>>)sqlWithParams);
    }

    @Timed
    public void setPreArchived(String releaseId, boolean preArchived) {
        this.releasePersistence.setPreArchived(releaseId, preArchived);
    }

    @Timed
    @IsReadOnly
    public Seq<Release> findPreArchivableReleases(int page, int pageSize) {
        Seq inactive = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReleaseStatus[]{ReleaseStatus.COMPLETED, ReleaseStatus.ABORTED}));
        Tuple2 sqlWithParams = new ReleasesSqlBuilder(this.sqlDialect()).selectReleaseData().withOneOfStatuses((Seq<ReleaseStatus>)inactive).withPreArchived(false).limitAndOffset(pageSize, page * pageSize).build();
        return (Seq)((TraversableLike)((TraversableLike)((TraversableLike)this.releasePersistence.findReleaseDatasByQuery((Tuple2<String, Seq<Object>>)sqlWithParams).flatMap((Function1 & Serializable & scala.Serializable)x$2 -> Option$.MODULE$.option2Iterable(this.tryDeserializeRelease((ReleaseRow)x$2, new ResolveOptionsBuilder().withEverything().build())), Seq$.MODULE$.canBuildFrom())).filterNot((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.isTutorial()))).map((Function1 & Serializable & scala.Serializable)release -> this.releaseExtensionsRepository().decorate(release), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)release -> this.commentPersistence().decorate((Release)release), Seq$.MODULE$.canBuildFrom());
    }

    @Timed
    public List<Release> search(ReleaseSearchByParams searchParams) {
        ReleaseSearchByParams releaseSearchByParams = searchParams;
        if (releaseSearchByParams == null) {
            throw new MatchError((Object)releaseSearchByParams);
        }
        Page page = releaseSearchByParams.page();
        Either folderId2 = releaseSearchByParams.folderId();
        ReleaseStatus[] statuses = releaseSearchByParams.statuses();
        String title = releaseSearchByParams.title();
        String rootReleaseId = releaseSearchByParams.rootReleaseId();
        boolean autoStart = releaseSearchByParams.autoStart();
        ReleasesSqlBuilder base = (ReleasesSqlBuilder)new ReleasesSqlBuilder(this.sqlDialect()).selectReleaseData().withTitle(title).withRootReleaseId(rootReleaseId).withPage(page);
        ReleasesSqlBuilder sqlBuilder = folderId2 == null ? base : (ReleasesSqlBuilder)((Object)folderId2.fold((Function1 & Serializable & scala.Serializable)folderId -> base.withFolder((String)folderId), (Function1 & Serializable & scala.Serializable)ancestorId -> base.withAncestor((String)ancestorId)));
        Object object = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])statuses)).nonEmpty() ? sqlBuilder.withOneOfStatuses((Seq<ReleaseStatus>)Predef$.MODULE$.wrapRefArray((Object[])statuses)) : BoxedUnit.UNIT;
        Object object2 = autoStart ? sqlBuilder.withAutoStart() : BoxedUnit.UNIT;
        List list = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableLike)((TraversableLike)this.releasePersistence.findReleaseDatasByQuery((Tuple2<String, Seq<Object>>)sqlBuilder.build()).flatMap((Function1 & Serializable & scala.Serializable)x$4 -> Option$.MODULE$.option2Iterable(this.tryDeserializeRelease((ReleaseRow)x$4, new ResolveOptionsBuilder().withEverything().build())), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)release -> this.releaseExtensionsRepository().decorate(release), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)release -> this.commentPersistence().decorate((Release)release), Seq$.MODULE$.canBuildFrom())).asJava();
        return list;
    }

    @Timed
    public void delete(String id) {
        this.checkIsNotReferencedByDependencies(id);
        this.releasePersistence.findUidByReleaseId(id).foreach((Function1 & Serializable & scala.Serializable)uid -> {
            this.deleteReleaseReferences(id, uid);
            return BoxedUnit.UNIT;
        });
        this.releasePersistence.deleteById(id);
    }

    private void deleteReleaseReferences(String id, int releaseUid) {
        this.dependencyPersistence().deleteByReleaseUid(Predef$.MODULE$.int2Integer(releaseUid));
        this.triggerPersistence().deleteByTemplateId(id);
        this.commentPersistence().deleteByRelease(Predef$.MODULE$.int2Integer(releaseUid));
        this.taskPersistence().deleteTasksByReleaseUid(releaseUid);
        this.teamRepository().deleteTeamsFromPlatform(new SecuredCi(id, releaseUid));
        this.releaseExtensionsRepository().deleteAll(id);
        this.deleteConfigurationRefs(Predef$.MODULE$.int2Integer(releaseUid));
        this.interceptDelete(id);
    }

    @Timed
    public void deleteWithUid(String id, int releaseUid) {
        this.deleteReleaseReferences(id, releaseUid);
        this.releasePersistence.deleteById(id);
    }

    @Timed
    public void move(String originalId, String newId) {
        this.releasePersistence.move(originalId, newId);
    }

    @Timed
    public ReleaseStatus getStatus(String id) {
        String status = (String)this.releasePersistence.findReleaseStatus(CiId$.MODULE$.RichCiId(id).normalized()).orNull(Predef$.MODULE$.$conforms());
        return status == null ? null : ReleaseStatus.valueOf((String)status.toUpperCase());
    }

    @Timed
    public Seq<ReleaseStatus> getStatuses(Seq<String> ids) {
        return ids.isEmpty() ? (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$) : (Seq)this.releasePersistence.findReleaseStatuses(ids).map((Function1 & Serializable & scala.Serializable)status -> ReleaseStatus.valueOf((String)status.toUpperCase()), Seq$.MODULE$.canBuildFrom());
    }

    @Timed
    @IsReadOnly
    public Seq<Object> getRiskScores(Seq<String> ids) {
        return this.releasePersistence.findReleaseRiskScores(ids);
    }

    @Timed
    public void setRiskScores(String releaseId, int score, int totalScore) {
        this.releasePersistence.updateReleaseRiskScores(releaseId, score, totalScore);
    }

    @Timed
    @IsReadOnly
    public boolean isTemplate(String releaseId) {
        return ReleaseStatus.TEMPLATE.equals(this.getStatus(releaseId));
    }

    @Timed
    @IsReadOnly
    public String getTitle(String id) {
        return (String)this.releasePersistence.findReleaseTitle(CiId$.MODULE$.RichCiId(id).normalized()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NotFoundException("Release [%s] not found", new Object[]{id});
        });
    }

    @Timed
    public Release update(Release release) {
        return this.update(null, release);
    }

    @Timed
    public Release update(Release original, Release updated) {
        Option originalReleaseOpt = Option$.MODULE$.apply((Object)original);
        this.releasePersistence.update((Option<Release>)Option$.MODULE$.apply((Object)original), updated);
        originalReleaseOpt.foreach((Function1 & Serializable & scala.Serializable)rel -> {
            SqlReleaseRepository.$anonfun$update$1(this, updated, rel);
            return BoxedUnit.UNIT;
        });
        this.updateConfigurationRefs(updated);
        return updated;
    }

    @Timed
    public Release replace(Release original, Release updated) {
        if (Ids.isFolderId((String)original.getId())) {
            updated.setTeams(Collections.emptyList());
        }
        this.releasePersistence.update((Option<Release>)Option$.MODULE$.apply((Object)original), updated);
        if (original != null) {
            this.replaceTasks(original, updated);
            this.replaceTriggers(original, updated);
            this.replaceReleaseExtensions(original, updated);
            this.replaceReleaseTeams(original, updated);
        }
        this.updateConfigurationRefs(updated);
        return updated;
    }

    @Timed
    @IsReadOnly
    public Set<String> getAllTags(int limitNumber) {
        return (Set)JavaConverters$.MODULE$.setAsJavaSetConverter(this.releasePersistence.findAllTags(limitNumber)).asJava();
    }

    /*
     * WARNING - void declaration
     */
    private Release getRelease(String releaseId, ResolveOptions resolveOptions) {
        void var3_3;
        BoxedUnit boxedUnit;
        Release release = (Release)this.repositoryAdapter().read(releaseId, resolveOptions);
        if (release == null) {
            throw new NotFoundException(new StringBuilder(30).append("Repository entity [").append(releaseId).append("] not found").toString(), new Object[0]);
        }
        if (resolveOptions.hasDecorators()) {
            this.releaseExtensionsRepository().decorate(release);
            boxedUnit = this.commentPersistence().decorate(release);
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return var3_3;
    }

    private void checkIsNotReferencedByDependencies(String planItemIdOrItsChildren) {
        Seq externalIncomingDependencies = (Seq)((TraversableLike)this.dependencyPersistence().findByPartialTargetIds((scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{planItemIdOrItsChildren}))), (Option<scala.collection.immutable.Set<String>>)None$.MODULE$).map((Function1 & Serializable & scala.Serializable)x$7 -> DependencyRow$.MODULE$.DependencyRowOps((DependencyRow)x$7).fullDependencyId(), Seq$.MODULE$.canBuildFrom())).filterNot((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)x$8.startsWith(CiId$.MODULE$.RichCiId(planItemIdOrItsChildren).normalized())));
        if (externalIncomingDependencies.nonEmpty()) {
            throw new ItemInUseException(new StringBuilder(68).append("Cannot delete [").append(planItemIdOrItsChildren).append("] because it or one of its children is referenced by ").append(new StringBuilder(28).append("one or more dependencies: [").append(externalIncomingDependencies.mkString(", ")).append("]").toString()).toString(), new Object[0]);
        }
    }

    @Timed
    @IsReadOnly
    public Option<Integer> findSCMDataById(String id) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(49).append("Finding scm data for template or release with id ").append(id).toString());
        return this.releasePersistence.findSCMDataById(id).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1));
    }

    public static final /* synthetic */ boolean $anonfun$create$3(SqlReleaseRepository $this, Integer taskUid$1, Comment comment) {
        return $this.commentPersistence().create(taskUid$1, CommentPersistence$CommentRow$.MODULE$.fromComment(comment));
    }

    public static final /* synthetic */ void $anonfun$create$2(SqlReleaseRepository $this, Release release$1, Task task) {
        Integer taskUid = $this.taskPersistence().insert(task, Predef$.MODULE$.Integer2int(release$1.getCiUid()));
        syntax.TaskOps$.MODULE$.comments$extension(syntax$.MODULE$.TaskOps(task)).foreach((Function1 & Serializable & scala.Serializable)comment -> BoxesRunTime.boxToBoolean((boolean)SqlReleaseRepository.$anonfun$create$3($this, taskUid, comment)));
        syntax.TaskOps$.MODULE$.dependencies$extension(syntax$.MODULE$.TaskOps(task)).foreach((Function1 & Serializable & scala.Serializable)dependency -> {
            $this.insertDependency(taskUid, dependency);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$update$3(SqlReleaseRepository $this, Integer taskUid$2, Comment c) {
        return $this.commentPersistence().create(taskUid$2, CommentPersistence$CommentRow$.MODULE$.fromComment(c));
    }

    public static final /* synthetic */ void $anonfun$update$2(SqlReleaseRepository $this, Release updated$1, Task task) {
        Integer taskUid = $this.taskPersistence().insert(task, Predef$.MODULE$.Integer2int(updated$1.getCiUid()));
        syntax.TaskOps$.MODULE$.comments$extension(syntax$.MODULE$.TaskOps(task)).foreach((Function1 & Serializable & scala.Serializable)c -> BoxesRunTime.boxToBoolean((boolean)SqlReleaseRepository.$anonfun$update$3($this, taskUid, c)));
        ((IterableLike)syntax.TaskOps$.MODULE$.dependencies$extension(syntax$.MODULE$.TaskOps(task)).filterNot((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.isArchived()))).foreach((Function1 & Serializable & scala.Serializable)dependency -> {
            $this.insertDependency(taskUid, dependency);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$update$6(SqlReleaseRepository $this, ReleaseTrigger trigger) {
        $this.triggerPersistence().insert(trigger);
    }

    public static final /* synthetic */ boolean $anonfun$update$7(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        ReleaseTrigger orig = (ReleaseTrigger)tuple2._1();
        ReleaseTrigger up = (ReleaseTrigger)tuple2._2();
        boolean bl = orig.isEnabled() != up.isEnabled();
        return bl;
    }

    public static final /* synthetic */ void $anonfun$update$9(SqlReleaseRepository $this, ReleaseTrigger releaseTrigger) {
        $this.triggerPersistence().update(releaseTrigger);
    }

    public static final /* synthetic */ void $anonfun$update$1(SqlReleaseRepository $this, Release updated$1, Release rel) {
        Diff$.MODULE$.apply((Iterable)JavaConverters$.MODULE$.asScalaBufferConverter(rel.getAllTasks()).asScala(), (Iterable)JavaConverters$.MODULE$.asScalaBufferConverter(updated$1.getAllTasks()).asScala()).newValues().foreach((Function1 & Serializable & scala.Serializable)task -> {
            SqlReleaseRepository.$anonfun$update$2($this, updated$1, task);
            return BoxedUnit.UNIT;
        });
        Buffer originalTriggers = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(rel.getReleaseTriggers()).asScala();
        Buffer updatedTriggers = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(updated$1.getReleaseTriggers()).asScala();
        Diff triggerDiff = Diff$.MODULE$.apply((Iterable)originalTriggers, (Iterable)updatedTriggers);
        triggerDiff.newValues().foreach((Function1 & Serializable & scala.Serializable)trigger -> {
            SqlReleaseRepository.$anonfun$update$6($this, trigger);
            return BoxedUnit.UNIT;
        });
        ((IterableLike)((TraversableLike)triggerDiff.updatedPairs().filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)SqlReleaseRepository.$anonfun$update$7(x0$1)))).map((Function1 & Serializable & scala.Serializable)x$6 -> (ReleaseTrigger)x$6._2(), Iterable$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)releaseTrigger -> {
            SqlReleaseRepository.$anonfun$update$9($this, releaseTrigger);
            return BoxedUnit.UNIT;
        });
    }

    public SqlReleaseRepository(ReleasePersistence releasePersistence, TaskPersistence taskPersistence, DependencyPersistence dependencyPersistence, CommentPersistence commentPersistence, TeamRepository teamRepository, ReleaseExtensionsRepository releaseExtensionsRepository, ConfigurationPersistence configurationPersistence, SqlRepositoryAdapter repositoryAdapter, TriggerPersistence triggerPersistence, FacetRepository facetRepository, SqlBuilder.Dialect sqlDialect) {
        this.releasePersistence = releasePersistence;
        this.taskPersistence = taskPersistence;
        this.dependencyPersistence = dependencyPersistence;
        this.commentPersistence = commentPersistence;
        this.teamRepository = teamRepository;
        this.releaseExtensionsRepository = releaseExtensionsRepository;
        this.configurationPersistence = configurationPersistence;
        this.repositoryAdapter = repositoryAdapter;
        this.triggerPersistence = triggerPersistence;
        this.facetRepository = facetRepository;
        this.sqlDialect = sqlDialect;
        InterceptedRepository.$init$(this);
        Logging.$init$((Logging)this);
        DeserializationSupport.$init$(this);
        ConfigurationReferencesSupport.$init$(this);
        SqlReleaseRepositoryHelper.$init$(this);
    }
}

