/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.variable;

import com.google.common.base.Preconditions;
import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.xlrelease.domain.variables.Variable;
import com.xebialabs.xlrelease.variable.VariableFactory$;
import com.xebialabs.xlrelease.variable.VariablesGraphResolver$;
import java.io.Serializable;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Iterable$;
import scala.collection.mutable.LinkedHashMap;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class VariableHelper$ {
    public static VariableHelper$ MODULE$;
    private final String VARIABLE_PATTERN;
    private final Pattern VARIABLE_NAME_PATTERN;
    private final Pattern ONLY_ONE_VARIABLE_NAME_PATTERN;
    private final Pattern CI_PROPERTY_VARIABLE_NAME_PATTERN;
    private final Pattern GLOBAL_VARIABLE_NAME_PATTERN;
    private final Pattern FOLDER_VARIABLE_NAME_PATTERN;

    static {
        new VariableHelper$();
    }

    private String VARIABLE_PATTERN() {
        return this.VARIABLE_PATTERN;
    }

    private Pattern VARIABLE_NAME_PATTERN() {
        return this.VARIABLE_NAME_PATTERN;
    }

    private Pattern ONLY_ONE_VARIABLE_NAME_PATTERN() {
        return this.ONLY_ONE_VARIABLE_NAME_PATTERN;
    }

    private Pattern CI_PROPERTY_VARIABLE_NAME_PATTERN() {
        return this.CI_PROPERTY_VARIABLE_NAME_PATTERN;
    }

    private Pattern GLOBAL_VARIABLE_NAME_PATTERN() {
        return this.GLOBAL_VARIABLE_NAME_PATTERN;
    }

    private Pattern FOLDER_VARIABLE_NAME_PATTERN() {
        return this.FOLDER_VARIABLE_NAME_PATTERN;
    }

    public String replaceAll(String raw, java.util.Map<String, String> replacements) {
        return (String)Option$.MODULE$.apply((Object)raw).map((Function1 & Serializable & scala.Serializable)x$1 -> (String)((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(replacements.entrySet()).asScala()).foldLeft(x$1, (Function2 & Serializable & scala.Serializable)(s, entry) -> {
            Matcher matcher = MODULE$.VARIABLE_NAME_PATTERN().matcher((CharSequence)entry.getKey());
            return matcher.matches() ? s.replaceAll(new StringBuilder(12).append("\\$\\{\\s*").append(Pattern.quote(matcher.group(1))).append("\\s*\\}").toString(), Matcher.quoteReplacement((String)entry.getValue())) : s.replace((CharSequence)entry.getKey(), (CharSequence)entry.getValue());
        })).orNull(Predef$.MODULE$.$conforms());
    }

    public String replaceAll(String raw, java.util.Map<String, String> replacements, java.util.Set<String> unresolvedVariables, boolean freezeEvenIfUnresolved) {
        return (String)Option$.MODULE$.apply((Object)this.replaceAll(raw, (java.util.Map)JavaConverters$.MODULE$.mutableMapAsJavaMapConverter((scala.collection.mutable.Map)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(replacements).asScala()).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)VariableHelper$.$anonfun$replaceAll$3(x$2)))).asJava())).map((Function1 & Serializable & scala.Serializable)replaced -> {
            java.util.Set<String> remainingVariables = MODULE$.collectVariables(replaced);
            unresolvedVariables.addAll(remainingVariables);
            return freezeEvenIfUnresolved ? (String)((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(remainingVariables).asScala()).foldLeft(replaced, (Function2 & Serializable & scala.Serializable)(s, remainingVariable) -> MODULE$.freezeUnresolvedVariable((String)s, (String)remainingVariable)) : replaced;
        }).orNull(Predef$.MODULE$.$conforms());
    }

    public Object replaceAll(Object raw, java.util.Map<String, String> replacements, java.util.Set<String> unresolvedVariables, boolean freezeEvenIfUnresolved) {
        return Option$.MODULE$.apply(raw).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Object object;
            Object object2 = x0$1;
            if (object2 instanceof String) {
                String string = (String)object2;
                object = this.replaceInValue$1(string, replacements, unresolvedVariables, freezeEvenIfUnresolved);
            } else if (object2 instanceof java.util.List) {
                java.util.List list = (java.util.List)object2;
                object = JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(list).asScala()).map((Function1 & Serializable & scala.Serializable)value -> this.replaceInValue$1((String)value, replacements, unresolvedVariables, freezeEvenIfUnresolved), Buffer$.MODULE$.canBuildFrom())).toList()).asJava();
            } else if (object2 instanceof java.util.Set) {
                java.util.Set set = (java.util.Set)object2;
                object = JavaConverters$.MODULE$.setAsJavaSetConverter((Set)((TraversableOnce)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(set).asScala()).map((Function1 & Serializable & scala.Serializable)value -> this.replaceInValue$1((String)value, replacements, unresolvedVariables, freezeEvenIfUnresolved), Set$.MODULE$.canBuildFrom())).toSet()).asJava();
            } else if (object2 instanceof java.util.Map) {
                java.util.Map map = (java.util.Map)object2;
                object = JavaConverters$.MODULE$.mutableMapAsJavaMapConverter((scala.collection.mutable.Map)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(map).asScala()).map((Function1 & Serializable & scala.Serializable)t -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.replaceInValue$1((String)t._1(), replacements, unresolvedVariables, freezeEvenIfUnresolved)), (Object)this.replaceInValue$1((String)t._2(), replacements, unresolvedVariables, freezeEvenIfUnresolved)), Map$.MODULE$.canBuildFrom())).asJava();
            } else {
                object = object2;
            }
            return object;
        }).orNull(Predef$.MODULE$.$conforms());
    }

    public String safeReplace(String input, String key, String replacement) {
        return input != null ? input.replace(key, replacement) : input;
    }

    public boolean isCiPropertyVariable(String variableName) {
        return this.CI_PROPERTY_VARIABLE_NAME_PATTERN().matcher(this.withoutVariableSyntax(variableName)).find();
    }

    public boolean isGlobalVariable(String variableName) {
        return this.GLOBAL_VARIABLE_NAME_PATTERN().matcher(this.withoutVariableSyntax(variableName)).find();
    }

    public boolean isFolderVariable(String variableName) {
        return this.FOLDER_VARIABLE_NAME_PATTERN().matcher(this.withoutVariableSyntax(variableName)).find();
    }

    public boolean isGlobalOrFolderVariable(String variableName) {
        return this.isGlobalVariable(variableName) || this.isFolderVariable(variableName);
    }

    public java.util.Set<String> collectVariables(Object input) {
        return (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Option$.MODULE$.apply(input).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            scala.collection.immutable.Set set;
            Object object = x0$1;
            if (object instanceof String) {
                String string = (String)object;
                set = MODULE$.collectVariablesFromValue(string);
            } else if (object instanceof Collection) {
                Collection collection = (Collection)object;
                set = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(collection).asScala()).flatMap((Function1 & Serializable & scala.Serializable)value -> MODULE$.collectVariablesFromValue(value), scala.collection.Iterable$.MODULE$.canBuildFrom())).toSet();
            } else if (object instanceof java.util.Map) {
                java.util.Map map = (java.util.Map)object;
                set = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(map).asScala()).flatMap((Function1 & Serializable & scala.Serializable)x0$2 -> {
                    Tuple2 tuple2 = x0$2;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    Object k = tuple2._1();
                    Object v = tuple2._2();
                    scala.collection.immutable.Set set = (scala.collection.immutable.Set)MODULE$.collectVariablesFromValue(k).$plus$plus(MODULE$.collectVariablesFromValue(v));
                    return set;
                }, Iterable$.MODULE$.canBuildFrom())).toSet();
            } else {
                set = Predef$.MODULE$.Set().empty();
            }
            return set;
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Set().empty())).asJava();
    }

    private scala.collection.immutable.Set<String> collectVariablesFromValue(Object value) {
        scala.collection.mutable.Set result = Set$.MODULE$.empty();
        Object object = value;
        if (object instanceof String) {
            String string = (String)object;
            Matcher matcher = this.VARIABLE_NAME_PATTERN().matcher(string);
            while (matcher.find()) {
                result.add((Object)new StringBuilder(3).append("${").append(matcher.group(1)).append("}").toString());
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        return result.toSet();
    }

    public boolean containsVariables(String input) {
        return input != null && this.VARIABLE_NAME_PATTERN().matcher(input).find();
    }

    public String formatVariableIfNeeded(String variableName) {
        return !com.google.common.base.Strings.isNullOrEmpty((String)variableName) && !this.containsOnlyVariable(variableName) ? this.withVariableSyntax(variableName) : variableName;
    }

    public boolean containsOnlyVariable(String input) {
        return !com.google.common.base.Strings.isNullOrEmpty((String)input) && this.ONLY_ONE_VARIABLE_NAME_PATTERN().matcher(input).find();
    }

    public String withVariableSyntax(String variableName) {
        return new StringBuilder(3).append("${").append(variableName).append("}").toString();
    }

    public String withoutVariableSyntax(String variableKey) {
        String string;
        if (this.containsOnlyVariable(variableKey)) {
            Matcher matcher = this.ONLY_ONE_VARIABLE_NAME_PATTERN().matcher(variableKey);
            matcher.find();
            string = matcher.group(1);
        } else {
            string = variableKey;
        }
        return string;
    }

    public void checkVariable(Variable variable) {
        Preconditions.checkNotNull((Object)variable);
        variable.checkValidity();
    }

    public void checkVariables(java.util.List<Variable> variables) {
        Preconditions.checkNotNull(variables);
        variables.forEach(variable -> MODULE$.checkVariable((Variable)variable));
        Buffer keys = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(variables).asScala()).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.getKey(), Buffer$.MODULE$.canBuildFrom());
        scala.collection.mutable.Set uniqueKeys = Set$.MODULE$.empty();
        keys.foreach((Function1 & Serializable & scala.Serializable)key -> {
            VariableHelper$.$anonfun$checkVariables$3(uniqueKeys, key);
            return BoxedUnit.UNIT;
        });
    }

    public java.util.Map<String, String> getStringVariableValues(java.util.List<Variable> vars) {
        return this.getVariableValuesAsStrings((List<Variable>)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(vars).asScala()).toList(), false);
    }

    public java.util.Map<String, String> getPasswordStringVariableValues(java.util.List<Variable> vars) {
        return this.getVariableValuesAsStrings((List<Variable>)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(vars).asScala()).toList(), true);
    }

    private java.util.Map<String, String> getVariableValuesAsStrings(List<Variable> variables, boolean passwords) {
        return (java.util.Map)JavaConverters$.MODULE$.mutableMapAsJavaMapConverter((scala.collection.mutable.Map)Map$.MODULE$.apply(((MapLike)VariablesGraphResolver$.MODULE$.resolveAsStrings((scala.collection.immutable.Set<Variable>)((TraversableOnce)variables.filter((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)VariableHelper$.$anonfun$getVariableValuesAsStrings$1(passwords, x$4)))).toSet())._1()).toSeq())).asJava();
    }

    /*
     * WARNING - void declaration
     */
    public java.util.Map<String, Variable> indexByKey(java.util.List<Variable> variables) {
        void var2_2;
        LinkedHashMap m = new LinkedHashMap();
        Option$.MODULE$.apply(variables).foreach((Function1 & Serializable & scala.Serializable)x$5 -> {
            x$5.forEach(v -> m.put((Object)v.getKey(), v));
            return BoxedUnit.UNIT;
        });
        return (java.util.Map)JavaConverters$.MODULE$.mutableMapAsJavaMapConverter((scala.collection.mutable.Map)var2_2).asJava();
    }

    public void checkVariableIdsAreTheSame(String requestVariableId, String bodyVariableId) {
        String string = bodyVariableId;
        String string2 = requestVariableId;
        Checks.checkArgument((!(string != null ? !string.equals(string2) : string2 != null) ? 1 : 0) != 0, (String)"Request to update variable [%s] contains an object with different ID: [%s]", (Object[])new Object[]{requestVariableId, bodyVariableId});
    }

    public boolean isGlobalVariableId(String id) {
        return id.startsWith("Configuration/variables/global/") || id.startsWith("/Configuration/variables/global/");
    }

    public java.util.List<Variable> fillVariableValues(java.util.List<Variable> target, java.util.List<Variable> source) {
        java.util.Map<String, Variable> sourceVariables = this.indexByKey(source);
        target.forEach(targetVariable -> {
            Variable sourceVariable;
            String key = targetVariable.getKey();
            if (sourceVariables.containsKey(key) && !(sourceVariable = (Variable)sourceVariables.get(key)).isInherited()) {
                if (targetVariable.getType().equals((Object)sourceVariable.getType())) {
                    targetVariable.setUntypedValue(sourceVariable.getValue());
                } else {
                    throw new IllegalArgumentException(new StringBuilder(33).append("Cannot set value of type [").append(sourceVariable.getType()).append("] into ").append(new StringBuilder(20).append("variable ").append(MODULE$.withVariableSyntax(sourceVariable.getKey())).append(" of type [").append(targetVariable.getType()).append("]").toString()).toString());
                }
            }
        });
        return target;
    }

    public String freezeUnresolvedVariable(String input, String variableName) {
        String string;
        if (this.containsVariables(variableName)) {
            String dollarLessName = variableName.substring(1);
            string = input.replace(variableName, new StringBuilder(2).append("$~").append(dollarLessName).toString());
        } else {
            string = input;
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public Variable cloneVariable(Variable variable, String newKey) {
        void var3_3;
        Variable newVar = VariableFactory$.MODULE$.createVariableByValueType(newKey, variable.getValue(), false, false);
        newVar.setId(null);
        newVar.setDescription(variable.getDescription());
        newVar.setLabel(variable.getLabel());
        newVar.setValueProvider(variable.getValueProvider());
        Option$.MODULE$.apply((Object)newVar.getValueProvider()).foreach((Function1 & Serializable & scala.Serializable)x$6 -> {
            x$6.setId(null);
            return BoxedUnit.UNIT;
        });
        return var3_3;
    }

    public java.util.Map<String, String> filterOutBlankStringVariables(java.util.Map<String, String> variables) {
        return (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(variables).asScala()).filter((Function1 & Serializable & scala.Serializable)entry -> BoxesRunTime.boxToBoolean((boolean)VariableHelper$.$anonfun$filterOutBlankStringVariables$1(entry)))).toMap(Predef$.MODULE$.$conforms())).asJava();
    }

    public static final /* synthetic */ boolean $anonfun$replaceAll$3(Tuple2 x$2) {
        return x$2._2() != null;
    }

    private final String replaceInValue$1(String value, java.util.Map replacements$2, java.util.Set unresolvedVariables$2, boolean freezeEvenIfUnresolved$2) {
        return this.replaceAll(value, (java.util.Map<String, String>)replacements$2, (java.util.Set<String>)unresolvedVariables$2, freezeEvenIfUnresolved$2);
    }

    public static final /* synthetic */ void $anonfun$checkVariables$3(scala.collection.mutable.Set uniqueKeys$1, String key) {
        Preconditions.checkNotNull((Object)key);
        Preconditions.checkArgument((boolean)uniqueKeys$1.add((Object)key), (String)"The variables list contains duplicate keys: '%s'", (Object[])new Object[]{key});
    }

    public static final /* synthetic */ boolean $anonfun$getVariableValuesAsStrings$1(boolean passwords$1, Variable x$4) {
        return x$4.isPassword() == passwords$1;
    }

    public static final /* synthetic */ boolean $anonfun$filterOutBlankStringVariables$1(Tuple2 entry) {
        return Strings.isNotBlank((String)((String)entry._2()));
    }

    private VariableHelper$() {
        MODULE$ = this;
        this.VARIABLE_PATTERN = "\\$\\{\\s*([^}]*[^} ])\\s*\\}";
        this.VARIABLE_NAME_PATTERN = Pattern.compile(this.VARIABLE_PATTERN());
        this.ONLY_ONE_VARIABLE_NAME_PATTERN = Pattern.compile("^\\$\\{([^}]+)\\}$");
        this.CI_PROPERTY_VARIABLE_NAME_PATTERN = Pattern.compile("^release\\..*$", 2);
        this.GLOBAL_VARIABLE_NAME_PATTERN = Pattern.compile("^global\\..*$", 2);
        this.FOLDER_VARIABLE_NAME_PATTERN = Pattern.compile("^folder\\..*$", 2);
    }
}

