/*
 * Decompiled with CFR 0.152.
 */
package de.javakaffee.kryoserializers.guava;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import de.javakaffee.kryoserializers.guava.ImmutableListSerializer;
import de.javakaffee.kryoserializers.guava.ImmutableMapSerializer;
import de.javakaffee.kryoserializers.guava.ImmutableSetSerializer;
import java.util.Map;
import java.util.Set;

public class ImmutableMultimapSerializer
extends Serializer<ImmutableMultimap<Object, Object>> {
    private static final boolean DOES_NOT_ACCEPT_NULL = true;
    private static final boolean IMMUTABLE = true;

    public ImmutableMultimapSerializer() {
        super(true, true);
    }

    public void write(Kryo kryo, Output output, ImmutableMultimap<Object, Object> immutableMultiMap) {
        kryo.writeObject(output, (Object)ImmutableMap.copyOf((Map)immutableMultiMap.asMap()));
    }

    public ImmutableMultimap<Object, Object> read(Kryo kryo, Input input, Class<ImmutableMultimap<Object, Object>> type) {
        Object builder = type.equals(ImmutableListMultimap.class) ? ImmutableMultimap.builder() : (type.equals(ImmutableSetMultimap.class) ? ImmutableSetMultimap.builder() : ImmutableMultimap.builder());
        Map map = (Map)kryo.readObject(input, ImmutableMap.class);
        Set entries = map.entrySet();
        for (Map.Entry entry : entries) {
            builder.putAll(entry.getKey(), (Iterable)entry.getValue());
        }
        return builder.build();
    }

    public static void registerSerializers(Kryo kryo) {
        Serializer immutableSetSerializer;
        Serializer immutableListSerializer;
        Serializer immutableMapSerializer = kryo.getSerializer(ImmutableMap.class);
        if (!(immutableMapSerializer instanceof ImmutableMapSerializer)) {
            ImmutableMapSerializer.registerSerializers(kryo);
        }
        if (!((immutableListSerializer = kryo.getSerializer(ImmutableList.class)) instanceof ImmutableListSerializer)) {
            ImmutableListSerializer.registerSerializers(kryo);
        }
        if (!((immutableSetSerializer = kryo.getSerializer(ImmutableSet.class)) instanceof ImmutableSetSerializer)) {
            ImmutableSetSerializer.registerSerializers(kryo);
        }
        ImmutableMultimapSerializer serializer = new ImmutableMultimapSerializer();
        kryo.register(ImmutableMultimap.class, (Serializer)serializer);
        kryo.register(ImmutableListMultimap.of().getClass(), (Serializer)serializer);
        kryo.register(ImmutableListMultimap.of((Object)"A", (Object)"B").getClass(), (Serializer)serializer);
        kryo.register(ImmutableSetMultimap.of().getClass(), (Serializer)serializer);
        kryo.register(ImmutableSetMultimap.of((Object)"A", (Object)"B").getClass(), (Serializer)serializer);
    }
}

