/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.xlrelease.domain.UserProfile;
import com.xebialabs.xlrelease.service.UserProfileService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserInfoResolver {
    private UserProfileService userProfileService;

    @Autowired
    public UserInfoResolver(UserProfileService userProfileService) {
        this.userProfileService = userProfileService;
    }

    @Timed
    public String getNotificationEmailOf(String username) {
        if (this.isUndefined(username)) {
            return null;
        }
        UserProfile profile = this.userProfileService.discover(username);
        return profile == null ? null : profile.getEmail();
    }

    @Timed
    public String getFullNameOf(String username) {
        if (this.isUndefined(username)) {
            return null;
        }
        UserProfile profile = this.userProfileService.resolveUserProfile(username);
        return profile == null ? null : profile.getFullName();
    }

    @Timed
    public String getFullNameOrUsernameOf(String username) {
        String fullName = this.getFullNameOf(username);
        return this.isUndefined(fullName) ? username : fullName;
    }

    private boolean isUndefined(String username) {
        return Strings.isEmpty((String)com.google.common.base.Strings.nullToEmpty((String)username).trim());
    }
}

