/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.domain.tasks.task;

import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xlrelease.domain.Changes;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.tasks.TaskUpdateValidator;
import com.xebialabs.xlrelease.domain.tasks.TaskUpdater;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DefaultTaskUpdater
implements TaskUpdater {
    @Autowired(required=false)
    private List<TaskUpdateValidator> validators = Collections.emptyList();

    @Override
    public Class<? extends Task> getTaskClass() {
        return Task.class;
    }

    @Override
    public Changes update(Task original, Task updated) {
        this.validators.forEach(v -> v.checkTask(original, updated));
        Changes changes = new Changes();
        changes.update((ConfigurationItem)original);
        original.setCheckAttributes(updated.isCheckAttributes());
        original.setPrecondition(updated.getPrecondition());
        original.setFailureHandler(updated.getFailureHandler());
        original.setTaskFailureHandlerEnabled(updated.isTaskFailureHandlerEnabled());
        original.setTaskRecoverOp(updated.getTaskRecoverOp());
        original.setPhaseRecoverOp(updated.getPhaseRecoverOp());
        original.setTitle(updated.getTitle());
        original.setDescription(updated.getDescription());
        this.resetDueSoonAndOverdueNotifications(original, updated);
        original.updateDates(updated.getScheduledStartDate(), updated.getDueDate(), updated.getPlannedDuration());
        original.setTags(updated.getTags());
        original.setFlagStatus(updated.getFlagStatus());
        original.setFlagComment(updated.getFlagComment());
        original.setTeam(updated.getTeam());
        original.setWaitForScheduledStartDate(updated.isWaitForScheduledStartDate());
        original.setDelayDuringBlackout(updated.isDelayDuringBlackout());
        original.getVariableMapping().keySet().removeIf(k -> !updated.getVariableMapping().containsKey(k));
        original.getVariableMapping().putAll(updated.getVariableMapping());
        if (!Objects.equals(original.getOwner(), updated.getOwner())) {
            original.setOwner(updated.getOwner());
        }
        return changes;
    }

    private void resetDueSoonAndOverdueNotifications(Task original, Task updated) {
        boolean dueSoonShouldBeNotifiedAgain;
        boolean dueDateChanged = original.getDueDate() != updated.getDueDate();
        boolean overdueShouldBeNotifiedAgain = original.isOverdueNotified() && !updated.isOverdue();
        boolean bl = dueSoonShouldBeNotifiedAgain = original.isDueSoonNotified() && !updated.isDueSoon();
        if (dueDateChanged) {
            if (overdueShouldBeNotifiedAgain) {
                original.setOverdueNotified(false);
            }
            if (dueSoonShouldBeNotifiedAgain) {
                original.setDueSoonNotified(false);
            }
        }
    }
}

