/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.server;

import javax.jcr.Credentials;
import javax.jcr.LoginException;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.apache.jackrabbit.server.CredentialsProvider;
import org.apache.jackrabbit.server.SessionProvider;

public class SessionProviderImpl
implements SessionProvider {
    private CredentialsProvider cp;

    public SessionProviderImpl(CredentialsProvider cp) {
        this.cp = cp;
    }

    public Session getSession(HttpServletRequest request, Repository repository, String workspace) throws LoginException, RepositoryException, ServletException {
        Credentials creds = this.cp.getCredentials(request);
        if (creds == null) {
            return repository.login(workspace);
        }
        return repository.login(creds, workspace);
    }

    public void releaseSession(Session session) {
        session.logout();
    }
}

